/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include "misc.h"
#include "sys.h"
#include "3d.h"
#include "poly2d.h"
#include "resource.h"
#include "music.h"
#if defined(__WATCOMC__) || defined (__DJGPP__)
#include <conio.h>
#endif

int sysSoundCard=0, sysVideoMode=3;
bool sysDebug = false;

TCollection<KBHandler*> kb_handlers;

void
sysRegisterKeyboardHandler( KBHandler* handler )
{
  kb_handlers.Insert( new KBHandler*(handler) );
}

void
sysUpdateFrame()
{
  KB key = sysGetKey();
  if( key ) {
    if( key == KB_ESC ) {
      Shutdown();
    }
    for( int i=0; i<kb_handlers.Count; i++ ) {
      if( (*kb_handlers[i])(key) ) break;
    }
  }
}

void
Startup( char* cmdline )
{
  srand(time(0));

  musNoSound = cmdline && strstr( (char*)cmdline, "-nosound" );
  bool saveconfig = cmdline && strstr( (char*)cmdline, "-saveconfig" );
  sysDebug = cmdline && strstr( (char*)cmdline, "-debug" );

  vidInitVideo();
  musInitMusic();
  resInit( PROJECT_NAME".DAT" );

  sysStartup();

  if( saveconfig || !sysLoadConfig( PROJECT_NAME ".cfg" ) ) {
    musChooseCard();
    sysVideoMode = vidChooseVideoMode();
  }

  if( saveconfig ) {
    sysSaveConfig( PROJECT_NAME ".cfg" );
  }
  musInitCard();
  vidSetVideoMode(sysVideoMode);

  Init3D();
  sysResetTimer();
}

void
Shutdown()
{
  musStopMusic();
  musCloseMusic();
  vidCloseVideo();
  sysCleanup();
}

void
sysSaveConfig( char* filename ) {
  int h = open( filename, O_RDWR|O_BINARY|O_CREAT, 0777 );
  if( h == -1 ) error( "Cannot write configuration file" );
  write( h, &sysSoundCard, sizeof(int) );
  write( h, &sysVideoMode, sizeof(int) );
  write( h, &vidHiResMode, sizeof(int) );
  close(h);
}

bool
sysLoadConfig( char* filename )
{
  int h = open( filename, O_RDONLY|O_BINARY );
  if( h == -1 )
    return false;
  else {
    read( h, &sysSoundCard, sizeof(int) );
    read( h, &sysVideoMode, sizeof(int) );
    read( h, &vidHiResMode, sizeof(int) );
    close(h);
    return true;
  }
}

void
error( char* msg ) {
  char str[256];
  sprintf( str, "\nFatal error: %s\n", msg );
  vidMessage(str);
  Shutdown();
}

void*
operator new( size_t size )
{
  return cmalloc(size);
}

void
operator delete( void* ptr )
{
  cfree(ptr);
}

size_t allocated=0, max_alloc=0;

void*
cmalloc( size_t size )
{
  char* tmp = (char*)malloc(size+8);
  if(!tmp) {
    char str[256];
    sprintf( str, "Not enough memory (%d allocated)", allocated );
    error( str );
  }
  *(uint*)tmp = 0x12345678;
  *(uint*)(tmp+4)=size;
  allocated+=size; if( allocated>max_alloc) max_alloc=allocated;
//  printf( "cmalloc %d\n", size );
  return tmp+8;
}

void
cfree( void* ptr )
{
  if(ptr) {
    if( *(((uint*)ptr)-2) != 0x12345678 ) error( "Heap corrupted" );
    *(((uint*)ptr)-2) = 0;
    uint size = *(((uint*)ptr)-1);
    if( !size ) error( "freeing object of zero bytes" );
    free((char*)ptr-8);
    allocated -= size;
//    printf( "cfree %d\n", size );
  }
}

int
sysGetNumber( char* str, int min, int max )
{
  printf( str );
  fflush( stdout );
  int c;
  do {
#if defined(__WATCOMC__) || defined (__DJGPP__)
    c = getch() - '0';
#else
    c = getchar() - '0';
#endif
    if( c == 27-48 ) error( "User abort" );
  } while( c < min || c > max );
  return c;
}

uint timer_offset = 0;

void sysResetTimer()
{
  timer_offset = 0;
}

uint sysTimer()
{
  return sysCurrentTime() - timer_offset;
}
