/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <math.h>
#include "3d.h"
#include "music.h"
#include "smooth.h"
#include "poly2d.h"
#include "parts.h"
#include "common.h"
#include "lines.h"

char* obj_names[] = { "chain.asc",
		      "mancage.asc",
		      "anvil.asc",
		      "abomb2.asc",
		      "vette.asc" };
const N_OBJECTS = sizeof(obj_names) / sizeof(char*);
const N_MAN=5;

struct Space: public Part {

  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what=0 );

  TCollection<FacedObject> objects;
  Image* back;
  int cur_object;
  TCollection<TPoly2D> man_phases[N_MAN];
  TPoly2D* man[N_MAN];
  int direction;
  Space():
    cur_object(-1),
    direction(1) {}
};

bool callback( Face* face )
{
  DrawLinePix( bw, face->vert[0]->x>>16, face->vert[0]->y,
	       face->vert[1]->x>>16, face->vert[1]->y, VID_AVG_BRIGHT );
  DrawLinePix( bw, face->vert[1]->x>>16, face->vert[1]->y,
	       face->vert[2]->x>>16, face->vert[2]->y, VID_AVG_BRIGHT );
  DrawLinePix( bw, face->vert[2]->x>>16, face->vert[2]->y,
	       face->vert[0]->x>>16, face->vert[0]->y, VID_AVG_BRIGHT );
  return true;
}

void Space::Init()
{
  Part::Init();
  for( i=0; i<N_OBJECTS; i++ ) {
    FacedObject *o;
    o = new FacedObject( PHONG | SORT | PERSPECT | NO_TEXTURE );
    o->ImportASC( obj_names[i], 0, VID_MAX_SIZE_Y*1.1, 0, MAP_XY );
    o->Prepare();
    o->perspect = 0.6;
    o->RotateAbs( 0, COS_STEPS_3D/2, 0 );
    objects.Insert(o);
    if( i==4 ) o->flags |= TWO_SIDES;
  }
  back = new Image( "tubes.raw", STRETCH_SCREEN );
  char man_parts[N_MAN][256] =
  { "lleg%d.dxf", "rleg%d.dxf", "lhand%d.dxf", "rhand%d.dxf", "torso%d.dxf" };
  for( int j=0; j<N_MAN; j++ ) {
    for( i=0; i<=6; i++ ) {
      char str[256];
      sprintf( str, man_parts[j], i );
      man_phases[j].Insert( new TPoly2D(str) );
    }
    man[j] = new TPoly2D( *man_phases[j][0] );
  }
}

void Space::Start( int what )
{
  Part::Start();
  cur_object = (cur_object+1) % N_OBJECTS;
  direction = 1-direction;
  ::dither = dither1;
  if( what ) {
    static vidPalette pal;
    for( i=0; i<256; i++ ) {
      pal[i].r = 255-dither1->palette[i].r;
      pal[i].g = 255-dither1->palette[i].g;
      pal[i].b = 255-dither1->palette[i].b;
    }
    part_pal = pal;
  }
  else {
    part_pal = dither1->palette;
  }
}

void man_line( int y, int x1, int x2, uchar c, PAGE buf )
{
  memset( buf+y*vidBytesPerLine+x1, c, x2-x1+1 );
/*
  PAGE ptr = buf+y*vidBytesPerLine+x1;
  int n = x2-x1+1;
  for( int x=0; x<n; x++ ) {
    ptr[x] = 255-ptr[x];
  }
*/
}

void man_line1( int y, int x1, int x2, uchar c, PAGE buf )
{
  memset( buf+y*vidBytesPerLine+x1, c, x2-x1+1 );
/*
  PAGE ptr = buf+y*vidBytesPerLine+x1;
  int n = x2-x1+1;
  for( int x=0; x<n; x++ ) {
    ptr[x] = 255-ptr[x];
  }
*/
}

void Space::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame(color,bw,what);

  vidClearPage( bw, VID_AVG_BRIGHT );

  if( !what ) {

    int angle = cur_timer*COS_STEPS_3D/2/musGetPatternTime();
    objects[cur_object]->RotateTo( angle, angle/3, 0 );
    objects[cur_object]->MoveTo(
      (direction?-1:1) *
      (VID_MAX_SIZE_X/2-cur_timer*VID_MAX_SIZE_X/(musGetRowTime()*48) / 2),
      -VID_MAX_SIZE_Y/3,
      VID_MAX_SIZE_X/2 - 2*cur_timer*VID_MAX_SIZE_X/sysTimerRes );
    objects[cur_object]->Draw( 0, color, bw );

    static offset = 0;
    vidSizeY /= 2; vidBytesPerLine *= 2;
    vidCopyPage(color+offset,back->data);
    vidSizeY *= 2; vidBytesPerLine /= 2;
    offset = vidBytesPerLine - offset;

    static prev_row = -1, delta = 0, prev_time = 0, mirror = 1;
    if( row/12 != prev_row ) {
      delta = -vidSizeX/5;
      mirror = -mirror;
      prev_row = row/12;
      prev_time = timer;
    }

    int steps = 6*musGetRowTime(),
	step = cur_timer % steps,
	n1 = 5 + (cur_timer / steps) % 2,
	n2 = 5 + (n1+4) % 2;

    for( i=0; i<N_MAN; i++ ) {
      int bright = VID_MAX_BRIGHT - 10 -
		   (timer-prev_time)*VID_MAX_BRIGHT/sysTimerRes;
      if( bright < 0 ) bright = 0;
      man[i]->MorphTo( man_phases[i][n1], man_phases[i][n2], step, steps );
      man[i]->Move( delta, 0 );
      float scale = 1.1 / ( 1 + 4.0*cur_timer/(musGetRowTime()*48) );
      man[i]->Scale( vidSizeX/2, vidSizeY/2, mirror*scale, scale );
      man[i]->Draw( man_line, bright, bw );
    }
  }
  else {
    int steps = musGetPatternTime()/8,
	step = cur_timer % steps,
	n1 = min( cur_timer / steps, 4 ),
	n2 = min( n1+1, 4 );

    int step1;
    if( n1 > 0 || step > steps/2 ) {
      step1 = (cur_timer-steps/2) % steps;
    }
    else {
      step1 = 0;
    }
    int n11 = min( (cur_timer-steps/2) / steps, 4 ),
	n21 = min( n11+1, 4 );

    for( i=0; i<N_MAN; i++ ) {
      man[i]->MorphTo( man_phases[i][n11], man_phases[i][n21], step1, steps );
      man[i]->Move( vidSizeX/5, 0 );
      man[i]->Scale( vidSizeX/2, vidSizeY/2, 0.7, 0.7 );
      man[i]->Draw( man_line1, VID_AVG_BRIGHT*3/4, bw );
    }

    for( i=0; i<N_MAN; i++ ) {
      man[i]->MorphTo( man_phases[i][n1], man_phases[i][n2], step, steps );
      man[i]->Move( vidSizeX/5, 0 );
      man[i]->Scale( vidSizeX/2, vidSizeY/2, 0.7, 0.7 );
      man[i]->Draw( man_line1, 0, bw );
    }
//    vidClearPage(color,back->data);
  }
}

Part* partSpace = new Space;
