/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "parts.h"
#include "video.h"
#include "music.h"
#include "sys.h"
#include "common.h"

void Part::Init()
{
  elapsed = 0;
  part_count = 0;
  stopped = true; 
  set_pal = true;
  part_pal = 0;
}

void Part::Start( int what )
{
  timer_offset = sysTimer();
}

void Part::Stop()
{
  elapsed += sysTimer() - timer_offset;
  part_count++;
  stopped = true;
  vidPalette pal;
  for( i=0; i<256; i++ ) {
    pal[i].r = pal[i].g = pal[i].b = i;
  }
  vidSetPalette(pal);
}

void Part::Frame( PAGE color, PAGE bw, int what )
{
  if( set_pal ) {
    set_pal = false;
    if( part_pal ) vidSetPalette( part_pal );
  }
  if( stopped ) {
    stopped = false;
    set_pal = true;
  }
  cur_timer = sysTimer() - timer_offset;
  timer = cur_timer + elapsed;
  musGetPosition( &order, &row );
}
