/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __IMAGE__
#define __IMAGE__

#include "misc.h"
#include "video.h"

enum Stretch {
  NO_STRETCH = 0,
  STRETCH,
  STRETCH_SCREEN,
  STRETCH_BIT0,
  STRETCH_BIT1,
  STRETCH_ALIAS
};

struct Image {
  int sizeX, sizeY, bytesPerLine;
  vidRGB* palette;
  void* buf;
  uchar* data;
  bool loaded;
  Image( Image& );
  Image( char* name, Stretch stretch = STRETCH );
  Image( int sizex, int sizey, int bytesperline, vidRGB pal[256], uchar* buf );
  ~Image();
  void Show( int x, int y, PAGE );
  void ShowT( int x, int y, PAGE );
  void ShowTC( int x, int y, uchar color, PAGE page );
  void ShowAdd( int x, int y, PAGE page );
  void ShowTB( int x, int y, uchar color, PAGE );
  void ShowR( int x, int y, int w, int h, PAGE page );
  void ShowRT( int x, int y, int w, int h, PAGE page );
  void ShowRTC( int x, int y, int w, int h, uchar color, PAGE page );
  void ShowRTAdd( int x, int y, int w, int h, PAGE page );
  void StretchTo( int newx, int newy, int newbytesperline );
  void StretchToBit( int newx, int newy, bool neg );
  void MapToPage( int u1, int v1,	   //  1   2
		  int u2, int v2,	   //
		  int u3, int v3,	   //  3   4
		  int u4, int v4,	   //
		  PAGE page );
  void MapToPage2( int u1, int v1,	    //	1   2
		   int u2, int v2,	    //
		   int u3, int v3,	    //	3   4
		   int u4, int v4,	    //
		   PAGE page );
  void Smooth();
};

#endif
