/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __FONT__
#define __FONT__

#include "poly2d.h"
#include "image.h"

enum FontAlignment { ALIGN_LEFT,
		     ALIGN_RIGHT,
		     ALIGN_CENTER };

class VFont {
  int size;
public:
  TPoly2D* font[256];
  int text_step_x, text_step_y;
  VFont( int sizeX, int sizeY );
  void Load( int first, int last, char* _name );
  void Prepare();
  void DrawString( int x, int y, char* s, FontAlignment alignment,
		   PAGE page, uchar color );
  TPoly2D* getChar( char c ) {
    return font[c] ? font[c] : font[' '];
  }
};

class RFont {
  void draw_string( uchar* data, char* s, int x, int y, int bpl );
  int vsize;
  struct {
    int x,y,a,b,c;
  } font[256];
  Image* image;
public:
  RFont( char* name, bool bw = false );
  void DrawString( int x, int y, char* s, FontAlignment aligment,
		   PAGE page );
  Image* CreateImage( char* s );
  int GetScreenWidth( char* str );
  ~RFont();
};

#endif
