/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include <ctype.h>
#include "font.h"
#include "parts.h"
#include "lines.h"
#include "resource.h"

VFont::VFont( int sizeX, int sizeY )
{
  memset( font, 0, sizeof(font) );
  font[' ']=new TPoly2D;
  size = sizeX;
  text_step_y = sizeY*2.5;
  text_step_x = size*0.5;
  font[' ']->Min.X = 0;
  font[' ']->Max.X = size*65536;
}

void VFont::Load( int first, int last, char* _name )
{
  int i;
  char name[256];
  strcpy( name, _name );
  char* num_pos = strchr( name, '?' );
  int width=0;
  for( i=first; i<=last; i++ ) {
    if( num_pos ) *num_pos = i;
    font[i] = new TPoly2D( name );
    font[i]->Move( -font[i]->SizeX()/2-font[i]->Min.X>>16,
		   -font[i]->SizeY()/2-font[i]->Min.Y>>16 );
    width+=font[i]->SizeX();
  }
  float scale = (float)size/width*(last-first+1);
  for( i=first; i<=last; i++ ) {
    TPoly2D* f = font[i];
    if(f) {
      f->Scale( 0, 0, scale, scale );
    }
  }
}

void VFont::DrawString( int x, int y, char* s, FontAlignment alignment,
			PAGE page, uchar color )
{
  int i, width = 0;
  for( i=0; i<strlen(s); i++ ) {
    width += getChar(s[i])->SizeX()+text_step_x;
  }
  switch( alignment ) {
    case ALIGN_LEFT: {
      x = x; break;
    }
    case ALIGN_RIGHT: {
      x -= width; break;
    }
    case ALIGN_CENTER:
    default: {
      x -= width/2; break;
    }
  }
  for( i=0; i<strlen(s); i++ ) {
    getChar(s[i])->DrawEdges(x,y,DrawLinePix,page,color);
    x += getChar(s[i])->SizeX()+text_step_x;
  }
}

RFont::RFont( char* name, bool bw )
{
  char real_name[256];
  strncpy( real_name, name, 256 );
  strcat( real_name, ".raw" );
  image = new Image( real_name );
  int i;
  if( bw ) {
    int n = image->bytesPerLine*image->sizeY;
    for( i=0; i<n; i++ ) {
      image->data[i] >>= 2;
    }
  }
  strncpy( real_name, name, 256 );
  strcat( real_name, ".fnt" );
  char* s = (char*)resGetResource( real_name );
  char* ptr = s;
  vsize = vidScaleY(strtol( ptr, &ptr, 10 ));
  for( i=0; i<256; i++ ) {
    font[i].x = vidScaleX(strtol( ptr, &ptr, 10 ));
    font[i].y = vidScaleY(strtol( ptr, &ptr, 10 ));
    font[i].a = vidScaleX(strtol( ptr, &ptr, 10 ));
    font[i].b = vidScaleX(strtol( ptr, &ptr, 10 ));
    font[i].c = vidScaleX(strtol( ptr, &ptr, 10 ));
  }
  resFreeResource(s);
}

void RFont::draw_string( uchar* data, char* ss, int x, int y, int bpl )
{
  uchar* s = (uchar*)ss;
  uchar c = font[s[0]].b ? s[0] : ' ';
  x -= font[c].a;
  for( int i=0; s[i]; i++ ) {
    x += font[c].a;
    c = font[s[i]].b ? s[i] : ' ';
    for( int v=0; v<vsize; v++ ) {
      uchar *dst = data+(v+y)*bpl+x,
	    *src = image->data+(v+font[c].y)*image->bytesPerLine+font[c].x;
      int n = font[c].b;
      for( int j=0; j<n; j++ ) {
	if( src[j] ) dst[j] = src[j];
      }
    }
    x += font[c].b+font[c].c;
  }
}

void RFont::DrawString( int x, int y, char* s, FontAlignment aligment,
			PAGE page )
{
  draw_string( page, s, x, y, vidBytesPerLine );
}

int RFont::GetScreenWidth( char* ss )
{
  uchar* s = (uchar*)ss;
  int width = 0;
  int i;
  for( i=0; s[i]; i++ ) {
    width += font[s[i]].a+font[s[i]].b+font[s[i]].c;
  }
  width -= font[s[0]].a - font[s[i-1]].c;
  width = (width+3)/4*4;
  return width;
}

Image* RFont::CreateImage( char* s )
{
  int width = GetScreenWidth(s);
  uchar* buf = new uchar[vsize*width];
  memset( buf, 0, vsize*width );
  draw_string( buf, s, 0, 0, width );
  return new Image( width, vsize, width, 0, buf );
}

RFont::~RFont()
{
  delete image;
}
