/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "music.h"
#include "image.h"
#include "3d.h"
#include "lines.h"
#include "smooth.h"
#include "misc.h"
#include "font.h"

const N_FRAMES = 2000000;

const float STEP_TIME = ((int)(2*sysTimerRes));

PAGE color, bw;
Image *back, *back1;

void effect1( int y, int x1, int x2, uchar c, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  memcpy( color+offset, back1->data+offset, x2-x1+1 );
}

void effect2( int y, int x1, int x2, uchar c, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  offset &= 0xFFFFFFFE; offset |= y & 1;
  PAGE ptr1 = back1->data+offset, ptr2 = color+offset;
  for( int i=0; i<x2-x1+1; i+=2 ) {
    ptr2[i] = ptr1[i];
  }
}

void effect3( int y, int x1, int x2, uchar c, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  memset( bw+offset, VID_MAX_BRIGHT*3/4, x2-x1+1 );
}

void effect4( int y, int x1, int x2, uchar c, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  memset( bw+offset, VID_MAX_BRIGHT*1/4, x2-x1+1 );
}

void effect5( int y, int x1, int x2, uchar c, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  PAGE ptr1 = back1->data+offset, ptr2 = bw+offset;
  for( int x=0; x<x2-x1+1; x++ )
    ptr2[x] = ptr1[x] >> 2;
}

PFLineDraw effects[] = { effect1, effect2, effect3, effect4, effect5 };
int effect = 0;
const int MAX_EFFECT = sizeof(effects) / sizeof(PFLineDraw);
int phase_rows = 8;

bool kb_handler( int key )
{
  switch(key) {
    case ' ': {
      effect = (effect+1)%MAX_EFFECT;
      return true;
    }
    case '1': phase_rows = 2; return true;
    case '2': phase_rows = 4; return true;
    case '3': phase_rows = 8; return true;
    case '4': phase_rows = 16; return true;
  }
  return false;
}

void sysMain( int argc, char* argv[] )
{

  UNIMOD* mod = musLoadModule( "music.s3m" );
  if(!mod) error( "Cannot load module" );

  TCollection<TPoly2D> dxfs;

  int songpos = -1, patpos = -1;
  for( int i=1; i<argc; i++ ) {
    if( atoi(argv[i] ) ) {
      if( songpos != -1 ) {
	patpos = atoi(argv[i] );
      }
      else {
	songpos = atoi(argv[i]);
      }
    }
    else {
      dxfs.Insert( new TPoly2D( argv[i] ) );
    }
  }
  if( !dxfs.Count ) error( "no dxf's specified" );
  TPoly2D dxf( *dxfs[0] );

  mp_loop = true;
  sysDebug = true;

  sysRegisterKeyboardHandler( &kb_handler );

  color = vidAllocPage(), bw = vidAllocPage();

  back = new Image( "back1.raw", STRETCH_SCREEN );
  back1 = new Image( "back2.raw", STRETCH_SCREEN );

  Image dither("dither.raw");

  FacedObject test( 0 /*| TWO_SIDES*/ /*| NO_TEXTURE*/ | PHONG | SORT );
  Image texture(*back);
  texture.StretchTo(64,64,64);
  test.ImportASC( "fig1.asc", 0, VID_MAX_SIZE_Y*0.3, &texture, MAP_XY );
  test.Prepare();

  vidSetPalette(dither.palette);
  vidPalette pal;

  short* zbuffer;
  if( !(test.flags & SORT) )
    zbuffer = new short[vidPageSize];

  sysResetTimer();
  uint start = sysTimer(), prevtime=start, prev1=start, time=start;

  musStartMusic();
  musSetPosition( songpos, patpos );

  for( int j=0; j<N_FRAMES; j++, time = sysTimer() ) {
    int i;

    if( !(test.flags & SORT) )
      Object3D::ClearZBuffer( zbuffer, MIN_Z );
    vidClearPage(bw,VID_MAX_BRIGHT/2);
    vidCopyPage(color,back->data);

    static int pos = 0, btime = time;
    if( mp_patpos/16 != pos ) {
      pos = mp_patpos/16;
      btime = time;
    }
    int tmp = 64-(time-btime)/sysTimerRes*64;
    if( tmp >= 0 ) {
       for( i=0; i<256; i++ ) {
	 if( dither.palette[i].r+tmp < 256 ) pal[i].r = dither.palette[i].r+tmp;
	 else pal[i].r = 255;
	 if( dither.palette[i].g+tmp < 256 ) pal[i].g = dither.palette[i].g+tmp;
	 else pal[i].g = 255;
	 if( dither.palette[i].b+tmp < 256 ) pal[i].b = dither.palette[i].b+tmp;
	 else pal[i].b = 255;
       }
       vidSetPalette(pal);
    }
    else {
      tmp = 0;
    }
    test.ScaleTo( 1+tmp/64.0, 1+tmp/64.0, 1+tmp/64.0 );
    test.RotateTo( 0,
		   time/sysTimerRes*COS_STEPS_3D*0.1,
		   time/sysTimerRes*COS_STEPS_3D*0.15 );
    test.MoveTo( -VID_MAX_SIZE_X/2*0.8, -VID_MAX_SIZE_Y/2*0.7, 0 );
    test.Draw( zbuffer, color, bw );

    musGetPosition( &songpos, &patpos );
    int steps = phase_rows*musGetRowTime(),
	step = time % steps,
	n1 = (time / steps) % dxfs.Count,
	n2 = (n1+1) % dxfs.Count;

    dxf.MorphTo( dxfs[n1], dxfs[n2], step, steps );
    dxf.Draw( effects[effect], 0, 0 );
    vidShowPage(color,bw,dither.data);
  }
  musStopMusic();
}
