#include "asm-defs.h"

.data

.equ	MIN_Z,	-512

.extern C(phongTable)	$:dword

.globl	C(shadow)
.globl	C(colorZGTS)
.globl	C(bwZGTS)
.globl	C(zbufferOffsetZGTS)
.globl	C(textureZGTS)
.globl	C(lsZGTS)
.globl	C(zsZGTS)
.globl	C(tsZGTS)
.globl	C(x2ZGTS)
.globl	C(zbuffer0ZGTS)
.globl	C(zbuffer1ZGTS)

.globl	C(colorZGT)
.globl	C(bwZGT)
.globl	C(textureZGT)
.globl	C(lsZGT)
.globl	C(zsZGT)
.globl	C(tsZGT)
.globl	C(x2ZGT)
.globl	C(zbuffer0ZGT)
.globl	C(zbuffer1ZGT)

.globl	C(bwZG)
.globl	C(lsZG)
.globl	C(zsZG)
.globl	C(x2ZG)
.globl	C(zbuffer0ZG)
.globl	C(zbuffer1ZG)

.globl	C(bwZP)
.globl	C(lsZP)
.globl	C(zsZP)
.globl	C(x2ZP)
.globl	C(zbuffer0ZP)
.globl	C(zbuffer1ZP)
.globl	C(phongZP)

.globl	C(textureZPT)
.globl	C(colorZPT)
.globl	C(bwZPT)
.globl	C(x2ZPT)
.globl	C(lsZPT)
.globl	C(zsZPT)
.globl	C(tsZPT)
.globl	C(phongZPT)
.globl	C(zbuffer0ZPT)
.globl	C(zbuffer1ZPT)

.globl	C(textureSPT)
.globl	C(colorSPT)
.globl	C(bwSPT)
.globl	C(x2SPT)
.globl	C(lsSPT)
.globl	C(tsSPT)
.globl	C(phongSPT)

.globl	C(textureSGT)
.globl	C(colorSGT)
.globl	C(bwSGT)
.globl	C(x2SGT)
.globl	C(lsSGT)
.globl	C(tsSGT)

.globl	C(textureZPT)
.globl	C(colorZPT)
.globl	C(bwZPT)
.globl	C(x2ZPT)
.globl	C(lsZPT)
.globl	C(zsZPT)
.globl	C(tsZPT)
.globl	C(phongZPT)
.globl	C(zbuffer0ZPT)
.globl	C(zbuffer1ZPT)

.globl	C(bwSP)
.globl	C(x2SP)
.globl	C(lsSP)
.globl	C(phongSP)

.globl	C(DrawLineZGTS)		# zbuffer + gouraud + texture + shadow
.globl	C(DrawLineZGT)		# zbuffer + gouraud + texture
.globl	C(DrawLineZG)		# zbuffer + gouraud
.globl	C(DrawLineZP)		# zbuffer + phong
.globl	C(DrawLineZPT)		# zbuffer + phong + texture
.globl	C(DrawLineSGT)		# sort + gouraud + texture
.globl	C(DrawLineSPT)		# sort + phong + texture
.globl	C(DrawLineSP)		# sort + phong

#  DrawLine( x, z, l, t );
#  esi - x
#  edi - z
#  ebx - l
#  eax - u & v

C(DrawLineZGTS):
	jmp	ZGTS_loop
	.p2align 4
ZGTS_loop:
	movl	%edi,%edx
	shr	$16,%edx
ZGTSpatch0:
	cmpw	12345678(,%esi,2),%dx
	jle	ZGTSno_draw
ZGTSpatch1:
	movw	%ax,12345678(,%esi,2)
ZGTSzbuffer_patch:
	movw	12345678(,%esi,2),%dx
	cmpw	$MIN_Z,%dx
	jnz	ZGTSno_shadow
ZGTSshadow_patch:
	movb	 $60,12345678(%esi)
ZGTSno_shadow:
	movl	%eax,%edx
	shr	$16,%edx
	movb	%ah,%dl
ZGTStexture_patch:
	movb	12345678(%edx),%dl
ZGTScolor_patch:
	movb	%dl,12345678(%esi)
ZGTSbw_patch:
	movb	%bh,12345678(%esi)
ZGTSno_draw:
	incl	%esi
ZGTSx2_patch:
	cmpl	$12345678,%esi
	jle	ZGTSnext
	jg	ZGTSexit
	je	ZGTS_loop
ZGTSnext:
ZGTSls_patch:
	addl	$12345678,%ebx
ZGTSzs_patch:
	addl	$12345678,%edi
ZGTSts_patch:
	addl	$12345678,%eax
	jmp	ZGTS_loop
ZGTSexit:
	ret

C(DrawLineZGT):
	jmp	ZGT_loop
	.p2align 4
ZGT_loop:
	movl	%edi,%edx
	movl	%eax,%ecx
	shr	$16,%edx
	shrl	$18,%ecx
ZGTpatch0:
	cmpw	12345678(,%esi,2),%dx
	jle	ZGTno_draw
	andl	$0B111111000000,%ecx
ZGTpatch1:
	movw	%dx,12345678(,%esi,2)
	orb	%ah,%cl
ZGTbw_patch:
	movb	%bh,12345678(%esi)
ZGTtexture_patch:
	movb	12345678(%ecx),%dl
ZGTcolor_patch:
	movb	%dl,12345678(%esi)
ZGTno_draw:
	incl	%esi
ZGTx2_patch:
	cmpl	$12345678,%esi
	jl	ZGTnext
	jmp	ZGTexit
ZGTnext:
ZGTls_patch:
	addl	$12345678,%ebx
ZGTzs_patch:
	addl	$12345678,%edi
ZGTts_patch:
	addl	$12345678,%eax
	jmp	ZGT_loop
ZGTexit:
	ret


C(DrawLineZG):
ZGpatch:
	jmp	ZGloop
	.p2align 4
ZGloop:
	movl	%edi,%edx
	shr	$16,%edx
ZGpatch0:
	cmpw	12345678(,%esi,2),%dx
	jle	ZGno_draw
ZGpatch1:
	movw	%dx,12345678(,%esi,2)
ZGbw_patch:
	movb	%bh,12345678(%esi)
ZGno_draw:
	incl	%esi
ZGx2_patch:
	cmpl	$12345678,%esi
	jl	ZGnext
	jg	ZGexit
	je	ZGloop
ZGnext:
ZGls_patch:
	addl	$12345678,%ebx
ZGzs_patch:
	addl	$12345678,%edi
	jmp	ZGloop
ZGexit:
	ret


C(DrawLineZP):
ZPpatch:
	jmp	ZPloop
	.p2align 4
ZPloop:
	movl	%edi,%edx
	movl	%ebx,%ecx
	shr	$16,%edx
ZPpatch0:
	cmpw	12345678(,%esi,2),%dx
	jle	ZPno_draw
	shrl	$18,%ecx
ZPpatch1:
	movw	%dx,12345678(,%esi,2)
	andl	$0B111111000000,%ecx
	orb	%bh,%cl
ZPphong_patch:
	movb	12345678(%ecx),%dl
ZPbw_patch:
	movb	%dl,12345678(%esi)
ZPno_draw:
	incl	%esi
ZPx2_patch:
	cmpl	$12345678,%esi
	jl	ZPnext
	jg	ZPexit
	je	ZPloop
ZPnext:
ZPls_patch:
	addl	$12345678,%ebx
ZPzs_patch:
	addl	$12345678,%edi
	jmp	ZPloop
ZPexit:
	ret


C(DrawLineZPT):

	pushl	%edi
	pushl	%esi
	pushl	%ebx
	movl	16(%esp),%esi
	movl	20(%esp),%edi
	movl	24(%esp),%ebx
	movl	28(%esp),%eax

	jmp	ZPTloop
	.p2align 4
ZPTloop:
	movl	%edi,%edx
	shr	$16,%edx
ZPTpatch0:
	cmpw	12345678(,%esi,2),%dx
	jle	ZPTno_draw
ZPTpatch1:
	movw	%dx,12345678(,%esi,2)
	movl	%eax,%edx
	movl	%ebx,%ecx
	shr	$18,%edx
	shr	$16,%ecx
	and	$0B111111000000,%edx
	movb	%bh,%cl
	orb	%ah,%dl
ZPTphong_patch:
	movb	12345678(%ecx),%cl
ZPTtexture_patch:
	movb	12345678(%edx),%dl
ZPTbw_patch:
	movb	%cl,12345678(%esi)
ZPTcolor_patch:
	movb	%dl,12345678(%esi)
ZPTno_draw:
	incl	%esi
ZPTx2_patch:
	cmpl	$12345678,%esi
	jl	ZPTnext
	jmp	ZPTexit
	.p2align 4
ZPTnext:
ZPTls_patch:
	addl	$12345678,%ebx
ZPTzs_patch:
	addl	$12345678,%edi
ZPTts_patch:
	addl	$12345678,%eax
	jmp	ZPTloop
ZPTexit:

	popl   %ebx
	popl   %esi
	popl   %edi
	ret

	
C(DrawLineSPT):

	pushl	%edi
	pushl	%esi
	pushl	%ebx
	movl	16(%esp),%esi
	movl	20(%esp),%edi
	movl	24(%esp),%ebx
	movl	28(%esp),%eax
	jmp	SPTloop
	.p2align 4
SPTloop:
	movl	%ebx,%edx
	movl	%eax,%ecx
	shrl	$16,%edx
	shrl	$16,%ecx
	movb	%bh,%dl
	movb	%ah,%cl
SPTphong_patch:
	movb	12345678(%edx),%dl
SPTtexture_patch:
	movb	12345678(%ecx),%cl
SPTbw_patch:
	movb	%dl,12345678(%esi)
SPTcolor_patch:
	movb	%cl,12345678(%esi)
	incl	%esi
SPTx2_patch:
	cmpl	$12345678,%esi
	jl	SPTnext
	jmp	SPTexit
	.p2align 4
SPTnext:
SPTls_patch:
	addl	$12345678,%ebx
SPTts_patch:
	addl	$12345678,%eax
	jmp	SPTloop
SPTexit:
	popl   %ebx
	popl   %esi
	popl   %edi
	ret


C(DrawLineSGT):
	jmp	SGTloop
	.p2align 4
SGTloop:
	movl	%eax,%edx
	shr	$18,%edx
	and	$0B111111000000,%edx
	orb	%ah,%dl
SGTtexture_patch:
	movb	12345678(%edx),%cl
SGTbw_patch:
	movb	%bh,12345678(%esi)
SGTcolor_patch:
	movb	%cl,12345678(%esi)
	incl	%esi
SGTx2_patch:
	cmpl	$12345678,%esi
	jl	SGTnext
	jmp	SGTexit
	.p2align 4
SGTnext:
SGTls_patch:
	addl	$12345678,%ebx
SGTts_patch:
	addl	$12345678,%eax
	jmp	SGTloop
SGTexit:
	ret

C(DrawLineSP):
	movl	4(%esp),%ecx
	movl	12(%esp),%eax

       jmp SPloop
       .p2align 4
SPloop:
       movl %eax,%edx
       shrl $16,%edx
       movb %ah,%dl
SPphong_patch:
       movb 12345678(%edx),%dl
SPbw_patch:
       movb %dl,12345678(%ecx)
       incl %ecx
SPx2_patch:
       cmpl $12345678,%ecx
       jl SPnext
       jmp SPexit
       .p2align 4
SPnext:
SPls_patch:
       addl $12345678,%eax
       jmp SPloop
SPexit:
	ret

V(zbufferOffsetZGTS):	.long ZGTSzbuffer_patch+4
V(shadow):		.long ZGTSshadow_patch+2
V(textureZGTS):		.long ZGTStexture_patch+3
V(colorZGTS):		.long ZGTScolor_patch+2
V(bwZGTS):		.long ZGTSbw_patch+2
V(x2ZGTS):		.long ZGTSx2_patch+2
V(lsZGTS):		.long ZGTSls_patch+2
V(zsZGTS):		.long ZGTSzs_patch+2
V(tsZGTS):		.long ZGTSts_patch+1
V(zbuffer0ZGTS):	.long ZGTSpatch0+4
V(zbuffer1ZGTS):	.long ZGTSpatch1+4

C(textureZGT):	    .long ZGTtexture_patch+2
C(colorZGT):	    .long ZGTcolor_patch+2
C(bwZGT): 	    .long ZGTbw_patch+2
C(x2ZGT): 	    .long ZGTx2_patch+2
C(lsZGT): 	    .long ZGTls_patch+2
C(zsZGT): 	    .long ZGTzs_patch+2
C(tsZGT): 	    .long ZGTts_patch+1
C(zbuffer0ZGT):	    .long ZGTpatch0+4
C(zbuffer1ZGT):	    .long ZGTpatch1+4

C(bwZG):	    .long ZGbw_patch+2
C(x2ZG):	    .long ZGx2_patch+2
C(lsZG):	    .long ZGls_patch+2
C(zsZG):	    .long ZGzs_patch+2
C(zbuffer0ZG):	    .long ZGpatch0+4
C(zbuffer1ZG):	    .long ZGpatch1+4

C(bwZP):	    .long ZPbw_patch+2
C(x2ZP):	    .long ZPx2_patch+2
C(lsZP):	    .long ZPls_patch+2
C(zsZP):	    .long ZPzs_patch+2
C(zbuffer0ZP):	    .long ZPpatch0+4
C(zbuffer1ZP):	    .long ZPpatch1+4
C(phongZP):	    .long ZPphong_patch+2

C(textureZPT):	    .long ZPTtexture_patch+2
C(colorZPT):	    .long ZPTcolor_patch+2
C(bwZPT): 	    .long ZPTbw_patch+2
C(x2ZPT): 	    .long ZPTx2_patch+2
C(lsZPT): 	    .long ZPTls_patch+2
C(zsZPT): 	    .long ZPTzs_patch+2
C(tsZPT): 	    .long ZPTts_patch+1
C(phongZPT):	    .long ZPTphong_patch+2
C(zbuffer0ZPT):	    .long ZPTpatch0+4
C(zbuffer1ZPT):	    .long ZPTpatch1+4

C(textureSPT):	    .long SPTtexture_patch+2
C(colorSPT):	    .long SPTcolor_patch+2
C(bwSPT): 	    .long SPTbw_patch+2
C(x2SPT): 	    .long SPTx2_patch+2
C(lsSPT): 	    .long SPTls_patch+2
C(tsSPT): 	    .long SPTts_patch+1
C(phongSPT):	    .long SPTphong_patch+2

C(textureSGT):	    .long SGTtexture_patch+2
C(colorSGT):	    .long SGTcolor_patch+2
C(bwSGT): 	    .long SGTbw_patch+2
C(x2SGT): 	    .long SGTx2_patch+2
C(lsSGT): 	    .long SGTls_patch+2
C(tsSGT): 	    .long SGTts_patch+1

C(bwSP):	    .long SPbw_patch+2
C(x2SP):	    .long SPx2_patch+2
C(lsSP):	    .long SPls_patch+1
C(phongSP):	    .long SPphong_patch+2
