/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "3d.h"
#include "video.h"
#include "types.h"

static PAGE bw, color;
static short* zbuffer;
static int zs, x2;
static shorts ls, ts;
static uchar *phong;
static uchar* texture;

extern "C" {

// drawLineZGTS patches
 short* zbufferOffsetZGTS;
 uchar* textureZGTS;
 PAGE colorZGTS, bwZGTS;
 int x2ZGTS, zsZGTS;
 shorts tsZGTS, lsZGTS;
 uchar* shadow;

// drawLineZGT patches
 uchar** textureZGT;
 PAGE *colorZGT, *bwZGT;
 int *x2ZGT, *zsZGT;
 shorts *tsZGT, *lsZGT;
 short **zbuffer0ZGT, **zbuffer1ZGT;

// drawLineZG patches
 PAGE bwZG;
 int x2ZG, zsZG;
 shorts lsZG;
 short *zbuffer0ZG, *zbuffer1ZG;

// drawLineZP patches
 PAGE *bwZP;
 int *x2ZP, *zsZP;
 shorts *lsZP;
 uchar** phongZP;
 short **zbuffer0ZP, **zbuffer1ZP;

// drawLineSGT patches
 uchar* textureSGT;
 PAGE colorSGT, bwSGT;
 int x2SGT;
 shorts tsSGT, lsSGT;

// drawLineZPT patchese
uchar** textureZPT = &texture;
PAGE *colorZPT = &color, *bwZPT = &bw;
int *x2ZPT = &x2, *zsZPT = &zs;
shorts *tsZPT = &ts, *lsZPT = &ls;
uchar** phongZPT = &phong;
short **zbuffer0ZPT = &zbuffer, **zbuffer1ZPT = &zbuffer;

// drawLineSPT patches
uchar** textureSPT = &texture;
PAGE *colorSPT = &color, *bwSPT = &bw;
int *x2SPT = &x2;
shorts *tsSPT = &ts, *lsSPT = &ls;
uchar** phongSPT = &phong;

// drawLineSP patches
PAGE *colorSP = &color, *bwSP = &bw;
int *x2SP = &x2;
shorts *lsSP = &ls;
uchar** phongSP = &phong;


void DrawLineZGT( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
}

void DrawLineZPT( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZPT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
  for( int i=x; i<x2; i++ ) {
    if( zbuffer[i] < z ) {
      zbuffer[i] = z;
      color[i] = texture[ (t.s.v&0xFF00)|(t.s.u>>8) ];
      bw[i] = phong[ (l.s.v&0xFF00)|(l.s.u>>8) ];
    }
    z += zs; l += ls; t += ts;
  }
}

void DrawLineSGT( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineSGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
}

void DrawLineSPT( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
  for( int i=x; i<x2; i++ ) {
    color[i] = texture[ (t.s.v&0xFF00)|(t.s.u>>8) ];
    bw[i] = phong[ (l.s.v&0xFF00)|(l.s.u>>8) ];
    l += ls; t += ts;
  }
}

void DrawLineZG( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZG parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
}

void DrawLineZP( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZP parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
  for( int i=x; i<x2; i++ ) {
    if( zbuffer[i] < z ) {
      zbuffer[i] = z;
      bw[i] = phong[ (l.s.v&0xFF00)|(l.s.u>>8) ];
    }
    z += zs; l += ls;
  }
}

void DrawLineSP( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineSP parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
  for( int i=x; i<x2; i++ ) {
    bw[i] = phong[ (l.s.v&0xFF00)|(l.s.u>>8) ];
    l += ls;
  }
}

void DrawLineZGTS( int x, int z, shorts l, shorts t )
#ifdef __WATCOMC__
#pragma aux DrawLineZGTS parm [esi] [edi] [ebx] [eax] modify [edx ecx];
#endif
{
}

}
