/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "3d.h"
#include "video.h"
#include "types.h"

int x1;
int *x2, *zs;
shorts *ls, *ts;
PAGE shadow;
uchar** texture;

// drawLineZGTS patches
short* zbufferOffsetZGTS;
uchar* textureZGTS;
PAGE colorZGTS, bwZGTS;
int x2ZGTS, zsZGTS;
shorts tsZGTS, lsZGTS;

// drawLineZGT patches
uchar* textureZGT;
PAGE colorZGT, bwZGT;
int x2ZGT, zsZGT;
shorts tsZGT, lsZGT;
ushort *zbuffer0ZGT, *zbuffer1ZGT;

// drawLineZB patches
PAGE bwZG;
int x2ZG, zsZG;
shorts lsZG;
short *zbuffer0ZG, *zbuffer1ZG;

// drawLineZP patches
PAGE bwZP;
int x2ZP, zsZP;
shorts lsZP;
uchar* phongZP;
short *zbuffer0ZP, *zbuffer1ZP;

// drawLineSGT patches
uchar* textureSGT;
PAGE colorSGT, bwSGT;
int x2SGT;
shorts tsSGT, lsSGT;

// drawLineZPT patches
uchar* textureZPT;
PAGE colorZPT, bwZPT;
int x2ZPT, zsZPT;
shorts tsZPT, lsZPT;
uchar* phongZPT;
short *zbuffer0ZPT, *zbuffer1ZPT;

// drawLineSPT patches
uchar* textureSPT;
PAGE colorSPT, bwSPT;
int x2SPT;
shorts tsSPT, lsSPT;
uchar* phongSPT;

void DrawLineZGT( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineZPT( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZPT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineSGT( int x, int z, shorts l, shorts t )
#pragma aux DrawLineSGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineSPT( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZGT parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineZG( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZG parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineZP( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZG parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}

void DrawLineZGTS( int x, int z, shorts l, shorts t )
#pragma aux DrawLineZGTS parm [esi] [edi] [ebx] [eax] modify [edx ecx];
{
  for( int i=x; i<x2ZGT; i++ ) {
    if( zbuffer0ZGT[i] < z ) {
      zbuffer0ZGT[i] = z;
      colorZGT[i] = textureZPT[ ((t>>18)&0xFC0)|(t.a>>8) ];
      bwZGT[i] = l>>8;
    }
    z += zsZGT; l += lsZGT; t += tsZGT;
  }
}
