/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <string.h>
#include "image.h"
#include "music.h"
#include "parts.h"
#include "common.h"

extern Part *partBegin, *partSpace, *partAbstract, *partCars, *partPoints,
	    *partDLines, *partText, *partBrain, *partRotate, *partWave;

bool skip = false;

bool handler( KB key )
{
  if( key == KB_NEXT ) skip = true;
  return true;
}

void sysMain( int argc, char* argv[] )
{

  Part* foo = new Part;
  foo->Init();

  struct PartDesc {
    int patterns;
    Part* part;
    int fx1, fx2;
  } parts[][2] =
  {
    { { 1, partWave,  0x80, 0x100 }, { 0,0,0,0 } },		     // 0
    { { 1, partBegin, 0, 0 },	{ 0, partDLines, 0,0 } },	// 1
    { { 1, partBegin, 1, 1 },	{ 0, partDLines, 0,0 } },	// 2
    { { 1, partBegin, 2, 2 },	{ 1, partDLines, 0,0 } },	// 3
    { { 1, partBegin, 2, 2 },	{ 0, partDLines, 0,0 } },	// 4
    { { 1, partBegin, 3, 3 },	{ 1,0,0,0 } },			// 5
    { { 1, partSpace, 0, 0 },	{ 1,0,0,0 } },			// 6
    { { 1, partBegin, 3, 3 },	{ 1,0,0,0 } },			// 7
    { { 1, partSpace, 0, 0 },	{ 1,0,0,0 } },			// 8
    { { 1, partBegin, 3, 3 },	{ 1,0,0,0 } },			// 9
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 1 } },	// 10
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 1 } },	// 11
    { { 1, partPoints, 0, 0 },	{ 1, partDLines, 0, 2 } },	// 12
    { { 1, partPoints, 0, 1 },	{ 0, partDLines, 0, 1 } },	// 13
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 14
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 15
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 16
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 17
    { { 1, partCars, 0, 0 },	{ 1, 0, 0, 0 } },		// 18
    { { 1, partCars, 0x80, 0 },    { 1, 0, 0, 0 } },		   // 19
    { { 1, partCars, 0, 0 },	{ 1, 0, 0, 0 } },		// 20
    { { 1, partPoints, 0, 2 },	{ 1, partDLines, 0, 1 } },	// 21
    { { 1, partPoints, 0, 0 },	{ 1, partDLines, 0, 1 } },	// 22
    { { 1, partBegin, 3, 3 },	{ 1,0,0,0 } },			// 23
    { { 1, partPoints, 0x80, 0 },  { 1, partDLines, 0, 1 } },	// 24
    { { 1, partBegin, 3, 3 },	{ 1,0,0,0 } },			// 25
    { { 1, partCars, 1, 0x83 },    { 1, 0, 0, 0 } },		   // 26
    { { 1, partCars, 0x81, 0x83 },    { 1, 0, 0, 0 } }, 	      // 27
    { { 1, partCars, 1, 0x83 },    { 1, 0, 0, 0 } },		   // 28
    { { 1, partCars, 0x81, 0x83 },    { 1, 0, 0, 0 } }, 	      // 29
    { { 1, partBegin, 3, 3 },	{ 0, partSpace, 0, 1 } },	// 30
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 31
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 32
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 33
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 34
    { { 1, partBegin, 2, 2 },	{ 1, partDLines, 0,0 } },	// 35
    { { 1, partCars, 0, 1 },	{ 1, 0, 0, 0 } },		// 36
    { { 1, partCars, 0x80, 1 },    { 1, 0, 0, 0 } },		   // 37
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 0 } },	// 38
    { { 1, partSpace, 0, 0 },	{ 1, 0,0,0 } }, 		// 39
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 0 } },	// 40
    { { 1, partSpace, 0, 0 },	{ 1, 0,0,0 } }, 		// 41
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 0 } },	// 42
    { { 1, partSpace, 0, 0 },	{ 1, 0,0,0 } }, 		// 43
    { { 1, partRotate, 0, 1 },	{ 1, partAbstract, 0, 0 } },	// 44
    { { 1, partSpace, 0, 0 },	{ 1, 0,0,0 } }, 		// 45
    { { 1, partWave, 0, VID_AVG_BRIGHT },{ 0, partCars, 0, 5 }},// 46
    { { 1, partWave, 1, VID_AVG_BRIGHT },{ 0, partCars, 1, 5 }},// 47
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 48
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 49
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 50
    { { 1, partRotate, 0, 1 },	{ 0, partBrain, 0, 0 } },	// 51
    { { 1, partPoints, 1, 3 },	{ 1, partDLines, 0, 1 } },	// 52
    { { 1, partPoints, 0x81, 3 },  { 1, partDLines, 0, 1 } },	// 53
    { { 1, partPoints, 1, 4 },	{ 1, partDLines, 0, 1 } },	// 54
    { { 1, partPoints, 0x81, 4 },  { 1, partDLines, 0, 1 } },	// 55
    { { 1, partCars, 0, 3 },	{ 1, 0, 0, 0 } },		// 56
    { { 1, partCars, 0x80, 3 },    { 1, 0, 0, 0 } },		// 57
    { { 1, partBegin, 3, 3 },	{ 0, partSpace, 0, 1 } },	// 58
    { { 1, partCars, 0x80, 3 },    { 1, 0, 0, 0 } },		// 59
    { { 1, partText, 1, 2 }, { 0, 0, 0, 0 } },			// 60
    { { 1, foo, 0, 0 }, { 0, 0, 0, 0 } }			// 61
  };
  const N_PARTS = sizeof(parts)/2/sizeof(PartDesc);

  //  sysRegisterKeyboardHandler( &handler ); doesn't work anymore

  mp_loop = true;

  UNIMOD* mod = musLoadModule( "divesc.s3m" );
  if(!mod) error( "Cannot load module" );
  int order=0, row=0;
  int prev_order;

  InitCommon();

  partText->Init();
  partText->Start( 1 );
  vidClearPage( color, 8*16+2 );
  vidSetPalette( dither1->palette );

  partText->Frame( color, bw, 1 );		// 1
  vidShowPage( color, bw, dither->data );

  partCars->Init();

  partText->Frame( color, bw, 1 );		// 2
  vidShowPage( color, bw, dither->data );

  partSpace->Init();

  partText->Frame( color, bw, 1 );
  vidShowPage( color, bw, dither->data );

  partBegin->Init();
  partAbstract->Init();

  partText->Frame( color, bw, 1 );
  vidShowPage( color, bw, dither->data );

  partPoints->Init();
  partDLines->Init();
  partBrain->Init();
  partRotate->Init();
  partWave->Init();

  partText->Stop();

  musStartMusic();
  vidStartTime = sysTimer();
  musGetPosition( &order, &row );
  
  while( order < N_PARTS ) {
    int n = order;
    musGetPosition( &prev_order );
    parts[n][0].part->Start( parts[n][0].fx1 );
    if( parts[n][1].part ) {
      parts[n][1].part->Start( parts[n][1].fx1 );
    }
    if( parts[n][1].patterns ) {
      partText->Start();
    }
    int old_order = order;
    while( old_order == order ) {
      if( n == N_PARTS-2 ) {
	vidClearPage( color, 8*16+2 );
	vidClearPage( bw );
	vidSetPalette( dither1->palette );
      }
      parts[n][0].part->Frame( color, bw, parts[n][0].fx2 );
      if( parts[n][1].part ) {
	parts[n][1].part->Frame( color, bw, parts[n][1].fx2 );
      }
      if( parts[n][1].patterns ) {
	partText->Frame( color, bw );
      }
      vidShowPage( color, bw, dither->data );
      musGetPosition( &order, &row );
      if( n == N_PARTS-1 && row ) {
	vidPalette pal;
	for( int i=0; i<256; i++ ) {
	  pal[i].r = dither->palette[i].r*(64-row)/64;
	  pal[i].g = dither->palette[i].g*(64-row)/64;
	  pal[i].b = dither->palette[i].b*(64-row)/64;
	}
	vidSetPalette(pal);
	musSetVolume( 100-row*100/64 );
      }
      if( skip ) {
	static first = true;
	static skip_order = 0;
	if( first ) {
	  skip_order = order;
	  first = false;
	}
	if( skip_order == order && row < 63 ) {
	  musSetPosition( order, row+1 );
	}
	if( order != skip_order ) {
	  first = true;
	  skip = false;
	}
	//	break;
      }
    }
    if( n == N_PARTS ) break;
    if( n == N_PARTS-1 ) continue;
    parts[n][0].part->Stop();
    if( parts[n][1].part ) {
      parts[n][1].part->Stop();
    }
    if( parts[n][1].patterns ) {
      partText->Stop();
    }
  }
  musStopMusic();
}
