/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include "3d.h"
#include "parts.h"
#include "common.h"
#include "poly2d.h"
#include "music.h"
#include "lines.h"

const NX=6, NY=4;

class Brain: public Part {

  void Init();
  void Start( int what );
  void Frame( PAGE color, PAGE bw, int what );
  FacedObject *brain, *cage;
  TCollection<TPoly2D> symbols;
  TPoly2D* symbol;
};

int dist( int x1, int y1, int x2, int y2 ) {
  return sqrt( sqr(x1-x2) + sqr(y1-y2) );
}

static bool callback( Point* p )
{
  int d = PHONG_STEPS/2 - dist(p->x,p->y, 320,240 );
  if( d > 0 ) {
    p->l = shorts( PHONG_STEPS/2, PHONG_STEPS/2 );
  }
  return true;
}

void Brain::Init()
{
  Part::Init();
/*
  brain = new FacedObject( PHONG | SORT | PERSPECT | ONE_SIDE );
  Image texture( "oldmeta1.raw" );
  brain->ImportASC( "brain.asc", 0, VID_MAX_SIZE_Y, &texture, MAP_XY );
  brain->Prepare();
  brain->setPointCallback(&callback);
*/
/*
  cage = new FacedObject( NO_TEXTURE | PHONG | SORT | PERSPECT | ONE_SIDE );
  cage->ImportASC( "mancage.asc", 0, VID_MAX_SIZE_Y, 0, MAP_XY );
  cage->Prepare();
*/
  for( i=0; i<=22; i++ ) {
    char str[] = "symb%d.dxf";
    char name[256];
    sprintf( name, str, i );
    symbols.Insert( new TPoly2D(name) );
  }
  int dx = -(symbols[0]->Min.X>>16), dy = -(symbols[0]->Min.Y>>16);
  for( i=0; i<=22; i++ ) {
    symbols[i]->Move( dx, dy );
  }

  symbol = new TPoly2D(*symbols[0]);
};

void Brain::Start( int what )
{
  Part::Start();
  ::dither = dither2;
  part_pal = dither2->palette;
}

void symbol_line( int y, int x1, int x2, uchar color, PAGE buf )
{
  int offset = y*vidBytesPerLine+x1;
  PAGE ptr = buf+offset;
  int n = x2-x1+1;
//  memcpy( buf+offset, bcar1->data+offset, x2-x1+1 );
//  for( int x=0; x<n; x++ ) ptr[x] = VID_MAX_BRIGHT-1-ptr[x];
  memset( ptr, color, n );
}

void Brain::Frame( PAGE color, PAGE bw, int what )
{
  Part::Frame( color, bw, what );
//  vidSizeY /= 2; vidBytesPerLine *= 2;
//  static offset = 0;
//  color += offset; bw += offset;
//  vidCopyPage( bw, bcar1_bw->data );
  uchar colors[] = { 128+2, 128+15, 96+8+32+15, 96+8+32 };
  vidClearPage( color, colors[ part_count%4 ] );
/*
  brain->RotateTo( 0,//timer*COS_STEPS_3D/sysTimerRes*0.05,
		   timer*COS_STEPS_3D/sysTimerRes*0.07, 0 );
  brain->Draw( 0, color, bw );
*/
//  vidSizeY *= 2; vidBytesPerLine /= 2;
//  offset = vidBytesPerLine-offset;
//  cage->Draw( 0, color, bw );
  static c = 0;
  static old_row = -1;
  if( row/6 != old_row ) {
    old_row = row/6;
    c += 6;
  }
  int steps = musGetRowTime()*6,
      step = timer % steps,
      n1 = ( timer / steps ) % symbols.Count,
      n2;
  int cur_c=c;
  for( int x=0; x<NX; x++ ) {
    for( int y=0; y<NY; y++ ) {
      n2 = ( n1+1 ) % symbols.Count;
      symbol->MorphTo( symbols[n1], symbols[n2], step, steps );
      symbol->Move( x*vidSizeX/NX, y*vidSizeY/NY );
      symbol->Draw( symbol_line, cur_c, color );
      cur_c = (cur_c+10) % 155;
      symbol->DrawEdges( 0,0, DrawLinePix, bw, VID_MAX_BRIGHT-1 );
      n1 = (n1+3) % symbols.Count;
    }
  }
}

Part* partBrain = new Brain;
