/*---------------------------------------------------------------
   DDEPOP.H header file

   Data from "The World Almanac and Book of Facts 1992," page 75
  ---------------------------------------------------------------*/

#include <time.h>

struct
     {
     char       *szState ;
     long        lPop70 ;
     long        lPop80 ;
     long        lPop90 ;
     long        lPop ;
     long        lPopLast ;
     long double a ;
     long double b ;
     long double c ;
     }
     pop[] = {
             "AL",   3444354,   3894025,   4040587, 0, 0, 0.0, 0.0, 0.0,
             "AK",    302583,    401851,    550043, 0, 0, 0.0, 0.0, 0.0,
             "AZ",   1775399,   2716546,   3665228, 0, 0, 0.0, 0.0, 0.0,
             "AR",   1923322,   2286357,   2350725, 0, 0, 0.0, 0.0, 0.0,
             "CA",  19971069,  23667764,  29760021, 0, 0, 0.0, 0.0, 0.0,
             "CO",   2209596,   2889735,   3294394, 0, 0, 0.0, 0.0, 0.0,
             "CT",   3032217,   3107564,   3287116, 0, 0, 0.0, 0.0, 0.0,
             "DE",    548104,    594338,    666168, 0, 0, 0.0, 0.0, 0.0,
             "DC",    756668,    638432,    606900, 0, 0, 0.0, 0.0, 0.0,
             "FL",   6791418,   9746961,  12937926, 0, 0, 0.0, 0.0, 0.0,
             "GA",   4587930,   5462982,   6478216, 0, 0, 0.0, 0.0, 0.0,
             "HI",    769913,    964691,   1108229, 0, 0, 0.0, 0.0, 0.0,
             "ID",    713015,    944127,   1006749, 0, 0, 0.0, 0.0, 0.0,
             "IL",  11110285,  11427409,  11430602, 0, 0, 0.0, 0.0, 0.0,
             "IN",   5195392,   5490214,   5544159, 0, 0, 0.0, 0.0, 0.0,
             "IA",   2825368,   2913808,   2776755, 0, 0, 0.0, 0.0, 0.0,
             "KS",   2249071,   2364236,   2477574, 0, 0, 0.0, 0.0, 0.0,
             "KY",   3220711,   3660324,   3685296, 0, 0, 0.0, 0.0, 0.0,
             "LA",   3644637,   4206116,   4219973, 0, 0, 0.0, 0.0, 0.0,
             "ME",    993722,   1125043,   1227928, 0, 0, 0.0, 0.0, 0.0,
             "MD",   3923897,   4216933,   4781468, 0, 0, 0.0, 0.0, 0.0,
             "MA",   5689170,   5737093,   6016425, 0, 0, 0.0, 0.0, 0.0,
             "MI",   8881826,   9262044,   9295297, 0, 0, 0.0, 0.0, 0.0,
             "MN",   3806103,   4075970,   4375099, 0, 0, 0.0, 0.0, 0.0,
             "MS",   2216994,   2520770,   2573216, 0, 0, 0.0, 0.0, 0.0,
             "MO",   4677623,   4916766,   5117073, 0, 0, 0.0, 0.0, 0.0,
             "MT",    694409,    786690,    799065, 0, 0, 0.0, 0.0, 0.0,
             "NE",   1485333,   1569825,   1578385, 0, 0, 0.0, 0.0, 0.0,
             "NV",    488738,    800508,   1201833, 0, 0, 0.0, 0.0, 0.0,
             "NH",    737681,    920610,   1109252, 0, 0, 0.0, 0.0, 0.0,
             "NJ",   7171112,   7365011,   7730188, 0, 0, 0.0, 0.0, 0.0,
             "NM",   1017055,   1303302,   1515069, 0, 0, 0.0, 0.0, 0.0,
             "NY",  18241391,  17558165,  17990455, 0, 0, 0.0, 0.0, 0.0,
             "NC",   5084411,   5880095,   6628637, 0, 0, 0.0, 0.0, 0.0,
             "ND",    617792,    652717,    638800, 0, 0, 0.0, 0.0, 0.0,
             "OH",  10657423,  10797603,  10847115, 0, 0, 0.0, 0.0, 0.0,
             "OK",   2559463,   3025487,   3145585, 0, 0, 0.0, 0.0, 0.0,
             "OR",   2091533,   2633156,   2842321, 0, 0, 0.0, 0.0, 0.0,
             "PA",  11800766,  11864720,  11881643, 0, 0, 0.0, 0.0, 0.0,
             "RI",    949723,    947154,   1003464, 0, 0, 0.0, 0.0, 0.0,
             "SC",   2590713,   3120729,   3486703, 0, 0, 0.0, 0.0, 0.0,
             "SD",    666257,    690768,    696004, 0, 0, 0.0, 0.0, 0.0,
             "TN",   3926018,   4591023,   4877185, 0, 0, 0.0, 0.0, 0.0,
             "TX",  11198655,  14225513,  16986510, 0, 0, 0.0, 0.0, 0.0,
             "UT",   1059273,   1461037,   1722850, 0, 0, 0.0, 0.0, 0.0,
             "VT",    444732,    511456,    562758, 0, 0, 0.0, 0.0, 0.0,
             "VA",   4651448,   5346797,   6187358, 0, 0, 0.0, 0.0, 0.0,
             "WA",   3413244,   4132353,   4866692, 0, 0, 0.0, 0.0, 0.0,
             "WV",   1744237,   1950186,   1793477, 0, 0, 0.0, 0.0, 0.0,
             "WI",   4417821,   4705642,   4891769, 0, 0, 0.0, 0.0, 0.0,
             "WY",    332416,    469557,    453588, 0, 0, 0.0, 0.0, 0.0,
             "US", 203302031, 226542203, 248709873, 0, 0, 0.0, 0.0, 0.0
             } ;

#define NUM_STATES (sizeof (pop) / sizeof (pop[0]))

void CalcPops (void)
     {
     int    i ;
     time_t lTime ;

     time (&lTime) ;                    // time in seconds since 1/1/70
     lTime -= 92L * 24 * 60 * 60 ;      // time in seconds since 4/1/70

     for (i = 0 ; i < NUM_STATES ; i++)
          pop[i].lPop = (long) (pop[i].a * lTime * lTime +
                                pop[i].b * lTime +
                                pop[i].c) ;
     }

void InitPops (void)
     {
     int         i ;
     long double ldSec80, ldSec90 ;

     ldSec80 = 3653.0 * 24 * 60 * 60 ;  // seconds from 4/1/70 to 4/1/80
     ldSec90 = 7305.0 * 24 * 60 * 60 ;  // seconds from 4/1/70 to 4/1/90

     for (i = 0 ; i < NUM_STATES ; i++)
          {
          pop[i].a = (ldSec90 * (pop[i].lPop80 - pop[i].lPop70) +
                      ldSec80 * (pop[i].lPop70 - pop[i].lPop90)) /
                     (ldSec90 * ldSec80 * (ldSec80 - ldSec90)) ;

          pop[i].b = (ldSec90 * ldSec90 * (pop[i].lPop70 - pop[i].lPop80) +
                      ldSec80 * ldSec80 * (pop[i].lPop90 - pop[i].lPop70)) /
                     (ldSec90 * ldSec80 * (ldSec80 - ldSec90)) ;

          pop[i].c = pop[i].lPop70 ;
          }

     CalcPops () ;
     }
