unit Config;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DXDraws;

const
  DisModes: array[0..11, 0..2] of Integer = (
    (640, 480, 8),
    (640, 480, 16),
    (640, 480, 24),
    (640, 480, 32),
    (800, 600, 8),
    (800, 600, 16),
    (800, 600, 24),
    (800, 600, 32),
    (1024, 768, 8),
    (1024, 768, 16),
    (1024, 768, 24),
    (1024, 768, 32)
  );

type
  TConfigForm = class(TForm)
    AutomaticButton: TRadioButton;
    ManualButton: TRadioButton;
    Bevel1: TBevel;
    DriverBox: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    DisplayModeBox: TComboBox;
    HardwareCheckBox: TCheckBox;
    RGBCheckBox: TCheckBox;
    MonoCheckBox: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    FullScreenButton: TCheckBox;
    Bevel2: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure DriverBoxClick(Sender: TObject);
    procedure DisplayModeBoxClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  ConfigForm: TConfigForm;

implementation

{$R *.DFM}

procedure TConfigForm.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i:=0 to TDXDraw.Drivers.Count-1 do
    DriverBox.Items.AddObject(TDXDraw.Drivers[i].Description, TDXDraw.Drivers[i]);
  DriverBox.ItemIndex := 0;

  for i:=Low(DisModes) to High(DisModes) do
    DisplayModeBox.Items.AddObject(Format('%dx%d %dbit', [DisModes[i, 0], DisModes[i, 1], DisModes[i, 2]]), Pointer(i));

  DisplayModeBox.ItemIndex := DisplayModeBox.Items.IndexOf('640x480 16bit');
end;

procedure TConfigForm.Button1Click(Sender: TObject);
begin
  Tag := 1;
  Close;
end;

procedure TConfigForm.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TConfigForm.DriverBoxClick(Sender: TObject);
begin
  ManualButton.Checked := True;
end;

procedure TConfigForm.DisplayModeBoxClick(Sender: TObject);
begin
  ManualButton.Checked := True;
  FullScreenButton.Checked := True;
end;

end.
