// ਬ 筮 ⥪஢

// 稬  ᢮ ⥪
#include "video.h"
#include "3d.h"

// 楤 ᮢ ࠭  
void drawPerfectTexturedFace(face *f) {
  vertex *a, *b, *c, *tmp_vertex;
  int current_sx, current_sy;
  float tmp, k, x_start, x_end;
  float uz_start, uz_end, vz_start, vz_end, z1_start, z1_end, duz, dvz, dz1;
  float uz, vz, z1;
  char *dest;

  a = f->v1;
  b = f->v2;
  c = f->v3;

  // ஥㥬 設 ࠭
  projectVertex(a);
  projectVertex(b);
  projectVertex(c);

  // ⠥ u/z, v/z, 1/z   設
  a->z1 = 1 / (a->z + dist);
  a->uz = a->u * a->z1;
  a->vz = a->v * a->z1;
  b->z1 = 1 / (b->z + dist);
  b->uz = b->u * b->z1;
  b->vz = b->v * b->z1;
  c->z1 = 1 / (c->z + dist);
  c->uz = c->u * c->z1;
  c->vz = c->v * c->z1;

  // 㥬 設 ࠭  sy
  if (a->sy > b->sy) { tmp_vertex = a; a = b; b = tmp_vertex; }
  if (a->sy > c->sy) { tmp_vertex = a; a = c; c = tmp_vertex; }
  if (b->sy > c->sy) { tmp_vertex = b; b = c; c = tmp_vertex; }

  // ࠭ 㫥  ᮢ  㤥
  if ((int)c->sy == (int)a->sy) return;

  // ⠥ d(u/z)/dsx, d(v/z)/dsx, d(1/z)/dsx
  // ⠥  ᠬ   (.. 室饩 १ 設 B)
  k = (b->sy - a->sy) / (c->sy - a->sy);
  x_start = a->sx + (c->sx - a->sx) * k;
  uz_start = a->uz + (c->uz - a->uz) * k;
  vz_start = a->vz + (c->vz - a->vz) * k;
  z1_start = a->z1 + (c->z1 - a->z1) * k;
  x_end = b->sx;
  uz_end = b->uz;
  vz_end = b->vz;
  z1_end = b->z1;
  duz = (uz_start - uz_end) / (x_start - x_end);
  dvz = (vz_start - vz_end) / (x_start - x_end);
  dz1 = (z1_start - z1_end) / (x_start - x_end);

  // 筠 ᮢ ࠭
  for (current_sy = (int)a->sy; current_sy <= (int)c->sy; current_sy++) {
    // ⠥ x, u/z, v/z, 1/z  ஭ AC
    k = (current_sy - a->sy) / (c->sy - a->sy);
    x_start = a->sx + (c->sx - a->sx) * k;
    uz_start = a->uz + (c->uz - a->uz) * k;
    vz_start = a->vz + (c->vz - a->vz) * k;
    z1_start = a->z1 + (c->z1 - a->z1) * k;

    if (current_sy >= b->sy) {
      //  室  設 B, ⠥ x, u/z, v/z, 1/z  ஭ BC
      k = (current_sy - b->sy) / (c->sy - b->sy);
      x_end = b->sx + (c->sx - b->sx) * k;
      uz_end = b->uz + (c->uz - b->uz) * k;
      vz_end = b->vz + (c->vz - b->vz) * k;
      z1_end = b->z1 + (c->z1 - b->z1) * k;
    } else {
      //  室  設 B, ⠥ x, u/z, v/z, 1/z  ஭ AB
      k = (current_sy - a->sy) / (b->sy - a->sy);
      x_end = a->sx + (b->sx - a->sx) * k;
      uz_end = a->uz + (b->uz - a->uz) * k;
      vz_end = a->vz + (b->vz - a->vz) * k;
      z1_end = a->z1 + (b->z1 - a->z1) * k;
    }

    // x_start  室  x_end
    if (x_start > x_end) {
      tmp = x_start; x_start = x_end; x_end = tmp;
      tmp = uz_start; uz_start = uz_end; uz_end = tmp;
      tmp = vz_start; vz_start = vz_end; vz_end = tmp;
      tmp = z1_start; z1_start = z1_end; z1_end = tmp;
    }

    // ⠥  砫 ப  
    dest = &videoBuffer;
    dest += current_sy * xSize + (int)x_start;

    // ⮢ u, v  ⥪஢
    uz = uz_start;
    vz = vz_start;
    z1 = z1_start;

    // ⥪㥬 ப
    for (current_sx = x_start; current_sx <= x_end; current_sx++) {
      *dest++ = f->texture[(int)(vz / z1) * 256 + (int)(uz / z1)];
      uz += duz;
      vz += dvz;
      z1 += dz1;
    }
  }
}

void main() {
  vertex v1, v2, v3;
  face f;

  setVideoMode(0x13); // ⠢ ० 320x200x256c
  initPalette();      // ⠢ 
  makeTexture();      // ᣥ㥬 ⥪
  clearVideoBuffer(); // ⨬  ᮢ

  // "ந" ࠭
  f.v1 = &v1;
  f.v2 = &v2;
  f.v3 = &v3;
  f.texture = &exampleTexture;

  // ⮢ 祭 न 設
  v1.x = -120;
  v1.y = 80;
  v1.z = 0;
  v2.x = -120;
  v2.y = -80;
  v2.z = 0;
  v3.x = -80;
  v3.y = 80;
  v3.z = 160;

  // ⮢ 祭 न ⥪  設
  v1.u = 0;
  v1.v = 0;
  v2.u = 0;
  v2.v = 255;
  v3.u = 255;
  v3.v = 0;

  // 㥬 ࠭  
  drawPerfectTexturedFace(&f);

  // ᪮㥬   ࠭
  showVideoBuffer();

  //   
  getch();

  // ୥  ⥪⮢ ०
  setVideoMode(0x03);
}