// ਬ 䨭 ⥪஢

// 稬  ᢮ ⥪
#include "video.h"
#include "3d.h"

// 楤 ᮢ ࠭  
void drawAffineTexturedFace(face *f) {
  vertex *a, *b, *c, *tmp_vertex;
  int current_sx, current_sy;
  float tmp, k, x_start, x_end, u_start, u_end, v_start, v_end;
  float u, v, du, dv;
  char *dest;

  a = f->v1;
  b = f->v2;
  c = f->v3;

  // ஥㥬 設 ࠭
  projectVertex(a);
  projectVertex(b);
  projectVertex(c);

  // 㥬 設 ࠭  sy
  if (a->sy > b->sy) { tmp_vertex = a; a = b; b = tmp_vertex; }
  if (a->sy > c->sy) { tmp_vertex = a; a = c; c = tmp_vertex; }
  if (b->sy > c->sy) { tmp_vertex = b; b = c; c = tmp_vertex; }

  // ࠭ 㫥  ᮢ  㤥
  if ((int)c->sy == (int)a->sy) return;

  // ⠥ du/dsx  dv/dsx
  // ⠥  ᠬ   (.. 室饩 १ 設 B)
  k = (b->sy - a->sy) / (c->sy - a->sy);
  x_start = a->sx + (c->sx - a->sx) * k;
  u_start = a->u + (c->u - a->u) * k;
  v_start = a->v + (c->v - a->v) * k;
  x_end = b->sx;
  u_end = b->u;
  v_end = b->v;
  du = (u_start - u_end) / (x_start - x_end);
  dv = (v_start - v_end) / (x_start - x_end);

  // 筠 ᮢ ࠭
  for (current_sy = (int)a->sy; current_sy <= (int)c->sy; current_sy++) {
    // ⠥ x/u/v  ஭ AC
    k = (current_sy - a->sy) / (c->sy - a->sy);
    x_start = a->sx + (c->sx - a->sx) * k;
    u_start = a->u + (c->u - a->u) * k;
    v_start = a->v + (c->v - a->v) * k;

    if (current_sy >= b->sy) {
      //  室  設 B, ⠥ x/u/v  ஭ BC
      k = (current_sy - b->sy) / (c->sy - b->sy);
      x_end = b->sx + (c->sx - b->sx) * k;
      u_end = b->u + (c->u - b->u) * k;
      v_end = b->v + (c->v - b->v) * k;
    } else {
      //  室  設 B, ⠥ x/u/v  ஭ AC
      k = (current_sy - a->sy) / (b->sy - a->sy);
      x_end = a->sx + (b->sx - a->sx) * k;
      u_end = a->u + (b->u - a->u) * k;
      v_end = a->v + (b->v - a->v) * k;
    }

    // x_start  室  x_end
    if (x_start > x_end) {
      tmp = x_start; x_start = x_end; x_end = tmp;
      tmp = u_start; u_start = u_end; u_end = tmp;
      tmp = v_start; v_start = v_end; v_end = tmp;
    }

    // ⠥  砫 ப  
    dest = &videoBuffer;
    dest += current_sy * xSize + (int)x_start;

    // ⮢ u, v  ⥪஢
    u = u_start;
    v = v_start;

    // ⥪㥬 ப
    for (current_sx = (int)x_start; current_sx <= (int)x_end; current_sx++) {
      *dest++ = f->texture[((int)v) * 256 + (int)u];
      u += du;
      v += dv;
    }
  }
}

void main() {
  vertex v1, v2, v3;
  face f;

  setVideoMode(0x13); // ⠢ ० 320x200x256c
  initPalette();      // ⠢ 
  makeTexture();      // ᣥ㥬 ⥪
  clearVideoBuffer(); // ⨬  ᮢ

  // "ந" ࠭
  f.v1 = &v1;
  f.v2 = &v2;
  f.v3 = &v3;
  f.texture = &exampleTexture;

  // ⮢ 祭 न 設
  v1.x = -120;
  v1.y = 80;
  v1.z = 0;
  v2.x = -120;
  v2.y = -80;
  v2.z = 0;
  v3.x = -80;
  v3.y = 80;
  v3.z = 160;

  // ⮢ 祭 न ⥪  設
  v1.u = 0;
  v1.v = 0;
  v2.u = 0;
  v2.v = 255;
  v3.u = 255;
  v3.v = 0;

  // 㥬 ࠭  
  drawAffineTexturedFace(&f);

  // ᪮㥬   ࠭
  showVideoBuffer();

  //   
  getch();

  // ୥  ⥪⮢ ०
  setVideoMode(0x03);
}