/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.m11component;

import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.datasource.DataBus;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.IDataValidator;
import com.apcc.m11.arch.event.EventBus;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.IM11ComponentManager;
import com.apcc.m11.arch.m11component.IM11SubcomponentManager;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.IDebugModel;
import com.apcc.m11.debug.util.ParameterDebugModel;
import com.apcc.m11.debug.util.StackTraceDebugModel;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.DataValidator;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.m11component.Listof;
import com.apcc.m11.ds.arch.m11component.M11Descriptor;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class M11ComponentManager
implements IM11ComponentManager {
    private final String kGroupName = "M11 Component Manager";
    private Vector theM11Components;
    private boolean theStartedState = false;
    private DataBus theDataBus;
    private EventBus theEventBus;
    private IPermanentStorage thePermanentStorage;

    public void init(DataBus dataBus, EventBus eventBus, IPermanentStorage iPermanentStorage) {
        this.theDataBus = dataBus;
        this.theEventBus = eventBus;
        this.thePermanentStorage = iPermanentStorage;
        this.theM11Components = new Vector();
    }

    public void start() {
        this.theStartedState = true;
        Enumeration enumeration = this.theM11Components.elements();
        IM11Component iM11Component = null;
        while (enumeration.hasMoreElements()) {
            try {
                iM11Component = (IM11Component)enumeration.nextElement();
                iM11Component.start();
            }
            catch (ComponentFailureException componentFailureException) {
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(iM11Component);
                DEBUG.Log("M11 Component Manager", "start: Component did not load.(component)", parameterDebugModel);
                DEBUG.Trace(" ");
                DEBUG.Trace("************************************************************************");
                try {
                    DEBUG.Trace("Component Manager:  COMPONENT FAILURE:  " + iM11Component.getComponentName());
                    DEBUG.Trace(componentFailureException.toString());
                }
                catch (Exception exception) {
                    DEBUG.Trace("Component Manager: Failed Component");
                }
                DEBUG.Trace("************************************************************************");
                DEBUG.Trace(" ");
            }
            catch (Exception exception) {
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(iM11Component);
                DEBUG.Log("M11 Component Manager", "start: Component did not load.(component)", parameterDebugModel);
                DEBUG.Trace(" ");
                DEBUG.Trace("************************************************************************");
                try {
                    DEBUG.Trace("Component Manager:  COMPONENT FAILURE:  " + iM11Component.getComponentName());
                    DEBUG.Trace(exception.toString());
                }
                catch (Exception exception2) {
                    DEBUG.Trace("Component Manager: Failed Component");
                }
                DEBUG.Trace("************************************************************************");
                DEBUG.Trace(" ");
            }
        }
    }

    public void addM11Components(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            IM11Component iM11Component = (IM11Component)enumeration.nextElement();
            this.addM11Component(iM11Component, null);
        }
    }

    public void addM11Components(Vector vector, ITemporaryStorage iTemporaryStorage) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addM11Component((IM11Component)enumeration.nextElement(), iTemporaryStorage);
        }
    }

    public void stopComponent(ComponentID componentID) throws InvalidValueException {
        IM11Component iM11Component = this.findM11Component(componentID);
        iM11Component.stop();
        this.theM11Components.removeElement(iM11Component);
    }

    public void stopComponent(ComponentID componentID, ITemporaryStorage iTemporaryStorage) throws InvalidValueException {
        IM11Component iM11Component = this.findM11Component(componentID);
        iM11Component.stop(iTemporaryStorage);
        this.theM11Components.removeElement(iM11Component);
    }

    public void stopAllComponents() {
        Enumeration enumeration = this.theM11Components.elements();
        while (enumeration.hasMoreElements()) {
            ((IM11Component)enumeration.nextElement()).stop();
        }
        this.theM11Components.removeAllElements();
    }

    public void suspendComponent(ComponentID componentID) throws InvalidValueException {
        IM11Component iM11Component = this.findM11Component(componentID);
        iM11Component.suspend();
    }

    public void suspendAllComponents() {
        Enumeration enumeration = this.theM11Components.elements();
        while (enumeration.hasMoreElements()) {
            ((IM11Component)enumeration.nextElement()).suspend();
        }
    }

    public void resumeComponent(ComponentID componentID) throws InvalidValueException {
        IM11Component iM11Component = this.findM11Component(componentID);
        iM11Component.resume();
    }

    public void resumeAllComponents() {
        Enumeration enumeration = this.theM11Components.elements();
        while (enumeration.hasMoreElements()) {
            ((IM11Component)enumeration.nextElement()).resume();
        }
    }

    public Object get(ObjectId objectId) {
        Vector<M11Descriptor> vector = null;
        if (objectId.equals(Listof.kOid)) {
            Vector<M11Descriptor> vector2 = new Vector<M11Descriptor>();
            Iterator iterator = ((AbstractList)this.theM11Components).iterator();
            while (iterator.hasNext()) {
                IM11Component iM11Component = (IM11Component)iterator.next();
                String string = iM11Component.getComponentVersion();
                String string2 = iM11Component.getComponentName();
                M11Descriptor m11Descriptor = new M11Descriptor(string2, string);
                vector2.addElement(m11Descriptor);
                if (!(iM11Component instanceof IM11SubcomponentManager)) continue;
                Vector vector3 = ((IM11SubcomponentManager)((Object)iM11Component)).getSubcomponentDescriptors();
                Iterator iterator2 = ((AbstractList)vector3).iterator();
                while (iterator2.hasNext()) {
                    m11Descriptor = (M11Descriptor)iterator2.next();
                    vector2.addElement(m11Descriptor);
                }
            }
            vector = vector2;
        }
        return vector;
    }

    private void wireComponent(IM11Component iM11Component) {
        IDebugModel iDebugModel;
        IDebugModel iDebugModel2;
        Object object;
        try {
            object = (IEventProducer)iM11Component.getInterface(EventProducer.kOid);
            if (object != null) {
                object.registerEventConsumer(this.theEventBus);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (RegistrationException registrationException) {
            iDebugModel2 = new StackTraceDebugModel(registrationException);
            DEBUG.Log("M11 Component Manager", "wireComponent: eventProducer Registration exception ", iDebugModel2);
        }
        catch (Exception exception) {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "wireComponent: Bad eventProducer.(component)", parameterDebugModel);
        }
        try {
            object = (IEventConsumer)iM11Component.getInterface(EventConsumer.kOid);
            if (object != null) {
                object.registerEventProducer(this.theEventBus);
                this.theEventBus.registerEventConsumer((IEventConsumer)object);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (RegistrationException registrationException) {
            iDebugModel = new StackTraceDebugModel(registrationException);
            DEBUG.Log("M11 Component Manager", "wireComponent: eventConsumer Registration exception ", iDebugModel);
        }
        catch (Exception exception) {
            iDebugModel2 = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "wireComponent: Bad eventConsumer.(component)", iDebugModel2);
        }
        try {
            object = (IDataSource)iM11Component.getInterface(DataSource.kOid);
            if (object != null) {
                this.theDataBus.registerDataSource((IDataSource)object);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (RegistrationException registrationException) {
            iDebugModel = new StackTraceDebugModel(registrationException);
            DEBUG.Log("M11 Component Manager", "wireComponent: dataSource Registration exception ", iDebugModel);
        }
        catch (Exception exception) {
            iDebugModel2 = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "wireComponent: Bad dataSource.(component)", iDebugModel2);
        }
        try {
            object = (IDataConsumer)iM11Component.getInterface(DataConsumer.kOid);
            if (object != null) {
                object.setDataSource(this.theDataBus);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (Exception exception) {
            iDebugModel = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "wireComponent: Bad dataConsumer.(component)", iDebugModel);
        }
        try {
            object = (IDataValidator)iM11Component.getInterface(DataValidator.kOid);
            if (object != null) {
                this.theDataBus.registerDataValidator((IDataValidator)object);
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
        }
        catch (RegistrationException registrationException) {
            iDebugModel = new StackTraceDebugModel(registrationException);
            DEBUG.Log("M11 Component Manager", "wireComponent: dataValidator Registration exception ", iDebugModel);
        }
        catch (Exception exception) {
            iDebugModel2 = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "wireComponent: Bad dataValidator.(component)", iDebugModel2);
        }
    }

    private void addM11Component(IM11Component iM11Component, ITemporaryStorage iTemporaryStorage) {
        try {
            if (iM11Component != null && !this.theM11Components.contains(iM11Component)) {
                iM11Component.init(this.thePermanentStorage);
                this.wireComponent(iM11Component);
                if (this.theStartedState) {
                    if (iTemporaryStorage != null) {
                        iM11Component.start();
                    } else {
                        iM11Component.start(iTemporaryStorage);
                    }
                }
                this.theM11Components.addElement(iM11Component);
            }
        }
        catch (ComponentFailureException componentFailureException) {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(iM11Component);
            DEBUG.Log("M11 Component Manager", "addM11Component: Component failure.(component)", parameterDebugModel);
            DEBUG.Trace(" ");
            DEBUG.Trace("************************************************************************");
            try {
                DEBUG.Trace("Component Manager:  COMPONENT FAILURE:  " + iM11Component.getComponentName());
            }
            catch (Exception exception) {
                DEBUG.Trace("Component Manager: Failed Component");
            }
            DEBUG.Trace("************************************************************************");
            DEBUG.Trace(" ");
        }
        catch (Exception exception) {
            try {
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(iM11Component);
                DEBUG.Log("M11 Component Manager", "addM11Component: Component failure.(component)", parameterDebugModel);
                DEBUG.Trace(" ");
                DEBUG.Trace("************************************************************************");
                DEBUG.Trace("Component Manager:  COMPONENT FAILURE:  " + iM11Component.getComponentName());
            }
            catch (Exception exception2) {
                DEBUG.Trace("Component Manager: Failed Component");
            }
            DEBUG.Trace("************************************************************************");
            DEBUG.Trace(" ");
        }
    }

    private IM11Component findM11Component(ComponentID componentID) throws InvalidValueException {
        Enumeration enumeration = this.theM11Components.elements();
        IM11Component iM11Component = (IM11Component)enumeration.nextElement();
        while (!componentID.isEqual(iM11Component.getComponentID()) && enumeration.hasMoreElements()) {
            iM11Component = (IM11Component)enumeration.nextElement();
        }
        if (!componentID.isEqual(iM11Component.getComponentID())) {
            throw new InvalidValueException("Component not found");
        }
        return iM11Component;
    }
}

