/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.factory;

import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.factory.ComponentDescriptor;
import com.apcc.m11.arch.factory.ComponentLoader;
import com.apcc.m11.arch.factory.IComponentStreamer;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.util.StackTraceDebugModel;
import com.apcc.m11.jar.JarFilenameFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;

public class ComponentFactory {
    public static final int kMaxTransferBufferSize = 1024;
    public static final String kJarExtension = ".jar";
    private ComponentLoader theLoader = new ComponentLoader();
    private Hashtable theLoadedComponents = new Hashtable();
    private String theDirectory = new String(".");

    public Vector createAll() {
        Vector<IComponent> vector = null;
        File file = new File(this.theDirectory, "");
        String[] stringArray = file.list(new JarFilenameFilter());
        if (stringArray != null) {
            vector = new Vector<IComponent>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                IComponent iComponent = this.load(stringArray[n]);
                if (iComponent != null) {
                    vector.addElement(iComponent);
                }
                ++n;
            }
            vector.trimToSize();
        }
        return vector;
    }

    public IComponent load(String string) {
        IComponent iComponent = null;
        ComponentDescriptor componentDescriptor = null;
        if (this.theLoadedComponents.contains(string)) {
            componentDescriptor = (ComponentDescriptor)this.theLoadedComponents.get(string);
            iComponent = componentDescriptor.Component;
        } else {
            String string2;
            String string3 = new String(string);
            if (!string3.endsWith(kJarExtension)) {
                string3 = new String(string) + kJarExtension;
            }
            if (this.theLoader.open(string2 = this.theDirectory + File.separatorChar + string3) && (iComponent = this.theLoader.load()) != null) {
                componentDescriptor = new ComponentDescriptor();
                componentDescriptor.Name = new String(string);
                componentDescriptor.JarFile = string2;
                componentDescriptor.Component = iComponent;
                this.theLoadedComponents.put(string, componentDescriptor);
            }
        }
        return iComponent;
    }

    public boolean release(String string) {
        boolean bl = false;
        if (this.theLoadedComponents.contains(string)) {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.theLoadedComponents.get(string);
            this.theLoadedComponents.remove(string);
            componentDescriptor.Name = null;
            componentDescriptor.JarFile = null;
            componentDescriptor.Component = null;
            componentDescriptor = null;
        }
        return bl;
    }

    public boolean remove(String string) {
        boolean bl = false;
        if (this.theLoadedComponents.contains(string)) {
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.theLoadedComponents.get(string);
            File file = new File(componentDescriptor.JarFile);
            this.release(string);
            bl = file.delete();
        }
        return bl;
    }

    public boolean store(IComponentStreamer iComponentStreamer) {
        boolean bl = false;
        String string = null;
        try {
            string = new String(this.theDirectory + File.pathSeparatorChar + iComponentStreamer.getPreferredName());
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string)));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iComponentStreamer.getInputStream()));
            char[] cArray = new char[1024];
            int n = 0;
            while ((n = ((Reader)bufferedReader).read(cArray, 0, 1024)) != -1) {
                ((Writer)bufferedWriter).write(cArray, 0, n);
            }
            ((Writer)bufferedWriter).close();
            ((Reader)bufferedReader).close();
            bl = true;
        }
        catch (IOException iOException) {
            DEBUG.Log("Components", "Storing the component " + string + " has failed", new StackTraceDebugModel(iOException));
        }
        return bl;
    }

    public void setDirectory(String string) {
        this.theDirectory = new String(string);
    }
}

