/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.application;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.util.ParameterDebugModel;
import java.io.File;
import java.util.MissingResourceException;

public class Directory {
    private static final String kComponentSubDirectory = "comp";
    private static final String kExeSubDirectory = "bin";
    private static final String kDirectoryID = "host";
    private static final String kApplicationDirectoryIdentifier = "ApplicationDirectory";
    private String theFullPathApplicationDirectory;
    private String theExeDirectory;
    private String theComponentDirectory;

    public Directory(IPermanentStorage iPermanentStorage) throws MissingResourceException {
        try {
            this.theFullPathApplicationDirectory = (String)iPermanentStorage.readData(new ComponentID(kDirectoryID), kApplicationDirectoryIdentifier);
        }
        catch (StorageEntryException storageEntryException) {
            DEBUG.Log(kDirectoryID, "Could not get directory information from the config file.");
            DEBUG.Trace("Could not get directory information from the config file.");
            throw new MissingResourceException("Could not get directory information from the config file.", "Directory", "Full Path Application Directory");
        }
        this.theExeDirectory = this.theFullPathApplicationDirectory + File.separator + kExeSubDirectory;
        this.theComponentDirectory = this.theFullPathApplicationDirectory + File.separator + kComponentSubDirectory;
        DEBUG.Log(kDirectoryID, "Application Directory: (theFullPathApplicationDirectory)", new ParameterDebugModel(this.theFullPathApplicationDirectory));
        DEBUG.Log(kDirectoryID, "Exe Directory: (theExeDirectory)", new ParameterDebugModel(this.theExeDirectory));
        DEBUG.Log(kDirectoryID, "Component Directory: (theComponentDirectory)", new ParameterDebugModel(this.theComponentDirectory));
    }

    public String getExeDirectory() {
        return this.theExeDirectory;
    }

    public String getFullApplicationDirectory() {
        return this.theFullPathApplicationDirectory;
    }

    public String getFullComponentDirectory() {
        return this.theComponentDirectory;
    }
}

