/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.arch.application;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.RegistrationException;
import com.apcc.m11.arch.application.Directory;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.Availability;
import com.apcc.m11.arch.datasource.DataBus;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.arch.event.EventBus;
import com.apcc.m11.arch.event.IEventConsumer;
import com.apcc.m11.arch.event.IEventProducer;
import com.apcc.m11.arch.factory.ComponentFactory;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.m11component.M11ComponentManager;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.ITemporaryStorage;
import com.apcc.m11.arch.storage.PermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.debug.DEBUG;
import com.apcc.m11.debug.IDebugModel;
import com.apcc.m11.debug.util.ParameterDebugModel;
import com.apcc.m11.debug.util.StackTraceDebugModel;
import com.apcc.m11.ds.arch.application.Debug;
import com.apcc.m11.ds.arch.application.Group;
import com.apcc.m11.ds.arch.application.M11VersionNumber;
import com.apcc.m11.ds.arch.application.Name;
import com.apcc.m11.ds.arch.application.Terminate;
import com.apcc.m11.ds.arch.interfaces.Component;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventConsumer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.arch.m11component.Add;
import com.apcc.m11.ds.arch.m11component.Listof;
import com.apcc.m11.ds.arch.m11component.Remove;
import com.apcc.m11.ds.arch.m11component.Resume;
import com.apcc.m11.ds.arch.m11component.ResumeAll;
import com.apcc.m11.ds.arch.m11component.Suspend;
import com.apcc.m11.ds.arch.m11component.SuspendAll;
import com.apcc.m11.ds.events.internalEvents.application.AllComponentsStarted;
import com.apcc.m11.ds.events.internalEvents.shutdown.FinalShutdown;
import com.apcc.m11.ds.host.directory.ComponentDirectory;
import com.apcc.m11.ds.host.directory.CurrentDirectory;
import com.apcc.m11.ds.host.directory.ExeDirectory;
import com.apcc.m11.util.Sleep;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;

public class Application
implements IComponent,
IDataSource,
IM11Component,
IEventConsumer {
    private final String kApplicationGroup = "Application";
    private final String kApplicationNameIdentifier = "Application_Name";
    private final String kCopyrightInformationIdentifier = "Copyright";
    private String theApplicationName = "PowerChute";
    private String theCopyrightInformation = "Copyright 2000 American Power Conversion";
    private final String kDefaultCountry = "Default Country";
    private final String kDefaultLanguage = "Default Language";
    private final String kDebugTracingEnabledIdentifier = "Debug_Tracing";
    private final String kDebugLoggingEnabledIdentifier = "Debug_Logging";
    private final String kDebugLoggingFileName = "Debug_Logging_File_Name";
    private Vector theSupportedOids;
    private M11ComponentManager theComponentManager;
    private ComponentFactory theComponentFactory;
    private DataBus theDataBus;
    private EventBus theEventBus;
    private IPermanentStorage thePermanentStorage;
    private Directory theDirectory;
    private Sleep theSleepObject;
    private IEventProducer theEventProducer;
    private final String theComponentVersionNumber = "1.0.0";
    private final String theArchitectureVersion = "1.0.0";

    public static void main(String[] stringArray) {
        DEBUG.Trace("Application Starting");
        String string = "m11.cfg";
        try {
            Application application = new Application();
            application.begin(string);
            DEBUG.Trace("");
            DEBUG.Trace("Application Exited");
            DEBUG.Trace(" ");
            DEBUG.Log("Application", "");
            DEBUG.Log("Application", " Application Exited ");
            DEBUG.Log("Application", "");
        }
        catch (Exception exception) {
            DEBUG.Trace("");
            DEBUG.Trace("Application Start Failed");
            DEBUG.Trace(" ");
            DEBUG.Trace("Exception = ");
            DEBUG.Trace(exception.toString());
            DEBUG.Trace("");
            DEBUG.Log("Application", "");
            DEBUG.Log("Application", " Application Start Failed ");
            DEBUG.Log("Application", "");
        }
    }

    public void init(IPermanentStorage iPermanentStorage) throws ComponentFailureException {
    }

    public void start() throws ComponentFailureException {
    }

    public void start(ITemporaryStorage iTemporaryStorage) throws ComponentFailureException {
    }

    public void stop() {
        this.theSleepObject.wakeUp();
    }

    public void stop(ITemporaryStorage iTemporaryStorage) {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public ComponentID getComponentID() {
        return new ComponentID("Application");
    }

    public String getComponentName() {
        return "Application Component";
    }

    public String getComponentVersion() {
        return "1.0.0";
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        Application application = null;
        if (objectId.equals(M11Component.kOid)) {
            application = this;
        } else if (objectId.equals(DataSource.kOid)) {
            application = this;
        } else if (objectId.equals(EventConsumer.kOid)) {
            application = this;
        } else {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(objectId);
            DEBUG.Log("Application", "getInterface: interface not supported (anInterfaceId)", parameterDebugModel);
            throw new InvalidObjectIdException("Interface Not Supported");
        }
        return application;
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        Application application = null;
        if (objectId.equals(Component.kOid)) {
            application = this;
        } else if (objectId.equals(M11Component.kOid)) {
            application = this;
        } else {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(objectId);
            DEBUG.Log("Application", "getInstanceOf: interface not supported (anInterfaceID)", parameterDebugModel);
            throw new InvalidObjectIdException("Interface not supported");
        }
        return application;
    }

    public void registerEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer = iEventProducer;
    }

    public void unRegisterEventProducer(IEventProducer iEventProducer) throws RegistrationException {
        this.theEventProducer.unRegisterEventConsumer(this);
    }

    public Enumeration getConsumedEvents() {
        Vector<ObjectId> vector = new Vector<ObjectId>();
        vector.addElement(FinalShutdown.kOid);
        return vector.elements();
    }

    public void update(Event event) {
        if (event.getObjectId().equals(FinalShutdown.kOid)) {
            try {
                this.set(Terminate.kOid, new Object());
            }
            catch (Exception exception) {
                StackTraceDebugModel stackTraceDebugModel = new StackTraceDebugModel(exception);
                DEBUG.Log("Application", "update: terminate set failed", stackTraceDebugModel);
            }
        }
    }

    public SetResult set(ObjectId objectId, Object object) throws InvalidObjectIdException {
        SetResult setResult = new SetResult();
        if (objectId.equals(Add.kOid)) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(object);
            this.theComponentManager.addM11Components(vector);
            setResult.setSuccessful(true);
        } else if (objectId.equals(Remove.kOid)) {
            setResult.setSuccessful(false);
            try {
                this.theComponentManager.stopComponent((ComponentID)object);
                if (this.theComponentFactory.remove(((ComponentID)object).getID())) {
                    setResult.setSuccessful(true);
                }
            }
            catch (InvalidValueException invalidValueException) {
                setResult.setSuccessful(false);
                StackTraceDebugModel stackTraceDebugModel = new StackTraceDebugModel(invalidValueException);
                DEBUG.Log("Application", "set: Component not removed.", stackTraceDebugModel);
            }
        } else if (objectId.equals(Suspend.kOid)) {
            try {
                this.theComponentManager.suspendComponent((ComponentID)object);
                setResult.setSuccessful(true);
            }
            catch (InvalidValueException invalidValueException) {
                setResult.setSuccessful(false);
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(object);
                DEBUG.Log("Application", "set: Component not suspended. (aValue)", parameterDebugModel);
            }
        } else if (objectId.equals(SuspendAll.kOid)) {
            this.theComponentManager.suspendAllComponents();
            setResult.setSuccessful(true);
        } else if (objectId.equals(Resume.kOid)) {
            try {
                this.theComponentManager.resumeComponent((ComponentID)object);
                setResult.setSuccessful(true);
            }
            catch (InvalidValueException invalidValueException) {
                setResult.setSuccessful(false);
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(object);
                DEBUG.Log("Application", "set: Component not resumed.", parameterDebugModel);
            }
        } else if (objectId.equals(ResumeAll.kOid)) {
            this.theComponentManager.resumeAllComponents();
            setResult.setSuccessful(true);
        } else if (objectId.equals(Terminate.kOid)) {
            this.theComponentManager.stopAllComponents();
            setResult.setSuccessful(true);
        } else if (objectId.equals(Debug.kOid)) {
            try {
                Boolean bl = (Boolean)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Logging");
                DEBUG.SetLogging(bl);
                Boolean bl2 = (Boolean)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Tracing");
                DEBUG.SetTracing(bl2);
                String string = (String)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Logging_File_Name");
                OutputStream outputStream = DEBUG.CreateFileOutputStream(string);
                DEBUG.SetOutputStream(outputStream);
            }
            catch (Exception exception) {
                DEBUG.Log("Application", "Application could not get debug info from permanent storage");
            }
        } else {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(objectId);
            DEBUG.Log("Application", "set: Bad object ID.", parameterDebugModel);
            throw new InvalidObjectIdException();
        }
        return setResult;
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = new GetResult();
        if (objectId.equals(Listof.kOid)) {
            getResult.setValue(this.theComponentManager.get(objectId));
        } else if (objectId.equals(CurrentDirectory.kOid)) {
            getResult.setValue(this.theDirectory.getFullApplicationDirectory());
        } else if (objectId.equals(ComponentDirectory.kOid)) {
            getResult.setValue(this.theDirectory.getFullComponentDirectory());
        } else if (objectId.equals(ExeDirectory.kOid)) {
            getResult.setValue(this.theDirectory.getExeDirectory());
        } else if (objectId.equals(Name.kOid)) {
            getResult.setValue(new String(this.theApplicationName));
        } else if (objectId.equals(M11VersionNumber.kOid)) {
            getResult.setValue(new String("1.0.0"));
        } else {
            ParameterDebugModel parameterDebugModel = new ParameterDebugModel(objectId);
            DEBUG.Log("Application", "get: Bad object ID.", parameterDebugModel);
            throw new InvalidObjectIdException();
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        GetResult getResult = null;
        switch (n) {
            case 0: {
                getResult = this.get(objectId, n);
                break;
            }
            case 1: {
                if (objectId.equals(Listof.kOid)) {
                    Availability availability = new Availability(true);
                    getResult = new GetResult();
                    getResult.setValue(availability);
                    break;
                }
                if (objectId.equals(Add.kOid)) {
                    Availability availability = new Availability(true);
                    getResult = new GetResult();
                    getResult.setValue(availability);
                    break;
                }
                if (objectId.equals(Remove.kOid)) {
                    Availability availability = new Availability(true);
                    getResult = new GetResult();
                    getResult.setValue(availability);
                    break;
                }
                Availability availability = new Availability(false);
                getResult = new GetResult();
                getResult.setValue(availability);
                break;
            }
            case 2: {
                getResult = new GetResult();
                getResult.setError();
                break;
            }
            case 3: {
                getResult = new GetResult();
                getResult.setError();
                break;
            }
            default: {
                ParameterDebugModel parameterDebugModel = new ParameterDebugModel(objectId, new Integer(n));
                DEBUG.Log("Application", "get: Bad object ID or type (anOid, type)", parameterDebugModel);
                throw new InvalidObjectIdException();
            }
        }
        return getResult;
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException {
        throw new InvalidObjectIdException();
    }

    public Enumeration getSupportedOids() {
        return this.theSupportedOids.elements();
    }

    private Application() {
    }

    private void begin(String string) throws MissingResourceException {
        IDebugModel iDebugModel;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        this.theSupportedOids = new Vector();
        this.theSupportedOids.addElement(Listof.kOid);
        this.theSupportedOids.addElement(Remove.kOid);
        this.theSupportedOids.addElement(Add.kOid);
        this.theSupportedOids.addElement(ComponentDirectory.kOid);
        this.theSupportedOids.addElement(CurrentDirectory.kOid);
        this.theSupportedOids.addElement(ExeDirectory.kOid);
        this.theSupportedOids.addElement(Group.kOid);
        this.theSupportedOids.addElement(Name.kOid);
        this.theSupportedOids.addElement(M11VersionNumber.kOid);
        this.thePermanentStorage = new PermanentStorage(string);
        try {
            this.theApplicationName = (String)this.thePermanentStorage.readData(this.getComponentID(), "Application_Name");
            this.theCopyrightInformation = (String)this.thePermanentStorage.readData(this.getComponentID(), "Copyright");
        }
        catch (StorageEntryException storageEntryException) {
            DEBUG.Log("Application", "Application Name or copyright was not found - using default.");
        }
        System.out.println(this.theApplicationName);
        System.out.println(this.theCopyrightInformation);
        try {
            serializable = (Boolean)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Logging");
            DEBUG.SetLogging((Boolean)serializable);
            object3 = (Boolean)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Tracing");
            DEBUG.SetTracing((Boolean)object3);
            object2 = (String)this.thePermanentStorage.readData(this.getComponentID(), "Debug_Logging_File_Name");
            object = DEBUG.CreateFileOutputStream((String)object2);
            DEBUG.SetOutputStream((OutputStream)object);
        }
        catch (Exception exception) {
            DEBUG.Log("Application", "Application could not get debug info from permanent storage");
        }
        this.theDirectory = new Directory(this.thePermanentStorage);
        DEBUG.Trace("Created thePermanentStorage");
        this.theDataBus = new DataBus();
        this.theEventBus = new EventBus();
        DEBUG.Trace("Created EventBus DataBus");
        this.theComponentManager = new M11ComponentManager();
        this.theComponentManager.init(this.theDataBus, this.theEventBus, this.thePermanentStorage);
        DEBUG.Trace("Created theComponentManager");
        this.theComponentFactory = new ComponentFactory();
        this.theComponentFactory.setDirectory(this.theDirectory.getFullComponentDirectory());
        serializable = this.theComponentFactory.createAll();
        DEBUG.Trace("Created all components");
        ((Vector)serializable).addElement(this);
        object3 = ((Vector)serializable).elements();
        object2 = new Vector();
        object = null;
        while (object3.hasMoreElements()) {
            try {
                object = (IComponent)object3.nextElement();
                IM11Component iM11Component = (IM11Component)object.getInstanceOf(M11Component.kOid);
                ((Vector)object2).addElement(iM11Component);
            }
            catch (InvalidObjectIdException invalidObjectIdException) {
                iDebugModel = new ParameterDebugModel(object);
                DEBUG.Log("Application", "begin: Component did not load.(component)", iDebugModel);
                DEBUG.Trace(" ");
                DEBUG.Trace("************************************************************************");
                try {
                    DEBUG.Trace("Application:  M11 INTERFACE FAILURE:  " + object.toString());
                }
                catch (Exception exception) {
                    DEBUG.Trace("Application:  Component Failed to load M11 interface");
                }
                DEBUG.Trace("************************************************************************");
                DEBUG.Trace(" ");
            }
        }
        DEBUG.Trace("Created all components");
        this.theComponentManager.addM11Components((Vector)object2);
        this.theComponentManager.start();
        DEBUG.Trace(" ");
        DEBUG.Trace("Application:   All components have received started call. ");
        DEBUG.Trace(" ");
        this.theEventBus.update(new Event(AllComponentsStarted.kOid));
        try {
            this.theSleepObject = new Sleep();
            this.theSleepObject.goToSleep();
        }
        catch (Exception exception) {
            iDebugModel = new StackTraceDebugModel(exception);
            DEBUG.Log("Application", "Application Terminated", iDebugModel);
        }
        DEBUG.Log("Application Terminated");
    }
}

