/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut1 = new Dimension(1, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Dimension vstrut15 = new Dimension(1, 15);
    private static final Dimension vstrut20 = new Dimension(1, 20);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 300;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 400;
    private static int MIN_HEIGHT = 200;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_MIN_WIDTH = 400;
    private static int LIST_MIN_HEIGHT = 100;
    private static Dimension LIST_MIN_SIZE = new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT);
    static final int space = 10;
    private JPanel centerPanel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction;
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private JList list;
    private JButton approveButton;
    private JButton cancelButton;
    private JComboBox filterComboBox;
    private JPanel bodyPanel;
    private int lookInLabelMnemonic;
    private String lookInLabelText;
    private int fileNameLabelMnemonic;
    private String fileNameLabelText;
    private int filesOfTypeLabelMnemonic;
    private String filesOfTypeLabelText;
    private String upFolderToolTipText;
    private String upFolderAccessibleName;
    private String homeFolderToolTipText;
    private String homeFolderAccessibleName;
    private String newFolderToolTipText;
    private String newFolderAccessibleName;
    private String listViewButtonToolTipText;
    private String listViewButtonAccessibleName;
    private String detailsViewButtonToolTipText;
    private String detailsViewButtonAccessibleName;
    int lastIndex;
    boolean editing;
    int editX;
    int editWidth;
    JTextField editCell;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setLayout(new BoxLayout(jFileChooser, 1));
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jFileChooser.add(jPanel);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JLabel jLabel = new JLabel(this.lookInLabelText);
        jLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.5f);
        jPanel.add(Box.createRigidArea(hstrut10));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(hstrut25));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        jLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        jPanel.add(this.directoryComboBox);
        jPanel.add(Box.createRigidArea(hstrut10));
        JButton jButton = new JButton(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener(this.getChangeToParentDirectoryAction());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        jButton = new JButton(this.homeFolderIcon);
        jButton.setToolTipText(this.homeFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener(this.getGoHomeAction());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        jButton = new JButton(this.newFolderIcon);
        jButton.setToolTipText(this.newFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener(this.getNewFolderAction());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setToolTipText(this.listViewButtonToolTipText);
        jToggleButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        jToggleButton.setEnabled(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add(jToggleButton);
        jToggleButton = new JToggleButton(this.detailsViewIcon);
        jToggleButton.setToolTipText(this.detailsViewButtonToolTipText);
        jToggleButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setSelected(true);
        jToggleButton.setEnabled(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add(jToggleButton);
        jPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.createList(jFileChooser);
        jPanel2.setMinimumSize(LIST_MIN_SIZE);
        this.centerPanel.add((Component)jPanel2, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        jFileChooser.add(this.centerPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(hstrut10));
        jFileChooser.add(Box.createRigidArea(vstrut10));
        jFileChooser.add(jPanel3);
        jFileChooser.add(Box.createRigidArea(vstrut10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JLabel jLabel2 = new JLabel(this.fileNameLabelText);
        jLabel2.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jLabel2.setAlignmentY(0.0f);
        jPanel4.add(jLabel2);
        jPanel4.add(Box.createRigidArea(vstrut20));
        JLabel jLabel3 = new JLabel(this.filesOfTypeLabelText);
        jLabel3.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel4.add(jLabel3);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createRigidArea(hstrut25));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        this.filenameTextField = new JTextField(windowsFileChooserUI){
            private final /* synthetic */ WindowsFileChooserUI this$0;

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.constructor$0(windowsFileChooserUI);
            }

            public void constructor$0(WindowsFileChooserUI windowsFileChooserUI) {
            }
        };
        jLabel2.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.setFileName(jFileChooser.getName(file));
        }
        jPanel5.add(this.filenameTextField);
        jPanel5.add(Box.createRigidArea(vstrut15));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        jLabel3.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel5.add(this.filterComboBox);
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createRigidArea(hstrut10));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        WindowsFileChooserUI windowsFileChooserUI2 = this;
        if (windowsFileChooserUI2 == null) {
            throw null;
        }
        this.approveButton = new JButton(windowsFileChooserUI2, this.getApproveButtonText(jFileChooser)){
            private final /* synthetic */ WindowsFileChooserUI this$0;

            public Dimension getMaximumSize() {
                return this.this$0.access$0().getPreferredSize().width > this.this$0.access$1().getPreferredSize().width ? this.this$0.access$0().getPreferredSize() : this.this$0.access$1().getPreferredSize();
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.constructor$0(windowsFileChooserUI, string);
            }

            public void constructor$0(WindowsFileChooserUI windowsFileChooserUI, String string) {
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        jPanel6.add(this.approveButton);
        jPanel6.add(Box.createRigidArea(vstrut10));
        WindowsFileChooserUI windowsFileChooserUI3 = this;
        if (windowsFileChooserUI3 == null) {
            throw null;
        }
        this.cancelButton = new JButton(windowsFileChooserUI3, this.cancelButtonText){
            private final /* synthetic */ WindowsFileChooserUI this$0;

            public Dimension getMaximumSize() {
                return this.this$0.access$0().getPreferredSize().width > this.this$0.access$1().getPreferredSize().width ? this.this$0.access$0().getPreferredSize() : this.this$0.access$1().getPreferredSize();
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.constructor$0(windowsFileChooserUI, string);
            }

            public void constructor$0(WindowsFileChooserUI windowsFileChooserUI, String string) {
            }
        };
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        jPanel6.add(this.cancelButton);
        jPanel3.add(jPanel6);
        jPanel3.add(Box.createRigidArea(hstrut10));
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString("FileChooser.lookInLabelText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = UIManager.getString("FileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = UIManager.getString("FileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.listViewButtonToolTipText = UIManager.getString("FileChooser.listViewButtonToolTipText");
        this.listViewButtonAccessibleName = UIManager.getString("FileChooser.listViewButtonAccessibleName");
        this.detailsViewButtonToolTipText = UIManager.getString("FileChooser.detailsViewButtonToolTipText");
        this.detailsViewButtonAccessibleName = UIManager.getString("FileChooser.detailsViewButtonAccessibleName");
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.list = new JList();
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        this.list.setCellRenderer(windowsFileChooserUI.new FileRenderer());
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return windowsFileChooserUI.new SingleClickListener(jList);
    }

    private void setEditIndex(int n) {
        this.lastIndex = n;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        this.editing = false;
        if (this.editCell != null) {
            this.list.remove(this.editCell);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
        File file = this.getFileChooser().getSelectedFile();
        if (file != null && this.getModel().contains(file)) {
            this.list.setSelectedIndex(this.getModel().indexOf(file));
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        } else {
            this.list.clearSelection();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return new PropertyChangeListener(windowsFileChooserUI){
            private final /* synthetic */ WindowsFileChooserUI this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    this.this$0.access$2();
                    File file = (File)propertyChangeEvent.getNewValue();
                    if (file != null) {
                        this.this$0.setFileName(this.this$0.getFileChooser().getName(file));
                    } else {
                        this.this$0.setFileName(null);
                    }
                    this.this$0.setFileSelected();
                } else if (string.equals("directoryChanged")) {
                    this.this$0.access$2();
                    this.this$0.access$3();
                    this.this$0.clearIconCache();
                    this.this$0.access$4().clearSelection();
                    File file = this.this$0.getFileChooser().getCurrentDirectory();
                    if (file != null) {
                        this.this$0.access$5().access$0(file);
                        this.this$0.getNewFolderAction().setEnabled(file.canWrite());
                    }
                } else if (string.equals("fileFilterChanged") || string.equals("fileSelectionChanged")) {
                    this.this$0.access$2();
                    this.this$0.access$3();
                    this.this$0.clearIconCache();
                    this.this$0.access$4().clearSelection();
                } else if (string == "AccessoryChangedProperty") {
                    if (this.this$0.getAccessoryPanel() != null) {
                        JComponent jComponent;
                        if (propertyChangeEvent.getOldValue() != null) {
                            this.this$0.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
                        }
                        if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                            this.this$0.getAccessoryPanel().add((Component)jComponent, "Center");
                        }
                    }
                } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                    JFileChooser jFileChooser = this.this$0.getFileChooser();
                    this.this$0.access$0().setText(this.this$0.getApproveButtonText(jFileChooser));
                    this.this$0.access$0().setToolTipText(this.this$0.getApproveButtonToolTipText(jFileChooser));
                    this.this$0.access$0().setMnemonic(this.this$0.getApproveButtonMnemonic(jFileChooser));
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    this.this$0.access$0().setMnemonic(this.this$0.getApproveButtonMnemonic(this.this$0.getFileChooser()));
                }
            }
            {
                this.this$0 = windowsFileChooserUI;
                this.constructor$0(windowsFileChooserUI);
            }

            public void constructor$0(WindowsFileChooserUI windowsFileChooserUI) {
            }
        };
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        if (this.getModel().contains(file)) {
            this.list.ensureIndexIsVisible(this.getModel().indexOf(file));
        }
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return new DirectoryComboBoxRenderer(windowsFileChooserUI);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return windowsFileChooserUI.new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return windowsFileChooserUI.new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        return windowsFileChooserUI.new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        File file = this.getFileChooser().getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    /* synthetic */ JButton access$0() {
        return this.approveButton;
    }

    /* synthetic */ JButton access$1() {
        return this.cancelButton;
    }

    /* synthetic */ void access$2() {
        this.cancelEdit();
    }

    /* synthetic */ void access$3() {
        this.resetEditIndex();
    }

    /* synthetic */ JList access$4() {
        return this.list;
    }

    /* synthetic */ DirectoryComboBoxModel access$5() {
        return this.directoryComboBoxModel;
    }

    /* synthetic */ void access$6(int n) {
        this.setEditIndex(n);
    }

    /* synthetic */ JComboBox access$7() {
        return this.directoryComboBox;
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
        WindowsFileChooserUI windowsFileChooserUI = this;
        if (windowsFileChooserUI == null) {
            throw null;
        }
        this.directoryComboBoxAction = windowsFileChooserUI.new DirectoryComboBoxAction();
        this.bodyPanel = null;
        this.lookInLabelMnemonic = 0;
        this.lookInLabelText = null;
        this.fileNameLabelMnemonic = 0;
        this.fileNameLabelText = null;
        this.filesOfTypeLabelMnemonic = 0;
        this.filesOfTypeLabelText = null;
        this.upFolderToolTipText = null;
        this.upFolderAccessibleName = null;
        this.homeFolderToolTipText = null;
        this.homeFolderAccessibleName = null;
        this.newFolderToolTipText = null;
        this.newFolderAccessibleName = null;
        this.listViewButtonToolTipText = null;
        this.listViewButtonAccessibleName = null;
        this.detailsViewButtonToolTipText = null;
        this.detailsViewButtonAccessibleName = null;
        this.lastIndex = -1;
        this.editing = false;
        this.editX = 20;
        this.editWidth = 200;
        this.editCell = null;
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = this.list.locationToIndex(mouseEvent.getPoint());
                if (n >= 0 && WindowsFileChooserUI.this.lastIndex == n && !WindowsFileChooserUI.this.editing) {
                    WindowsFileChooserUI.this.editing = true;
                    Rectangle rectangle = this.list.getCellBounds(n, n);
                    this.list.add(WindowsFileChooserUI.this.editCell);
                    File file = (File)this.list.getSelectedValue();
                    WindowsFileChooserUI.this.editCell.setText(WindowsFileChooserUI.this.getFileChooser().getName(file));
                    WindowsFileChooserUI.this.editCell.setBounds(WindowsFileChooserUI.this.editX + rectangle.x, rectangle.y, WindowsFileChooserUI.this.editWidth, rectangle.height);
                    WindowsFileChooserUI.this.editCell.selectAll();
                } else {
                    if (n >= 0) {
                        WindowsFileChooserUI.this.access$6(n);
                    } else {
                        WindowsFileChooserUI.this.access$3();
                    }
                    WindowsFileChooserUI.this.access$2();
                }
            } else {
                WindowsFileChooserUI.this.access$3();
                WindowsFileChooserUI.this.access$2();
            }
            this.list.repaint();
        }

        public SingleClickListener(JList jList) {
            this.list = jList;
            WindowsFileChooserUI.this.editCell = new JTextField();
            WindowsFileChooserUI windowsFileChooserUI2 = WindowsFileChooserUI.this;
            if (windowsFileChooserUI2 == null) {
                throw null;
            }
            WindowsFileChooserUI.this.editCell.addActionListener(windowsFileChooserUI2.new EditActionListener());
        }
    }

    class EditActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JTextField jTextField = (JTextField)actionEvent.getSource();
            File file2 = (File)WindowsFileChooserUI.this.access$4().getSelectedValue();
            String string = jTextField.getText();
            if (!(string = string.trim()).equals(WindowsFileChooserUI.this.getFileChooser().getName(file2)) && file2.renameTo(file = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory(), string))) {
                WindowsFileChooserUI.this.rescanCurrentDirectory(WindowsFileChooserUI.this.getFileChooser());
            }
            WindowsFileChooserUI.this.access$2();
            WindowsFileChooserUI.this.access$4().repaint();
        }

        EditActionListener() {
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            String string = WindowsFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl) {
                WindowsFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }

        FileRenderer() {
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private final /* synthetic */ WindowsFileChooserUI this$0;
        IndentIcon ii;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            if (file == null) {
                this.setText("");
                return this;
            }
            String string = this.this$0.getFileChooser().getName(file);
            this.setText(string);
            int n2 = 0;
            if (n != -1) {
                object2 = file;
                while (((File)object2).getParent() != null) {
                    ++n2;
                    object2 = this.this$0.getFileChooser().getFileSystemView().createFileObject(((File)object2).getParent());
                }
            }
            this.ii.icon = object2 = this.this$0.getFileChooser().getIcon(file);
            this.ii.depth = n2;
            this.setIcon(this.ii);
            return this;
        }

        DirectoryComboBoxRenderer(WindowsFileChooserUI windowsFileChooserUI) {
            WindowsFileChooserUI windowsFileChooserUI2 = this.this$0 = windowsFileChooserUI;
            if (windowsFileChooserUI2 == null) {
                throw null;
            }
            this.ii = windowsFileChooserUI2.new IndentIcon();
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        IndentIcon() {
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int topIndex = -1;
        int pathCount = 0;
        File selectedDirectory = null;

        private void removeSelectedDirectory() {
            if (this.topIndex >= 0) {
                int n = this.topIndex;
                while (n < this.topIndex + this.pathCount) {
                    this.directories.removeElementAt(this.topIndex + 1);
                    ++n;
                }
            }
            this.topIndex = -1;
            this.pathCount = 0;
            this.selectedDirectory = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addItem(File file) {
            if (file == null) {
                return;
            }
            if (this.selectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File file2 = null;
            try {
                file2 = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                file2 = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file.getAbsolutePath());
            }
            File file3 = file2;
            Vector<File> vector = new Vector<File>(10);
            while (file3.getParent() != null) {
                vector.addElement(file3);
                if (this.directories.contains(file3)) {
                    this.topIndex = this.directories.indexOf(file3);
                }
                file3 = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(file3.getParent());
            }
            this.pathCount = vector.size();
            if (this.topIndex < 0) {
                if (this.directories.contains(file3)) {
                    this.topIndex = this.directories.indexOf(file3);
                } else {
                    this.directories.addElement(file3);
                }
            }
            int n = 0;
            while (n < vector.size()) {
                this.directories.insertElementAt(vector.elementAt(n), this.topIndex + 1);
                ++n;
            }
            this.setSelectedItem(file2);
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }

        /* synthetic */ void access$0(File file) {
            this.addItem(file);
        }

        public DirectoryComboBoxModel() {
            File[] fileArray = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            int n = 0;
            while (n < fileArray.length) {
                this.directories.addElement(fileArray[n]);
                ++n;
            }
            this.addItem(WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory());
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                WindowsFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    WindowsFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }

        protected FilterComboBoxModel() {
            this.filters = WindowsFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }
    }

    protected class DirectoryComboBoxAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory((File)WindowsFileChooserUI.this.access$7().getSelectedItem());
        }

        DirectoryComboBoxAction() {
        }
    }
}

