/*
 * Decompiled with CFR 0.152.
 */
package com.denova.util;

import com.denova.io.LineEndingInputFilter;
import com.denova.io.Log;
import com.denova.lang.FieldAccess;
import com.denova.ui.UiUtilities;
import com.denova.util.StringArrayString;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.List;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PropertyList
extends Properties
implements Runnable {
    static final boolean debugging = false;
    static Log propLog;
    Exception lastError;
    FieldAccess setContainerFieldAccess;
    boolean setContainerOk;
    String title = "Property List";

    public synchronized boolean load(String string) {
        return this.load(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean load(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            LineEndingInputFilter lineEndingInputFilter = new LineEndingInputFilter(file.getName(), fileInputStream);
            this.load(lineEndingInputFilter);
            return true;
        }
        catch (Exception exception) {
            PropertyList.log(exception);
            this.lastError = exception;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void load(InputStream inputStream) throws IOException {
        try {
            PropertyList.log("removing old properties");
            Enumeration<?> enumeration = this.propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    PropertyList.log("loading new properties");
                    super.load(inputStream);
                    PropertyList.log("properties loaded");
                    return;
                }
                String string = (String)enumeration.nextElement();
                ((Hashtable)this).remove(string);
            }
        }
        catch (Exception exception) {
            this.lastError = exception;
            PropertyList.log(exception);
        }
    }

    public synchronized boolean save(String string) {
        return this.save(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean save(File file) {
        try {
            PropertyList.log("Saving properties to " + file.getPath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.save(fileOutputStream, this.title);
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            PropertyList.log(exception);
            this.lastError = exception;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save(OutputStream outputStream, String string) {
        try {
            PropertyList.log("saving properties");
            super.save(outputStream, string);
            PropertyList.log("saved properties");
            return;
        }
        catch (Exception exception) {
            PropertyList.log(exception);
            this.lastError = exception;
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Object setProperty(String string, String string2) {
        return ((Hashtable)this).put(string, string2);
    }

    public Object setProperty(String string, Properties properties) {
        PropertyList propertyList = new PropertyList(properties);
        return ((Hashtable)this).put(string, propertyList.toString());
    }

    public Object setProperty(String string, Component component) {
        Object object;
        String string2 = null;
        PropertyList.log("setProperty for ");
        if (component instanceof TextField) {
            string2 = ((TextField)component).getText();
        } else if (component instanceof JTextField) {
            string2 = ((JTextField)component).getText();
            PropertyList.log(" a JTextField");
        } else if (component instanceof TextArea) {
            string2 = ((TextArea)component).getText();
        } else if (component instanceof JTextArea) {
            string2 = ((JTextArea)component).getText();
            PropertyList.log(" a JTextArea");
        } else if (component instanceof Checkbox) {
            boolean bl = ((Checkbox)component).getState();
            string2 = new Boolean(bl).toString();
        } else if (component instanceof JCheckBox) {
            boolean bl = ((JCheckBox)component).isSelected();
            string2 = new Boolean(bl).toString();
        } else if (component instanceof List) {
            StringArrayString stringArrayString = new StringArrayString();
            stringArrayString.setItems((List)component);
            string2 = stringArrayString.toString();
        } else if (component instanceof JList) {
            StringArrayString stringArrayString = new StringArrayString();
            stringArrayString.setItems((JList)component);
            string2 = stringArrayString.toString();
        } else if (component instanceof JRadioButton) {
            boolean bl = ((JRadioButton)component).isSelected();
            string2 = new Boolean(bl).toString();
        } else if (component instanceof JComboBox && (object = ((JComboBox)component).getSelectedItem()) != null && object instanceof String) {
            string2 = (String)object;
        }
        PropertyList.log(" named: " + string);
        PropertyList.log(" value: " + string2);
        Object object2 = string2 != null ? this.setProperty(string, string2) : null;
        return object2;
    }

    public Object setProperty(String string, int n) {
        return this.setProperty(string, new Integer(n).toString());
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, new Boolean(bl).toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIntProperty(String string) {
        try {
            return new Integer(this.getProperty(string, "0"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = new Boolean(bl).toString();
        Boolean bl2 = new Boolean(this.getProperty(string, string2));
        return bl2;
    }

    public PropertyList getPropertyListProperty(String string) {
        return this.getPropertyListProperty(string, new PropertyList());
    }

    public PropertyList getPropertyListProperty(String string, PropertyList propertyList) {
        PropertyList propertyList2;
        String string2 = this.getProperty(string);
        if (string2 == null) {
            propertyList2 = propertyList;
        } else {
            propertyList2 = new PropertyList();
            propertyList2.fromString(string2);
        }
        return propertyList2;
    }

    public void setPropertyListProperty(String string, PropertyList propertyList) {
        this.setProperty(string, propertyList.toString());
    }

    public Object removeProperty(String string) {
        return ((Hashtable)this).remove(string);
    }

    public void removeAll() {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeProperty(string);
        }
    }

    public void setPropertyList(PropertyList propertyList) {
        this.setProperties(propertyList);
    }

    public void setProperties(Properties properties) {
        this.removeAll();
        this.addProperties(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setProperties(Container container, FieldAccess fieldAccess) {
        this.removeAll();
        try {
            Class<?> clazz = container.getClass();
            PropertyList.log("class name is " + clazz.getName());
            Field[] fieldArray = fieldAccess.getDeclaredFields();
            int n = fieldArray.length;
            PropertyList.log("# of fields is " + n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Field field = fieldArray[n2];
                Object object = fieldAccess.getFieldObject(field);
                if (object instanceof Component) {
                    PropertyList.log("  field " + field.getName());
                    this.setProperty(field.getName(), (Component)object);
                    Thread.yield();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            PropertyList.log(exception);
            this.lastError = exception;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setContainer(FieldAccess fieldAccess) {
        this.setContainerFieldAccess = fieldAccess;
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
            return this.setContainerOk;
        }
        try {
            SwingUtilities.invokeAndWait(this);
            return this.setContainerOk;
        }
        catch (Exception exception) {
            PropertyList.log(exception);
        }
        return this.setContainerOk;
    }

    public void addPropertyList(PropertyList propertyList) {
        this.addProperties(propertyList);
    }

    public void addProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
            Thread.yield();
        }
    }

    public Properties getPropertyList() {
        return this;
    }

    public Properties getProperties() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl;
        try {
            Enumeration<?> enumeration = this.getProperties().propertyNames();
            while (true) {
                block17: {
                    if (!enumeration.hasMoreElements()) {
                        bl = true;
                        break;
                    }
                    String string = (String)enumeration.nextElement();
                    try {
                        StringArrayString stringArrayString;
                        Field field = this.setContainerFieldAccess.getDeclaredField(string);
                        Object object = this.setContainerFieldAccess.getFieldObject(field);
                        String string2 = this.getProperty(string);
                        if (object instanceof TextField) {
                            ((TextComponent)((TextField)object)).setText(this.getProperty(string, ""));
                            break block17;
                        }
                        if (object instanceof JTextField) {
                            UiUtilities.update((Component)((JTextField)object), (Object)this.getProperty(string, ""));
                            break block17;
                        }
                        if (object instanceof TextArea) {
                            ((TextArea)object).setText(this.getProperty(string, ""));
                            break block17;
                        }
                        if (object instanceof JTextArea) {
                            UiUtilities.update((Component)((JTextArea)object), (Object)this.getProperty(string, ""));
                            break block17;
                        }
                        if (object instanceof Checkbox) {
                            ((Checkbox)object).setState(this.getBooleanProperty(string));
                            break block17;
                        }
                        if (object instanceof JCheckBox) {
                            UiUtilities.update((Component)((JCheckBox)object), this.getBooleanProperty(string));
                            break block17;
                        }
                        if (object instanceof List) {
                            stringArrayString = new StringArrayString();
                            stringArrayString.fromString(this.getProperty(string, ""));
                            stringArrayString.showList((List)object);
                            break block17;
                        }
                        if (object instanceof JList) {
                            stringArrayString = new StringArrayString();
                            stringArrayString.fromString(this.getProperty(string, ""));
                            stringArrayString.showList((JList)object);
                            break block17;
                        }
                        if (object instanceof JRadioButton) {
                            UiUtilities.update((Component)((JRadioButton)object), this.getBooleanProperty(string));
                            break block17;
                        }
                        if (object instanceof JComboBox) {
                            ((JComboBox)object).setSelectedItem(this.getProperty(string, ""));
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            PropertyList.log(exception);
            this.lastError = exception;
            bl = false;
        }
        this.setContainerOk = bl;
    }

    public String toString() {
        StringArrayString stringArrayString = new StringArrayString();
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getProperty(string);
            String string3 = string + "=" + string2;
            stringArrayString.addItem(string3);
        }
        return stringArrayString.toString();
    }

    public boolean fromString(String string) {
        boolean bl = true;
        StringArrayString stringArrayString = new StringArrayString();
        this.removeAll();
        stringArrayString.fromString(string);
        int n = 0;
        while (n < stringArrayString.getCount() && bl) {
            String string2 = stringArrayString.getItem(n);
            int n2 = string2.indexOf("=");
            if (n2 > 0) {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                this.setProperty(string3, string4);
                Thread.yield();
            } else {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public void clearLastError() {
        this.lastError = null;
    }

    private String getLine(BufferedReader bufferedReader) throws IOException {
        String string = "\\\\";
        String string2 = bufferedReader.ready() ? bufferedReader.readLine() : null;
        return string2;
    }

    private static void log(String string) {
        PropertyList.startLog();
        propLog.write(string);
    }

    private static void log(Throwable throwable) {
        PropertyList.startLog();
        propLog.write(throwable);
    }

    private static void startLog() {
        if (propLog == null) {
            propLog = new Log("properties");
        }
    }

    public static void main(String[] stringArray) {
        String string = "test";
        PropertyList propertyList = new PropertyList();
        propertyList.setProperty("test", "test value");
        System.out.println(propertyList.getProperty("test"));
    }

    public PropertyList(Properties properties) {
        super(properties);
    }

    public PropertyList() {
    }
}

