/*
 * Decompiled with CFR 0.152.
 */
package com.denova.util;

import com.denova.io.Log;
import com.denova.util.PropertyList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class DefaultOptions
extends PropertyList {
    Log errorLog;
    String defaultDirName = "";
    String defaultOptionsFilename = "default.options";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        try {
            File file = this.defaultDirName != null && this.defaultDirName.length() > 0 ? new File(this.defaultDirName, this.defaultOptionsFilename) : new File(this.defaultOptionsFilename);
            FileInputStream fileInputStream = new FileInputStream(file);
            super.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            this.logError("Unable to load options from file " + this.defaultOptionsFilename);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        try {
            File file = this.defaultDirName != null && this.defaultDirName.length() > 0 ? new File(this.defaultDirName, this.defaultOptionsFilename) : new File(this.defaultOptionsFilename);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            super.save(fileOutputStream, "Default Options");
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            this.logError("Unable to save options to file " + this.defaultOptionsFilename);
        }
    }

    public void setDefaultDirectory(String string) {
        this.defaultDirName = string;
    }

    public void setDefaultOptionsFilename(String string) {
        this.defaultOptionsFilename = string;
    }

    private void logError(String string) {
        if (this.errorLog != null) {
            this.errorLog.write(string);
        }
    }

    public DefaultOptions() {
    }

    public DefaultOptions(Log log) {
        this.errorLog = log;
    }
}

