/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.io.Log;
import com.denova.runtime.OS;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardActiveThread;
import com.denova.ui.WizardPanel;
import com.denova.ui.WizardSetPanelThread;
import com.denova.ui.WizardVisibleThread;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.border.EmptyBorder;

public class Wizard
extends JPanel
implements Runnable {
    Log log;
    JPanel parent;
    Vector panels = new Vector();
    WizardPanel panel;
    int panelIndex = 0;
    boolean cancelled;
    boolean aborted;
    boolean firstPanel = true;
    boolean visible = true;
    boolean silentInstall = false;
    JPanel subPanel;
    JPanel buttons;
    JButton nextButton;
    JButton previousButton;
    JButton cancelButton;
    String cancelButtonLabel = "  Cancel  ";
    String previousButtonLabel = "  << Back  ";
    String nextButtonLabel = "  Next >>  ";
    String finishedButtonLabel = "Finished";

    public void run() {
        this.log.write("silent install");
        this.panelIndex = 0;
        this.showPanel(this.panelIndex);
        while (this.panelIndex < this.panels.size()) {
            OS.sleep(1000L);
            int n = this.panelIndex;
            WizardPanel wizardPanel = (WizardPanel)this.panels.elementAt(n);
            while (n == this.panelIndex && !wizardPanel.getNextButton().isEnabled()) {
                Thread.yield();
                OS.sleep(100L);
            }
            if (n == this.panelIndex) {
                this.showNext();
            }
            Thread.yield();
        }
    }

    void cancelButton_Clicked(ActionEvent actionEvent) {
        this.cancel();
    }

    void nextButton_Clicked(ActionEvent actionEvent) {
        this.showNext();
    }

    void previousButton_Clicked(ActionEvent actionEvent) {
        this.showPrevious();
    }

    public void setSilent(boolean bl) {
        this.silentInstall = bl;
    }

    public boolean getSilent() {
        return this.silentInstall;
    }

    public void createPanel() {
        int n;
        Box box;
        int n2 = 12;
        int n3 = 300;
        int n4 = 150;
        EmptyBorder emptyBorder = new EmptyBorder(12, 12, 12, 12);
        this.log = new Log("wizard");
        this.setLayout(new BorderLayout());
        this.subPanel = new JPanel();
        this.subPanel.setLayout(new CardLayout());
        this.add((Component)this.subPanel, "Center");
        String string = this.getButtonsPosition();
        if (string.equals("North") || string.equals("South")) {
            box = Box.createHorizontalBox();
            n = 300;
        } else {
            box = Box.createVerticalBox();
            n = 150;
        }
        box.add(this.buttonGlue(string));
        this.cancelButton = new JButton(this.getDefaultCancelButtonLabel());
        box.add(this.cancelButton);
        box.add(this.buttonGlue(string));
        this.previousButton = new JButton(this.getDefaultPreviousButtonLabel());
        box.add(this.previousButton);
        box.add(this.buttonGlue(string));
        this.nextButton = new JButton(this.getDefaultNextButtonLabel());
        box.add(this.nextButton);
        box.add(this.buttonGlue(string));
        this.buttons = new JPanel();
        this.buttons.setLayout(new BorderLayout());
        this.buttons.setBorder(emptyBorder);
        this.buttons.add((Component)box, "Center");
        this.buttons.add(Box.createHorizontalStrut(n), "North");
        this.add((Component)this.buttons, string);
        Wizard wizard = this;
        if (wizard == null) {
            throw null;
        }
        Action action = wizard.new Action();
        this.previousButton.addActionListener(action);
        this.nextButton.addActionListener(action);
        this.cancelButton.addActionListener(action);
    }

    public Component buttonGlue(String string) {
        Component component = string.equals("North") || string.equals("South") ? Box.createHorizontalGlue() : Box.createVerticalGlue();
        return component;
    }

    public void addPanel(WizardPanel wizardPanel) {
        wizardPanel.setWizard(this);
        this.subPanel.add((Component)wizardPanel, String.valueOf(this.panels.size()));
        this.panels.addElement(wizardPanel);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void start() {
        if (this.silentInstall) {
            new Thread(this).start();
        } else {
            this.showPanel(this.panelIndex);
        }
    }

    public boolean resetPanel(String string) {
        boolean bl = false;
        WizardPanel wizardPanel = this.getPanel(string);
        if (wizardPanel != null) {
            wizardPanel.reset();
            bl = true;
        }
        return bl;
    }

    public WizardPanel getPanel(String string) {
        WizardPanel wizardPanel = null;
        int n = this.getPanelIndex(string);
        if (n >= 0) {
            wizardPanel = (WizardPanel)this.panels.elementAt(n);
        }
        return wizardPanel;
    }

    public int getPanelIndex(String string) {
        WizardPanel wizardPanel = null;
        boolean bl = false;
        int n = 0;
        while (n < this.panels.size() && !bl) {
            wizardPanel = (WizardPanel)this.panels.elementAt(n);
            String string2 = wizardPanel.getName();
            if (string2.equals(string)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (!bl) {
            n = -1;
        }
        return n;
    }

    public void showPanel(String string) {
        int n = this.getPanelIndex(string);
        if (n >= 0) {
            this.showPanel(n);
        }
    }

    public void showPanel(int n) {
        if (n >= 0 && n < this.panels.size() && this.isPanelIndexEnabled(n)) {
            new WizardActiveThread(this.panel, false);
            if (!this.silentInstall) {
                new WizardVisibleThread(this.panel, this.visible);
            }
            new WizardSetPanelThread(this, n);
        }
    }

    public void setPanel(int n) {
        String string;
        this.log.write("set panel " + n);
        this.panelIndex = n;
        this.panel = (WizardPanel)this.panels.elementAt(n);
        CardLayout cardLayout = (CardLayout)this.subPanel.getLayout();
        String string2 = String.valueOf(n);
        if (!this.silentInstall) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(this.subPanel);
            vector.addElement(string2);
            UiUtilities.update((Object)cardLayout, vector);
        }
        if ((string = this.panel.getPreviousButtonLabel()) == null) {
            string = this.getDefaultPreviousButtonLabel();
        }
        UiUtilities.update((Component)this.previousButton, (Object)string);
        string = this.panel.getNextButtonLabel();
        if (string == null) {
            string = this.getDefaultNextButtonLabel();
        }
        UiUtilities.update((Component)this.nextButton, (Object)string);
        string = this.panel.getCancelButtonLabel();
        if (string == null) {
            string = this.getDefaultCancelButtonLabel();
        }
        UiUtilities.update((Component)this.cancelButton, (Object)string);
        if (n <= 0) {
            this.nextButton.setEnabled(this.panel.isNextButtonEnabled());
            this.log.write("next button " + (this.panel.isNextButtonEnabled() ? "" : "not ") + "enabled");
            this.previousButton.setEnabled(false);
            this.cancelButton.setEnabled(true);
        } else if (n + 1 >= this.panels.size()) {
            UiUtilities.update((Component)this.nextButton, (Object)this.getDefaultFinishedButtonLabel());
            this.nextButton.setEnabled(this.panel.isNextButtonEnabled());
            this.log.write("next button " + (this.panel.isNextButtonEnabled() ? "" : "not ") + "enabled");
            this.previousButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(this.panel.isNextButtonEnabled());
            this.log.write("next button " + (this.panel.isNextButtonEnabled() ? "" : "not ") + "enabled");
            this.previousButton.setEnabled(this.panel.isPreviousButtonEnabled());
            this.cancelButton.setEnabled(this.panel.isCancelButtonEnabled());
        }
        ((RootPaneContainer)((Object)this.getTopLevelAncestor())).getRootPane().setDefaultButton(this.nextButton);
        this.cancelButton.setRequestFocusEnabled(false);
        this.previousButton.setRequestFocusEnabled(false);
        this.nextButton.requestFocus();
        new WizardActiveThread(this.panel, true);
    }

    public void showPrevious() {
        int n = this.panelIndex - 1;
        while (n >= 0 && !this.isPanelIndexEnabled(n)) {
            --n;
        }
        if (n >= 0) {
            this.showPanel(n);
        } else {
            this.finish();
        }
    }

    public void showNext() {
        if (this.getCurrentPanel().isOk()) {
            int n = this.panelIndex + 1;
            while (n < this.panels.size() && !this.isPanelIndexEnabled(n)) {
                ++n;
            }
            if (n < this.panels.size()) {
                this.showPanel(n);
            } else {
                this.finish();
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
        int n = 0;
        while (n < this.panels.size()) {
            WizardPanel wizardPanel = (WizardPanel)this.panels.elementAt(n);
            wizardPanel.userCanceled();
            ++n;
        }
    }

    public void abort() {
        this.aborted = true;
        this.cancelled = true;
        int n = 0;
        while (n < this.panels.size()) {
            WizardPanel wizardPanel = (WizardPanel)this.panels.elementAt(n);
            wizardPanel.userCanceled();
            ++n;
        }
    }

    public WizardPanel getCurrentPanel() {
        return (WizardPanel)this.panels.elementAt(this.panelIndex);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getPanelIndex() {
        return this.panelIndex;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getPreviousButton() {
        return this.previousButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void finish() {
    }

    public void setDefaultFinishedButtonLabel(String string) {
        this.finishedButtonLabel = string;
    }

    public String getDefaultFinishedButtonLabel() {
        return this.finishedButtonLabel;
    }

    public void setDefaultCancelButtonLabel(String string) {
        this.cancelButtonLabel = string;
        if (this.cancelButton != null) {
            UiUtilities.update((Component)this.cancelButton, (Object)this.getDefaultCancelButtonLabel());
        }
    }

    public String getDefaultCancelButtonLabel() {
        return this.cancelButtonLabel;
    }

    public void setDefaultPreviousButtonLabel(String string) {
        this.previousButtonLabel = string;
        if (this.previousButton != null) {
            UiUtilities.update((Component)this.previousButton, (Object)this.getDefaultPreviousButtonLabel());
        }
    }

    public String getDefaultPreviousButtonLabel() {
        return this.previousButtonLabel;
    }

    public void setDefaultNextButtonLabel(String string) {
        this.nextButtonLabel = string;
        if (this.nextButton != null) {
            UiUtilities.update((Component)this.nextButton, (Object)this.getDefaultNextButtonLabel());
        }
    }

    public String getDefaultNextButtonLabel() {
        return this.nextButtonLabel;
    }

    public WizardPanel getPanel(int n) {
        return (WizardPanel)this.panels.elementAt(n);
    }

    public boolean isPanelIndexEnabled(int n) {
        return this.getPanel(n).isEnabled();
    }

    public String getButtonsPosition() {
        return "South";
    }

    public Wizard(JPanel jPanel) {
        this.parent = jPanel;
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Wizard.this.previousButton) {
                Wizard.this.previousButton_Clicked(actionEvent);
            } else if (object == Wizard.this.nextButton) {
                Wizard.this.nextButton_Clicked(actionEvent);
            } else if (object == Wizard.this.cancelButton) {
                Wizard.this.cancelButton_Clicked(actionEvent);
            }
        }

        Action() {
        }
    }
}

