/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.runtime.OS;
import com.denova.ui.UiUtilitiesRedraw;
import com.denova.ui.UpdateComponent;
import com.denova.ui.awt.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class UiUtilities {
    static final int InitialDefaultMargin = 12;
    public static final String NeedSwingErrorMsg = "You need Swing 1.1 or 1.2 in the classpath to use this program.";
    public static final String CrossPlatformLookAndFeelName = "javax.swing.plaf.multi.MultiLookAndFeel";
    public static final String WindowsLookAndFeelName = "javax.swing.plaf.windows.WindowsLookAndFeel";
    public static final String MotifLookAndFeelName = "javax.swing.plaf.motif.MotifLookAndFeel";
    static int defaultMargin = 12;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setLookAndFeel() {
        boolean bl = false;
        try {
            try {
                String string = OS.isUnix() ? MotifLookAndFeelName : UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
                return true;
            }
            catch (Throwable throwable) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    return true;
                }
                catch (Throwable throwable2) {
                    UiUtilities.awtNoteError(NeedSwingErrorMsg);
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            UiUtilities.awtNoteError(NeedSwingErrorMsg);
        }
        return bl;
    }

    public static void update(Component component, int n) {
        UiUtilities.update((Object)component, (Object)new Integer(n));
    }

    public static void update(Object object, int n) {
        UiUtilities.update(object, (Object)new Integer(n));
    }

    public static void update(Component component, boolean bl) {
        UiUtilities.update((Object)component, (Object)new Boolean(bl));
    }

    public static void update(Object object, boolean bl) {
        UiUtilities.update(object, (Object)new Boolean(bl));
    }

    public static void update(Component component, Object object) {
        UiUtilities.update((Object)component, object);
    }

    public static void update(Object object, Object object2) {
        new UpdateComponent(object, object2);
    }

    public static void centerComponent(Component component) {
        Rectangle rectangle = UiUtilities.getParentBounds(component);
        Rectangle rectangle2 = component.getBounds();
        component.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        if (component.isVisible()) {
            component.paintAll(component.getGraphics());
        }
    }

    public static void centerOnScreen(Container container) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = container.getBounds();
        container.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        if (container.isVisible()) {
            container.paintAll(container.getGraphics());
        }
    }

    public static void maximizeComponent(Component component) {
        Rectangle rectangle = UiUtilities.getParentBounds(component);
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        component.setSize(dimension);
        if (component.isVisible()) {
            component.paintAll(component.getGraphics());
        }
    }

    public static JPanel centerLabel(JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        return jPanel;
    }

    public static Rectangle getParentBounds(Component component) {
        Rectangle rectangle = component.getParent() != null ? component.getParent().bounds() : new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return rectangle;
    }

    public static void paintNow(JComponent jComponent) {
        jComponent.paintImmediately(jComponent.getVisibleRect());
    }

    public static void redraw(Component component) {
        new UiUtilitiesRedraw(component);
    }

    public static JFrame findJFrameParent(Container container) {
        while (container != null && !(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    public static JFrame forceJFrameParent(Container container) {
        if ((container = UiUtilities.findJFrameParent(container)) == null) {
            container = new JFrame();
        }
        return (JFrame)container;
    }

    public static boolean isRunningInBrowser(Component component) {
        Container container = component.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return container == null;
    }

    public static JPanel addBorder(Component component, Border border) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(border);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(component, "Center");
        return jPanel;
    }

    public static JPanel addBevel(Component component, int n) {
        return UiUtilities.addBorder(component, new BevelBorder(n));
    }

    public static JPanel addDoubleBevel(Component component, int n) {
        JPanel jPanel = UiUtilities.addBorder(component, new BevelBorder(n));
        return UiUtilities.addBorder(jPanel, new BevelBorder(n));
    }

    public static JPanel addMargin(Component component) {
        return UiUtilities.addBorder(component, UiUtilities.getMarginBorder());
    }

    public static int getDefaultMargin() {
        return defaultMargin;
    }

    public static void setDefaultMargin(int n) {
        defaultMargin = n;
    }

    public static Border getMarginBorder() {
        return UiUtilities.getMarginBorder(defaultMargin);
    }

    public static Border getMarginBorder(int n) {
        return new EmptyBorder(n, n, n, n);
    }

    public static JScrollPane addScrollPane(Component component) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(component);
        return jScrollPane;
    }

    public static boolean ask(Object object) {
        int n = JOptionPane.showConfirmDialog(null, object, "Question", 0, 3);
        return n == 0;
    }

    public static boolean ask(Object object, String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        int n = JOptionPane.showOptionDialog(null, object, string, 0, 3, null, objectArray, objectArray[0]);
        return n == 0;
    }

    public static void note(Object object) {
        JOptionPane.showMessageDialog(null, object);
    }

    public static void note(Object object, String string) {
        Object[] objectArray = new Object[]{string};
        JOptionPane.showOptionDialog(null, object, null, 0, -1, null, objectArray, objectArray[0]);
    }

    public static void noteError(Object object) {
        JOptionPane.showMessageDialog(null, object, "Error", 0);
    }

    public static void noteError(Object object, String string) {
        Object[] objectArray = new Object[]{string};
        JOptionPane.showOptionDialog(null, object, null, 0, 0, null, objectArray, objectArray[0]);
    }

    public static void awtNoteError(String string) {
        ErrorDialog.show("Error", string);
    }

    public static void reportSwingMissing() {
        UiUtilities.awtNoteError(NeedSwingErrorMsg);
    }
}

