/*
 * Decompiled with CFR 0.152.
 */
package com.denova.ui;

import com.denova.ui.UiUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class FileProgressUI
extends JFrame {
    protected boolean ok = true;
    JLabel status;
    JProgressBar progressBar;
    protected boolean firewallError;
    Exception error;

    void FileProgressUI_WindowClosing(WindowEvent windowEvent) {
        this.userCanceled();
    }

    Box createMainPanel() {
        int n = 400;
        int n2 = 20;
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        Font font = new Font("BoldFont", 1, 12);
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.setBorder(emptyBorder);
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(100);
        jPanel.add(this.progressBar);
        this.status = new JLabel("");
        jPanel.add(this.status);
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(400, 1)));
        box.add(jPanel);
        return box;
    }

    public void setStatus(String string) {
        UiUtilities.update((Component)this.status, (Object)string);
    }

    public void setProgressBarMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void setProgressBar(int n) {
        UiUtilities.update((Component)this.progressBar, n);
    }

    public boolean isOk() {
        return this.ok && !this.firewallError;
    }

    public boolean isFirewallError() {
        return this.firewallError;
    }

    public void setError(Exception exception) {
        this.error = exception;
        this.ok = false;
    }

    public Exception getError() {
        return this.error;
    }

    protected void userCanceled() {
        this.ok = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void waitUntilDone() {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
        }
    }

    protected synchronized void notifyDone() {
        this.notify();
    }

    public FileProgressUI() {
        Container container = this.getContentPane();
        container.add((Component)this.createMainPanel(), "Center");
        this.setTitle("Getting files...");
        FileProgressUI fileProgressUI = this;
        if (fileProgressUI == null) {
            throw null;
        }
        FileProgressUIWindow fileProgressUIWindow = fileProgressUI.new FileProgressUIWindow();
        this.addWindowListener(fileProgressUIWindow);
        this.pack();
        UiUtilities.centerOnScreen(this);
    }

    class FileProgressUIWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == FileProgressUI.this) {
                FileProgressUI.this.FileProgressUI_WindowClosing(windowEvent);
            }
        }

        FileProgressUIWindow() {
        }
    }
}

