/*
 * Decompiled with CFR 0.152.
 */
package com.denova.runtime;

import com.denova.runtime.Exec;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import java.io.File;

public class JRE {
    static final String Quote = "\"";
    static final String Dot = ".";
    public static final String SwingJarFilename = "swingall.jar";
    static final boolean debugging = false;
    static String swingPath = null;
    static String javaHome = null;
    static String javaVersion = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getActiveJavaHome() {
        String string = System.getProperty("java.home");
        File file = new File(string);
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        if (string.endsWith(File.separator)) return string;
        return string + File.separator;
    }

    public static String getJavaHome() {
        if (javaHome == null || javaHome.length() <= 0) {
            javaHome = JRE.getActiveJavaHome();
            javaVersion = System.getProperty("java.version");
        }
        return javaHome;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static void setJavaHome(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            javaHome = string;
            if (!javaHome.endsWith(File.separator)) {
                javaHome = javaHome + File.separator;
            }
            javaVersion = "";
        }
    }

    public static void setJavaHome(String string, String string2) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            javaHome = string;
            javaVersion = string2;
        }
    }

    public static String getNativeExecutable(String string) {
        boolean bl = false;
        return JRE.getNativeExecutable(string, false);
    }

    public static String getNativeExecutable(String string, boolean bl) {
        String string2;
        if (string == null || string.length() <= 0) {
            string = "jre";
        }
        if (!((string2 = JRE.getNativeExecBaseName(string)) != null && string2.length() > 0 || !string.equalsIgnoreCase("jre") || (string2 = JRE.getNativeExecBaseName("java")) != null && string2.length() > 0)) {
            string2 = string;
        }
        if (OS.isWindows()) {
            String string3;
            File file;
            if (!bl && (file = new File(string3 = string2 + "w.exe")).exists()) {
                string2 = string2 + "w";
            }
            if (!string2.endsWith(".exe")) {
                string2 = string2 + ".exe";
            }
        }
        return string2;
    }

    public static String getNativeExecBaseName(String string) {
        String string2;
        String string3;
        File file;
        if (string == null || string.length() <= 0) {
            string = "jre";
        }
        if (!((file = new File(string3 = JRE.getJavaHome() + "bin" + File.separator + string)).exists() || (file = new File(string2 = string3 + ".exe")).exists() || (file = new File(string2 = string3 + ".bin")).exists())) {
            string3 = "";
        }
        return string3;
    }

    public static String getCommandPrefix(String string) {
        return JRE.getCommandPrefix(string, null);
    }

    public static String getCommandPrefix(String string, String string2) {
        boolean bl = false;
        return JRE.getCommandPrefix(string, string2, false);
    }

    public static String getCommandPrefix(String string, String string2, boolean bl) {
        Object var3_3 = null;
        boolean bl2 = false;
        return JRE.getCommandPrefix(string, string2, null, bl, false);
    }

    public static String getCommandPrefix(String string, String string2, String string3, boolean bl, boolean bl2) {
        String string4;
        String string5 = JRE.getSwingPath();
        boolean bl3 = false;
        if (string3 != null && string3.length() > 0) {
            string3 = string3.trim();
            string4 = Quote + JRE.getNativeExecutable(string, bl) + "\" " + string3;
        } else {
            string4 = Quote + JRE.getNativeExecutable(string, bl) + Quote;
        }
        File file = new File(string5);
        if (bl2 && file.exists()) {
            string4 = string4 + " -cp \"" + string5;
            bl3 = true;
        }
        if (string2 != null && string2.length() > 0) {
            if (!bl3) {
                string4 = string4 + " -cp \"";
                bl3 = true;
            }
            string4 = string4 + File.pathSeparator + string2 + Quote;
        }
        string4 = string4 + " ";
        return string4;
    }

    public static void runCommand(String string) throws Exception {
        JRE.runCommand(string, null);
    }

    public static void runCommand(String string, String string2) throws Exception {
        JRE.runCommand(string, null, string2);
    }

    public static void runCommand(String string, File file) throws Exception {
        JRE.runCommand(string, null, file);
    }

    public static void runCommand(String string, String string2, String string3) throws Exception {
        if (string3 != null && string3.length() > 0) {
            JRE.runCommand(string, string2, new File(string3));
        } else {
            File file = null;
            JRE.runCommand(string, string2, file);
        }
    }

    public static void runCommand(String string, String string2, File file) throws Exception {
        JRE.debug("Command: " + string);
        if (string2 != null) {
            JRE.debug("Local classpath: " + string2);
        }
        String string3 = JRE.getCommandPrefix("jre", string2) + string;
        if (file == null) {
            Exec.runCommand(string3);
        } else {
            JRE.debug("Directory: " + file.getPath());
            Exec.runCommand(string3, file);
        }
    }

    public static void launchCommand(String string, String string2, File file) throws Exception {
        boolean bl = false;
        JRE.launchCommand(string, string2, file, false);
    }

    public static void launchCommand(String string, String string2, File file, boolean bl) throws Exception {
        Object var4_4 = null;
        boolean bl2 = false;
        JRE.launchCommand(string, string2, null, file, bl, false);
    }

    public static void launchCommand(String string, String string2, String string3, File file, boolean bl, boolean bl2) throws Exception {
        JRE.debug("Classname: " + string);
        if (string2 != null) {
            JRE.debug("Local classpath: " + string2);
        }
        String string4 = JRE.getCommandPrefix("jre", string2, string3, bl, bl2) + string;
        JRE.debug("Command: " + string4);
        if (file == null) {
            Exec.launchCommand(string4);
        } else {
            JRE.debug("Directory: " + file.getPath());
            if (OS.isUnix()) {
                String string5 = JRE.adjustJreClasspath(string4, file.getPath(), true, bl2);
                JRE.debug("Command after classpath adjustment: " + string5);
                Exec.launchCommand(string5);
            } else {
                JRE.debug("Command " + string4 + " directory " + file.getPath());
                Exec.launchCommand(string4, file.getPath());
            }
        }
    }

    public static String adjustJreClasspath(String string, String string2, boolean bl) {
        return JRE.adjustJreClasspath(string, string2, bl, true);
    }

    public static String adjustJreClasspath(String string, String string2, boolean bl, boolean bl2) {
        CharSequence charSequence;
        String string3 = "jre";
        String string4 = "java";
        String string5 = " -cp ";
        JRE.debug("command before adjustment: \"" + string + Quote);
        String string6 = string.toLowerCase();
        int n = string6.indexOf(" -cp ");
        int n2 = string6.indexOf("jre");
        if (n2 < 0) {
            n2 = string6.indexOf("java");
        }
        if (n2 >= 0 && n2 < n) {
            int n3;
            charSequence = string.substring(0, n + " -cp ".length());
            String string7 = string.substring(n + " -cp ".length());
            String string8 = "";
            if (string7.startsWith(Quote)) {
                n3 = string7.indexOf(Quote, 1);
                if (n3 > 0) {
                    string8 = string7.substring(1, n3);
                    string7 = string7.substring(n3 + 1);
                } else {
                    JRE.debug("adjustJreClasspath: Mismatched quotes: " + string);
                }
            } else {
                n3 = string7.indexOf(32);
                if (n3 > 0) {
                    string8 = string7.substring(0, n3);
                    string7 = string7.substring(n3);
                } else {
                    JRE.debug("adjustJreClasspath: No class to run: " + string);
                }
            }
            if (bl) {
                string8 = JRE.changeDotsToCurrentDirectory(string8, string2);
            }
            if (bl2) {
                String string9 = JRE.getSwingPath().trim();
                File file = new File(string9);
                if (!file.exists()) {
                    string9 = "";
                }
                if (string9.length() > 0) {
                    JRE.debug("classpath before swing: \"" + string8 + Quote);
                    string8 = string8.trim() + File.pathSeparator + string9;
                    JRE.debug("classpath after swing: \"" + string8 + Quote);
                } else {
                    JRE.debug("no swing path found");
                }
            }
            if (OS.isWindows()) {
                String string10;
                String string11 = "";
                int n4 = 0;
                int n5 = string8.indexOf(File.pathSeparatorChar);
                while (n5 != -1) {
                    string10 = JRE.getWinShortName(string8.substring(n4, n5));
                    string11 = string11.length() > 0 ? string11 + File.pathSeparator + string10 : string10;
                    n4 = n5 + 1;
                    n5 = n4 < string8.length() ? string8.indexOf(File.pathSeparatorChar, n4) : -1;
                }
                if (n4 > 0) {
                    string10 = JRE.getWinShortName(string8.substring(n4));
                    string11 = string11.length() > 0 ? string11 + File.pathSeparator + string10 : string10;
                }
                if (string11.length() > 0) {
                    string8 = string11;
                }
            } else if (string8.indexOf(32) != -1) {
                string8 = Quote + string8 + Quote;
            }
            string = (String)charSequence + string8 + string7;
        }
        charSequence = new StringBuffer();
        int n6 = 0;
        while (n6 < string.length()) {
            if (string.charAt(n6) == '\\') {
                if (n6 + 1 < string.length() && string.charAt(n6 + 1) == '/') {
                    ((StringBuffer)charSequence).append(string.charAt(++n6));
                } else {
                    ((StringBuffer)charSequence).append(File.separatorChar);
                }
            } else if (string.charAt(n6) == '/') {
                ((StringBuffer)charSequence).append(File.separatorChar);
            } else {
                ((StringBuffer)charSequence).append(string.charAt(n6));
            }
            ++n6;
        }
        if (((StringBuffer)charSequence).length() > 0) {
            string = ((StringBuffer)charSequence).toString();
        }
        JRE.debug("command after adjustment: \"" + string + Quote);
        return string;
    }

    static String changeDotsToCurrentDirectory(String string, String string2) {
        WindowsOS windowsOS;
        String string3;
        String string4 = string2;
        if (OS.isWindows() && (string3 = (windowsOS = new WindowsOS()).getAncientShortPath(string4)) != null && string3.length() > 0) {
            string4 = string3;
        }
        if (string.startsWith(Dot)) {
            string = string4 + string.substring(1);
        }
        int n = string.indexOf(File.pathSeparator);
        while (n >= 0) {
            string3 = string.substring(n + File.pathSeparator.length());
            if (string3.startsWith(Dot)) {
                string = string.substring(0, n) + File.pathSeparator + string4 + string3.substring(Dot.length());
                n += string4.length();
            }
            n += File.pathSeparator.length();
            n = string.indexOf(File.pathSeparator, n);
        }
        return string;
    }

    public static void setSwingPath(String string) {
        swingPath = string;
    }

    public static String getSwingPath() {
        WindowsOS windowsOS;
        String string;
        File file;
        if (swingPath == null && (file = new File(swingPath = JRE.getJavaHome() + "lib" + File.separator + SwingJarFilename)).exists() && OS.isWindows() && swingPath.length() > 0 && (string = (windowsOS = new WindowsOS()).getAncientShortPath(swingPath)) != null && string.length() > 0) {
            swingPath = string;
        }
        return swingPath;
    }

    private static String getWinShortName(String string) {
        WindowsOS windowsOS;
        String string2;
        if (string.length() > 0 && !string.startsWith(Dot) && (string2 = (windowsOS = new WindowsOS()).getAncientShortPath(string)) != null && string2.length() > 0) {
            string = string2;
        }
        if (string.indexOf(" ") != -1) {
            string = Quote + string + Quote;
        }
        return string;
    }

    static void debug(String string) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            JRE.runCommand("dir >test.zos");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

