/*
 * Decompiled with CFR 0.152.
 */
package com.denova.net;

import com.denova.io.Log;
import com.denova.net.HTTPTimeoutException;
import com.denova.net.HTTPTimeoutThread;
import com.denova.net.HtmlAnchor;
import com.denova.net.HtmlAvPair;
import com.denova.net.HtmlComment;
import com.denova.net.HtmlElement;
import com.denova.net.HtmlImage;
import com.denova.net.HtmlTag;
import com.denova.net.HtmlText;
import com.denova.net.WebFileProgress;
import com.denova.util.Base64;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebFile {
    public static final String UserAgent = "Denova 1.0";
    public static final String HTTPGet = "GET";
    public static final String HTTPPost = "POST";
    public static final String HTTPHead = "HEAD";
    static final int HTTPSocket = 80;
    static final int MaxLinks = 2000;
    static final String DefaultDelimiters = " \t\r\n<>!-";
    static final String TagDelimiters = " \t\r\n=\">";
    static final String StringDelimiters = "\\\"";
    static final int LeadingTextLength = 250;
    static final long OneSecond = 1000L;
    static final long DefaultMaxWait = 300000L;
    static final int MinOkReturnCode = 200;
    static final int MaxOkReturnCode = 299;
    static final String TempFilename = "qzhttpqz";
    static final boolean debug = false;
    static final boolean debugHTTP = false;
    static final boolean debugParse = false;
    static final String OkStatus = "Ok";
    static final String TimedOutStatus = "Timed out";
    static final int PermanentlyMovedCode = 301;
    static final int TemporarilyMovedCode = 302;
    String status;
    boolean headerOnly;
    boolean summaryOnly;
    boolean dataOnly;
    boolean inputStreamOnly;
    long startTimestamp;
    long startTime;
    long dnsTime;
    long connectionTime;
    long headerTime;
    long dataTime;
    long maxWait;
    Socket socket;
    HTTPTimeoutThread timeoutThread;
    InputStream ins;
    BufferedInputStream bins;
    DataInputStream inStream;
    OutputStream outs;
    BufferedOutputStream bouts;
    PrintStream outStream;
    boolean connectionClosed;
    int contentCount;
    int lineCount;
    String currentDelimiters;
    String urlString;
    URL url;
    InetAddress[] inetAddresses;
    int httpReturnCode;
    String httpReturnCodeDescription;
    String server;
    String serverDate;
    String lastModified;
    String ifModifiedSince;
    String contentType;
    long contentLength;
    StringBuffer html;
    String title;
    StringBuffer bodyText;
    String preAnchorBodyText;
    boolean endOfHTML;
    String username;
    String password;
    String redirectedLocation;
    boolean followRedirections;
    boolean followPermanentRedirections;
    boolean pageTimedOut;
    byte[] data;
    int linkCount;
    String[] links;
    boolean reportedTooManyLinks = false;
    boolean inTitle;
    boolean inBody;
    int inAnchor;
    HtmlAnchor anchor;
    int anchorCount;
    HtmlAnchor[] anchors;
    int inImage;
    int imageCount;
    HtmlImage[] images;
    String htmlLine;
    StringTokenizer tokens;
    String pushedBackToken;
    HtmlTag httpResponseHeaderTag;
    Vector elements;
    String receiveFilename;
    Log webPageLog;
    Log httpLog;
    Log htmlTokensLog;
    Log errorLog;
    WebFileProgress webFileProgress;

    void init() {
        this.webPageLog = new Log("webfile");
        this.httpLog = new Log("webhttp");
        this.htmlTokensLog = new Log("htmltokens");
        this.resetPage();
        this.urlString = "";
    }

    void resetPage() {
        this.status = OkStatus;
        this.headerOnly = false;
        this.summaryOnly = false;
        this.dataOnly = false;
        this.inputStreamOnly = false;
        this.socket = null;
        this.timeoutThread = null;
        this.ins = null;
        this.bins = null;
        this.inStream = null;
        this.outs = null;
        this.bouts = null;
        this.outStream = null;
        this.connectionClosed = false;
        this.contentCount = 0;
        this.lineCount = 0;
        this.startTimestamp = 0L;
        this.startTime = 0L;
        this.dnsTime = 0L;
        this.connectionTime = 0L;
        this.headerTime = 0L;
        this.dataTime = 0L;
        this.maxWait = 300000L;
        this.currentDelimiters = DefaultDelimiters;
        this.url = null;
        this.endOfHTML = false;
        this.pageTimedOut = false;
        this.httpReturnCode = 0;
        this.httpReturnCodeDescription = "";
        this.server = "";
        this.serverDate = "";
        this.lastModified = "";
        this.ifModifiedSince = "";
        this.contentType = "unknown";
        this.contentLength = -1L;
        this.redirectedLocation = "";
        this.followRedirections = true;
        this.followPermanentRedirections = true;
        this.html = new StringBuffer("");
        this.bodyText = new StringBuffer("");
        this.title = "";
        this.links = new String[2000];
        this.anchors = new HtmlAnchor[2000];
        this.images = new HtmlImage[2000];
        this.httpResponseHeaderTag = null;
        this.elements = new Vector();
    }

    public void getHeader(String string) {
        this.setUrlString(string);
        this.getHeader();
    }

    public void getHeader() {
        this.headerOnly = true;
        if (this.getRequest() || this.shouldRedirect()) {
            this.getHeader(this.getRedirectedLocation());
        }
    }

    public void getSummary(String string) {
        this.setUrlString(string);
        this.getSummary();
    }

    public void getSummary() {
        this.summaryOnly = true;
        if (this.getRequest() || this.shouldRedirect()) {
            this.getSummary(this.getRedirectedLocation());
        }
    }

    public void getPage(String string) {
        this.setUrlString(string);
        this.getPage();
    }

    public void getPage() {
        if (this.getRequest() || this.shouldRedirect()) {
            this.getPage(this.getRedirectedLocation());
        }
    }

    public void getFile(String string, String string2) {
        this.receiveFilename = string2;
        this.setUrlString(string);
        this.getData();
    }

    public void getFile(String string, File file) {
        this.receiveFilename = file.getPath();
        this.setUrlString(string);
        this.getData();
    }

    public void getData(String string) {
        this.setUrlString(string);
        this.getData();
    }

    public void getData() {
        this.dataOnly = true;
        if (this.getRequest() || this.shouldRedirect()) {
            this.getData(this.getRedirectedLocation());
        }
    }

    public InputStream getInputStream(String string) {
        this.setUrlString(string);
        return this.getInputStream();
    }

    public InputStream getInputStream() {
        this.inputStreamOnly = true;
        if (this.getRequest() || this.shouldRedirect()) {
            this.getData(this.getRedirectedLocation());
        }
        return this.inStream;
    }

    public long getDnsTime() {
        long l = 0L;
        if (this.dnsTime >= this.startTime) {
            l = this.dnsTime - this.startTime;
        }
        return l;
    }

    public long getConnectionTime() {
        long l = 0L;
        if (this.connectionTime >= this.dnsTime) {
            l = this.connectionTime - this.dnsTime;
        }
        return l;
    }

    public long getHeaderTime() {
        long l = 0L;
        if (this.headerTime >= this.connectionTime) {
            l = this.headerTime - this.connectionTime;
        }
        return l;
    }

    public long getDataTime() {
        long l = 0L;
        if (this.dataTime >= this.headerTime) {
            l = this.dataTime - this.headerTime;
        }
        return l;
    }

    boolean getRequest() {
        boolean bl = false;
        boolean bl2 = true;
        this.httpReturnCode = 0;
        this.httpReturnCodeDescription = "";
        if (this.headerOnly) {
            this.log("Getting head");
        } else {
            this.log("Getting page");
        }
        this.log("            for " + this.urlString);
        this.url = this.makeUrl(this.urlString);
        if (this.url != null) {
            int n;
            String string;
            this.log("url is " + this.url.toString());
            if (this.isProxySet()) {
                string = this.getProxyHost();
                n = this.getProxyPort();
                this.log("using proxy");
            } else {
                string = this.url.getHost();
                n = this.url.getPort();
            }
            if (n == -1) {
                n = 80;
            }
            this.log("host is " + string);
            this.log("port is " + n);
            this.startTimestamp = new Date().getTime();
            this.startTime = System.currentTimeMillis();
            if (this.dnsOk(string)) {
                this.dnsTime = new Date().getTime();
                if (this.openConnection(this.urlString, string, n)) {
                    this.connectionTime = System.currentTimeMillis();
                    this.requestPage();
                    if (this.pageResponseOk()) {
                        this.headerTime = System.currentTimeMillis();
                        if (!this.inputStreamOnly) {
                            if (this.dataOnly) {
                                bl2 = this.receiveData();
                            } else if (this.contentIsText() && !this.headerOnly) {
                                this.parse();
                            }
                            this.dataTime = System.currentTimeMillis();
                            if (!(this.contentLength <= 0L || (long)this.contentCount >= this.contentLength || this.headerOnly || this.inputStreamOnly || this.endOfHTML)) {
                                this.status = "Data incomplete";
                                this.logError(this.status);
                            } else if (bl2) {
                                bl = true;
                            }
                        }
                    }
                }
                if (!this.inputStreamOnly) {
                    this.close();
                }
            }
        }
        return bl;
    }

    public boolean isOk() {
        this.log("isOk " + this.status);
        return this.status.equals(OkStatus);
    }

    public boolean isTimedOut() {
        this.log("isTimedOut " + this.status);
        return this.status.equals(TimedOutStatus);
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long l) {
        this.maxWait = l;
    }

    public String getStatus() {
        return new String(this.status);
    }

    public void setUrlString(String string) {
        this.urlString = new String(string);
    }

    public String getUrlString() {
        return this.urlString;
    }

    public URL getURL() {
        return this.url;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = new String(string);
    }

    public String getPassword() {
        return this.password;
    }

    public void setInetAddresses(InetAddress[] inetAddressArray) {
        this.inetAddresses = inetAddressArray;
    }

    public InetAddress[] getInetAddresses() {
        return this.inetAddresses;
    }

    public HtmlTag getHttpResponseHeader() {
        return this.httpResponseHeaderTag;
    }

    public void setServer(String string) {
        this.server = new String(string);
    }

    public String getServer() {
        return this.server;
    }

    public String getServerDate() {
        return this.serverDate;
    }

    public void setLastModified(String string) {
        this.lastModified = new String(string);
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setIfModifiedSince(String string) {
        this.ifModifiedSince = new String(string);
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setContentType(String string) {
        this.contentType = new String(string);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentLength(long l) {
        this.contentLength = l;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getContentCount() {
        return this.contentCount;
    }

    public int getHttpReturnCode() {
        return this.httpReturnCode;
    }

    public String getHttpReturnCodeDescription() {
        return this.httpReturnCodeDescription;
    }

    public boolean isRedirected() {
        return this.isPermanentlyRedirected() || this.isTemporarilyRedirected();
    }

    public boolean isTemporarilyRedirected() {
        return this.getHttpReturnCode() == 302;
    }

    public boolean isPermanentlyRedirected() {
        return this.getHttpReturnCode() == 301;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRedirectedLocation() {
        try {
            if (this.redirectedLocation != null && this.redirectedLocation.length() > 0) {
                this.log("Getting redirected location for " + this.redirectedLocation);
            }
            URL uRL = new URL(this.getURL(), this.redirectedLocation);
            String string = uRL.toString();
            this.log("                   new location " + string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            this.logError("Redirected to bad url \"" + this.redirectedLocation + "\"", malformedURLException);
            return "";
        }
    }

    public boolean getFollowRedirections() {
        return this.followRedirections;
    }

    public void setFollowRedirections(boolean bl) {
        this.followRedirections = bl;
    }

    public boolean getFollowPermanentRedirections() {
        return this.followPermanentRedirections;
    }

    public void setFollowPermanentRedirections(boolean bl) {
        this.followPermanentRedirections = bl;
    }

    boolean shouldRedirect() {
        return this.isPermanentlyRedirected() && this.followPermanentRedirections || this.isRedirected() && this.followRedirections;
    }

    public void setHTML(String string) {
        this.html = new StringBuffer(string);
    }

    public String getHTML() {
        return this.html.toString();
    }

    public void setTitle(String string) {
        this.title = new String(string);
    }

    public String getTitle() {
        return new String(this.title);
    }

    public void setWebFileProgress(WebFileProgress webFileProgress) {
        this.webFileProgress = webFileProgress;
    }

    public WebFileProgress getWebFileProgress() {
        return this.webFileProgress;
    }

    public String getBodyText() {
        return new String(this.bodyText).trim();
    }

    public String getLeadingText() {
        String string = this.bodyText.length() > 250 ? new String(this.bodyText.toString().substring(0, 250)) : new String(this.bodyText.toString());
        return string.trim();
    }

    public String[] getLinks() {
        String[] stringArray = new String[this.linkCount];
        int n = 0;
        while (n < this.linkCount) {
            stringArray[n] = this.links[n];
            ++n;
        }
        return stringArray;
    }

    public HtmlAnchor[] getAnchors() {
        HtmlAnchor[] htmlAnchorArray = new HtmlAnchor[this.anchorCount];
        int n = 0;
        while (n < this.anchorCount) {
            htmlAnchorArray[n] = this.anchors[n];
            ++n;
        }
        return htmlAnchorArray;
    }

    public boolean getHeaderOnly() {
        return this.headerOnly;
    }

    public boolean getSummaryOnly() {
        return this.summaryOnly;
    }

    public String getReceiveFilename() {
        return this.receiveFilename;
    }

    public void setReceiveFilename(String string) {
        this.receiveFilename = string;
    }

    public Vector getElements() {
        return this.elements;
    }

    public boolean contentIsHTML() {
        return this.contentType.equalsIgnoreCase("www/source") || this.contentType.equalsIgnoreCase("text/html");
    }

    public boolean contentIsText() {
        return this.contentType.equalsIgnoreCase("www/source") || this.contentType.equalsIgnoreCase("text/html") || this.contentType.equalsIgnoreCase("text/plain");
    }

    public boolean contentIsImage() {
        return this.contentType.equalsIgnoreCase("video/mpeg") || this.contentType.equalsIgnoreCase("image/jpeg") || this.contentType.equalsIgnoreCase("image/x-tiff") || this.contentType.equalsIgnoreCase("image/x-rgb") || this.contentType.equalsIgnoreCase("image/x-xbm") || this.contentType.equalsIgnoreCase("image/gif") || this.contentType.equalsIgnoreCase("application/postscript");
    }

    public boolean contentIsBinary() {
        return this.contentType.equalsIgnoreCase("application/bin");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean dnsOk(String string) {
        boolean bl = false;
        this.log("checking DNS for host " + string);
        try {
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                return true;
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            try {
                this.inetAddresses = InetAddress.getAllByName(string);
                bl = true;
                int n = this.inetAddresses.length;
                if (n > 1) {
                    this.logHTTP(string + " is a multi-homed host with " + n + " addresses.");
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return bl;
                    }
                    this.logHTTP(string + " address: " + this.inetAddresses[n2]);
                    ++n2;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.status = "Unknown host (DNS error)";
                this.logError(this.status + ": " + string + ": " + unknownHostException);
                return bl;
            }
        }
        catch (Exception exception) {
            this.status = "Unknown local host";
            this.logError(this.status, exception);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean openConnection(String string, String string2, int n) {
        boolean bl = false;
        this.logHTTP("Opening connection");
        this.html = new StringBuffer("");
        try {
            this.logHTTP("Contacting HTTP server at " + string2);
            this.socket = new Socket(string2, n);
            this.timeoutThread = new HTTPTimeoutThread(this.socket, this.timeOutTime());
            try {
                this.logHTTP("Opening streams");
                this.ins = this.socket.getInputStream();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.ins);
                this.inStream = new DataInputStream(bufferedInputStream);
                this.outs = this.socket.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.outs);
                this.outStream = new PrintStream(bufferedOutputStream);
                bl = true;
            }
            catch (IOException iOException) {
                this.status = "Unable to create HTTP stream";
                this.logError(this.status, iOException);
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.status = "Unknown host";
            this.logError(": " + string2);
        }
        catch (SocketException socketException) {
            this.status = "HTTP server not available";
            this.logError(this.status + " at " + string2);
        }
        catch (Exception exception) {
            this.status = "Unable to create socket";
            this.logError(this.status, exception);
        }
        if (this.timeoutThread != null && !bl) {
            this.timeoutThread.stop();
        }
        return bl;
    }

    void requestPage() {
        CharSequence charSequence;
        int n = 0;
        String string = "";
        String string2 = this.headerOnly ? HTTPHead : HTTPGet;
        String string3 = this.isProxySet() ? this.url.toString() : this.trimReference(this.url.getFile());
        this.log("request url is " + string3);
        this.output(string2 + " " + string3 + " HTTP/1.1");
        this.output("Host:" + this.url.getHost());
        if (this.getIfModifiedSince() != null && this.getIfModifiedSince().length() > 0) {
            this.output("If-Modified-Since: " + this.getIfModifiedSince());
        }
        if (this.dataOnly) {
            this.acceptMimeType("*/*");
        } else {
            this.acceptMimeType("www/source");
            this.acceptMimeType("text/html");
            this.acceptMimeType("text/plain");
            this.acceptMimeType("video/mpeg");
            this.acceptMimeType("image/jpeg");
            this.acceptMimeType("image/x-tiff");
            this.acceptMimeType("image/x-rgb");
            this.acceptMimeType("image/x-xbm");
            this.acceptMimeType("image/gif");
            this.acceptMimeType("application/postscript");
            this.acceptMimeType("application/bin");
            this.acceptMimeType("application/octet-stream");
        }
        this.output("User-Agent: " + UserAgent);
        if (this.username != null && this.username.length() > 0 && this.password != null && this.password.length() > 0) {
            charSequence = this.username + ':' + this.password;
            this.output("Authorization: Basic " + Base64.toString(((String)charSequence).getBytes()));
        }
        if (string2.equalsIgnoreCase(HTTPPost)) {
            this.output("Content-type: " + "text/html");
            this.output("Content-length: " + n);
            this.output("");
            this.outStream.print(string);
            this.outStream.flush();
        } else {
            this.output("");
        }
        charSequence = new StringBuffer("Sent ");
        ((StringBuffer)charSequence).append(string2);
        ((StringBuffer)charSequence).append(" request for ");
        ((StringBuffer)charSequence).append(this.urlString);
        this.logHTTP(((StringBuffer)charSequence).toString());
    }

    void acceptMimeType(String string) {
        this.output("Accept: " + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean pageResponseOk() {
        boolean bl;
        block8: {
            bl = false;
            this.logHTTP("Getting HTTP response");
            try {
                String string = this.nextLineTrimmed();
                if (string == null) break block8;
                int n = string.indexOf(32);
                int n2 = n >= 0 ? string.indexOf(32, n + 1) : -1;
                if (n >= 0 && n2 >= 0) {
                    try {
                        this.httpReturnCode = Integer.parseInt(string.substring(n + 1, n2));
                        this.httpReturnCodeDescription = string.substring(n2 + 1).trim();
                        this.logHTTP("HTTP return code: \"" + this.httpReturnCode + " " + this.httpReturnCodeDescription + "\"");
                        if (this.httpReturnCode >= 200 && this.httpReturnCode <= 299) {
                            bl = true;
                        } else {
                            this.status = "Bad HTTP return code: " + string;
                            this.logError(this.status);
                        }
                        Vector vector = this.scanHeader();
                        this.httpResponseHeaderTag = new HtmlTag("httpHeader", vector);
                        this.rememberHeader(this.httpResponseHeaderTag);
                    }
                    catch (Exception exception) {
                        if (string == null) {
                            this.status = "HTTP header incomplete";
                            this.logError(this.status);
                            break block8;
                        }
                        this.status = "Got invalid HTTP status: " + string;
                        this.logError(this.status, exception);
                    }
                    break block8;
                }
                this.status = "Got invalid HTTP status: " + string;
                this.logError(this.status);
            }
            catch (Exception exception) {
                this.status = "Bad HTTP header";
                this.logError(this.status, exception);
            }
        }
        this.lineCount = 0;
        this.contentCount = 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.ins != null) {
                this.ins.close();
                this.ins = null;
            }
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
            if (this.outs != null) {
                this.outs.close();
                this.outs = null;
            }
            if (this.timeoutThread != null) {
                this.timeoutThread.stop();
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            this.logError(iOException);
        }
        this.logHTTP("Connection closed");
    }

    void parse() {
        this.logParse("Starting parse");
        while (!this.parseDone()) {
            this.scanToTagStart();
            HtmlTag htmlTag = this.scanTag();
            if (htmlTag != null) {
                if (htmlTag.nameIs("a") || htmlTag.nameIs("anchor") || htmlTag.nameIs("area")) {
                    this.scanAnchor(htmlTag);
                } else if (htmlTag.nameIs("/a") || htmlTag.nameIs("/anchor") || htmlTag.nameIs("/area")) {
                    this.scanEndAnchor();
                } else if (htmlTag.nameIs("img")) {
                    this.scanImage(htmlTag);
                } else if (htmlTag.nameIs("title")) {
                    this.scanTitle();
                } else if (htmlTag.nameIs("/title")) {
                    this.scanEndTitle();
                } else if (htmlTag.nameIs("body")) {
                    this.scanBody();
                } else if (htmlTag.nameIs("/body")) {
                    this.scanEndBody();
                } else if (htmlTag.nameIs("/html") && this.contentIsHTML()) {
                    this.endOfHTML = true;
                }
            }
            this.webPageLog.flush();
            Thread.yield();
        }
        this.logParse("Ending parse");
    }

    boolean parseDone() {
        boolean bl;
        boolean bl2 = bl = this.endOfHTML || this.endOfContent();
        if (!bl) {
            boolean bl3 = bl = this.summaryOnly && this.getLeadingText().length() >= 250;
        }
        if (!bl) {
            bl = !this.moreTokens();
        }
        return bl;
    }

    Vector scanHeader() {
        Vector<HtmlAvPair> vector = null;
        String string = this.nextLineTrimmed();
        while (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n >= 0) {
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                boolean bl = false;
                if (string2.length() > 0) {
                    if (vector == null) {
                        vector = new Vector<HtmlAvPair>();
                    }
                    vector.addElement(new HtmlAvPair(string2, string3, false));
                }
            }
            string = this.nextLineTrimmed();
            Thread.yield();
        }
        this.logParse("Scanned HTTP header");
        return vector;
    }

    void rememberHeader(HtmlTag htmlTag) {
        this.server = this.getHttpHeaderString(htmlTag, "Server");
        this.serverDate = this.getHttpHeaderString(htmlTag, "Date");
        this.lastModified = this.getHttpHeaderString(htmlTag, "Last-modified");
        this.contentType = this.getHttpHeaderString(htmlTag, "Content-type");
        this.redirectedLocation = this.getHttpHeaderString(htmlTag, "Location");
        this.contentLength = this.getHttpHeaderInt(htmlTag, "Content-length");
        if (this.contentLength > 0L && this.webFileProgress != null) {
            this.webFileProgress.setTotalBytes(this.contentLength);
        }
    }

    String getHttpHeaderString(HtmlTag htmlTag, String string) {
        HtmlAvPair htmlAvPair = htmlTag.getAvPair(string);
        String string2 = htmlAvPair != null ? htmlAvPair.getValue() : "";
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getHttpHeaderInt(HtmlTag htmlTag, String string) {
        String string2 = this.getHttpHeaderString(htmlTag, string);
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    void scanAnchor(HtmlTag htmlTag) {
        this.logParse("Scanning anchor");
        ++this.inAnchor;
        HtmlAvPair htmlAvPair = htmlTag.getAvPair("href");
        if (htmlAvPair != null && htmlAvPair.getValue() != null) {
            this.anchor = new HtmlAnchor();
            this.anchor.setHref(htmlAvPair.getValue());
        } else {
            this.logError("Error: empty anchor");
        }
        this.preAnchorBodyText = new String(this.bodyText);
        this.clearBodyText();
    }

    void scanEndAnchor() {
        if (this.inAnchor > 0) {
            --this.inAnchor;
            if (this.anchor != null) {
                this.anchor.setText(this.bodyText.toString().trim());
            }
            this.clearBodyText();
            this.appendBodyText(this.preAnchorBodyText);
            if (this.anchor != null) {
                this.appendBodyText(this.anchor.getText());
            }
            if (this.anchorCount < 2000) {
                this.anchors[this.anchorCount++] = this.anchor;
            }
        } else {
            String string = "Error: end of anchor without start";
            this.logError(string);
            this.log(this.htmlTokensLog, string);
        }
        this.logParse("Scanned anchor");
    }

    void scanImage(HtmlTag htmlTag) {
        this.logParse("Scanning image");
        ++this.inImage;
        HtmlAvPair htmlAvPair = htmlTag.getAvPair("src");
        if (htmlAvPair != null && htmlAvPair.getValue() != null) {
            HtmlImage htmlImage = new HtmlImage();
            htmlImage.setSrc(htmlAvPair.getValue());
            if (this.imageCount < 2000) {
                this.images[this.imageCount++] = htmlImage;
            }
        }
        this.logParse("Scanned image");
    }

    void scanTitle() {
        if (this.inTitle || !this.title.equals("")) {
            this.logError("Error: Unexpected start of title");
        }
        this.inTitle = true;
        this.clearBodyText();
    }

    void scanEndTitle() {
        if (!this.inTitle) {
            String string = "Error: end of title without start";
            this.logError(string);
            this.log(this.htmlTokensLog, string);
        }
        this.inTitle = false;
        this.title = new String(this.bodyText.toString().trim());
        this.clearBodyText();
    }

    void scanBody() {
        if (this.inBody) {
            this.logError("Error: Unexpected start of body");
        }
        this.inBody = true;
    }

    void scanEndBody() {
        if (!this.inBody) {
            String string = "Error: end of body without start";
            this.logError(string);
            this.log(this.htmlTokensLog, string);
        }
        this.inBody = false;
    }

    void scanToTagStart() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.skipComments(stringBuffer);
        while (!string.equals("<") && this.moreTokens()) {
            stringBuffer.append(string);
            string = this.skipComments(stringBuffer);
        }
        this.saveText(stringBuffer);
    }

    HtmlTag scanTag() {
        HtmlTag htmlTag = null;
        this.logParse("Scanning tag");
        String string = null;
        Vector<HtmlAvPair> vector = null;
        String string2 = null;
        String string3 = this.nextToken(TagDelimiters);
        if (!string3.equals(">")) {
            string = new String(string3);
        }
        while (!string3.equals(">") && this.moreTokens()) {
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            if (string2 != null) {
                string3 = string2;
                string2 = null;
            } else {
                string3 = this.nextMeaningfulToken();
            }
            if (!string3.equals(">")) {
                string4 = new String(string3);
                string3 = this.nextMeaningfulToken();
                if (string3.equals("=") && this.moreTokens()) {
                    string3 = this.nextMeaningfulToken();
                    if (string3.equals("\"")) {
                        bl = true;
                        string5 = this.scanString();
                    } else if (string3.equals(">")) {
                        this.logParse("Expected value after \"" + string4 + "=\"");
                    } else {
                        string5 = string3;
                    }
                } else if (!string3.equals(">")) {
                    string2 = string3;
                }
                if (string4.length() > 0) {
                    if (vector == null) {
                        vector = new Vector<HtmlAvPair>();
                    }
                    vector.addElement(new HtmlAvPair(string4, string5, bl));
                }
            }
            Thread.yield();
        }
        if (string != null) {
            htmlTag = new HtmlTag(string, vector);
            this.elements.addElement(new HtmlElement(htmlTag));
        }
        this.logParse("Scanned tag");
        return htmlTag;
    }

    String scanToTagEnd() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.moreTokens()) {
            String string = this.nextToken(TagDelimiters);
            while (!string.equals(">") && this.moreTokens()) {
                stringBuffer.append(string);
                string = this.nextToken(TagDelimiters);
            }
        }
        return stringBuffer.toString();
    }

    String skipComments(StringBuffer stringBuffer) {
        String string = this.nextToken(DefaultDelimiters);
        if (string.equals("<")) {
            this.saveText(stringBuffer);
            string = this.nextToken(DefaultDelimiters);
            if (string.equals("!")) {
                this.logParse("Started comment (or Doctype)");
                HtmlComment htmlComment = new HtmlComment(this.scanToTagEnd());
                HtmlElement htmlElement = new HtmlElement(htmlComment);
                this.elements.addElement(htmlElement);
                string = " ";
            } else {
                this.pushBackToken(string);
                string = "<";
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    String scanToEndComment() {
        var1_1 = false;
        var2_2 = "";
        ** GOTO lbl14
        {
            var2_2 = this.nextToken();
            do {
                if (!var2_2.equals("-") && this.moreTokens()) continue block0;
                if (this.moreTokens() && (var2_2 = this.nextToken()).equals("-")) {
                    while (var2_2.equals("-") && this.moreTokens()) {
                        var2_2 = this.nextToken();
                    }
                    if (var2_2.equals(">")) {
                        var1_1 = true;
                    }
                }
                Thread.yield();
lbl14:
                // 2 sources

            } while (!var1_1);
        }
        return var2_2;
    }

    String scanString() {
        this.logParse("Started string");
        String string = this.currentDelimiters;
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        if (this.moreTokens()) {
            string2 = this.nextToken(StringDelimiters);
            while (!string2.equals("\"") && this.moreTokens()) {
                stringBuffer.append(string2);
                if (string2.equals("\\") && this.moreTokens()) {
                    stringBuffer.append(this.nextToken());
                }
                string2 = this.nextToken();
            }
            this.logParse("String: \"" + stringBuffer + "\"");
        }
        if (!string2.equals("\"")) {
            this.logParse("Unexpected end of string: \"" + stringBuffer + "\"");
        }
        this.currentDelimiters = string;
        this.logParse("Ended string");
        return stringBuffer.toString();
    }

    String scanUrl() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        this.logParse("Started url");
        while (!string.equals("=") && this.moreTokens()) {
            string = this.nextToken();
        }
        if (string.equals("=")) {
            while (!string.equals("\"") && this.moreTokens()) {
                string = this.nextToken();
            }
            if (string.equals("\"")) {
                stringBuffer.append(this.scanString());
                this.logParse("Link: \"" + stringBuffer + "\"");
                if (this.linkCount < 2000) {
                    this.links[this.linkCount++] = stringBuffer.toString();
                } else if (!this.reportedTooManyLinks) {
                    this.logError("Too many links.");
                    this.reportedTooManyLinks = true;
                }
            }
        }
        this.logParse("Ended url");
        return stringBuffer.toString();
    }

    void saveText(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (this.bodyTextOk() || string.length() > 0 && string.trim().length() <= 0) {
            this.appendBodyText(string);
            HtmlText htmlText = new HtmlText(string);
            HtmlElement htmlElement = new HtmlElement(htmlText);
            this.elements.addElement(htmlElement);
            stringBuffer.setLength(0);
        }
    }

    void appendBodyText(String string) {
        if (this.bodyTextOk()) {
            char c;
            String string2 = this.bodyText.toString();
            if (string2.length() > 0 && Character.isLetter(c = string2.charAt(string2.length() - 1)) && !string2.endsWith(" ")) {
                this.bodyText.append(" ");
            }
            this.bodyText.append(string);
        } else {
            String string3 = " \t\r\n";
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.trim().length() > 0) {
                    this.logError("Error: Unexpected text \"" + string4 + "\"");
                } else if (string4.equals("\t")) {
                    this.bodyText.append(string4);
                } else if (string4.equals("\n")) {
                    this.bodyText.append(System.getProperty("line.separator"));
                }
                Thread.yield();
            }
        }
    }

    void clearBodyText() {
        this.bodyText = new StringBuffer("");
    }

    boolean bodyTextOk() {
        return this.inBody || this.inTitle;
    }

    String nextToken(String string) {
        this.currentDelimiters = string;
        return this.nextToken();
    }

    String nextToken() {
        String string;
        if (this.pushedBackToken != null) {
            string = this.pushedBackToken;
            this.pushedBackToken = null;
        } else if (this.moreTokens()) {
            string = new String(this.tokens.nextToken(this.currentDelimiters));
            this.log(this.htmlTokensLog, string);
            this.logParse(string);
        } else {
            string = "";
            this.log(this.htmlTokensLog, string);
        }
        return string;
    }

    boolean moreTokens() {
        this.refreshTokens();
        return this.tokens != null && this.tokens.hasMoreTokens();
    }

    void refreshTokens() {
        if (this.tokens == null || !this.tokens.hasMoreTokens()) {
            this.htmlLine = this.nextLine();
            while (!(this.htmlLine == null || this.tokens != null && this.tokens.hasMoreTokens())) {
                this.html.append(this.htmlLine);
                this.tokens = new StringTokenizer(this.htmlLine, this.currentDelimiters, true);
                if (!this.tokens.hasMoreTokens()) {
                    this.htmlLine = this.nextLine();
                }
                Thread.yield();
            }
        }
    }

    void pushBackToken(String string) {
        this.pushedBackToken = string;
    }

    String nextMeaningfulToken() {
        String string = " ";
        while (this.moreTokens() && (string.equals(" ") || string.equals("\t") || string.equals("\r") || string.equals("\n"))) {
            string = this.nextToken();
        }
        return string;
    }

    String nextLineTrimmed() {
        String string = this.nextLine();
        String string2 = string != null ? string.trim() : null;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String nextLine() {
        String string = null;
        if (this.endOfHTML) return string;
        if (this.endOfContent()) return string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte by = this.nextByte();
            while (true) {
                if (by == 13 || by == 10 || this.endOfContent()) {
                    if (by == 13) {
                        by = this.nextByte();
                    }
                    byteArrayOutputStream.write(by);
                    string = new String(byteArrayOutputStream.toByteArray());
                    break;
                }
                byteArrayOutputStream.write(by);
                by = this.nextByte();
            }
        }
        catch (HTTPTimeoutException hTTPTimeoutException) {
        }
        catch (Exception exception) {
            this.logError("Error reading line", exception);
        }
        if (string == null) {
            this.logHTTP("No more data");
            return string;
        }
        ++this.lineCount;
        this.logHTTP("In: " + string);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte nextByte() throws HTTPTimeoutException, IOException {
        byte by = 0;
        if (this.timedOut()) {
            this.status = TimedOutStatus;
            throw new HTTPTimeoutException(TimedOutStatus);
        }
        try {
            by = this.inStream.readByte();
            ++this.contentCount;
            return by;
        }
        catch (Exception exception) {
            this.connectionClosed = true;
        }
        return by;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean receiveData() {
        this.log("Receiving data . . .");
        boolean bl = true;
        String string = this.receiveFilename == null ? TempFilename : this.receiveFilename;
        try {
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while (true) {
                block11: {
                    if (!bl || this.inStream.available() <= 0 && this.endOfContent() || this.timedOut()) {
                        fileOutputStream.close();
                        if (this.webFileProgress != null) {
                            this.webFileProgress.setTotalBytes(this.contentCount);
                            this.webFileProgress.setDone(true);
                        }
                        this.log("Received " + this.contentCount + " bytes");
                        return bl;
                    }
                    try {
                        int n = 50000;
                        byte[] byArray = new byte[n];
                        int n2 = this.inStream.read(byArray);
                        if (n2 > 0) {
                            try {
                                fileOutputStream.write(byArray, 0, n2);
                                this.contentCount += n2;
                            }
                            catch (Exception exception) {
                                bl = false;
                                this.status = "Error writingdata to file";
                                this.logError(this.status, exception);
                            }
                            if (this.webFileProgress != null) {
                                this.webFileProgress.setBytesReceived(this.contentCount);
                            }
                            break block11;
                        }
                        this.connectionClosed = true;
                    }
                    catch (Exception exception) {
                        bl = false;
                        this.connectionClosed = true;
                        this.status = "Error receiving data";
                        this.logError(this.status, exception);
                    }
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            bl = false;
            this.logError("Unable to receive data to file " + string + ": " + exception);
        }
        return bl;
    }

    boolean timedOut() {
        if (!this.pageTimedOut) {
            long l = new Date().getTime();
            boolean bl = this.pageTimedOut = l > this.timeOutTime();
            if (this.pageTimedOut) {
                this.status = TimedOutStatus;
                this.logError(this.status);
            }
        }
        return this.pageTimedOut;
    }

    long timeOutTime() {
        return this.startTimestamp + this.getMaxWait();
    }

    boolean endOfContent() {
        return this.connectionClosed || this.inStream == null || this.contentLength > 0L && (long)this.contentCount >= this.contentLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URL makeUrl(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
            if (this.webFileProgress == null) return uRL;
            this.webFileProgress.setUrl(uRL);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new URL("file", "", string);
                if (this.webFileProgress == null) return uRL;
                this.webFileProgress.setUrl(uRL);
                return uRL;
            }
            catch (MalformedURLException malformedURLException2) {
                this.logError("Bad url \"" + string + "\"", malformedURLException);
                return null;
            }
        }
    }

    String trimReference(String string) {
        int n = string.indexOf(35);
        if (n == 0) {
            string = "";
        } else if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void logSystemProperties() {
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        this.log("System properties:");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = System.getProperty(string);
            this.log("System. getProperty ( " + string + " ) is " + string2);
        }
    }

    public boolean isProxySet() {
        String string = System.getProperty("proxySet");
        return string != null && string.equals("true");
    }

    public String getProxyHost() {
        return System.getProperty("proxyHost");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getProxyPort() {
        try {
            String string = System.getProperty("proxyPort");
            if (string == null) return -1;
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    void output(String string) {
        this.logHTTP("Out: " + string);
        this.outStream.print(string + "\r\n");
        this.outStream.flush();
    }

    String logMessage(String string) {
        string = string.replace('\r', ' ');
        string = string.replace('\n', ' ');
        StringBuffer stringBuffer = new StringBuffer();
        if (this.urlString != null) {
            stringBuffer.append(this.urlString);
        }
        stringBuffer.append(": ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void logHTTP(String string) {
        this.log(this.httpLog, string);
    }

    void logParse(String string) {
    }

    void log(Log log, String string) {
        String string2 = this.logMessage(string);
        log.write(string2);
    }

    void log(String string) {
        String string2 = this.logMessage(string);
        this.webPageLog.write(string2);
    }

    public void log(Exception exception) {
        this.log("Exception", exception);
        this.logError(exception);
    }

    public void log(String string, Exception exception) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(exception);
        this.log(stringBuffer.toString());
        System.err.println(stringBuffer.toString());
        this.logError(stringBuffer.toString());
    }

    void logError(String string) {
        if (this.errorLog != null) {
            if (this.lineCount > 0) {
                this.errorLog.write(this.logMessage(string) + ": Line " + this.lineCount);
            } else {
                this.errorLog.write(this.logMessage(string));
            }
        }
        this.log(string);
    }

    void logError(Exception exception) {
        if (this.errorLog != null) {
            this.errorLog.write(exception);
        }
        this.log(exception);
    }

    void logError(String string, Exception exception) {
        this.logError(string);
        this.logError(exception);
    }

    public WebFile(Log log) {
        this.errorLog = log;
        this.init();
    }

    public WebFile() {
        this.init();
    }
}

