/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.io.FileSystem;
import com.denova.io.JarException;
import com.denova.io.JarManifest;
import com.denova.io.LineEndingInputFilter;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.io.ZipEntryInputStream;
import com.denova.ui.TextDisplayable;
import com.denova.util.Base64;
import com.denova.util.Cancelable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class JarFile
implements Cancelable {
    static Log jarLog;
    static TextDisplayable textDisplay;
    static String UnarchivingText;
    static boolean canceled;
    final boolean debugging = false;
    final String MainClassAttribute = "Main-Class";
    File jarFile;
    Vector files;
    ZipFile zFile;
    ZipOutputStream zOut;
    FileOutputStream fOut;
    JarManifest manifest;
    String entryPathname;
    DigestOutputStream shaOut;
    DigestOutputStream entryOut;

    public static JarFile create(String string) throws Exception {
        return JarFile.create(new File(string));
    }

    public static JarFile create(File file, String string) throws Exception {
        return JarFile.create(new File(file, string));
    }

    public static JarFile create(File file) throws Exception {
        String string = new String(file.getPath());
        if (file.exists()) {
            file.delete();
        }
        return new JarFile(string);
    }

    public File getFile() {
        return this.jarFile;
    }

    public void close() throws Exception {
        if (this.zOut != null) {
            this.manifest.write(this.zOut);
            this.zOut.close();
            this.zOut = null;
            this.fOut.close();
            this.fOut = null;
        }
        if (this.zFile != null) {
            this.zFile.close();
            this.zFile = null;
        }
    }

    public void setMainClass(String string) {
        if (string != null && string.length() > 0) {
            this.addManifestHeaderItem("Main-Class", string);
        }
    }

    public void addManifestHeaderItem(String string, String string2) {
        if (this.manifest != null && string != null && string2 != null) {
            this.manifest.addHeader(string, string2);
        }
    }

    public void unarchive(String string) throws Exception {
        this.unarchive(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unarchive(File file) throws Exception {
        try {
            if (!canceled) {
                this.extractFilesToDirectory(file);
            }
            if (canceled) return;
            if (this.filesActuallyExtracted(file)) return;
            if (!canceled) {
                this.extractFilesToDirectory(file);
            }
            if (canceled) return;
            if (this.filesActuallyExtracted(file)) return;
            String string = "Unable to unarchive all files";
            String string2 = " from " + this.jarFile.getPath();
            String string3 = " to " + file.getPath();
            String string4 = "";
            String string5 = "Out of system resources. Please reboot and try again.";
            String[] stringArray = new String[]{string, string2, string3, string4, string5};
            JOptionPane.showMessageDialog(null, stringArray, "Error", 0);
            throw new JarException(string + string2 + string3);
        }
        catch (Exception exception) {
            JarFile.log(exception);
            throw exception;
        }
    }

    public void unarchiveManifest(String string) throws Exception {
        if (!canceled) {
            this.unarchiveManifest(new File(string));
        }
    }

    public void unarchiveManifest(File file) throws Exception {
        if (!canceled) {
            this.unarchiveFileToDirectory(JarManifest.getManifestPathname(), file);
        }
    }

    public int getCount() {
        return this.getPathnames().size();
    }

    public Vector getPathnames() {
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = null;
        if (this.manifest.isJar()) {
            enumeration = this.manifest.getItems().elements();
        } else if (this.zFile != null) {
            enumeration = this.zFile.entries();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements() && !canceled) {
                String string;
                Cloneable cloneable;
                if (this.manifest.isJar()) {
                    cloneable = (Properties)enumeration.nextElement();
                    string = ((Properties)cloneable).getProperty("Name");
                } else {
                    cloneable = (ZipEntry)enumeration.nextElement();
                    string = ((ZipEntry)cloneable).getName();
                }
                if (!canceled) {
                    vector.addElement(string);
                }
                Thread.yield();
            }
        }
        return vector;
    }

    public static void addUnarchiveToTempFiles(String string) {
        if (!canceled) {
            JarFile.addUnarchiveToTempFiles(new File(string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addUnarchiveToTempFiles(File file) {
        try {
            File file2 = new File(file, JarManifest.getManifestPathname());
            if (!file2.exists()) return;
            if (!canceled) {
                TempFiles.add(file2.getParent());
            }
            if (!canceled) {
                TempFiles.add(file2);
            }
            JarManifest jarManifest = new JarManifest(file2);
            Enumeration enumeration = jarManifest.getItems().elements();
            while (enumeration.hasMoreElements()) {
                if (canceled) {
                    return;
                }
                Properties properties = (Properties)enumeration.nextElement();
                String string = properties.getProperty("Name");
                TempFiles.add(string);
                Thread.yield();
            }
            return;
        }
        catch (Exception exception) {
            JarFile.log(exception);
        }
    }

    void extractFilesToDirectory(File file) throws Exception {
        if (this.getCount() > 0) {
            if (!canceled) {
                file.mkdirs();
            }
            Runtime.getRuntime().gc();
            Enumeration enumeration = this.getPathnames().elements();
            while (enumeration.hasMoreElements() && !canceled) {
                String string = (String)enumeration.nextElement();
                this.unarchiveFileToDirectory(string, file);
            }
        }
    }

    boolean filesActuallyExtracted(File file) throws Exception {
        boolean bl = true;
        Enumeration enumeration = this.getPathnames().elements();
        while (bl && enumeration.hasMoreElements() && !canceled) {
            String string = (String)enumeration.nextElement();
            File file2 = new File(file, string);
            bl = file2.exists();
            Thread.yield();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ZipEntry getZipEntry(String string) throws Exception {
        ZipEntry zipEntry = null;
        if (this.zFile == null) return zipEntry;
        try {
            if (canceled) return zipEntry;
            return this.zFile.getEntry(string);
        }
        catch (Exception exception) {
            JarFile.log(exception);
            throw new JarException("Unable to find " + string + " in " + this.jarFile.getPath() + ": " + exception);
        }
    }

    public InputStream getInputStream(String string) throws Exception {
        return this.getInputStream(this.getZipEntry(string));
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws Exception {
        ZipEntryInputStream zipEntryInputStream = null;
        if (zipEntry == null) {
            throw new JarException("Unable to get input stream from null ZipEntry ");
        }
        if (this.zFile == null) {
            throw new JarException("Unable to get input stream for " + zipEntry.getName() + " from null ZipFile ");
        }
        zipEntryInputStream = new ZipEntryInputStream(this.zFile, zipEntry);
        if (zipEntryInputStream == null) {
            throw new JarException("Unable to get input stream for " + zipEntry.getName() + " in " + this.zFile.getName());
        }
        return zipEntryInputStream;
    }

    public long getFileSize(String string) throws Exception {
        return this.getZipEntry(string).getSize();
    }

    public void unarchiveFileToDirectory(String string, String string2) throws Exception {
        if (!canceled) {
            this.unarchiveFileToDirectory(string, new File(string2));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unarchiveFileToDirectory(String string, File file) throws Exception {
        Object object;
        Object object2;
        if (string == null) throw new JarException("Unable to unarchive null pathname to " + file.getPath());
        if (this.getUnarchivingText().length() > 0) {
            JarFile.log(this.getUnarchivingText() + ":" + string);
        } else {
            object2 = string;
            object2 = ((String)object2).replace('\\', File.separatorChar);
            object = new File((String)(object2 = ((String)object2).replace('/', File.separatorChar)));
            if (object != null && ((File)object).getName().length() > 0) {
                JarFile.log(((File)object).getName());
            } else {
                JarFile.log((String)object2);
            }
        }
        try {
            string = string.replace('\\', '/');
            object2 = this.getZipEntry(string);
            object = this.getInputStream((ZipEntry)object2);
            LineEndingInputFilter lineEndingInputFilter = new LineEndingInputFilter(string, (InputStream)object);
            String string2 = string.replace('/', File.separatorChar);
            File file2 = new File(file, string2);
            JarFile.logMsg("adding file: " + file2.getPath());
            this.files.addElement(file2);
            File file3 = new File(file2.getParent());
            if (!canceled) {
                file3.mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (!canceled) {
                JarFile.logMsg("copying stream");
                FileSystem.copyStreams(lineEndingInputFilter, fileOutputStream);
            }
            fileOutputStream.close();
            lineEndingInputFilter.close();
            ((InputStream)object).close();
            return;
        }
        catch (Exception exception) {
            throw new JarException("Unable to copy " + string + " from " + this.jarFile.getPath() + " to " + file.getPath() + ": " + exception);
        }
    }

    public void archiveAs(String string, String string2) throws Exception {
        if (!canceled) {
            this.archiveAs(new File(string), string2);
        }
    }

    public void archiveAs(File file, String string) throws Exception {
        if (!canceled) {
            this.archiveAs(file, string, null);
        }
    }

    public void archiveAs(File file, String string, File file2) throws Exception {
        if (!canceled) {
            this.addFile(file, string, file2);
        }
    }

    public void archive(String string) throws Exception {
        if (!canceled) {
            this.archive(null, string);
        }
    }

    public void archive(File file) throws Exception {
        if (!canceled) {
            this.archive(file, null, null);
        }
    }

    public void archive(File file, String string) throws Exception {
        if (!canceled) {
            this.archive(null, file, string);
        }
    }

    public void archive(File file, File file2, String string) throws Exception {
        if (file == null) {
            file = new File(string);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (file.isDirectory() && file2 == null) {
            file2 = file;
        }
        String string2 = this.baseFilename(file2, file, string);
        if (!canceled) {
            this.addFile(file, string2, file2);
        }
    }

    void addFile(File file, String string, File file2) throws Exception {
        JarFile.log("Archiving to " + this.jarFile.getName() + ": " + file.getName());
        if (file.isDirectory()) {
            File file3 = file;
            String[] stringArray = file3.list();
            int n = 0;
            while (n < stringArray.length && !canceled) {
                String string2 = stringArray[n];
                File file4 = new File(file3, string2);
                String string3 = this.baseFilename(file2, file4, string2);
                if (!canceled) {
                    this.addFile(file4, string3, file2);
                }
                ++n;
            }
        } else {
            String string4 = this.baseFilename(file2, file, string);
            FileInputStream fileInputStream = new FileInputStream(file);
            String string5 = string.toLowerCase();
            if (string5.endsWith(".jar") || string5.endsWith(".zip") || string5.endsWith(".gz") || string5.endsWith(".taz") || string5.endsWith(".lzh") || string5.endsWith(".gif") || string5.endsWith(".jpeg") || string5.endsWith(".jpg")) {
                this.getOutputStream().setMethod(0);
                this.openStoredEntry(string, file.length(), FileSystem.getCrc(file));
            } else {
                this.openEntry(string, file.length());
            }
            if (!canceled) {
                this.archiveStream(string, fileInputStream);
            } else {
                fileInputStream.close();
            }
            this.closeEntry();
            this.getOutputStream().setMethod(8);
        }
    }

    String baseFilename(File file, File file2, String string) throws Exception {
        if (file != null) {
            String string2 = file.getCanonicalPath();
            string = file2.getCanonicalPath();
            if (string.startsWith(string2) && !string.equals(string2)) {
                string = string.substring(string2.length() + 1, string.length());
            }
            if (string.startsWith(File.separator) && string.length() > File.separator.length()) {
                string = string.substring(File.separator.length() + 1, string.length());
            }
        }
        return string;
    }

    public void archiveStream(String string, InputStream inputStream) throws Exception {
        int n = 30000;
        byte[] byArray = new byte[30000];
        int n2 = FileSystem.read(inputStream, byArray);
        while (n2 > 0 && !canceled) {
            if (!canceled) {
                this.getEntryOutputStream().write(byArray, 0, n2);
            }
            Thread.yield();
            if (canceled) continue;
            n2 = FileSystem.read(inputStream, byArray);
        }
        inputStream.close();
    }

    String base64(DigestOutputStream digestOutputStream) {
        return Base64.toString(digestOutputStream.getMessageDigest().digest());
    }

    ZipOutputStream getOutputStream() throws Exception {
        if (this.zOut == null) {
            if (this.zFile != null) {
                this.zFile.close();
                this.zFile = null;
            }
            this.fOut = new FileOutputStream(this.jarFile);
            this.zOut = new ZipOutputStream(this.fOut);
            this.manifest.clear();
        }
        return this.zOut;
    }

    public void openEntry(String string) throws Exception {
        this.openEntry(string, -1L);
    }

    public void openEntry(String string, long l) throws Exception {
        this.entryPathname = string.replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry(this.entryPathname);
        if (l >= 0L) {
            zipEntry.setSize(l);
        }
        this.getOutputStream().putNextEntry(zipEntry);
        this.setEntryOut();
    }

    public void openStoredEntry(String string, long l, long l2) throws Exception {
        this.entryPathname = string.replace(File.separatorChar, '/');
        ZipEntry zipEntry = new ZipEntry(this.entryPathname);
        zipEntry.setSize(l);
        zipEntry.setCrc(l2);
        zipEntry.setMethod(0);
        this.getOutputStream().putNextEntry(zipEntry);
        this.setEntryOut();
    }

    void setEntryOut() throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        MessageDigest messageDigest2 = MessageDigest.getInstance("MD5");
        this.shaOut = new DigestOutputStream(this.getOutputStream(), messageDigest);
        this.entryOut = new DigestOutputStream(this.shaOut, messageDigest2);
    }

    public void closeEntry() throws Exception {
        this.getOutputStream().closeEntry();
        Properties properties = new Properties();
        ((Hashtable)properties).put("Name", this.entryPathname);
        ((Hashtable)properties).put("Digest-Algorithms", "SHA MD5");
        ((Hashtable)properties).put("SHA-Digest", this.base64(this.shaOut));
        ((Hashtable)properties).put("MD5-Digest", this.base64(this.entryOut));
        this.manifest.addSection(properties);
    }

    public void setCancel(boolean bl) {
        canceled = bl;
        if (this.manifest != null) {
            this.manifest.setCancel(canceled);
        }
    }

    public boolean isCanceled() {
        return canceled;
    }

    public static void setTextDisplay(TextDisplayable textDisplayable) {
        textDisplay = textDisplayable;
    }

    public static TextDisplayable getTextDisplay() {
        return textDisplay;
    }

    public OutputStream getEntryOutputStream() {
        return this.entryOut;
    }

    public Vector getFiles() {
        return this.files;
    }

    public void setUnarchivingText(String string) {
        UnarchivingText = string;
    }

    public String getUnarchivingText() {
        return UnarchivingText;
    }

    private static void logMsg(String string) {
        JarFile.startLog();
        jarLog.write(string);
    }

    private static void log(String string) {
        JarFile.logMsg(string);
        if (textDisplay != null && !canceled) {
            textDisplay.displayText(string);
        }
    }

    private static void log(Exception exception) {
        JarFile.startLog();
        jarLog.setLogging(true);
        jarLog.write(exception);
    }

    private static void startLog() {
        if (jarLog == null) {
            jarLog = new Log("jarFile");
        }
    }

    public JarFile(String string) throws Exception {
        this(new File(string));
    }

    public JarFile(File file, String string) throws Exception {
        this(new File(file, string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarFile(File file) throws Exception {
        try {
            this.jarFile = file;
            this.zFile = null;
            this.zOut = null;
            this.manifest = null;
            this.files = new Vector();
            canceled = false;
            if (this.jarFile.exists()) {
                try {
                    this.zFile = new ZipFile(this.jarFile);
                }
                catch (ZipException zipException) {
                    JarFile.log(zipException);
                    if (this.zFile != null) {
                        try {
                            this.zFile.close();
                        }
                        catch (Exception exception) {
                            JarFile.log(exception);
                        }
                        this.zFile = null;
                    }
                    String string = this.jarFile.getPath();
                    this.jarFile.delete();
                    this.jarFile = new File(string);
                }
            }
            this.manifest = new JarManifest(this.zFile);
            return;
        }
        catch (Exception exception) {
            JarFile.log(exception);
            throw exception;
        }
    }

    static {
        UnarchivingText = "Unarchiving";
        canceled = false;
    }
}

