/*
 * Decompiled with CFR 0.152.
 */
package com.denova.io;

import com.denova.runtime.OS;
import com.denova.ui.UiUtilities;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class FileSystem {
    static JProgressBar progressBar;
    static JLabel progressStatus;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean removeFile(String string) {
        try {
            File file = new File(string);
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean removeDirectory(String string) {
        return FileSystem.removeDirectory(new File(string));
    }

    public static boolean removeDirectory(File file) {
        boolean bl = true;
        if (file.isDirectory() && !FileSystem.isRootDirectory(file)) {
            bl = FileSystem.removeDirectoryContents(file);
            if (file.exists()) {
                bl = file.delete();
            }
        }
        return bl;
    }

    public static boolean removeDirectoryContents(String string) {
        return FileSystem.removeDirectoryContents(new File(string));
    }

    public static boolean removeDirectoryContents(File file) {
        boolean bl = false;
        if (file.isDirectory() && !FileSystem.isRootDirectory(file)) {
            File file2;
            bl = true;
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                file2 = new File(file, stringArray[n]);
                if (!file2.isDirectory() && !file2.delete()) {
                    bl = false;
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].equals(".") && !stringArray[n].equals("..") && (file2 = new File(file, stringArray[n])).isDirectory() && !FileSystem.removeDirectory(file2.getAbsolutePath())) {
                    bl = false;
                }
                ++n;
            }
            if (!file.delete()) {
                bl = false;
            }
        }
        return bl;
    }

    public static void copyFile(String string, String string2) throws Exception {
        FileSystem.copyFile(new File(string), new File(string2));
    }

    public static void copyFile(File file, String string) throws Exception {
        FileSystem.copyFile(file, new File(string));
    }

    public static void copyFile(String string, File file) throws Exception {
        FileSystem.copyFile(new File(string), file);
    }

    public static void copyFile(File file, File file2) throws Exception {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileSystem.copyFileToStream(file, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    public static void copyFileToStream(String string, OutputStream outputStream) throws Exception {
        FileSystem.copyFileToStream(new File(string), outputStream);
    }

    public static void copyFileToStream(File file, OutputStream outputStream) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileSystem.copyStreams(fileInputStream, outputStream);
        fileInputStream.close();
    }

    public static void copyStreamToFile(InputStream inputStream, String string) throws Exception {
        FileSystem.copyStreamToFile(inputStream, new File(string));
    }

    public static void copyStreamToFile(InputStream inputStream, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileSystem.copyStreams(inputStream, fileOutputStream);
        fileOutputStream.close();
    }

    public static void copyFileToZipStream(String string, ZipOutputStream zipOutputStream) throws Exception {
        File file = new File(string);
        FileSystem.copyFileToZipStream(file, file.getPath(), zipOutputStream);
    }

    public static void copyFileToZipStream(File file, String string, ZipOutputStream zipOutputStream) throws Exception {
        File file2 = null;
        FileSystem.copyFileToZipStream(file, string, file2, zipOutputStream);
    }

    public static void copyFileToZipStream(File file, String string, File file2, ZipOutputStream zipOutputStream) throws Exception {
        if (file.isDirectory()) {
            File file3 = file;
            String[] stringArray = file3.list();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                File file4 = new File(file3, string2);
                String string3 = FileSystem.getRelativePathname(file2, file4);
                FileSystem.copyFileToZipStream(file4, string3, file2, zipOutputStream);
                ++n;
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            String string4 = string.replace(File.separatorChar, '/');
            ZipEntry zipEntry = new ZipEntry(string4);
            zipEntry.setSize(file.length());
            zipOutputStream.putNextEntry(zipEntry);
            FileSystem.copyStreams(fileInputStream, zipOutputStream);
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
    }

    public static String getRelativePathname(File file, File file2) throws Exception {
        String string = file2.getPath();
        if (file != null) {
            String string2 = file.getCanonicalPath();
            string = file2.getCanonicalPath();
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
            if (string.startsWith(File.separator)) {
                string = string.substring(File.separator.length());
            }
        }
        return string;
    }

    public static void copyDirectory(String string, String string2) throws Exception {
        FileSystem.copyDirectory(new File(string), new File(string2));
    }

    public static void copyDirectory(File file, String string) throws Exception {
        FileSystem.copyDirectory(file, new File(string));
    }

    public static void copyDirectory(String string, File file) throws Exception {
        FileSystem.copyDirectory(new File(string), file);
    }

    public static void copyDirectory(File file, File file2) throws Exception {
        if (file.exists() && file.isDirectory() && file2.exists()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file3 = new File(file, stringArray[n]);
                File file4 = new File(file2, stringArray[n]);
                if (file3.isDirectory()) {
                    if (file4.exists() && file4.isDirectory() || file4.mkdirs()) {
                        FileSystem.copyDirectory(file3, file4);
                    }
                } else {
                    FileSystem.copyFile(file3.getPath(), file4.getPath());
                }
                ++n;
            }
        }
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n = 50000;
        byte[] byArray = new byte[50000];
        int n2 = FileSystem.read(inputStream, byArray);
        while (n2 > 0) {
            outputStream.write(byArray, 0, n2);
            n2 = FileSystem.read(inputStream, byArray);
            Thread.yield();
        }
        FileSystem.setProgressBar(100);
        FileSystem.setProgressStatus("100%");
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream, long l) throws Exception {
        int n = 50000;
        byte[] byArray = new byte[50000];
        int n2 = (int)l;
        int n3 = n2;
        if (n3 > 50000) {
            n3 = 50000;
        }
        int n4 = FileSystem.read(inputStream, byArray, n3);
        while (n4 > 0) {
            outputStream.write(byArray, 0, n4);
            int n5 = (int)((l - (long)n2) * 100L / l);
            FileSystem.setProgressBar(n5);
            FileSystem.setProgressStatus(String.valueOf(n5));
            n3 = n2 -= n4;
            if (n3 > 50000) {
                n3 = 50000;
            }
            n4 = FileSystem.read(inputStream, byArray, n3);
            Thread.yield();
        }
        FileSystem.setProgressBar(100);
        FileSystem.setProgressStatus("100%");
    }

    public static int read(InputStream inputStream) throws IOException {
        int n = inputStream.available() > 0 ? inputStream.read() : -1;
        return n;
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        int n = inputStream.read(byArray);
        return n;
    }

    public static int read(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = inputStream.read(byArray, 0, n);
        return n2;
    }

    public static boolean isRootDirectory(String string) {
        return File.separator.equals(string) || OS.isWindows() && string.endsWith(":\\");
    }

    public static boolean isRootDirectory(File file) {
        return FileSystem.isRootDirectory(file.getPath());
    }

    public static long getCrc(File file) throws Exception {
        CRC32 cRC32 = new CRC32();
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 50000;
        byte[] byArray = new byte[50000];
        long l = file.length();
        int n2 = (int)l;
        int n3 = n2;
        if (n3 > 50000) {
            n3 = 50000;
        }
        int n4 = FileSystem.read(fileInputStream, byArray, n3);
        while (n4 > 0) {
            cRC32.update(byArray, 0, n4);
            int n5 = (int)((l - (long)n2) * 100L / l);
            FileSystem.setProgressBar(n5);
            FileSystem.setProgressStatus(String.valueOf(n5));
            n3 = n2 -= n4;
            if (n3 > 50000) {
                n3 = 50000;
            }
            n4 = FileSystem.read(fileInputStream, byArray, n3);
            Thread.yield();
        }
        FileSystem.setProgressBar(100);
        FileSystem.setProgressStatus("100%");
        fileInputStream.close();
        return cRC32.getValue();
    }

    public static void setProgressBar(JProgressBar jProgressBar) {
        progressBar = jProgressBar;
    }

    public static JProgressBar getProgressBar() {
        return progressBar;
    }

    public static void setProgressStatus(JLabel jLabel) {
        progressStatus = jLabel;
    }

    public static JLabel getProgressStatus() {
        return progressStatus;
    }

    static void setProgressBar(int n) {
        if (progressBar != null) {
            UiUtilities.update((Component)progressBar, n);
        }
    }

    static void setProgressStatus(String string) {
        if (progressStatus != null) {
            UiUtilities.update((Component)progressStatus, (Object)string);
        }
    }
}

