/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.InstallerConstants;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.FileSystem;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.runtime.Exec;
import com.denova.runtime.JRE;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.swing.JLabel;

public class UninstallPanel
extends WizardPanel
implements JExpressConstants,
InstallerConstants,
InstallPropertyNames {
    final String KeyPrefix = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
    final String Quote = "\"";
    final String UninstallSpecFilename = "uninstall";
    JLabel uninstallNotice;
    boolean uninstallDone = false;
    JExpressInstaller installer;
    String packageName;
    String packageVersion;
    String packageID;
    String appDir;
    String javaHomeDir;
    File jExpressDir;
    File commandFile;
    File winPgmsExe;
    File uninstallFile;
    WindowsOS windowsOS;
    Log log;
    Log errorLog;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActive(boolean bl) {
        if (bl) {
            if (!this.uninstallDone) {
                String string;
                block8: {
                    this.installer.logToInstaller("Installing uninstaller");
                    this.packageName = this.getPropertyList().getProperty("packageName");
                    this.packageVersion = this.getPropertyList().getProperty("packageVersion");
                    this.packageID = (this.packageName + " " + this.packageVersion).trim();
                    this.appDir = this.getPropertyList().getProperty("applicationDirectory");
                    string = null;
                    this.jExpressDir = new File(this.appDir, "JExpress");
                    this.jExpressDir.mkdirs();
                    this.commandFile = new File(this.jExpressDir, "uninstall");
                    this.winPgmsExe = new File(this.jExpressDir, "WinCmds.exe");
                    this.javaHomeDir = JRE.getJavaHome();
                    if (this.javaHomeDir.length() <= 0) {
                        this.javaHomeDir = this.jExpressDir.getPath();
                    }
                    String string2 = "JExpressUninstaller.jar";
                    this.uninstallFile = new File(this.javaHomeDir, string2);
                    this.log.write("uninstall filename " + string2);
                    try {
                        if (OS.isWindows()) {
                            this.createWindowsUninstall();
                            break block8;
                        }
                        if (OS.isUnix()) {
                            this.createUnixUninstall();
                        }
                    }
                    catch (Exception exception) {
                        string = this.getLocalizedString("NoUninstaller");
                        this.installer.logException(this, string, exception);
                    }
                }
                this.uninstallDone = true;
                if (string != null) {
                    UiUtilities.update((Component)this.uninstallNotice, (Object)string);
                }
                this.log.stopLogging();
            }
            this.showNextPanel();
        }
    }

    public boolean isNextButtonEnabled() {
        return false;
    }

    public boolean isPreviousButtonEnabled() {
        return false;
    }

    public boolean isCancelButtonEnabled() {
        return false;
    }

    public void reset() {
        this.uninstallDone = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWindowsUninstall() {
        File file = TempFiles.getFile("WinCmds.exe");
        if (!this.getWindowsExe("WinCmds.exe") && !file.exists()) {
            this.log.write("unable to get " + "WinCmds.exe");
            return;
        }
        try {
            FileSystem.copyFile(file.getPath(), this.jExpressDir.getPath());
        }
        catch (Exception exception) {
            this.log.write("unable to copy " + "WinCmds.exe" + " to " + this.jExpressDir.getPath());
        }
        this.createWindowsRegistryDeleteInfo();
        this.createWindowsMenusDeleteInfo();
        this.writeWindowsCommandFile(this.commandFile);
        file = new File(this.uninstallFile.getName());
        if (!this.getUninstallerJar(this.uninstallFile.getName()) && !file.exists()) {
            this.log.write("unable to extract uninstaller jar file " + this.uninstallFile.getName());
            return;
        }
        this.registerWindowsUninstall(this.commandFile);
    }

    void createUnixUninstall() {
        this.writeUnixCommandFile(this.commandFile);
        if (this.getUninstallerJar(this.uninstallFile.getName())) {
            this.writeUnixUninstallScript(this.commandFile);
        }
    }

    String getApplicationDirectory() {
        return JExpressInstaller.getInstaller().getProperty("applicationDirectory");
    }

    String getWindowsPackageKey() {
        return "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall" + File.separator + this.packageID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean getWindowsExe(String string) {
        boolean bl = false;
        File file = TempFiles.getFile(string);
        if (!this.installer.extractFile(string) && !file.exists()) {
            this.installer.logError("Unable to extract file " + string);
            return bl;
        }
        try {
            FileSystem.copyFile(file.getPath(), this.jExpressDir);
            bl = true;
            this.log.write("copied " + string + " to " + this.jExpressDir);
            return bl;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to copy " + file.getPath() + " to " + this.jExpressDir.getPath(), exception);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWindowsRegistryDeleteInfo() {
        File file = new File(this.jExpressDir, "specreg");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("delete" + "\t" + "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall" + "\t" + this.packageID);
            printWriter.close();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file.getPath(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createWindowsMenusDeleteInfo() {
        File file = new File(this.jExpressDir, "specmenu");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            PropertyList propertyList = this.getPropertyList().getPropertyListProperty("menus");
            Enumeration<?> enumeration = propertyList.propertyNames();
            block2: while (true) {
                if (!enumeration.hasMoreElements()) {
                    if (!this.installer.getPropertyList().getBooleanProperty("autoupdateNever")) {
                        printWriter.println("deleteProgramsMenu");
                        printWriter.println(this.packageName);
                        printWriter.println("Update " + this.packageName);
                    }
                    printWriter.close();
                    fileOutputStream.close();
                    return;
                }
                String string = (String)enumeration.nextElement();
                String string2 = propertyList.getProperty(string);
                if (string2 == null) continue;
                PropertyList propertyList2 = new PropertyList();
                propertyList2.fromString(string2);
                String string3 = propertyList2.getProperty("longName");
                if (string3 == null || string3.length() <= 0) {
                    string3 = propertyList2.getProperty("shortName");
                }
                String string4 = string3;
                int n = string4.indexOf(" ");
                while (true) {
                    if (n <= -1) {
                        printWriter.println("deleteProgramsMenu");
                        printWriter.println(this.packageName);
                        printWriter.println(string3);
                        continue block2;
                    }
                    string4 = string4.substring(0, n) + string4.substring(n + 1);
                    n = string4.indexOf(" ");
                }
                break;
            }
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file.getPath(), exception);
        }
    }

    void removeMenuLaunchers(PrintWriter printWriter) {
        PropertyList propertyList = this.getPropertyList().getPropertyListProperty("menus");
        Enumeration<?> enumeration = propertyList.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = propertyList.getProperty(string);
            if (string2 == null) continue;
            PropertyList propertyList2 = new PropertyList();
            propertyList2.fromString(string2);
            String string3 = propertyList2.getProperty("longName");
            if (string3 == null || string3.length() <= 0) {
                string3 = propertyList2.getProperty("shortName");
            }
            this.removeLauncher(printWriter, string3);
        }
        if (!this.installer.getPropertyList().getBooleanProperty("autoupdateNever")) {
            this.removeLauncher(printWriter, "Update " + this.packageName);
        }
    }

    void removeLauncher(PrintWriter printWriter, String string) {
        int n = string.indexOf(" ");
        while (n > -1) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(" ");
        }
        printWriter.println("delfile" + "\t" + this.appDir + File.separator + string + ".exe");
        printWriter.println("delfile" + "\t" + this.jExpressDir + File.separator + string + ".properties");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeWindowsCommandFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("title" + "\t" + this.packageID);
            printWriter.println("installdir" + "\t" + this.appDir);
            File file2 = new File(this.jExpressDir, "specreg");
            printWriter.println(this.winPgmsExe.getCanonicalPath() + "\t" + "registry" + "\t" + file2.getCanonicalPath());
            File file3 = new File(this.jExpressDir, "specmenu");
            printWriter.println(this.winPgmsExe.getCanonicalPath() + "\t" + "programsMenu" + "\t" + file3.getCanonicalPath());
            this.removeMenuLaunchers(printWriter);
            if (!this.installer.getPropertyList().getBooleanProperty("autoupdateNever")) {
                printWriter.println("delfile" + "\t" + this.appDir + File.separator + "JExpress" + File.separator + "update.control");
            }
            printWriter.println("delmanifest" + "\t" + this.appDir);
            printWriter.close();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file.getPath(), exception);
        }
    }

    void registerWindowsUninstall(File file) {
        String string;
        int n = 255;
        String string2 = this.createWinUninstallCommand(file);
        if (string2.length() > 255) {
            string = this.createUninstallBatchFile(string2);
            if (string == null || string.length() < 0) {
                string = string2;
            }
        } else {
            string = string2;
        }
        this.windowsOS.replaceWindowsRegistry(this.getWindowsPackageKey(), "DisplayName", this.packageID);
        this.windowsOS.replaceWindowsRegistry(this.getWindowsPackageKey(), "UninstallString", string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createUninstallBatchFile(String string) {
        String string2 = string;
        File file = new File(this.appDir, "JExpress");
        File file2 = new File(file, "uninstall.bat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("echo off");
            printWriter.println("echo Uninstalling " + this.packageName);
            printWriter.println("echo This batch file is required because the uninstall command line too long for Windows registry.");
            File file3 = new File(this.appDir);
            String string3 = this.getWindowsShortName(file3);
            printWriter.println("cd " + string3);
            printWriter.println(string);
            printWriter.close();
            fileOutputStream.close();
            String string4 = this.getWindowsShortName(file2);
            String string5 = OS.isWindows95() ? "command.com" : "CMD.exe";
            return string5 + " /c " + string4;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file2.getPath(), exception);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getWindowsShortName(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        String string2 = this.windowsOS.getAncientShortPath(string);
        if (string2 == null) return string;
        if (string2.length() <= 0) return string;
        return string2;
    }

    private String createWinUninstallCommand(File file) {
        String string = this.installer.getProperty("jvmCommandName", "");
        String string2 = JRE.getNativeExecutable(string);
        String string3 = this.windowsOS.getAncientShortPath(string2);
        if (string3 == null || string3.length() <= 0) {
            string3 = string2;
        }
        this.log.write("jvm command name is " + string);
        this.log.write("jvm executable is " + string2);
        this.log.write("jvm exe is " + string3);
        String string4 = this.getWindowsShortName(this.uninstallFile);
        String string5 = this.getWindowsShortName(file);
        String string6 = JRE.getSwingPath();
        File file2 = new File(string6);
        String string7 = file2.exists() ? "\"" + string6 + File.pathSeparator + string4 + "\"" : "\"" + string4 + "\"";
        String string8 = string3 + " -cp " + string7 + " " + "com.denova.JExpress.Uninstaller.JUninstall" + " " + string5;
        return string8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeUnixCommandFile(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("title" + "\t" + this.packageID);
            printWriter.println("installdir" + "\t" + this.appDir);
            PropertyList propertyList = this.getPropertyList().getPropertyListProperty("menus");
            Enumeration<?> enumeration = propertyList.propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    if (!this.installer.getPropertyList().getBooleanProperty("autoupdateNever")) {
                        printWriter.println("delfile" + "\t" + this.appDir + File.separator + "update");
                        printWriter.println("delfile" + "\t" + this.appDir + File.separator + "JExpress" + File.separator + "update.control");
                    }
                    printWriter.println("delfile" + "\t" + this.appDir + File.separator + this.uninstallLaunchName());
                    printWriter.println("delmanifest" + "\t" + this.appDir);
                    printWriter.close();
                    fileOutputStream.close();
                    return;
                }
                String string = (String)enumeration.nextElement();
                String string2 = propertyList.getProperty(string);
                if (string2 == null) continue;
                PropertyList propertyList2 = new PropertyList();
                propertyList2.fromString(string2);
                String string3 = propertyList2.getProperty("shortName");
                if (string3 == null || string3.length() <= 0) continue;
                printWriter.println("delfile" + "\t" + this.appDir + File.separator + string3);
            }
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file.getPath(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeUnixUninstallScript(File file) {
        File file2 = new File(this.appDir, this.uninstallLaunchName());
        try {
            String string;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            try {
                string = this.uninstallFile.getCanonicalPath();
            }
            catch (Exception exception) {
                string = this.uninstallFile.getAbsolutePath();
            }
            String string2 = "\"" + file + "\"";
            String string3 = JRE.getNativeExecutable(this.installer.getProperty("jvmCommandName", ""));
            String string4 = "\"" + JRE.getSwingPath() + ":" + string + "\"";
            String string5 = string3 + " -cp " + string4 + " " + "com.denova.JExpress.Uninstaller.JUninstall" + " " + string2 + " &";
            this.log.write("uninstall command " + string5);
            printWriter.println(string5);
            printWriter.close();
            fileOutputStream.close();
            Exec.runCommand("chmod 0744 " + file2.getPath());
            return;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to write to " + file2.getPath(), exception);
        }
    }

    boolean getUninstallerJar(String string) {
        boolean bl = false;
        if (this.installer.extractFile(string)) {
            String string2;
            bl = this.copyUninstallerJar(string, this.javaHomeDir);
            if (!bl && (string2 = System.getProperty("user.home", "")).length() > 0 && (bl = this.copyUninstallerJar(string, string2))) {
                String string3 = "JExpressUninstaller.jar";
                this.uninstallFile = new File(string2, string3);
            }
            if (!bl) {
                bl = this.copyUninstallerJar(string, this.appDir);
                if (bl) {
                    string2 = "JExpressUninstaller.jar";
                    this.uninstallFile = new File(this.appDir, string2);
                } else {
                    this.installer.logError("Unable to copy " + string);
                }
            }
        } else {
            this.installer.logError("Unable to extract file " + string);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean copyUninstallerJar(String string, String string2) {
        boolean bl = false;
        try {
            File file = TempFiles.getFile(string);
            FileSystem.copyFile(file.getPath(), string2);
            return true;
        }
        catch (Exception exception) {
        }
        return bl;
    }

    String uninstallLaunchName() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 0;
        while (n < this.packageName.length()) {
            int n2 = Character.getType(this.packageName.charAt(n));
            if (n2 == 1 || n2 == 2) {
                charArrayWriter.write(this.packageName.charAt(n));
            }
            ++n;
        }
        charArrayWriter.close();
        String string = "uninstall" + charArrayWriter.toString();
        return string;
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    public String getName() {
        return "UninstallPanel";
    }

    public UninstallPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.errorLog = log;
        this.setLayout(new BorderLayout());
        this.uninstallNotice = new JLabel(this.getLocalizedString("SettingUpUninstaller"), 0);
        this.uninstallNotice.setFont(new Font("BoldFont", 1, 14));
        this.add((Component)this.uninstallNotice, "Center");
        this.installer = JExpressInstaller.getInstaller();
        this.packageName = this.getPropertyList().getProperty("packageName");
        this.packageVersion = this.getPropertyList().getProperty("packageVersion");
        this.packageID = (this.packageName + " " + this.packageVersion).trim();
        this.windowsOS = new WindowsOS();
        this.log = new Log("uninstall");
    }
}

