/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.io.LineEndingInputFilter;
import com.denova.io.Log;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class TextPanel
extends WizardPanel
implements InstallPropertyNames,
Runnable {
    final String Loading = "loading";
    final String Displaying = "displaying";
    final boolean debugging = false;
    JTextArea textArea;
    JViewport displayViewport;
    Log log = new Log("textpanel");
    StringBuffer text;
    String filename;
    Thread thread;
    boolean startedRun = false;
    boolean gotFile = false;
    boolean active = false;
    boolean isHtml = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFile() {
        this.setNextButtonEnabled(false);
        this.log("getting file");
        try {
            if (this.filename == null) {
                throw new FileNotFoundException("null");
            }
            if (this.filename.length() <= 0) {
                throw new FileNotFoundException(this.filename);
            }
            String string = this.filename;
            String string2 = "." + JExpressInstaller.getInstaller().getLanguage();
            this.log("extension " + string2);
            this.log("filename is " + this.filename + string2);
            File file = new File(this.filename + string2);
            InputStream inputStream = JExpressInstaller.getInstaller().getResourceAsStream(file.getName());
            if (inputStream == null) {
                this.log("trying default filename " + this.filename);
                file = new File(this.filename);
                inputStream = JExpressInstaller.getInstaller().getResourceAsStream(file.getName());
            }
            if (inputStream == null) {
                throw new FileNotFoundException(this.filename);
            }
            LineEndingInputFilter lineEndingInputFilter = new LineEndingInputFilter(string, inputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(lineEndingInputFilter));
            this.text = new StringBuffer();
            String string3 = bufferedReader.readLine();
            while (true) {
                if (string3 == null) {
                    bufferedReader.close();
                    lineEndingInputFilter.close();
                    inputStream.close();
                    this.log(file.getPath() + " received");
                    this.showText();
                    this.gotFile = true;
                    if (!this.active) return;
                    this.log("Panel is already active");
                    this.setNextButtonEnabled(true);
                    return;
                }
                this.log(string3);
                this.text.append(string3 + System.getProperty("line.separator"));
                string3 = bufferedReader.readLine();
                Thread.yield();
            }
        }
        catch (Exception exception) {
            String string = "Unable to load text file " + this.filename;
            JExpressInstaller.getInstaller().logException(this, string, exception);
        }
    }

    public void setActive(boolean bl) {
        this.log("Panel active: " + String.valueOf(bl));
        this.active = bl;
        while (!this.gotFile) {
            Thread.yield();
        }
        this.setNextButtonEnabled(this.gotFile);
        this.showText();
    }

    public void run() {
        if (!this.gotFile) {
            this.getFile();
        }
        this.setNextButtonEnabled(this.gotFile);
    }

    public boolean isNextButtonEnabled() {
        return false;
    }

    protected void setTextFilename(String string) {
        this.log("Setting filename to " + string);
        this.filename = this.trimFilename(string);
        boolean bl = this.isHtml = this.filename.toLowerCase().endsWith(".html") || this.filename.toLowerCase().endsWith(".htm");
        if (!this.gotFile) {
            new Thread(this).start();
        }
    }

    protected StringBuffer getText() {
        return this.text;
    }

    private void setNextButtonEnabled(boolean bl) {
        if (this.active) {
            this.getNextButton().setEnabled(bl);
        }
    }

    private void showText() {
        if (this.active) {
            this.log("Showing text: " + this.text.toString());
            if (this.isHtml) {
                // empty if block
            }
            this.updateText(this.text.toString());
        } else {
            this.updateText(" ");
        }
    }

    private void updateText(String string) {
        UiUtilities.update((Component)this.textArea, (Object)string);
        Point point = this.displayViewport.getViewPosition();
        UiUtilities.update((Component)this.displayViewport, (Object)point);
    }

    private String trimFilename(String string) {
        int n = string.lastIndexOf(92);
        if (n < 0) {
            n = string.lastIndexOf(47);
        }
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    private void log(String string) {
        this.log.write(string);
    }

    private void log(Exception exception) {
        this.log.write(exception);
        exception.printStackTrace();
    }

    void debug(String string) {
    }

    public TextPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        String string = this.getLocalizedString("LoadingFile");
        this.text = new StringBuffer(string);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.textArea = new JTextArea(this.text.toString());
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(20, 31);
        this.displayViewport = jScrollPane.getViewport();
        this.displayViewport.add(this.textArea);
        jPanel.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "Center");
        TextPanel textPanel = this;
        if (textPanel == null) {
            throw null;
        }
        Action action = textPanel.new Action();
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
        }

        Action() {
        }
    }
}

