/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.InstallerConstants;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.FileSelectionDialog;
import com.denova.ui.GridBagControl;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.DefaultOptions;
import com.denova.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RequestBrowserName
extends WizardPanel
implements JExpressConstants,
InstallerConstants,
InstallPropertyNames {
    JTextField browserFilename;
    JButton browseButton;
    JExpressInstaller installer;

    public void setActive(boolean bl) {
        String string;
        if (bl && (string = System.getProperty("java.version")).compareTo("1.1.6") < 0) {
            this.browseButton.setEnabled(false);
        }
    }

    public boolean isOk() {
        boolean bl = false;
        File file = new File(this.browserFilename.getText());
        if (file != null && file.exists()) {
            String string = this.getPropertyList().getProperty("applicationDirectory");
            DefaultOptions defaultOptions = new DefaultOptions();
            defaultOptions.setDefaultDirectory(string);
            defaultOptions.setDefaultOptionsFilename("jex.developer");
            defaultOptions.load();
            defaultOptions.setProperty("browser", this.browserFilename);
            defaultOptions.save();
            bl = true;
        } else {
            Object[] objectArray = new Object[]{this.getLocalizedString("NoBrowserSpecified"), this.getLocalizedString("NoBrowserTryAgain")};
            bl = !UiUtilities.ask(objectArray, this.getLocalizedString("Question"), this.getLocalizedString("Yes"), this.getLocalizedString("No"));
        }
        return bl;
    }

    public boolean isPreviousButtonEnabled() {
        return false;
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    void browseButton_Clicked(ActionEvent actionEvent) {
        this.browse();
    }

    void browse() {
        JFrame jFrame = UiUtilities.forceJFrameParent(this);
        FileSelectionDialog fileSelectionDialog = new FileSelectionDialog(jFrame);
        FileSelectionDialog.setDefaultDirectory(".");
        fileSelectionDialog.setPrompt(this.getLocalizedString("BrowserExecPrompt"));
        fileSelectionDialog.show();
        File file = fileSelectionDialog.getSelection();
        if (file != null) {
            UiUtilities.update((Component)this.browserFilename, (Object)file.getPath());
        }
    }

    public String getName() {
        return "RequestBrowserName";
    }

    public RequestBrowserName(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.setLayout(new BorderLayout());
        Object var3_3 = null;
        int n = 10;
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        gridBagControl.addVerticalSpace();
        JLabel jLabel = new JLabel(this.getLocalizedString("BrowserExecPrompt"));
        jLabel.setFont(new Font("Bold", 1, 12));
        gridBagControl.endRow(jLabel);
        gridBagControl.addVerticalSpace();
        this.browserFilename = new JTextField();
        this.browserFilename.setToolTipText(this.getLocalizedString("BrowserExecTooltip"));
        this.browserFilename.setEditable(true);
        gridBagControl.add(gridBagConstraints, this.browserFilename);
        this.browseButton = new JButton(this.getLocalizedString("BrowseButton"));
        gridBagControl.endRow(gridBagConstraints2, this.browseButton);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        RequestBrowserName requestBrowserName = this;
        if (requestBrowserName == null) {
            throw null;
        }
        Action action = requestBrowserName.new Action();
        this.browseButton.addActionListener(action);
        this.installer = JExpressInstaller.getInstaller();
    }

    public RequestBrowserName() {
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RequestBrowserName.this.browseButton) {
                RequestBrowserName.this.browseButton_Clicked(actionEvent);
            }
        }

        Action() {
        }
    }
}

