/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.Dlc;
import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.InstallWizard;
import com.denova.JExpress.Installer.JExpressInstallerApp;
import com.denova.JExpress.JExpressConstants;
import com.denova.JExpress.JExpressStatusLog;
import com.denova.io.FileSystem;
import com.denova.io.JarFile;
import com.denova.io.LineEndingInputFilter;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.lang.LangUtilities;
import com.denova.runtime.JRE;
import com.denova.runtime.OS;
import com.denova.ui.LocaleTranslator;
import com.denova.ui.TextDisplayable;
import com.denova.ui.UiUtilities;
import com.denova.util.DataFinder;
import com.denova.util.PathEnumeration;
import com.denova.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class JExpressInstaller
extends JPanel
implements JExpressConstants,
InstallPropertyNames,
TextDisplayable {
    static JExpressInstaller installer;
    final String Quote = "\"";
    final String Dot = ".";
    final boolean debugging = false;
    LocaleTranslator locale;
    String controlUrl;
    boolean appletVersion = false;
    boolean statusEnabled = false;
    File swingDirectory;
    Log log = null;
    Log errorLog = null;
    JLabel status;
    String tempDirectory = null;
    String startDirectory = null;
    InstallWizard installWizard;
    PropertyList properties;
    boolean showInstallNowButton = true;
    boolean createdTempDir = false;
    JPanel logoPanel;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean configureProperties(String string) {
        String string2;
        boolean bl = false;
        this.logToInstaller("about to load properties");
        this.properties = new PropertyList();
        if (this.loadPropertyList(string) && (string2 = this.properties.getProperty("packageName", "")) != null && string2.length() > 0) {
            bl = true;
        }
        if (bl) {
            String string3;
            this.logToInstaller("properties loaded");
            this.properties.setProperty("startDirectory", this.startDirectory);
            this.properties.setProperty("tempDirectory", this.tempDirectory);
            boolean bl2 = this.properties.getBooleanProperty("metalLookAndFeel", false);
            if (bl2) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    this.logToInstaller("Unable to set metal UI");
                }
            }
            if ((string3 = this.properties.getProperty("defaultLanguage", "english")) != null && string3.length() > 0) {
                this.locale.setDefaultLanguage(string3);
            }
            this.setNativeJvmSettings();
        }
        this.logToInstaller("exiting configureProperties");
        return bl;
    }

    private void configureInstaller(boolean bl, String string, String string2) {
        this.setTextFileExtensions();
        this.createPanel();
        if (bl) {
            File file = new File(string);
            if (!file.isDirectory() && file.exists()) {
                PropertyList propertyList = this.getSilentInstallDirectory(file);
                if (propertyList != null) {
                    String string3 = propertyList.getProperty("applicationDirectory");
                    if (string3 != null && string3.length() > 0) {
                        this.properties.setProperty("silentConfigFilename", string);
                        this.logToInstaller("silentConfigFilename" + " " + string);
                        string = string3;
                        String string4 = propertyList.getProperty("installType", "");
                        if (string4 != null && string4.length() > 0) {
                            this.properties.setProperty("installType", string4);
                            this.logToInstaller("installType" + " " + string4);
                        }
                    } else {
                        bl = false;
                        this.logToInstaller("no application directory property in " + string);
                    }
                } else {
                    bl = false;
                    this.logToInstaller("unable to read config file " + string);
                }
            }
            if (bl) {
                this.installWizard.setSilent(bl);
                this.properties.setBooleanProperty("silentInstall", bl);
                this.properties.setProperty("applicationDirectory", string);
                this.logToInstaller("silent installation");
                this.logToInstaller("applicationDir " + string);
            }
        } else {
            this.properties.setBooleanProperty("silentInstall", bl);
        }
        if (string2 != null && string2.length() > 0) {
            this.properties.setProperty("extraParameters", string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PropertyList getSilentInstallDirectory(File file) {
        PropertyList propertyList = null;
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) return propertyList;
            propertyList = new PropertyList();
            propertyList.load(fileInputStream);
            fileInputStream.close();
            return propertyList;
        }
        catch (Exception exception) {
            return propertyList;
        }
    }

    void setTextFileExtensions() {
        String string = this.properties.getProperty("textFileExtensions");
        if (string != null) {
            LineEndingInputFilter.setTextExtensions(string);
        }
    }

    void createPanel() {
        int n = UiUtilities.getDefaultMargin();
        EmptyBorder emptyBorder = new EmptyBorder(n, n, n, n);
        this.logToInstaller("Creating panels");
        this.setLayout(new BorderLayout());
        this.setBorder(emptyBorder);
        boolean bl = false;
        String string = this.properties.getProperty("installImagePosition", "West");
        if (string.equals("North") || string.equals("South")) {
            bl = true;
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
        }
        this.add((Component)this.createLogoPanel(), string);
        if (bl) {
            this.add(Box.createVerticalStrut(n));
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalStrut(n));
            this.add(Box.createHorizontalGlue());
        }
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(LineBorder.createGrayLineBorder());
        this.logToInstaller("Instantiating wizard panel");
        this.installWizard = new InstallWizard(this, this.errorLog);
        this.logToInstaller("Done instantiating wizard panel");
        jPanel.add((Component)this.installWizard, "Center");
        box.add(jPanel);
        this.add((Component)box, this.oppositeBorder(string));
        if (bl) {
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JPanel createLogoPanel() {
        JLabel jLabel;
        ImageIcon imageIcon;
        this.logoPanel = new JPanel();
        this.logoPanel.setLayout(new BorderLayout());
        String string = this.properties.getProperty("installImageFilename", "jexinst.jpg");
        if (string == null || string.length() <= 0) {
            string = "jexinst.jpg";
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        String string2 = "";
        File file = new File(string);
        try {
            string2 = file.getName();
            imageIcon = this.getLogoIcon(string2);
            jLabel = new JLabel(imageIcon);
        }
        catch (Exception exception) {
            imageIcon = null;
            this.logToInstaller("Error: Unable to instantiate ImageIcon with " + string2 + " " + exception);
            jLabel = new JLabel("");
        }
        this.logoPanel.add((Component)jLabel, "Center");
        if (imageIcon != null) {
            this.logToInstaller("Image width is " + imageIcon.getIconWidth());
            this.logToInstaller("Image height is " + imageIcon.getIconHeight());
            this.logoPanel.add(Box.createHorizontalStrut(imageIcon.getIconWidth()), "North");
            this.logoPanel.add(Box.createVerticalStrut(imageIcon.getIconHeight()), "West");
        }
        return UiUtilities.addDoubleBevel(this.logoPanel, 1);
    }

    public void start() {
        this.logToInstaller("Starting wizard");
        this.installWizard.start();
    }

    public void exit() {
        this.logToInstaller("Exiting");
        this.setVisible(false);
        this.errorLog.stopLogging();
        this.log.stopLogging();
        if (this.tempDirectory != null && this.startDirectory != null) {
            this.copyLogsToStartDir(this.tempDirectory, this.startDirectory);
        }
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().setVisible(false);
        }
        this.deleteTemporaryFiles();
        if (this.isAppletVersion()) {
            File file = new File("JExpressInstaller" + "." + "jar");
            file.delete();
        }
        System.exit(0);
    }

    public PropertyList getPropertyList() {
        return this.properties;
    }

    public String getProperty(String string) {
        return this.getProperty(string, "");
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public JPanel getLogoPanel() {
        return this.logoPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadPropertyList(String string) {
        boolean bl = true;
        String string2 = null;
        String string3 = this.getStatus();
        this.setStatus(this.getLocalizedString("LoadProperties"));
        try {
            InputStream inputStream = this.getFileStream("jex.control");
            if (inputStream != null) {
                try {
                    this.logToInstaller("got properties stream");
                    this.properties.load(inputStream);
                    this.logToInstaller("loaded properties stream");
                    inputStream.close();
                }
                catch (Exception exception) {
                    this.logError("Error loading control url");
                    this.logToInstaller(exception);
                    bl = false;
                }
            } else {
                this.logError("Unable to load control url");
                bl = false;
            }
            this.properties.setProperty("controlUrl", string);
            if (string2 != null) {
                this.properties.setProperty("oldApplicationDirectory", string2);
            }
        }
        catch (Exception exception) {
            this.logException(this, "Unable to load property list", exception);
            bl = false;
        }
        this.setStatus(string3);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean savePropertyList() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("jex.control");
            this.properties.save(fileOutputStream, "JExpress Installation Properties");
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            this.logException(this, "Unable to save options to " + "jex.control", exception);
            return false;
        }
    }

    private ImageIcon getLogoIcon(String string) {
        ImageIcon imageIcon = null;
        File file = new File(this.tempDirectory, string);
        imageIcon = this.getResourceAsFile(string, file.getPath()) ? new ImageIcon(file.getPath()) : new ImageIcon(this.getClass().getResource(string));
        TempFiles.add(file.getPath());
        TempFiles.add(string);
        return imageIcon;
    }

    public boolean passwordRequired() {
        return this.getProperty("installPasswordDigest", "").length() > 0;
    }

    public boolean fileSpecified(String string) {
        return this.getProperty(string, "").length() > 0;
    }

    public boolean multipleFileGroups() {
        Boolean bl = new Boolean(this.getProperty("multipleFileGroups"));
        return bl;
    }

    public boolean isServlet() {
        Boolean bl = new Boolean(this.getProperty("isServlet"));
        return bl;
    }

    public boolean getResourceAsFile(String string) {
        return this.getResourceAsFile(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResourceAsFile(String string, String string2) {
        InputStream inputStream;
        if (string2 == null) {
            string2 = string;
        }
        boolean bl = (inputStream = this.getResourceAsStream(string)) != null && this.getFile(string2, inputStream);
        if (inputStream == null) return bl;
        try {
            inputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            this.logToInstaller(iOException);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFile(String string) {
        boolean bl = false;
        String string2 = this.getStatus();
        this.setStatus(this.getLocalizedString("Loading") + " " + string + "...");
        try {
            InputStream inputStream = null;
            inputStream = this.getFileStream(string);
            if (inputStream != null) {
                bl = this.getFile(string, inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            this.logException(this, "Unable to get file", exception);
        }
        if (bl) {
            this.setStatus(string2);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFile(String string, InputStream inputStream) {
        boolean bl = false;
        if (inputStream == null) throw new NullPointerException();
        String string2 = this.getStatus();
        this.setStatus(this.getLocalizedString("Loading") + " " + string + "...");
        try {
            int n = 50000;
            byte[] byArray = new byte[50000];
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            int n2 = inputStream.read(byArray);
            while (true) {
                if (n2 <= 0) {
                    fileOutputStream.close();
                    inputStream.close();
                    bl = true;
                    break;
                }
                fileOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
                Thread.yield();
            }
        }
        catch (Exception exception) {
            this.logException(this, "Unable to get file from inputStream", exception);
        }
        if (bl) {
            this.setStatus(string2);
            return bl;
        }
        String string3 = "Unable to load " + string;
        this.logToInstaller(string3);
        this.logError(string3);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getFileStream(String string) throws Exception {
        int n = 5;
        boolean bl = false;
        int n2 = 1;
        InputStream inputStream = null;
        String string2 = this.getStatus();
        this.setStatus(this.getLocalizedString("GettingStream") + " " + string + "...");
        while (!bl) {
            Object object;
            if (!this.isAppletVersion()) {
                try {
                    this.logToInstaller("getFileStream: getting resource as stream");
                    object = this.getResourceAsStream(string);
                    if (object != null) {
                        inputStream = new LineEndingInputFilter(string, (InputStream)object);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    this.logException(this, "getFileStream: File not found: " + string, exception);
                }
            }
            if (inputStream == null || !bl) {
                Object object2;
                Object object3;
                try {
                    object = new URL(this.controlUrl);
                    object3 = new URL((URL)object, string);
                    this.logToInstaller("Getting file stream from url " + object3);
                    object2 = ((URL)object3).openConnection();
                    ((URLConnection)object2).connect();
                    InputStream inputStream2 = ((URLConnection)object2).getInputStream();
                    boolean bl2 = false;
                    inputStream = new LineEndingInputFilter(inputStream2, false);
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.logToInstaller(fileNotFoundException);
                    this.setStatus(string + " " + this.getLocalizedString("TryingAsResource"));
                    try {
                        inputStream = this.getResourceAsStream(string);
                    }
                    catch (Exception exception) {
                        this.logException(this, "getFileStream: Resource not found: " + string, exception);
                    }
                    bl = true;
                }
                catch (UnknownHostException unknownHostException) {
                    object3 = "getFileStream: Host not found: " + this.controlUrl;
                    this.logError((String)object3);
                    bl = true;
                }
                catch (Exception exception) {
                    object3 = "getFileStream: filename: " + string + ", control url: " + this.controlUrl;
                    this.logException(this, (String)object3, exception);
                    if (n2 < 5) {
                        ++n2;
                        object2 = this.getLocalizedString("TryingAgain") + string;
                    } else {
                        bl = true;
                        object2 = this.getLocalizedString("UnableToLoad") + string;
                    }
                    this.setStatus((String)object2);
                    object2 = (String)object2 + ": " + exception;
                    this.logRemote(this, "getFileStream: " + (String)object2);
                    this.logError((String)object2);
                    throw exception;
                }
            }
            Thread.yield();
        }
        this.setStatus(string2);
        this.logToInstaller("getFileStream: success: " + (inputStream != null));
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copySwing() {
        try {
            String string = "swingall.jar";
            File file = new File(JRE.getJavaHome(), "lib");
            String string2 = System.getProperty("java.version");
            if (!string2.startsWith("1.1")) {
                if (!string2.startsWith("1.0")) return;
            }
            String string3 = System.getProperty("java.class.path", "");
            PathEnumeration pathEnumeration = new PathEnumeration(string3);
            File file2 = new File(string);
            boolean bl = false;
            while (true) {
                if (!pathEnumeration.hasMoreElements() || bl) {
                    if (!bl) return;
                    file2 = new File(string);
                    if (!file2.exists()) return;
                    this.logToInstaller("about to copy swingall.jar (JVM version " + string2 + ")");
                    try {
                        if (!file.isDirectory()) return;
                        this.copySwingToDir(file2, file);
                        return;
                    }
                    catch (Exception exception) {
                        String string4 = this.properties.getProperty("applicationDirectory");
                        if (string4 == null) return;
                        file = new File(string4);
                        if (!file.isDirectory()) return;
                        this.copySwingToDir(file2, file);
                        return;
                    }
                }
                String string5 = (String)pathEnumeration.nextElement();
                bl = string5.endsWith("swingall.jar");
                if (bl) {
                    string = string5;
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            this.logException(this, "Unable to copy Swing", exception);
        }
    }

    void copySwingToDir(File file, File file2) throws Exception {
        File file3 = new File(file2, file.getName());
        if (!this.theSameFile(file, file3)) {
            if (file3.exists()) {
                File file4 = new File(file2, "swingall.bak");
                file3.renameTo(file4);
            }
            FileSystem.copyFile(file, file2);
            JRE.setSwingPath(file3.getPath());
        }
    }

    public boolean isAppletVersion() {
        return this.appletVersion;
    }

    public void setStatus(String string) {
        if (this.status != null) {
            UiUtilities.update((Component)this.status, (Object)string);
        }
        this.logToInstaller(string);
    }

    public String getStatus() {
        String string = "";
        if (this.status != null) {
            string = this.status.getText();
        }
        return string;
    }

    public static JExpressInstaller getInstaller() {
        return installer;
    }

    String oppositeBorder(String string) {
        String string2 = string.equalsIgnoreCase("North") ? "South" : (string.equalsIgnoreCase("South") ? "North" : (string.equalsIgnoreCase("East") ? "West" : "East"));
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean licenseOk(String string) {
        boolean bl = true;
        if (this.installingFromFiles()) return bl;
        Dlc dlc = new Dlc(this.errorLog);
        try {
            URL uRL = new URL(string);
            return dlc.ok(uRL);
        }
        catch (Exception exception) {
            this.logException(this, "License not ok", exception);
        }
        return bl;
    }

    public String getUserClasspath() {
        String string = this.getProperty("installUserClasspath", "");
        string = string.replace(':', File.pathSeparatorChar);
        string = string.replace(';', File.pathSeparatorChar);
        string = string.replace('|', ':');
        return string;
    }

    public boolean installingFromFiles() {
        return this.controlUrl.startsWith("file:");
    }

    public void displayText(String string) {
    }

    public URL getResource(String string) {
        URL uRL = LangUtilities.getResource(string);
        if (uRL == null) {
            this.logToInstaller(LangUtilities.getLastException());
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = DataFinder.getStream(string);
        if (inputStream == null) {
            inputStream = LangUtilities.getResourceAsStream(string);
        }
        if (inputStream == null) {
            this.logToInstaller(LangUtilities.getLastException());
        }
        return inputStream;
    }

    public boolean extractFile(String string) {
        File file = TempFiles.getFile(string);
        boolean bl = file.exists();
        if (!bl) {
            bl = this.getResourceAsFile(string, file.getPath());
        }
        return bl;
    }

    public boolean showInstallButton() {
        if (this.installWizard != null) {
            this.showInstallNowButton = this.installWizard.showInstallButton();
        }
        return this.showInstallNowButton;
    }

    public void logToInstaller(String string) {
        if (this.log != null) {
            this.log.write(string);
            this.log.flush();
        }
        this.debug(string);
    }

    public void logToInstaller(Throwable throwable) {
        if (throwable != null) {
            if (this.log != null) {
                this.log.write(throwable);
                this.log.flush();
            }
            this.debug(throwable);
        }
    }

    public void logException(Object object, String string, Throwable throwable) {
        if (this.errorLog != null) {
            this.errorLog.write(throwable);
            this.errorLog.flush();
        }
        this.logError(string);
        this.debug("Error in " + object.getClass().getName());
        this.debug(string);
        this.debug(throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setNativeJvmSettings() {
        File file = new File("native.properties");
        if (!file.exists()) return;
        try {
            PropertyList propertyList = new PropertyList();
            FileInputStream fileInputStream = new FileInputStream("native.properties");
            if (fileInputStream == null) return;
            propertyList.load(fileInputStream);
            fileInputStream.close();
            String string = propertyList.getProperty("nativeJvmHomeDir", "");
            string = string.replace('/', File.separatorChar);
            this.properties.setProperty("nativeJvmHomeDir", string);
            this.properties.setBooleanProperty("nativeJvmInstalled", propertyList.getBooleanProperty("nativeJvmInstalled", false));
            return;
        }
        catch (Exception exception) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyLogsToStartDir(String string, String string2) {
        if (string != null && string.length() > 0 && !string2.equals(string)) {
            File file = new File(string2);
            File file2 = new File(string);
            String[] stringArray = file2.list();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (string3.endsWith(".log") && !string3.equals("jinstall.log")) {
                    File file3 = new File(file2, string3);
                    File file4 = new File(file, string3);
                    try {
                        FileSystem.copyFile(file3, file4);
                    }
                    catch (Exception exception) {
                    }
                    file3.delete();
                    Thread.yield();
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyLogsToTempDir(String string, String string2) {
        if (string != null && string.length() > 0 && !string2.equals(string)) {
            File file = new File(string2);
            File file2 = new File(string);
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (string3.endsWith(".log") && !string3.equals("jinstall.log")) {
                    File file3 = new File(file, string3);
                    File file4 = new File(file2, string3);
                    try {
                        FileSystem.copyFile(file3, file4);
                    }
                    catch (Exception exception) {
                        this.logException(this, "Unable to copy log files", exception);
                    }
                    Thread.yield();
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getStartDirectory() {
        String string = System.getProperty("user.dir", ".");
        File file = new File("startdir.txt");
        if (!file.exists()) return string;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
            bufferedReader.close();
            if (string == null) return System.getProperty("user.dir", ".");
            if (string.length() > 0) return string;
            return System.getProperty("user.dir", ".");
        }
        catch (Exception exception) {
        }
        return string;
    }

    public String getTempDirectory() {
        if (this.tempDirectory == null) {
            this.tempDirectory = "";
        }
        return this.tempDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String setTempDirectory(String string) {
        String string2 = System.getProperty("user.home", ".");
        String string3 = System.getProperty("user.dir", ".");
        if (string3.equals(string)) {
            String string4 = System.getProperty("user.home");
            string2 = this.createTempDirectory(string4);
            if (string2 == null) {
                string4 = System.getProperty("java.home");
                string2 = this.createTempDirectory(string4);
            }
            if (string2 == null) {
                File file = new File(string3, "___testjex.txt");
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(0);
                    fileOutputStream.close();
                    string2 = string3;
                    file.delete();
                }
                catch (Exception exception) {
                }
            }
            if (string2 != null && !string2.equals(string3)) {
                TempFiles.add(string2);
            } else {
                string2 = string3;
            }
        } else {
            string2 = string3;
        }
        TempFiles.setDefaultDirectory(string2);
        return string2;
    }

    String createTempDirectory(String string) {
        String string2 = null;
        if (OS.isUnix()) {
            File file = new File(File.separator, "tmp");
            if (file.exists()) {
                string2 = this._createTempDirectory(file.getPath());
            }
            if (string2 == null && (file = new File(File.separator, "temp")).exists()) {
                string2 = this._createTempDirectory(file.getPath());
            }
        }
        if (string2 == null) {
            string2 = this._createTempDirectory(string);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String _createTempDirectory(String string) {
        String string2 = null;
        boolean bl = false;
        if (string == null) return string2;
        int n = 1;
        while (!bl && n < 20) {
            File file = new File(string, "tmpjex" + String.valueOf(n));
            file.delete();
            if (!file.exists() && file.mkdir()) {
                this.createdTempDir = true;
                bl = true;
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (Exception exception) {
                    string2 = file.getPath();
                }
            }
            ++n;
            Thread.yield();
        }
        return string2;
    }

    void deleteTemporaryFiles() {
        File file;
        if (this.createdTempDir) {
            JarFile.addUnarchiveToTempFiles(this.tempDirectory);
        }
        TempFiles.delete();
        if (this.createdTempDir && (file = new File(this.tempDirectory)) != null) {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean theSameFile(File file, File file2) {
        boolean bl = false;
        try {
            if (!file.exists()) return false;
            if (!file2.exists()) return false;
            if (file.getCanonicalPath().equals(file2.getCanonicalPath())) return true;
            return false;
        }
        catch (Exception exception) {
            this.logToInstaller(exception);
        }
        return bl;
    }

    void debug(String string) {
    }

    void debug(Throwable throwable) {
    }

    void debugShowStream(InputStream inputStream) {
    }

    void logError(String string) {
        if (this.errorLog != null) {
            this.errorLog.write("Error: " + string);
        }
        this.debug(string);
    }

    void logRemote(Object object, String string) {
        this.logRemote(object.getClass().getName() + ": " + string);
    }

    void logRemote(String string) {
        new JExpressStatusLog(string);
    }

    public LocaleTranslator getCurrentLocale() {
        return this.locale;
    }

    public String getLocalizedString(String string) {
        return this.locale.getString(string);
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public static void main(String[] stringArray) {
        JExpressInstallerApp jExpressInstallerApp = new JExpressInstallerApp(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JExpressInstaller(String string, boolean bl, boolean bl2, String string2, String string3) {
        try {
            installer = this;
            this.controlUrl = string;
            this.appletVersion = bl;
            if (!UiUtilities.setLookAndFeel()) {
                this.exit();
                return;
            }
            this.startDirectory = this.getStartDirectory();
            this.tempDirectory = this.setTempDirectory(this.startDirectory);
            Log.setAlwaysFlush(false);
            Log.setUseTempDirectory(true);
            this.copyLogsToTempDir(this.tempDirectory, this.startDirectory);
            this.log = new Log("installer");
            this.errorLog = new Log("errors");
            this.errorLog.setStatusDisplay(this);
            this.errorLog.setLogging(true);
            this.log.setStatusDisplay(this);
            if (this.tempDirectory != null && this.tempDirectory.length() > 0) {
                DataFinder.addDirectory(this.tempDirectory);
                this.logToInstaller("added temp dir: " + this.tempDirectory + " to DataFinder");
            } else {
                DataFinder.addDirectory(this.startDirectory);
                this.logToInstaller("added start dir: " + this.startDirectory + " to DataFinder");
            }
            this.logToInstaller("classpath " + System.getProperty("java.class.path", ""));
            this.locale = new LocaleTranslator(".resources");
            this.logToInstaller("inited LocaleTranslator");
            if (string != null) {
                if (!this.configureProperties(string)) {
                    String[] stringArray = new String[]{"Unable to load properties for installer.", "Try resarting installer"};
                    this.logError(stringArray[0]);
                    UiUtilities.note(stringArray);
                    this.copyLogsToStartDir(this.tempDirectory, this.startDirectory);
                    this.exit();
                }
            } else {
                JOptionPane.showMessageDialog(this, this.getLocalizedString("Usage"));
                this.logError("No control url");
                this.exit();
            }
            this.logToInstaller("Control url: " + string);
            if (bl) {
                this.logToInstaller("Applet version");
            } else {
                this.logToInstaller("App version");
            }
            this.configureInstaller(bl2, string2, string3);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoClassDefFoundError) {
                UiUtilities.awtNoteError("Missing class " + throwable.getMessage());
                return;
            }
            this.logException(this, "Unable to instantiate", throwable);
        }
    }
}

