/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.DirectoryPanel;
import com.denova.JExpress.Installer.DownloadPanel;
import com.denova.JExpress.Installer.FinalPanel;
import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.Installer.LicensePanel;
import com.denova.JExpress.Installer.MultipleTypesPanel;
import com.denova.JExpress.Installer.NoticesPanel;
import com.denova.JExpress.Installer.PasswordPanel;
import com.denova.JExpress.Installer.ReadMePanel;
import com.denova.JExpress.Installer.SetupMenusPanel;
import com.denova.JExpress.Installer.UninstallPanel;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.FileGroup;
import com.denova.io.Log;
import com.denova.ui.FileGroupsListEditor;
import com.denova.ui.ListEditor;
import com.denova.ui.UiUtilities;
import com.denova.ui.Wizard;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class InstallWizard
extends Wizard
implements JExpressConstants,
InstallPropertyNames {
    final String TrialCopy1 = "This installer is for in-house evaluation";
    final String TrialCopy2 = " only.";
    final String TrialCopy3 = "Distribution ";
    final String TrialCopy4 = "violates the JExpress license.   ";
    final String TrialCopy5 = " ";
    final String TrialCopy6 = "Did you create this installation package?      ";
    JExpressInstaller installer;
    Log errorLog;
    boolean showInstallNowButton = true;

    public String getButtonsPosition() {
        return this.getPropertyList().getProperty("installButtonsPosition", super.getButtonsPosition());
    }

    private boolean trialCopy() {
        String string = this.installer.getProperty("customBeforeInstallWizardPanelClass", "");
        return string.startsWith("com.denova.JExpress.Installer.JExpressCustomClass");
    }

    public void cancel() {
        Object[] objectArray = new Object[]{this.getLocalizedString("IncompleteInstall"), this.getLocalizedString("WantToStopInstall")};
        boolean bl = UiUtilities.ask(objectArray, this.getLocalizedString("Warning"), this.getLocalizedString("Yes"), this.getLocalizedString("No"));
        if (bl) {
            JExpressInstaller.getInstaller().logToInstaller("user canceled");
            super.cancel();
            this.installer.exit();
        }
    }

    public void finish() {
        this.installer.exit();
    }

    public boolean showInstallButton() {
        return this.showInstallNowButton;
    }

    void addCustomWizardPanel(Log log, String string) {
        String string2 = this.installer.getProperty(string, "");
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() <= 0) continue;
            String string4 = ".class";
            if (string3.endsWith(".class")) {
                int n = string3.length() - ".class".length();
                string3 = string3.substring(0, n);
            }
            if (string3.equalsIgnoreCase("com.denova.JExpress.Installer.JExpressCustomClass")) continue;
            this.addCustomClassPanel(log, string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addCustomClassPanel(Log log, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            try {
                Constructor<?>[] constructorArray = clazz.getConstructors();
                int n = 0;
                boolean bl = false;
                while (true) {
                    if (n >= constructorArray.length || bl) {
                        if (bl) return;
                        this.logError("No successful constructor for custom class \"" + string + "\"");
                        return;
                    }
                    Constructor<?> constructor = constructorArray[n];
                    Object[] objectArray = new Object[]{this.getPropertyList(), log};
                    try {
                        this.addPanel((WizardPanel)constructor.newInstance(objectArray));
                        bl = true;
                    }
                    catch (Exception exception) {
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                this.logError("Could not instantiate custom class \"" + string + "\"", exception);
                return;
            }
        }
        catch (Exception exception) {
            this.logError("Could not load custom class \"" + string + "\"", exception);
        }
    }

    void addMultipleAppDirectoryPanels(Log log) {
        FileGroupsListEditor fileGroupsListEditor = new FileGroupsListEditor(new ListEditor());
        fileGroupsListEditor.fromString(this.getPropertyList().getProperty("fileGroupsTypes", ""));
        Enumeration enumeration = fileGroupsListEditor.getItems().elements();
        while (enumeration.hasMoreElements()) {
            FileGroup fileGroup = (FileGroup)enumeration.nextElement();
            this.addPanel(new DirectoryPanel(this.getPropertyList(), log, fileGroup.getName(), fileGroup.getDescription()));
        }
    }

    PropertyList getPropertyList() {
        return this.installer.getPropertyList();
    }

    void logError(String string) {
        this.errorLog.write(string);
    }

    void logError(Exception exception) {
        this.errorLog.write(exception);
    }

    void logError(Throwable throwable) {
        this.errorLog.write(throwable.toString());
    }

    void logError(String string, Exception exception) {
        this.errorLog.write(string);
        this.errorLog.write(exception);
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    InstallWizard(JExpressInstaller jExpressInstaller, Log log) {
        super(jExpressInstaller);
        Object object;
        boolean bl;
        this.installer = jExpressInstaller;
        this.errorLog = log;
        this.createPanel();
        this.setDefaultPreviousButtonLabel(this.getLocalizedString("BackButton"));
        this.setDefaultNextButtonLabel(this.getLocalizedString("NextButton"));
        this.setDefaultCancelButtonLabel(this.getLocalizedString("CancelButton"));
        this.setDefaultFinishedButtonLabel(this.getLocalizedString("FinishedButton"));
        if (this.trialCopy() && !(bl = UiUtilities.ask(object = new Object[]{"This installer is for in-house evaluation only.", "Distribution violates the JExpress license.   ", " ", "Did you create this installation package?      "}, this.getLocalizedString("Warning"), this.getLocalizedString("Yes"), this.getLocalizedString("No")))) {
            UiUtilities.note("This installer may only be used for in-house evaluation.");
            JExpressInstaller.getInstaller().logRemote("trial copy canceled");
            jExpressInstaller.exit();
        }
        if (jExpressInstaller.passwordRequired()) {
            this.addPanel(new PasswordPanel(this.getPropertyList(), log));
        }
        this.addCustomWizardPanel(log, "customBeforeInstallWizardPanelClass");
        this.addPanel(new NoticesPanel(this.getPropertyList(), log));
        this.addCustomWizardPanel(log, "customAfterWelcomeWizardPanelClass");
        if (jExpressInstaller.fileSpecified("installLicenseFilename")) {
            this.addPanel(new LicensePanel(this.getPropertyList(), log));
        }
        this.addCustomWizardPanel(log, "customAfterLicenseWizardPanelClass");
        if (jExpressInstaller.fileSpecified("installReadmeFilename")) {
            this.addPanel(new ReadMePanel(this.getPropertyList(), log));
        }
        this.addCustomWizardPanel(log, "customAfterReadMeWizardPanelClass");
        if (jExpressInstaller.multipleFileGroups()) {
            this.addPanel(new MultipleTypesPanel(this.getPropertyList(), log));
            this.addCustomWizardPanel(log, "customAfterMultipleInstallsWizardPanelClass");
        }
        if ((object = jExpressInstaller.getProperty("customAfterDirectoryWizardPanelClass", "").trim()) != null && ((String)object).length() > 0) {
            this.showInstallNowButton = false;
        }
        if (jExpressInstaller.isServlet()) {
            this.addMultipleAppDirectoryPanels(log);
        } else {
            this.addPanel(new DirectoryPanel(this.getPropertyList(), log));
        }
        this.addCustomWizardPanel(log, "customAfterDirectoryWizardPanelClass");
        this.addPanel(new DownloadPanel(this.getPropertyList(), log));
        this.addCustomWizardPanel(log, "customAfterFilesInstalledWizardPanelClass");
        this.addPanel(new SetupMenusPanel(this.getPropertyList(), log));
        this.addCustomWizardPanel(log, "customAfterMenusWizardPanelClass");
        if (!JExpressInstaller.getInstaller().isServlet()) {
            this.addPanel(new UninstallPanel(this.getPropertyList(), log));
        }
        this.addCustomWizardPanel(log, "customAfterInstallWizardPanelClass");
        this.addPanel(new FinalPanel(this.getPropertyList(), log));
    }
}

