/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.FileGroup;
import com.denova.io.JarFile;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.net.Downloader;
import com.denova.net.DownloaderStatus;
import com.denova.net.WebFile;
import com.denova.net.WebFileProgress;
import com.denova.ui.AutoProgressBar;
import com.denova.ui.FileGroupsListEditor;
import com.denova.ui.ListEditor;
import com.denova.ui.TextDisplayable;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import com.denova.util.StringConversions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class DownloadPanel
extends WizardPanel
implements JExpressConstants,
InstallPropertyNames,
WebFileProgress,
DownloaderStatus,
TextDisplayable,
Runnable {
    final boolean debugging = false;
    final int Margin = 20;
    Log log = new Log("download");
    File directory;
    String controlUrl;
    boolean ok;
    long totalBytesToReceive;
    int totalFileCount;
    Downloader downloader;
    boolean isActive;
    boolean canceled;
    boolean askedForFiles;
    boolean silentInstall;
    JLabel downloadLabel;
    JLabel title;
    JProgressBar progressBar;
    boolean progressCountUpdates;
    int progressCount;
    int filesInJarCount;
    AutoProgressBar autoProgress;
    JLabel status;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        JExpressInstaller jExpressInstaller;
        block22: {
            block23: {
                this.ok = true;
                jExpressInstaller = JExpressInstaller.getInstaller();
                this.log("Run started");
                this.silentInstall = this.getPropertyList().getBooleanProperty("silentInstall", false);
                this.getPreviousButton().setEnabled(false);
                this.getNextButton().setEnabled(false);
                this.autoProgress = new AutoProgressBar(this.progressBar);
                this.autoProgress.start();
                if (this.getPropertyList() == null) {
                    if (!this.silentInstall) {
                        UiUtilities.note(this.getLocalizedString("NoProperties"), this.getLocalizedString("Ok"));
                    }
                    this.gotError("No properties");
                }
                if (this.ok) {
                    this.controlUrl = this.getPropertyList().getProperty("controlUrl");
                    if (this.controlUrl == null) {
                        if (!this.silentInstall) {
                            UiUtilities.note(this.getLocalizedString("NoControlUrl"), this.getLocalizedString("Ok"));
                        }
                        this.gotError("No control url");
                    }
                }
                if (this.ok) {
                    object = this.getPropertyList().getProperty("applicationDirectory");
                    if (object != null) {
                        this.directory = new File((String)object);
                    }
                    if (this.directory == null) {
                        if (jExpressInstaller.isServlet()) {
                            this.directory = new File(".");
                        } else {
                            if (!this.silentInstall) {
                                UiUtilities.note(this.getLocalizedString("NoAppDir"), this.getLocalizedString("Ok"));
                            }
                            this.gotError("No application directory");
                        }
                    }
                }
                if (!this.ok) break block22;
                jExpressInstaller.copySwing();
                if (!jExpressInstaller.isAppletVersion()) break block23;
                this.ok = this.getJarFileFromWeb();
                if (!this.ok) {
                    try {
                        URL uRL = new URL(this.controlUrl);
                        URL uRL2 = new URL(uRL, this.getJarFilename());
                        object = "Unable to get " + uRL2.toString();
                    }
                    catch (Exception exception) {
                        object = "Unable to get " + this.getJarFilename();
                        this.logException((String)object, exception);
                    }
                    this.gotError((String)object);
                    jExpressInstaller.logError((String)object);
                }
                break block22;
            }
            try {
                object = new File(this.directory, this.getJarFilename());
                this.log("Looking for " + ((File)object).getName());
                if (((File)object).exists()) {
                    this.log(((File)object).getPath() + " exists");
                    this.ok = this.unpack((File)object);
                    TempFiles.add((File)object);
                    break block22;
                }
                this.setStatus(this.getLocalizedString("Unpacking") + " " + this.getJarFilename());
                if (this.extractJarFile((File)object, this.directory)) {
                    this.ok = this.unpack((File)object);
                    TempFiles.add((File)object);
                } else {
                    String string = "No files to install at " + this.controlUrl;
                    this.gotError(string);
                }
            }
            catch (Exception exception) {
                String string = this.getLocalizedString("UnableToGetFiles");
                this.logException(string, exception);
                this.ok = false;
            }
        }
        this.autoProgress.stop();
        this.getPreviousButton().setEnabled(true);
        if (this.ok) {
            this.setDownloadLabel("");
            if (this.isActive) {
                this.showNextPanel();
            }
            this.getNextButton().setEnabled(true);
        } else {
            object = this.getLocalizedString("UnableToGetFiles");
            jExpressInstaller.logError((String)object);
            this.setStatus((String)object);
        }
        this.log.stopLogging();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean getJarFileFromWeb() {
        try {
            long l = 10800000L;
            URL uRL = new URL(this.controlUrl);
            URL uRL2 = new URL(uRL, this.getJarFilename());
            this.totalBytesToReceive = 0L;
            this.autoProgress.stop();
            WebFile webFile = new WebFile();
            webFile.setWebFileProgress(this);
            webFile.setMaxWait(10800000L);
            File file = new File(this.directory, this.getJarFilename());
            webFile.getFile(uRL2.toString(), file);
            TempFiles.add(file.getPath());
            if (!webFile.isOk()) return false;
            return this.unpack(file);
        }
        catch (Exception exception) {
            String string = "Unable to get files from web";
            this.logException(string, exception);
            return false;
        }
    }

    void getIndividualFiles() {
        this.downloader = new Downloader(this.directory);
        Downloader.setErrorLog(this.getErrorLog());
        this.downloader.setUrlVectorFromUrl(this.controlUrl);
        this.downloader.setDownloaderStatus(this);
        this.downloader.startDownload();
    }

    String getJarFilename() {
        return this.getPropertyList().getProperty("safePackageName") + "Jex" + "." + "jar";
    }

    String getInstallerJarFilename() {
        return "install" + "." + "jar";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean extractJarFile(File file, File file2) {
        boolean bl = true;
        JExpressInstaller jExpressInstaller = JExpressInstaller.getInstaller();
        this.autoProgress.start();
        try {
            JarFile jarFile = new JarFile(this.getInstallerJarFilename());
            jarFile.unarchiveFileToDirectory(this.getJarFilename(), file2);
            jarFile.close();
            this.log(this.getJarFilename() + " extracted from " + this.getInstallerJarFilename() + " to " + file2);
        }
        catch (Exception exception) {
            this.log("Attempting to correct error extracting " + this.getJarFilename());
            if (jExpressInstaller.getResourceAsFile(this.getJarFilename(), file.getPath())) {
                this.log(this.getJarFilename() + " extracted from resources to " + file.getPath());
            }
            String string = "Unable to extract " + this.getJarFilename() + " from " + this.getInstallerJarFilename();
            this.logException(string, exception);
            bl = false;
        }
        this.autoProgress.stop();
        return bl;
    }

    boolean unpack(File file) throws Exception {
        boolean bl = true;
        String string = this.getLocalizedString("Unpacking") + " " + file.getName();
        this.setStatus(string);
        this.log(string + ", exists: " + file.exists());
        JarFile jarFile = new JarFile(file.getPath());
        this.startProgressBar(jarFile);
        JExpressInstaller jExpressInstaller = JExpressInstaller.getInstaller();
        if (jExpressInstaller.multipleFileGroups()) {
            bl = this.unpackSelectedInstallType(this.directory, jarFile, jExpressInstaller);
        } else if (jExpressInstaller.isServlet()) {
            bl = this.unpackServlet(jarFile, jExpressInstaller);
        } else {
            jarFile.unarchive(this.directory);
        }
        jarFile.unarchiveManifest(this.directory);
        this.stopProgressBar();
        jarFile.close();
        this.log("Unpacked");
        return bl;
    }

    boolean unpackSelectedInstallType(File file, JarFile jarFile, JExpressInstaller jExpressInstaller) throws Exception {
        String string = this.getPropertyList().getProperty("installType");
        return this.unpackFileGroup(string, file, jarFile, jExpressInstaller);
    }

    boolean unpackServlet(JarFile jarFile, JExpressInstaller jExpressInstaller) throws Exception {
        boolean bl = true;
        FileGroupsListEditor fileGroupsListEditor = new FileGroupsListEditor(new ListEditor());
        fileGroupsListEditor.fromString(this.getPropertyList().getProperty("fileGroupsTypes", ""));
        Enumeration enumeration = fileGroupsListEditor.getItems().elements();
        while (bl && enumeration.hasMoreElements()) {
            FileGroup fileGroup = (FileGroup)enumeration.nextElement();
            String string = fileGroup.getName();
            String string2 = fileGroup.getDescription();
            String string3 = this.getPropertyList().getProperty("applicationDirectory" + string);
            File file = new File(string3);
            String string4 = this.getPropertyList().getProperty("installType");
            bl = this.unpackFileGroup(string, file, jarFile, jExpressInstaller);
            Thread.yield();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unpackFileGroup(String var1_1, File var2_2, JarFile var3_3, JExpressInstaller var4_4) throws Exception {
        var5_5 = true;
        this.log("multiple install");
        var6_6 = new File(var2_2, "JExpress");
        var6_6.mkdirs();
        var7_7 = new File(var6_6, "filelist.txt");
        var8_8 = null;
        var9_9 = null;
        try {
            var8_8 = new FileOutputStream(var7_7);
            var9_9 = new PrintWriter(var8_8);
        }
        catch (Exception var10_10) {
            this.logException("Unable to create file output stream", var10_10);
        }
        var10_11 = var4_4.getProperty("relativeFileMap", "");
        var11_12 = StringConversions.toHashtable(var10_11);
        this.log("fileMapString " + var10_11);
        var12_13 = new FileGroupsListEditor(new ListEditor());
        var12_13.fromString(this.getPropertyList().getProperty("fileGroupsTypes", ""));
        var13_14 = new FileGroupsListEditor(new ListEditor());
        var13_14.fromString(this.getPropertyList().getProperty("fileGroupsFolders", ""));
        var14_15 = this.getNamedFileGroup(var12_13, var1_1);
        this.log("file group " + var1_1);
        Runtime.getRuntime().gc();
        var15_16 = var14_15.getElements().elements();
        while (var15_16 != null && var15_16.hasMoreElements()) {
            var16_17 = (String)var15_16.nextElement();
            var17_18 = this.getNamedFileGroup(var13_14, var16_17);
            this.log("folderName " + var16_17);
            Runtime.getRuntime().gc();
            var18_19 = var17_18.getElements().elements();
            while (var18_19 != null && var18_19.hasMoreElements()) {
                block11: {
                    block10: {
                        var19_20 = (String)var18_19.nextElement();
                        this.log("fileSet " + var19_20);
                        Runtime.getRuntime().gc();
                        var20_21 = (Vector)var11_12.get(var19_20);
                        if (var20_21 == null) break block10;
                        var21_22 = var20_21.elements();
                        Runtime.getRuntime().gc();
                        if (true) ** GOTO lbl54
                    }
                    var5_5 = false;
                    this.log("Unable to extract files from fileset: \"" + var19_20 + "\".");
                    break block11;
                    do {
                        var22_23 = (String)var21_22.nextElement();
                        this.log("starting to unarchive " + var22_23 + " to " + var2_2);
                        var3_3.unarchiveFileToDirectory(var22_23, var2_2);
                        if (var9_9 != null) {
                            var9_9.println(var22_23);
                        }
                        this.log("ending unarchive of " + var22_23);
                        Thread.yield();
lbl54:
                        // 2 sources

                    } while (var21_22 != null && var21_22.hasMoreElements());
                    if (var21_22 == null) {
                        var5_5 = false;
                        this.log("Unable to get elements from fileset.");
                    }
                }
                Thread.yield();
            }
            if (var18_19 == null) {
                var5_5 = false;
                this.log("Unable to get \"" + var16_17 + "\" folder's filesets.");
            }
            Thread.yield();
        }
        if (var15_16 == null) {
            var5_5 = false;
            this.log("Unable to get " + var1_1 + "'s folders.");
        }
        if (var9_9 != null) {
            var9_9.close();
        }
        return var5_5;
    }

    void startProgressBar(JarFile jarFile) {
        this.autoProgress.stop();
        this.progressCount = 0;
        this.filesInJarCount = jarFile.getCount();
        this.progressCountUpdates = true;
        jarFile.setUnarchivingText("");
        JarFile.setTextDisplay(this);
    }

    void stopProgressBar() {
        this.progressCountUpdates = false;
    }

    FileGroup getNamedFileGroup(FileGroupsListEditor fileGroupsListEditor, String string) {
        Enumeration enumeration = fileGroupsListEditor.getItems().elements();
        FileGroup fileGroup = null;
        while (enumeration.hasMoreElements() && fileGroup == null) {
            FileGroup fileGroup2 = (FileGroup)enumeration.nextElement();
            if (fileGroup2.getName().equals(string)) {
                fileGroup = fileGroup2;
            }
            Thread.yield();
        }
        return fileGroup;
    }

    public void setUrl(URL uRL) {
        String string = uRL.getFile().replace('/', File.separatorChar);
        File file = new File(string);
        this.setFilename(file.getName());
    }

    public void setBytesReceived(long l) {
        String string = String.valueOf(l / 1024L) + "K bytes";
        if (this.totalBytesToReceive > 0L) {
            float f = l;
            float f2 = this.totalBytesToReceive;
            int n = (int)(f / f2 * 100.0f);
            UiUtilities.update((Component)this.progressBar, n);
            this.setStatus(string + ": " + String.valueOf(n) + "%");
        } else {
            this.setStatus(string);
        }
    }

    public void setTotalBytes(long l) {
        this.totalBytesToReceive = l;
    }

    public void setFilename(String string) {
        UiUtilities.update((Component)this.title, (Object)string);
    }

    public void setFileIndex(int n) {
        if (n > 0) {
            if (this.totalFileCount > 0) {
                this.setStatus("File " + n + " of " + this.totalFileCount);
            } else {
                this.setStatus("File " + n);
            }
        }
    }

    public void setTotalFileCount(int n) {
        this.totalFileCount = n;
    }

    public void setDone(boolean bl) {
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        if (!this.askedForFiles) {
            this.log("Starting thread");
            new Thread(this).start();
            this.askedForFiles = true;
        } else if (bl) {
            this.showNextPanel();
        }
    }

    public void userCanceled() {
        this.canceled = true;
        if (this.downloader != null) {
            if (this.downloader.isDownloading()) {
                String string = "User cancelled while downloading files.";
                JExpressInstaller.getInstaller().logToInstaller(string);
            }
            this.downloader.userCanceled();
        }
    }

    public boolean isNextButtonEnabled() {
        return false;
    }

    public boolean isPreviousButtonEnabled() {
        return false;
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    void setStatus(String string) {
        int n = 35;
        if (string.length() > 35) {
            string = string.substring(0, 35) + "...";
        }
        UiUtilities.update((Component)this.status, (Object)string);
    }

    void setDownloadLabel(String string) {
        UiUtilities.update((Component)this.downloadLabel, (Object)string);
    }

    void log(String string) {
        this.log.write(string);
        JExpressInstaller.installer.debug(string);
    }

    void logException(String string, Throwable throwable) {
        this.gotError(string);
        JExpressInstaller.installer.logException(this, string, throwable);
    }

    void gotError(String string) {
        this.log(string);
        JExpressInstaller.getInstaller().logError(string);
        this.ok = false;
    }

    void monitor(String string) {
        this.log(string);
    }

    public void displayText(String string) {
        if (this.progressCountUpdates) {
            ++this.progressCount;
            float f = this.progressCount;
            float f2 = this.filesInJarCount;
            int n = (int)(f / f2 * 100.0f);
            UiUtilities.update((Component)this.progressBar, n);
        }
        this.setStatus(string);
    }

    public String getName() {
        return "InstallFilesPanel";
    }

    public void reset() {
        this.askedForFiles = false;
    }

    public DownloadPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.log("Instantiating. . .");
        JExpressInstaller jExpressInstaller = JExpressInstaller.getInstaller();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(20));
        this.downloadLabel = new JLabel(this.getLocalizedString("InstallingFiles"), 0);
        this.downloadLabel.setFont(new Font("Bold", 1, 12));
        jPanel.add(UiUtilities.centerLabel(this.downloadLabel));
        if (jExpressInstaller.multipleFileGroups()) {
            jPanel.add(Box.createVerticalStrut(20));
        }
        this.title = new JLabel(" ", 0);
        this.title.setFont(new Font("BigFont", 1, 14));
        jPanel.add(UiUtilities.centerLabel(this.title));
        String string = this.getPropertyList().getProperty("packageName", this.getJarFilename());
        if (jExpressInstaller.multipleFileGroups()) {
            string = this.getPropertyList().getProperty("installType", this.getJarFilename());
        }
        this.setFilename(string);
        jPanel.add(Box.createVerticalStrut(20));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(20, 20, 20, 20));
        jPanel2.setLayout(new GridLayout(2, 1));
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(100);
        jPanel2.add(this.progressBar);
        this.status = new JLabel("                                        ", 2);
        jPanel2.add(this.status);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(20));
        this.add((Component)jPanel, "Center");
        this.log("Instantiated");
    }
}

