/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.CustomInstaller;
import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.io.FileGroup;
import com.denova.io.Log;
import com.denova.runtime.JRE;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import com.denova.ui.DirectorySelectionDialog;
import com.denova.ui.FileGroupsListEditor;
import com.denova.ui.FileSelectionDialog;
import com.denova.ui.GridBagControl;
import com.denova.ui.ListEditor;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DirectoryPanel
extends WizardPanel
implements JExpressConstants,
InstallPropertyNames {
    JTextField dirname;
    JButton browseButton;
    WindowsOS winOS;
    String name;
    File defaultDirectory;
    boolean silentInstall;

    void initialize(String string, String string2) {
        if (string == null) {
            string = this.getLocalizedString("InstallDir");
        }
        if (string2 == null) {
            string2 = this.getLocalizedString("DirToolTip");
        }
        this.name = string;
        int n = 12;
        EmptyBorder emptyBorder = new EmptyBorder(12, 12, 12, 12);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.anchor = 10;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        GridBagConstraints gridBagConstraints4 = GridBagControl.getDefaultConstraints();
        gridBagConstraints4.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        gridBagControl.addVerticalSpace();
        String string3 = null;
        if (JExpressInstaller.getInstaller().isServlet()) {
            string3 = string2;
        }
        if (string3 == null || string3.length() <= 0) {
            string3 = string;
        }
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(new Font("Bold", 1, 12));
        gridBagControl.addCentered(jLabel);
        gridBagControl.endRow();
        gridBagControl.addVerticalSpace();
        this.dirname = new JTextField();
        this.dirname.setToolTipText(string2);
        this.dirname.setEditable(true);
        gridBagControl.add(gridBagConstraints3, this.dirname);
        this.browseButton = new JButton(this.getLocalizedString("BrowseButton"));
        gridBagControl.endRow(gridBagConstraints4, this.browseButton);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        DirectoryPanel directoryPanel = this;
        if (directoryPanel == null) {
            throw null;
        }
        Action action = directoryPanel.new Action();
        this.browseButton.addActionListener(action);
        this.winOS = new WindowsOS();
        WindowsOS.clearError();
    }

    public void setActive(boolean bl) {
        if (bl) {
            Object object;
            this.getNextButton().setEnabled(false);
            this.silentInstall = this.getPropertyList().getBooleanProperty("silentInstall", false);
            boolean bl2 = true;
            String string = CustomInstaller.getLanguage();
            if (string.equals(Locale.JAPANESE.getLanguage())) {
                object = new File(JRE.getActiveJavaHome() + "lib", "font.properties." + Locale.JAPANESE.getLanguage());
                bl2 = ((File)object).exists();
            }
            if (((String)(object = System.getProperty("java.version"))).compareTo("1.1.6") < 0 || OS.isNetware() || !bl2) {
                this.browseButton.setEnabled(false);
            }
            this.resetDir();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOk() {
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl = false;
        boolean bl2 = true;
        File file = new File(this.dirname.getText());
        if (OS.isWindows() && !this.silentInstall) {
            object2 = this.dirname.getText();
            if (object2 != null && ((String)object2).length() >= 3) {
                objectArray = ":";
                object = File.separator;
                if (!objectArray.equals(((String)object2).substring(1, 2)) || !((String)object).equals(((String)object2).substring(2, 3))) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            if (!bl2) {
                if (this.silentInstall) {
                    objectArray = this.getLocalizedString("InvalidWinDirName") + " " + this.getLocalizedString("NeedValidWinDirName");
                    JExpressInstaller.getInstaller().logError((String)objectArray);
                } else {
                    objectArray = new Object[]{this.getLocalizedString("InvalidWinDirName"), this.getLocalizedString("NeedValidWinDirName")};
                    UiUtilities.note(objectArray, this.getLocalizedString("Ok"));
                }
            }
        }
        if (bl2) {
            if (file.exists()) {
                if (this.silentInstall) {
                    bl = true;
                } else {
                    object2 = new Object[]{file.getPath() + " " + this.getLocalizedString("DirectoryExists")};
                    bl = UiUtilities.ask(object2, this.getLocalizedString("Question"), this.getLocalizedString("Yes"), this.getLocalizedString("No"));
                }
            } else {
                file.mkdirs();
                object2 = new File(file.getPath());
                if (!((File)object2).exists()) {
                    bl = false;
                    if (!this.silentInstall) {
                        objectArray = new Object[]{this.getLocalizedString("UnableToCreate") + " " + file.getPath()};
                        UiUtilities.note(objectArray, this.getLocalizedString("Ok"));
                    } else {
                        this.getErrorLog().write(this.getLocalizedString("UnableToCreate") + " " + file.getPath());
                    }
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            block27: {
                object2 = new File(file, "zosJexTemp");
                ((File)object2).mkdirs();
                objectArray = new File(((File)object2).getPath());
                if (objectArray.exists()) {
                    objectArray.delete();
                    object2 = new File(file, "zosJexTemp");
                    try {
                        ((File)object2).delete();
                        boolean bl3 = bl = !((File)object2).exists();
                        if (!bl) break block27;
                        object = new FileOutputStream((File)object2);
                        ((FileOutputStream)object).write(190);
                        ((FileOutputStream)object).close();
                        bl = ((File)object2).exists();
                        if (bl) {
                            ((File)object2).delete();
                            bl = !((File)object2).exists();
                        }
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                if (!this.silentInstall) {
                    UiUtilities.note(this.getLocalizedString("WriteProtected"), this.getLocalizedString("Ok"));
                } else {
                    JExpressInstaller.getInstaller().logError(this.getLocalizedString("WriteProtected"));
                }
            }
        }
        if (bl) {
            this.getPropertyList().setProperty("applicationDirectory", file.getPath());
            if (!JExpressInstaller.getInstaller().isServlet()) return bl;
            this.getPropertyList().setProperty("applicationDirectory" + this.name, file.getPath());
            return bl;
        }
        if (!this.silentInstall) return bl;
        JExpressInstaller.getInstaller().exit();
        return bl;
    }

    public String getNextButtonLabel() {
        String string = JExpressInstaller.getInstaller().showInstallButton() ? this.getLocalizedString("InstallButton") : this.getLocalizedString("NextButton");
        if (JExpressInstaller.getInstaller().isServlet() && this.name != null) {
            FileGroupsListEditor fileGroupsListEditor = new FileGroupsListEditor(new ListEditor());
            fileGroupsListEditor.fromString(this.getPropertyList().getProperty("fileGroupsTypes", ""));
            String string2 = "";
            Enumeration enumeration = fileGroupsListEditor.getItems().elements();
            while (enumeration.hasMoreElements()) {
                FileGroup fileGroup = (FileGroup)enumeration.nextElement();
                string2 = fileGroup.getName();
            }
            string = this.name.equals(string2) && JExpressInstaller.getInstaller().showInstallButton() ? this.getLocalizedString("InstallButton") : this.getLocalizedString("NextButton");
        }
        return string;
    }

    void browseButton_Clicked(ActionEvent actionEvent) {
        this.browse();
    }

    void resetDir() {
        Object object;
        String string = JExpressInstaller.getInstaller().isServlet() ? this.getPropertyList().getProperty("applicationDirectory" + this.name) : this.getPropertyList().getProperty("applicationDirectory");
        if (string == null) {
            string = this.getPropertyList().getProperty("oldApplicationDirectory");
        }
        if (string == null) {
            object = this.getPropertyList().getProperty("defaultApplicationDirectory");
            string = this.getDirPath((String)object);
        }
        if (string == null) {
            object = this.getPropertyList().getProperty("safePackageName");
            string = this.getDirPath((String)object);
        }
        if (string == null) {
            object = new File(System.getProperty("user.home"), "lib");
            string = ((File)object).getPath();
        }
        if (string == null) {
            object = new File(System.getProperty("user.dir"), "lib");
            string = ((File)object).getPath();
        }
        if (string != null) {
            if (JExpressInstaller.getInstaller().isServlet()) {
                string = string + File.separator + this.name;
            }
            this.defaultDirectory = object = new File(string);
            UiUtilities.update((Component)this.dirname, (Object)((File)object).getPath());
        }
        this.getNextButton().setEnabled(true);
        this.getNextButton().requestFocus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getDirPath(String object) {
        File file;
        String string;
        block22: {
            Object object2;
            block23: {
                string = null;
                if (object == null) return string;
                if (((String)object).length() <= 0) return string;
                boolean bl = false;
                String string2 = ":";
                file = null;
                object = ((String)object).replace('/', File.separatorChar);
                if (((String)(object = ((String)object).replace('\\', File.separatorChar))).length() >= 2 && ":".equals(((String)object).substring(1, 2))) {
                    if (this.isWindows()) {
                        if (((String)object).length() >= 3 && !File.separator.equals(((String)object).substring(2, 3))) {
                            object = object2 = ((String)object).substring(0, 2) + File.separator + ((String)object).substring(2);
                        } else if (((String)object).length() == 2) {
                            object = (String)object + File.separator;
                        }
                        bl = true;
                        file = new File((String)object);
                    } else {
                        object = ((String)object).length() > 3 ? ((String)object).substring(2) : "";
                    }
                }
                if (bl) break block22;
                if (!((String)object).startsWith(File.separator)) break block23;
                if (OS.isWindows()) {
                    String string3;
                    object2 = new File(System.getProperty("user.dir"));
                    try {
                        string3 = ((File)object2).getCanonicalPath();
                    }
                    catch (Exception exception) {
                        string3 = ((File)object2).getAbsolutePath();
                    }
                    if (string3.length() >= 2 && ":".equals(string3.substring(1, 2))) {
                        object = string3.substring(0, 2) + (String)object;
                    }
                    file = new File((String)object);
                    break block22;
                } else {
                    file = new File((String)object);
                }
                break block22;
            }
            if (OS.isWindows() || OS.isWindowsNT()) {
                String string4;
                String string5 = null;
                try {
                    string5 = this.winOS.programManagerDirectory();
                }
                catch (Exception exception) {
                }
                if (string5 == null || string5.length() <= 0) {
                    string5 = "C:\\Program Files";
                    JExpressInstaller.getInstaller().logToInstaller("trying standard program files directory " + string5);
                }
                if ((string4 = this.dirNameOk(string5, (String)object)) == null) {
                    string4 = System.getProperty("user.home", File.separator);
                }
                if (string4 == null) {
                    string4 = System.getProperty("user.dir", File.separator);
                }
                object2 = new File(string5);
            } else if (OS.isUnix()) {
                String string6 = this.getUnixInstallDir((String)object);
                if (string6 == null) {
                    string6 = System.getProperty("user.home", File.separator);
                }
                if (string6 == null) {
                    string6 = System.getProperty("user.dir", File.separator);
                }
                object2 = new File(string6);
            } else {
                String string7 = System.getProperty("user.dir", File.separator);
                object2 = new File(string7);
            }
            file = new File((File)object2, (String)object);
        }
        if (file == null) return string;
        if (!file.exists()) return file.getPath();
        if (!file.isDirectory()) return string;
        return file.getPath();
    }

    String getUnixInstallDir(String string) {
        String string2;
        String string3 = "/bin";
        String string4 = "/sbin";
        String string5 = "/usr";
        String string6 = null;
        if (string6 == null) {
            string6 = this.dirNameOk("/bin", string);
        }
        if (string6 == null) {
            string6 = this.dirNameOk("/sbin", string);
        }
        if (string6 == null) {
            string6 = this.dirNameOk("/usr", string);
        }
        if (string6 == null && (string2 = System.getProperty("user.home")) != null && string2.length() > 0) {
            string6 = this.dirNameOk(string2, string);
        }
        return string6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String dirNameOk(File file, String string) {
        String string2;
        try {
            string2 = file.getCanonicalPath();
            return this.dirNameOk(string2, string);
        }
        catch (Exception exception) {
            string2 = file.getAbsolutePath();
        }
        return this.dirNameOk(string2, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String dirNameOk(String string, String string2) {
        String string3 = null;
        File file = new File(string, string2);
        boolean bl = file.mkdirs();
        file = new File(string, string2);
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, "zosJexTest");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.close();
                file2.delete();
                string3 = string;
            }
            catch (Exception exception) {
            }
            if (bl) {
                file.delete();
            }
        }
        return string3;
    }

    void browse() {
        DirectorySelectionDialog directorySelectionDialog = new DirectorySelectionDialog(this);
        FileSelectionDialog.setDefaultDirectory(this.defaultDirectory);
        directorySelectionDialog.setPrompt(this.getLocalizedString("SelectDir"));
        directorySelectionDialog.show();
        File file = directorySelectionDialog.getSelection();
        if (file != null) {
            UiUtilities.update((Component)this.dirname, (Object)file.getPath());
            this.defaultDirectory = file;
        }
    }

    private String getLocalizedString(String string) {
        return JExpressInstaller.getInstaller().getLocalizedString(string);
    }

    public String getName() {
        String string = "DirectoryPanel";
        if (this.name != null && JExpressInstaller.getInstaller().isServlet()) {
            string = string + this.name;
        }
        return string;
    }

    public DirectoryPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.initialize(this.getLocalizedString("InstallDir"), this.getLocalizedString("DirToolTip"));
    }

    public DirectoryPanel(PropertyList propertyList, Log log, String string, String string2) {
        super(propertyList, log);
        this.initialize(string, string2);
    }

    class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == DirectoryPanel.this.browseButton) {
                DirectoryPanel.this.browseButton_Clicked(actionEvent);
            }
        }

        Action() {
        }
    }
}

