/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.JExpressConstants;
import com.denova.JExpress.Updater.UpdatePropertyNames;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.UiUtilities;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CustomerUpdatePanel
extends WizardPanel
implements InstallPropertyNames,
UpdatePropertyNames,
JExpressConstants {
    JTextField userName;
    JTextField userId;
    JTextField serialNumber;
    JLabel hint;
    PropertyList properties;
    String programDir;
    String updatePropertiesName;

    public void setActive(boolean bl) {
        if (!bl) {
            this.programDir = this.getPropertyList().getProperty("applicationDirectory", "");
            if (this.programDir != null && this.isOk()) {
                this.properties = new PropertyList();
                if (this.loadPropertyList()) {
                    this.properties.setProperty("licenseeName", this.userName.getText());
                    this.properties.setProperty("userName", this.userId.getText());
                    this.properties.setProperty("password", this.serialNumber.getText());
                    this.savePropertyList();
                }
            }
        }
    }

    public boolean isOk() {
        boolean bl = false;
        if (this.userName != null && this.userId != null && this.serialNumber != null && this.userName.getText().length() > 0 && this.userId.getText().length() > 0 && this.serialNumber.getText().length() > 0) {
            if (this.serialNumber.getText().length() >= 8) {
                bl = true;
            } else {
                UiUtilities.note("Invalid user id and/or serial number.", JExpressInstaller.getInstaller().getLocalizedString("Ok"));
            }
        } else {
            String[] stringArray = new String[]{"Enter your name and the user id/password", "issued to you when you purchased JExpress."};
            UiUtilities.note(stringArray, JExpressInstaller.getInstaller().getLocalizedString("Ok"));
        }
        return bl;
    }

    public boolean isPreviousButtonEnabled() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadPropertyList() {
        boolean bl = true;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.updatePropertiesFilename());
            if (fileInputStream == null) return false;
            this.properties.load(fileInputStream);
            fileInputStream.close();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean savePropertyList() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.updatePropertiesFilename());
            this.properties.save(fileOutputStream, "JExpress Update Properties");
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String updatePropertiesFilename() {
        if (this.updatePropertiesName == null || this.updatePropertiesName.length() <= 0) {
            this.updatePropertiesName = this.programDir + File.separatorChar + "JExpress" + File.separatorChar + "update.control";
        }
        return this.updatePropertiesName;
    }

    public CustomerUpdatePanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        int n = 20;
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        gridBagControl.addVerticalSpace();
        JLabel jLabel = new JLabel("Update On Demand Configuration");
        jLabel.setFont(new Font("Bold", 1, 12));
        gridBagControl.endRow(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, new JLabel("Licensee name:"));
        this.userName = new JTextField();
        this.userName.setToolTipText("Your first and last name");
        this.userName.setEditable(true);
        gridBagControl.add(gridBagConstraints2, this.userName);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, new JLabel("User id:"));
        this.userId = new JTextField();
        this.userId.setToolTipText("ID supplied to you when you purchased JExpress");
        this.userId.setEditable(true);
        gridBagControl.add(gridBagConstraints2, this.userId);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints, new JLabel("Serial number:"));
        this.serialNumber = new JTextField();
        this.serialNumber.setToolTipText("Serial number, same as password, supplied to you when you purchased JExpress");
        this.serialNumber.setEditable(true);
        gridBagControl.add(gridBagConstraints2, this.serialNumber);
        gridBagControl.addVerticalSpace();
        this.hint = new JLabel("Please fill in all fields");
        gridBagControl.addCentered(this.hint);
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
    }
}

