/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Installer;

import com.denova.JExpress.Installer.InstallPropertyNames;
import com.denova.JExpress.Installer.InstallerConstants;
import com.denova.JExpress.Installer.JExpressInstaller;
import com.denova.JExpress.Installer.StartAppPatcher;
import com.denova.JExpress.JExpressConstants;
import com.denova.JExpress.Updater.UpdatePropertyNames;
import com.denova.io.FileSystem;
import com.denova.io.JarFile;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.lang.LangUtilities;
import com.denova.runtime.Exec;
import com.denova.runtime.JRE;
import com.denova.runtime.OS;
import com.denova.runtime.WindowsOS;
import com.denova.util.PropertyList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;

public class CustomMenuInstaller
implements JExpressConstants,
InstallerConstants,
InstallPropertyNames,
UpdatePropertyNames {
    final String ClassExtension = ".class";
    final String AppDirVariable = "[$AppDir]";
    final String JavaHomeVariable = "[$JavaHomeDir]";
    final String Quote = "\"";
    PropertyList updateProperties = null;
    JExpressInstaller installer;
    Log log;
    Log errorLog;
    WindowsOS windowsOS;
    boolean updaterInstalled = false;

    public boolean addMenus() {
        boolean bl = this.okToAddMenus();
        if (bl) {
            this.addItems();
        }
        this.log.stopLogging();
        return bl;
    }

    void addItems() {
        if (this.needUpdater()) {
            this.installUpdater();
        }
        boolean bl = false;
        String string = this.getApplicationDirectory();
        String string2 = this.installer.getProperty("packageName", "Java applications");
        String string3 = this.getCommandPrefix(string, this.getClasspath(), false);
        String string4 = this.getCommandPrefix(string, this.getClasspath(), true);
        String string5 = string3;
        PropertyList propertyList = this.getPropertyList().getPropertyListProperty("menus");
        Enumeration<?> enumeration = propertyList.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            String string7 = propertyList.getProperty(string6);
            if (string7 != null) {
                String string8;
                Object object;
                PropertyList propertyList2 = new PropertyList();
                propertyList2.fromString(string7);
                String string9 = propertyList2.getProperty("longName");
                String string10 = propertyList2.getProperty("shortName");
                boolean bl2 = this.getUseJavaCommandPrefix(propertyList2);
                boolean bl3 = this.getUseJavaConsole(propertyList2);
                boolean bl4 = this.getUseSwing(propertyList2);
                String string11 = this.getExecutableFile(propertyList2);
                String string12 = this.getCommandLineArguments(propertyList2);
                String string13 = propertyList2.getProperty("iconFilename");
                if (this.needUpdater()) {
                    this.saveUpdaterMenuSettings(bl3, bl4);
                    if (this.installer.getPropertyList().getBooleanProperty("autoupdateEveryStartup") && bl2) {
                        bl4 = true;
                    }
                }
                string5 = bl3 ? string4 : string3;
                if (string13 != null && string13.length() > 0) {
                    string13 = string13.replace('/', File.separatorChar);
                    string13 = string13.replace('\\', File.separatorChar);
                    object = new File(string13);
                    string8 = string + File.separator + ((File)object).getName();
                } else {
                    string8 = "";
                }
                object = string;
                if (string11 != null) {
                    string11 = string11.replace('/', File.separatorChar);
                    string11 = string11.replace('\\', File.separatorChar);
                    String string14 = propertyList2.getProperty("executableFile", "");
                    string14 = string14.replace('/', File.separatorChar);
                    if ((string14 = string14.replace('\\', File.separatorChar)).indexOf(58) == 1 || string14.indexOf(File.separatorChar) == 0) {
                        object = "";
                        this.log.write("executableFile contains the full path " + string14);
                    } else {
                        int n = string14.lastIndexOf(File.separator);
                        if (n != -1) {
                            String string15 = string14.substring(0, n);
                            object = string + File.separator + string15;
                            n = string11.lastIndexOf(File.separator);
                            if (n != -1) {
                                string11 = string11.substring(n + 1);
                            }
                        }
                    }
                }
                this.log.write("add menu item " + string2);
                this.addMenuItem(string2, string5, string, (String)object, string9, string10, bl2, bl3, bl4, string11, string12, "", string8);
            }
            Thread.yield();
        }
        if (this.needUpdater()) {
            this.createUpdateOnDemandMenu(string2);
        }
    }

    boolean okToAddMenus() {
        boolean bl = true;
        if (this.needUpdater() && !(bl = this.installer.extractFile(this.getUpdaterJarFilename()))) {
            JExpressInstaller.getInstaller().logError("unable to extract " + this.getUpdaterJarFilename());
        }
        if (bl && OS.isWindows()) {
            this.windowsOS = new WindowsOS();
            File file = TempFiles.getFile("WinCmds.exe");
            boolean bl2 = bl = this.installer.extractFile(file.getPath()) || file.exists();
            if (!bl) {
                JExpressInstaller.getInstaller().logError("unable to extract " + file.getPath());
            }
        }
        return bl;
    }

    void addMenuItem(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, String string7, String string8, String string9, String string10) {
        int n;
        Object object;
        if (string8 != null) {
            String string11;
            int n2;
            while (string8.indexOf("[$AppDir]") != -1) {
                n2 = string8.indexOf("[$AppDir]");
                string8 = string11 = string8.substring(0, n2) + string4 + string8.substring(n2 + "[$AppDir]".length());
            }
            while (string8.indexOf("[$JavaHomeDir]") != -1) {
                n2 = string8.indexOf("[$JavaHomeDir]");
                string11 = JRE.getJavaHome();
                if (string11.endsWith(File.separator)) {
                    int n3 = string11.lastIndexOf(File.separator);
                    string11 = string11.substring(0, n3);
                }
                object = string8.substring(0, n2) + string11 + string8.substring(n2 + "[$JavaHomeDir]".length());
                string8 = object;
            }
            string8 = string8.replace('\\', File.separatorChar);
        }
        if (bl && string7 != null && string7.indexOf(".class") != -1) {
            String string12 = string2.toLowerCase();
            int n4 = string12.indexOf("jre");
            if (n4 < 0) {
                n4 = string12.indexOf("java");
            }
            if (n4 >= 0) {
                n4 = string7.lastIndexOf(".class");
                string7 = string7.substring(0, n4);
            }
        }
        if ((n = string2.indexOf("-cp \".\" ")) != -1 && !bl3) {
            boolean bl4 = true;
            object = JRE.adjustJreClasspath(string2, string4, true, bl3);
            if (object != null && ((String)object).length() > 0) {
                string2 = object;
            }
        }
        if (!string2.endsWith(" ")) {
            string2 = string2 + " ";
        }
        string = string.trim();
        string3 = string3.trim();
        string4 = string4.trim();
        string5 = string5.trim();
        string6 = string6.trim();
        string10 = string10.trim();
        string10 = string10.replace('/', File.separatorChar);
        string10 = string10.replace('\\', File.separatorChar);
        string7 = string7.trim();
        string7 = string7.replace('/', File.separatorChar);
        string7 = string7.replace('\\', File.separatorChar);
        string8 = string8.trim();
        this.log.write("OS name is " + System.getProperty("os.name"));
        this.log.write("Menu item long name is " + string5);
        this.log.write("Menu item short name is " + string6);
        if (OS.isWindows() && string5.length() > 0) {
            File file;
            if (string10 != null && string10.length() > 0 && !(file = new File(string10)).exists()) {
                object = new File(string4);
                this.extractIconFile(file, (File)object);
                file = new File(string10);
                if (!file.exists()) {
                    string10 = "";
                }
            }
            this.addWindowsMenuItem(string, string2, string3, string4, string5, bl, bl2, bl3, string7, string8, string10);
        }
        if (OS.isUnix() && string6.length() > 0) {
            this.addLaunchScript(string, string2, string4, string5, string6, bl, bl2, bl3, string7, string8);
        }
        if (!OS.isUnix() && !OS.isWindows()) {
            this.log.write("OS isn't Windows or Unix");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addWindowsMenuItem(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, String string6, String string7, String string8) {
        boolean bl4 = true;
        this.log.write("    menu name " + string5);
        this.log.write("  install dir " + string3);
        this.log.write("    start dir " + string4);
        this.log.write("     use Java " + String.valueOf(bl));
        this.log.write("  use console " + String.valueOf(bl2));
        this.log.write("    use Swing " + String.valueOf(bl3));
        this.log.write("   cmd prefix " + string2);
        this.log.write("   executable " + string6);
        this.log.write("     cmd args " + string7);
        this.log.write("    icon file " + string8);
        File file = null;
        try {
            file = TempFiles.getFile("startapp.exe");
            if (file != null && !file.exists() && !LangUtilities.getResourceAsFile(file.getPath())) {
                file = null;
            }
        }
        catch (Exception exception) {
            this.log.write("using old style menus because " + "startapp.exe" + " doesn't exist ");
        }
        if (bl && file != null && file.exists()) {
            String string9 = string5;
            int n = string9.indexOf(" ");
            while (n > -1) {
                string9 = string9.substring(0, n) + string9.substring(n + 1);
                n = string9.indexOf(" ");
            }
            try {
                String string10;
                boolean bl5 = true;
                File file2 = new File(string3, string9 + ".exe");
                String string11 = file2.getPath();
                int n2 = 120;
                String string12 = string11 + " " + string7;
                if (string12.length() <= 120) {
                    string12 = string7;
                    string10 = "";
                } else {
                    string12 = "";
                    string10 = string7;
                }
                FileSystem.copyFile(file, file2);
                String string13 = this.createPropertiesFile(string2, string3, string4, string5, bl, bl2, bl3, string6, string10, string9);
                if (string13 != null) {
                    this.log.write("    creating the launcher " + string13);
                    new StartAppPatcher(this.errorLog, string11, string13);
                } else {
                    this.log.write("    unable to create launcher");
                    bl5 = false;
                }
                if (bl5) {
                    this.log.write("  menu folder " + string);
                    this.log.write("    menu item " + string5);
                    this.log.write("  install dir " + string3);
                    this.log.write("   executable " + file2.getName());
                    this.log.write("    icon file " + string8);
                    this.windowsOS.addMenuItem(string, string5, string3, file2.getName(), string12, "", string8);
                    return;
                }
            }
            catch (Exception exception) {
            }
        }
        if (!bl4) return;
        boolean bl6 = this.windowsOS.addMenuItem(string, string5, string4, bl, bl2, bl3, string2, string6, string7, "", string8);
        if (bl6) return;
        this.log.write(WindowsOS.getLastError());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String createPropertiesFile(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, String string5, String string6, String string7) {
        String string8 = this.windowsOS.getExecutable(string3, bl, bl2, bl3, string, string5);
        String string9 = this.windowsOS.getArguments(string3, bl, bl2, bl3, string, string5, string6);
        int n = string5.indexOf(32);
        if (n != -1 && !string5.startsWith("\"")) {
            string5 = "\"" + string5 + "\"";
        }
        this.log.write(" product name " + string4);
        this.log.write("   executable " + string8);
        this.log.write("     cmd args " + string9);
        PropertyList propertyList = new PropertyList();
        propertyList.setProperty("programName", string4);
        propertyList.setProperty("execFilename", string8);
        propertyList.setProperty("args", string9);
        propertyList.setProperty("startDir", string3);
        File file = new File(string2, "JExpress");
        file.mkdirs();
        String string10 = "JExpress" + File.separator + string7 + ".properties";
        file = new File(string2, string10);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            propertyList.save(fileOutputStream, "Menu for " + string4);
            fileOutputStream.close();
            return string10;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean extractIconFile(File file, File file2) {
        JarFile jarFile = null;
        boolean bl = true;
        String string = this.installer.getProperty("safePackageName") + "Jex" + "." + "jar";
        try {
            jarFile = new JarFile(file2, string);
            jarFile.unarchiveFileToDirectory(file.getName(), file2);
            jarFile.close();
            jarFile = null;
            this.log.write(file.getName() + " extracted from " + string + " to " + file2);
        }
        catch (Exception exception) {
            if (this.installer.getResourceAsFile(file.getName(), file2.getPath())) {
                this.log.write(file.getName() + " extracted from resources to " + file2);
            }
            String string2 = "Unable to extract " + file.getName() + " from " + string;
            bl = false;
        }
        if (jarFile == null) return bl;
        try {
            jarFile.close();
            return bl;
        }
        catch (Exception exception) {
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addLaunchScript(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3, String string6, String string7) {
        int n;
        if (bl) {
            string6 = string2 + string6;
        }
        if ((n = string6.indexOf(32)) != -1 && !string6.startsWith("\"")) {
            string6 = "\"" + string6 + "\"";
        }
        String string8 = string6 + " " + string7;
        string8 = JRE.adjustJreClasspath(string8, string3, false, bl3) + " $*";
        this.log.write("    menu name " + string5);
        this.log.write("    start dir " + string3);
        this.log.write("     use Java " + String.valueOf(bl));
        this.log.write("  use console " + String.valueOf(bl2));
        this.log.write("    use Swing " + String.valueOf(bl3));
        this.log.write("   cmd prefix " + string2);
        this.log.write("   executable " + string6);
        this.log.write("     cmd args " + string7);
        this.log.write("      command " + string8);
        int n2 = 100;
        int n3 = 0;
        File file = new File(string3, string5);
        while (file.exists() && file.isDirectory() && n3 < 100) {
            file = new File(string3, string5 + String.valueOf(n3));
            ++n3;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("cd " + string3);
            printWriter.println(string8);
            printWriter.close();
            fileOutputStream.close();
            Exec.runCommand("chmod 0744 " + file.getPath());
            return;
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to create script", exception);
        }
    }

    boolean needUpdater() {
        return !this.installer.getPropertyList().getBooleanProperty("autoupdateNever");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createUpdateOnDemandMenu(String string) {
        if (this.installer.getPropertyList().getBooleanProperty("autoupdateOnDemand")) {
            String string2 = this.getApplicationDirectory();
            String string3 = this.getCommandPrefix(string2, this.getUpdaterClasspath());
            File file = new File(string2, "JExpress");
            file.mkdirs();
            try {
                JarFile jarFile = new JarFile(file, "JExpressUpdater" + "." + "jar");
                jarFile.unarchiveFileToDirectory("jexupd.ico", file);
                jarFile.close();
            }
            catch (Exception exception) {
                this.log.write("unable to get icon file " + "jexupd.ico" + " from " + file.getPath() + "JExpressUpdater" + "." + "jar");
            }
            this.addMenuItem(string, string3, string2, string2, "Update " + string, "update", true, false, true, "com.denova.JExpress.Updater.JUpdate", this.getUpdateOnDemandCommandLineArguments(), "", file + File.separator + "jexupd.ico");
        }
    }

    void saveUpdaterMenuSettings(boolean bl, boolean bl2) {
        File file = this.getUpdaterDir();
        if (this.updateProperties == null) {
            this.updateProperties = new PropertyList();
        }
        if (this.loadUpdatePropertyList(file)) {
            this.updateProperties.setBooleanProperty("useJavaConsole", bl);
            this.updateProperties.setBooleanProperty("useSwing", bl2);
            this.saveUpdatePropertyList(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void installUpdater() {
        if (!this.updaterInstalled) {
            try {
                File file = TempFiles.getFile(this.getUpdaterJarFilename());
                File file2 = this.getUpdaterDir();
                file2.mkdirs();
                FileSystem.copyFile(file.getPath(), file2.getPath());
                this.updateProperties = new PropertyList();
                if (!this.loadUpdatePropertyList(file2)) {
                    this.updateProperties.setProperty("userName", "");
                    this.updateProperties.setProperty("password", "");
                }
                File file3 = new File(this.installer.getPropertyList().getProperty("installImageFilename", "jexupd.jpg"));
                this.updateProperties.setProperty("packageName", this.installer.getPropertyList().getProperty("packageName"));
                this.updateProperties.setProperty("updateImageFilename", file3.getName());
                this.updateProperties.setProperty("updateImagePosition", this.installer.getPropertyList().getProperty("installImagePosition", "North"));
                this.updateProperties.setProperty("updateButtonsPosition", this.installer.getPropertyList().getProperty("installButtonsPosition", "South"));
                this.updateProperties.setBooleanProperty("nativeLookAndFeel", this.installer.getPropertyList().getBooleanProperty("nativeLookAndFeel", true));
                this.updateProperties.setBooleanProperty("metalLookAndFeel", this.installer.getPropertyList().getBooleanProperty("metalLookAndFeel", false));
                this.updateProperties.setProperty("jvmParameters", this.installer.getPropertyList().getProperty("installJvmParameters", ""));
                this.updateProperties.setProperty("userClasspath", this.installer.getPropertyList().getProperty("installUserClasspath", ""));
                this.updateProperties.setProperty("customBeforeUpdate", this.installer.getPropertyList().getProperty("customBeforeUpdate", ""));
                this.updateProperties.setProperty("customAfterGetFileList", this.installer.getPropertyList().getProperty("customAfterGetFileList", ""));
                this.updateProperties.setProperty("customAfterFilesCompared", this.installer.getPropertyList().getProperty("customAfterFilesCompared", ""));
                this.updateProperties.setProperty("customAfterFilesDownloaded", this.installer.getPropertyList().getProperty("customAfterFilesDownloaded", ""));
                this.updateProperties.setProperty("customAfterUpdate", this.installer.getPropertyList().getProperty("customAfterUpdate", ""));
                this.updateProperties.setProperty("textFileExtensions", this.installer.getPropertyList().getProperty("textFileExtensions", ""));
                this.saveUpdatePropertyList(file2);
            }
            catch (Exception exception) {
                this.installer.logException(this, "Unable to install auto-update.", exception);
            }
            this.updaterInstalled = true;
        }
    }

    private boolean loadUpdatePropertyList() {
        boolean bl = this.loadUpdatePropertyList(this.getUpdaterDir());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadUpdatePropertyList(File file) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.updatePropertiesFilename(file));
            if (fileInputStream == null) return bl;
            this.updateProperties.load(fileInputStream);
            fileInputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean saveUpdatePropertyList() {
        boolean bl = this.saveUpdatePropertyList(this.getUpdaterDir());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveUpdatePropertyList(File file) {
        boolean bl = false;
        String string = this.updatePropertiesFilename(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.updateProperties.save(fileOutputStream, "JExpress Update Properties");
            fileOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            bl = false;
            this.log.write("unable to save update properties " + string);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getUpdaterDir() {
        File file = null;
        try {
            return new File(this.getApplicationDirectory(), "JExpress");
        }
        catch (Exception exception) {
            this.installer.logException(this, "Unable to install auto-update.", exception);
        }
        return file;
    }

    private String updatePropertiesFilename(File file) {
        File file2 = new File(file, "update.control");
        return file2.getPath();
    }

    private String getCommandPrefix(String string, String string2) {
        boolean bl = false;
        return this.getCommandPrefix(string, string2, false);
    }

    private String getCommandPrefix(String string, String string2, boolean bl) {
        String string3;
        String string4 = this.installer.getProperty("jvmCommandName", "");
        String string5 = JRE.getJavaHome();
        if (!string5.endsWith(File.separator)) {
            string5 = string5 + File.separator;
        }
        this.log.write("jvm command name is " + string4);
        this.log.write("javaHome is " + string5);
        String string6 = JRE.getNativeExecutable(string4, bl);
        this.log.write("executable is " + string6);
        if (OS.isWindows() && (string3 = this.windowsOS.getAncientShortPath(string6)) != null && string3.length() > 0) {
            string6 = string3;
        }
        if ((string3 = this.installer.getProperty("installJvmParameters", "")).length() > 0) {
            String string7;
            int n;
            if (!string3.endsWith(" ")) {
                string3 = string3 + " ";
            }
            while (string3.indexOf("[$AppDir]") != -1) {
                n = string3.indexOf("[$AppDir]");
                string3 = string7 = string3.substring(0, n) + string + string3.substring(n + "[$AppDir]".length());
            }
            while (string3.indexOf("[$JavaHomeDir]") != -1) {
                n = string3.indexOf("[$JavaHomeDir]");
                if (string5.endsWith(File.separator)) {
                    int n2 = string5.lastIndexOf(File.separator);
                    string5 = string5.substring(0, n2);
                }
                string3 = string7 = string3.substring(0, n) + string5 + string3.substring(n + "[$JavaHomeDir]".length());
            }
        }
        return "\"" + string6 + "\" " + string3 + "-cp \"" + string2 + "\" ";
    }

    String getClasspath() {
        String string;
        if (this.installer.getPropertyList().getBooleanProperty("autoupdateEveryStartup")) {
            string = this.getUpdaterClasspath();
            this.log.write("classpath with auto-update is " + string);
        } else {
            string = this.installer.getUserClasspath();
            this.log.write("classpath is " + string);
        }
        return string;
    }

    String getUpdaterClasspath() {
        return "." + File.separator + "JExpress" + File.separator + this.getUpdaterJarFilename();
    }

    String getCurrentDir() {
        String string = this.getApplicationDirectory();
        if (OS.isWindows()) {
            string = this.windowsOS.getAncientShortPath(string);
        }
        if (string.indexOf(" ") != -1) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    boolean getUseJavaCommandPrefix(PropertyList propertyList) {
        boolean bl = propertyList.getBooleanProperty("useJavaCommandPrefix");
        return bl;
    }

    boolean getUseJavaConsole(PropertyList propertyList) {
        boolean bl = propertyList.getBooleanProperty("useJavaConsole", false);
        return bl;
    }

    boolean getUseSwing(PropertyList propertyList) {
        boolean bl = propertyList.getBooleanProperty("useSwing", true);
        return bl;
    }

    boolean autoupdateEveryStartup(PropertyList propertyList) {
        return this.installer.getPropertyList().getBooleanProperty("autoupdateEveryStartup") && this.getUseJavaCommandPrefix(propertyList);
    }

    String getExecutableFile(PropertyList propertyList) {
        String string = this.autoupdateEveryStartup(propertyList) ? "com.denova.JExpress.Updater.JUpdate" : propertyList.getProperty("executableFile");
        return string;
    }

    String getCommandLineArguments(PropertyList propertyList) {
        String string = this.autoupdateEveryStartup(propertyList) ? this.getUpdateEveryStartupCommandLineArguments(propertyList) : propertyList.getProperty("commandLineArguments");
        return string;
    }

    String getUpdateOnDemandCommandLineArguments() {
        String string = this.installer.getProperty("downloadUrl");
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + "updates";
        return this.getCurrentDir() + " " + "\"" + string + "\"";
    }

    String getUpdateEveryStartupCommandLineArguments(PropertyList propertyList) {
        return this.getUpdateOnDemandCommandLineArguments() + " " + "\"" + propertyList.getProperty("executableFile") + "\"" + " " + "\"" + propertyList.getProperty("commandLineArguments") + "\"";
    }

    String getUpdaterJarFilename() {
        return "JExpressUpdater" + "." + "jar";
    }

    String getApplicationDirectory() {
        return this.installer.getProperty("applicationDirectory");
    }

    PropertyList getPropertyList() {
        return this.installer.getPropertyList();
    }

    CustomMenuInstaller(JExpressInstaller jExpressInstaller, Log log) {
        this.installer = jExpressInstaller;
        this.errorLog = log;
        this.log = new Log("menus");
    }
}

