/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.runtime.WindowsOS;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class PicardDirectoryPanel
extends WizardPanel
implements JExpressConstants {
    private static final int cMaxDirLength = 224;
    private JTextField theDirectoryField;
    private JFileChooser theChooser;
    private JButton theBrowseButton;

    public PicardDirectoryPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.anchor = 10;
        GridBagConstraints gridBagConstraints2 = GridBagControl.getDefaultConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        GridBagConstraints gridBagConstraints3 = GridBagControl.getDefaultConstraints();
        gridBagConstraints3.fill = 2;
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.DirectoryPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.DirectoryDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.DirectoryDescriptionMsg02);
        this.theDirectoryField = new JTextField("");
        this.theDirectoryField.setToolTipText(PicardResources.DirectoryFieldHelp);
        this.theDirectoryField.setEditable(true);
        this.theChooser = new JFileChooser();
        this.theBrowseButton = new JButton("Browse ...");
        this.theBrowseButton.addActionListener(new FileSelection());
        this.theChooser.setDialogTitle(PicardResources.DirectoryFileChooserTitle);
        this.theChooser.setDialogType(2);
        this.theChooser.setFileSelectionMode(1);
        this.theChooser.setFileFilter(new DirFileFilter());
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.add(gridBagConstraints2, this.theDirectoryField);
        gridBagControl.add(gridBagConstraints3, this.theBrowseButton);
        gridBagControl.addVerticalSpace();
        gridBagControl.addVerticalSpace();
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            String string;
            if (this.getPropertyList().getProperty("silentInstall", "").equalsIgnoreCase("true")) {
                PicardInstaller.silentConfiguration.load(PicardInstaller.silentConfiguration.getFileName(this.getPropertyList()));
            }
            if (this.isReInstall()) {
                string = this.getPowerChuteUPSMgrDir();
            } else {
                string = PicardInstaller.configuration.getDirectory();
                if (string == null && (string = PicardInstaller.configuration.getDirectory()) == null) {
                    if (this.isLinux() || this.isSolaris()) {
                        string = "/opt/APC/" + PicardResources.DirectoryFieldDefault + "/" + PicardResources.DirectoryFieldAgentDefault;
                    } else if (this.isNetware()) {
                        string = "SYS:\\" + PicardResources.DirectoryFieldDefault + "\\" + PicardResources.DirectoryFieldAgentDefault;
                    } else {
                        WindowsOS windowsOS = new WindowsOS();
                        string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion", "ProgramFilesDir");
                        if (string == null) {
                            string = "C:\\Program Files";
                        }
                        string = string + File.separator + "APC" + File.separator + PicardResources.DirectoryFieldDefault;
                    }
                }
            }
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                string = PicardInstaller.silentConfiguration.getDirectory(string);
            }
            this.theDirectoryField.setText(string);
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                this.showNextPanel();
            }
        } else {
            this.getPropertyList().setProperty("applicationDirectory", this.theDirectoryField.getText());
            PicardInstaller.configuration.setDirectory(this.theDirectoryField.getText());
        }
    }

    public boolean isOk() {
        if (this.theDirectoryField.getText().compareTo("") == 0) {
            this.note(PicardResources.MsgNeedDirectory);
            return false;
        }
        if (this.theDirectoryField.getText().length() > 224) {
            this.note(PicardResources.MsgDirectoryLength);
            return false;
        }
        if (this.NetworkDrive(this.theDirectoryField.getText())) {
            this.note(PicardResources.MsgNetworkDrive);
            return false;
        }
        File file = new File(this.theDirectoryField.getText());
        if (file.exists() && !file.isDirectory()) {
            this.note(PicardResources.MsgInvalidDirectory);
            return false;
        }
        if (file.getParent() == null) {
            this.note(PicardResources.MsgNotRootDirectory);
            return false;
        }
        long l = PicardInstaller.platform.getDiskSpace(this.theDirectoryField.getText()) / 1024L;
        if (l < 7000L) {
            long l2 = 7000L - l;
            this.note(PicardResources.MsgNoDiskSpace + " " + l2 + " " + PicardResources.MsgNoDiskSpaceUnits);
            return false;
        }
        return true;
    }

    public String getName() {
        return "PicardDirectoryPanel";
    }

    private boolean NetworkDrive(String string) {
        if (this.isLinux() || this.isNetware() || this.isSolaris()) {
            return false;
        }
        return ((PicardWindowsPlatform)PicardInstaller.platform).isNetworkDrive(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReInstall() {
        boolean bl = false;
        if (this.isWindows()) {
            WindowsOS windowsOS = new WindowsOS();
            String string = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\PowerChuteUpsManager\\Parameters", "AppDirectory");
            if (string == null) return bl;
            File file = new File(string);
            if (file == null) return bl;
            return file.exists();
        }
        if (this.isNetware()) {
            File file = new File("SYS:\\System\\Autoexec.ncf");
            if (file == null) return bl;
            try {
                FileReader fileReader = new FileReader(file);
                Long l = new Long(file.length());
                if (l.intValue() <= 0) return bl;
                char[] cArray = new char[l.intValue()];
                fileReader.read(cArray, 0, l.intValue());
                String string = new String(cArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    if (bl) {
                        return bl;
                    }
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!string2.endsWith(PicardNetwarePlatform.theStartCommand)) continue;
                    bl = true;
                }
                return bl;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return bl;
            }
            catch (IOException iOException) {
                return bl;
            }
        }
        String string = null;
        if (this.isLinux()) {
            string = "/etc/rc.d/init.d/PBEAgent";
        } else if (this.isSolaris()) {
            string = "/etc/rc2.d/S99PBEAgent";
        }
        File file = new File(string);
        if (file == null) return bl;
        return file.exists();
    }

    private String getPowerChuteUPSMgrDir() {
        String string = null;
        if (this.isWindows()) {
            WindowsOS windowsOS = new WindowsOS();
            String string2 = windowsOS.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\PowerChuteUpsManager\\Parameters", "AppDirectory");
            if (string2 != null) {
                string = string2;
            }
        } else if (this.isNetware()) {
            File file = new File("SYS:\\System\\Autoexec.ncf");
            if (file != null) {
                try {
                    FileReader fileReader = new FileReader(file);
                    Long l = new Long(file.length());
                    if (l.intValue() > 0) {
                        char[] cArray = new char[l.intValue()];
                        fileReader.read(cArray, 0, l.intValue());
                        String string3 = new String(cArray);
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken().trim();
                            if (!string4.endsWith(PicardNetwarePlatform.theStartCommand)) continue;
                            string = string4.substring(0, string4.indexOf(PicardNetwarePlatform.theStartCommand) - 1);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
            }
        } else {
            String string5 = null;
            if (this.isLinux()) {
                string5 = "/etc/rc.d/init.d/PBEAgent";
            } else if (this.isSolaris()) {
                string5 = "/etc/rc2.d/S99PBEAgent";
            }
            File file = new File(string5);
            if (file != null) {
                try {
                    FileReader fileReader = new FileReader(file);
                    Long l = new Long(file.length());
                    if (l.intValue() > 0) {
                        char[] cArray = new char[l.intValue()];
                        fileReader.read(cArray, 0, l.intValue());
                        String string6 = new String(cArray);
                        StringTokenizer stringTokenizer = new StringTokenizer(string6, "\n");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string7 = stringTokenizer.nextToken().trim();
                            if (!string7.startsWith("cd ")) continue;
                            string = string7.substring(3);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    private class DirFileFilter
    extends FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return "Directories";
        }
    }

    public class FileSelection
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PicardDirectoryPanel.this.theChooser.showOpenDialog(null);
            if (n == 0) {
                PicardDirectoryPanel.this.theDirectoryField.setText(PicardDirectoryPanel.this.theChooser.getSelectedFile().getPath());
            }
        }
    }
}

