/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.Log;
import com.denova.ui.GridBagControl;
import com.denova.ui.WizardPanel;
import com.denova.util.PropertyList;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class PicardCommitPanel
extends WizardPanel
implements JExpressConstants {
    private JTextArea theText;
    private JScrollPane theScrollpane;

    public PicardCommitPanel(PropertyList propertyList, Log log) {
        super(propertyList, log);
        this.layoutScreen();
    }

    public void layoutScreen() {
        EmptyBorder emptyBorder = new EmptyBorder(20, 20, 20, 20);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(emptyBorder);
        JPanel jPanel = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel(PicardResources.CommitPanelTitle);
        jLabel.setFont(new Font("Bold", 1, 12));
        JLabel jLabel2 = new JLabel(PicardResources.CommitDescriptionMsg01);
        JLabel jLabel3 = new JLabel(PicardResources.CommitDescriptionMsg02);
        this.theText = new JTextArea(8, 50);
        this.theText.setLineWrap(true);
        this.theText.setMinimumSize(new Dimension(250, 250));
        this.theScrollpane = new JScrollPane(this.theText);
        this.theScrollpane.setMinimumSize(new Dimension(250, 150));
        gridBagControl.addCentered(jLabel);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(jLabel2);
        gridBagControl.addCentered(jLabel3);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(this.theScrollpane);
        this.add(jPanel);
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void setActive(boolean bl) {
        if (bl) {
            this.LoadTextArea();
            if (PicardInstaller.silentConfiguration.isSilentInstall()) {
                this.startInstall();
                this.showNextPanel();
            }
        }
    }

    public String getName() {
        return "PicardCommitPanel";
    }

    private void startInstall() {
        File file = new File(this.getPropertyList().getProperty("applicationDirectory"));
        file.mkdirs();
        this.shutdownOldSoftware(this.getPropertyList());
        PicardInstallableComponent picardInstallableComponent = PicardInstaller.componentManager.getInstallableComponent();
        this.getPropertyList().setProperty("installType", picardInstallableComponent.getName());
    }

    private void LoadTextArea() {
        boolean bl = true;
        this.theText.setText("");
        Enumeration enumeration = PicardInstaller.componentManager.enumerateSelectedComponents();
        while (enumeration.hasMoreElements()) {
            PicardInstallableComponent picardInstallableComponent = (PicardInstallableComponent)enumeration.nextElement();
            if (picardInstallableComponent.isRequiredComponent()) continue;
            if (bl) {
                this.theText.append(PicardResources.SummaryComponent + "\r\n");
                bl = false;
            }
            this.theText.append(picardInstallableComponent.getTitle());
            this.theText.append("\r\n");
        }
        this.theText.append("\r\n");
        this.theText.append(PicardResources.SummaryChanges + "\r\n");
        this.theText.append(PicardResources.SummaryUpsType + " " + PicardInstaller.configuration.getUpsType() + "\r\n");
        this.theText.append(PicardResources.SummaryUpsPort + " " + PicardInstaller.configuration.getUpsPort() + "\r\n");
        this.theText.append(PicardResources.SummaryWebPort + " " + PicardInstaller.configuration.getWebPort() + "\r\n");
        String string = PicardInstaller.configuration.getUserName();
        if (string.equalsIgnoreCase("")) {
            string = PicardResources.BlankValue;
        }
        this.theText.append(PicardResources.SummaryUserName + " " + string + "\r\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < PicardInstaller.configuration.getUserPassword().length()) {
            stringBuffer.append("*");
            ++n;
        }
        string = stringBuffer.toString();
        if (string.equalsIgnoreCase("")) {
            string = PicardResources.BlankValue;
        }
        this.theText.append(PicardResources.SummaryPassword + " " + string + "\r\n");
        string = PicardInstaller.configuration.getContactPerson();
        if (string.equalsIgnoreCase("")) {
            string = PicardResources.BlankValue;
        }
        this.theText.append(PicardResources.SummaryContact + " " + string + "\r\n");
        string = PicardInstaller.configuration.getContactLocation();
        if (string.equalsIgnoreCase("")) {
            string = PicardResources.BlankValue;
        }
        this.theText.append(PicardResources.SummaryLocation + " " + string + "\r\n");
        this.theText.setCaretPosition(0);
    }

    private void shutdownOldSoftware(PropertyList propertyList) {
        String string = propertyList.getProperty("applicationDirectory");
        boolean bl = propertyList.getBooleanProperty("Linux");
        boolean bl2 = propertyList.getBooleanProperty("Netware");
        boolean bl3 = propertyList.getBooleanProperty("Solaris");
        try {
            String string2 = bl || bl3 ? string + File.separator + "bin//startup stop" : (bl2 ? "" : "\"" + string + File.separator + "pcupsmgr\"" + " -remove");
            Process process = Runtime.getRuntime().exec(string2);
            try {
                process.waitFor();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOk() {
        this.startInstall();
        return true;
    }
}

