/*
 * Decompiled with CFR 0.152.
 */
import com.denova.JExpress.JExpressConstants;
import com.denova.io.FileSystem;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.runtime.JRE;
import com.denova.ui.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class JExpressLoader
extends JFrame
implements Runnable,
JExpressConstants {
    public static final boolean debugging = false;
    Log log;
    String controlUrl;
    boolean appletInstall;
    boolean silentInstall;
    String installDirectory;
    String extraParameters;
    boolean ok;
    Thread loaderThread;
    JLabel status;
    JLabel fileStatus;
    JProgressBar progressBar;
    File dir;

    void JExpressLoader_WindowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    JPanel createMainPanel() {
        int n = 400;
        int n2 = 20;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        jPanel.add(new JLabel("Getting installer..."));
        jPanel.add(Box.createRigidArea(new Dimension(400, 20)));
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(100);
        jPanel.add(this.progressBar);
        jPanel.add(Box.createVerticalStrut(20));
        this.status = new JLabel("");
        jPanel.add(this.status);
        this.fileStatus = new JLabel("", 0);
        jPanel.add(this.fileStatus);
        return jPanel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch() {
        this.logStatus("launched");
        this.ok = true;
        if (this.ok) {
            this.logMessage("Ready to install");
            this.loaderThread = new Thread(this);
            this.loaderThread.start();
            try {
                this.loaderThread.join();
            }
            catch (Exception exception) {
                this.log.write(exception);
                this.logMessage(exception.getMessage());
                this.ok = false;
            }
        }
        if (!this.ok) {
            this.errorExit("Unable to load JExpress Installer");
        }
        if (load.installingFromFiles(this.controlUrl)) {
            // empty if block
        }
    }

    public void run() {
        this.installSwing();
        String[] stringArray = load.getInstallerArgs(this.controlUrl, this.appletInstall, this.silentInstall, this.installDirectory, this.extraParameters);
        if (this.appletInstall) {
            if (this.installJarFile("JExpressInstaller" + "." + "jar")) {
                this.runInstaller(stringArray);
            } else {
                this.logMessage("Unable to install " + "JExpressInstaller" + "." + "jar");
            }
        } else {
            this.invokeInstaller(stringArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean installJarFile(String string) {
        this.logMessage("installing jar file " + string);
        InstallerInstaller installerInstaller = new InstallerInstaller();
        installerInstaller.getFile(string, this.controlUrl);
        if (installerInstaller.isFirewallError()) {
            String string2;
            this.logMessage("got firewall error while installing jar file");
            try {
                URL uRL = new URL(this.controlUrl);
                string2 = uRL.getHost();
            }
            catch (Exception exception) {
                this.log.write(exception);
                this.logMessage(exception.getMessage());
                string2 = this.controlUrl;
            }
            this.firewallExit(string2);
        }
        this.logMessage("after installing jar file: " + installerInstaller.isOk());
        return installerInstaller.isOk();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void installSwing() {
        try {
            String string = System.getProperty("java.version");
            if (!string.startsWith("1.1")) {
                if (!string.startsWith("1.0")) return;
            }
            File file = new File("swingall.jar");
            File file2 = new File(JRE.getJavaHome() + "lib");
            File file3 = new File(file2, "swingall.jar");
            this.logMessage("installing swing " + file.getPath() + " to " + file3.getPath());
            if (!file.exists()) {
                if (file3.exists()) return;
                this.logMessage("swingall.jar not found");
                return;
            }
            if (file3.exists()) {
                this.logMessage("swing already installed in " + file2.getPath());
                return;
            }
            try {
                FileSystem.copyFile(file, file3);
                this.logMessage("installed swing in " + file2.getPath());
                return;
            }
            catch (Exception exception) {
                this.logMessage("unable to copy swingall.jar to " + file2.getPath());
                return;
            }
        }
        catch (Exception exception) {
            this.log.write(exception);
            this.logMessage(exception.getMessage());
        }
    }

    void exit() {
        TempFiles.delete();
        this.logMessage("exiting");
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
        }
        load.exit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runInstaller(String[] stringArray) {
        try {
            String string = this.getMainClassName();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    String string2 = "." + File.pathSeparator + this.dir.getPath() + File.separator + this.getMainJarFilename();
                    this.logMessage("Running: \"" + string + "\" in directory \"" + this.dir.getPath() + "\" with classpath of \"" + string2 + "\"");
                    JRE.launchCommand(string, string2, this.dir);
                    return;
                }
                string = string + " \"" + stringArray[n] + "\"";
                ++n;
            }
        }
        catch (Exception exception) {
            this.log.write(exception);
            this.logMessage(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void invokeInstaller(String[] stringArray) {
        try {
            this.logStatus("running app");
            this.setStatus("Loading...");
            this.getClass();
            Class<?> clazz = Class.forName(this.getMainClassName());
            if (clazz == null) {
                this.logMessage("Could not load main class \"" + this.getMainClassName());
                return;
            }
            try {
                Method[] methodArray = clazz.getMethods();
                int n = 0;
                while (true) {
                    if (n >= methodArray.length || methodArray[n].getName().equals("main")) {
                        if (n >= methodArray.length) {
                            this.logMessage("No main() method found");
                            this.ok = false;
                            return;
                        }
                        this.logStatus("using main in " + methodArray[n].getName());
                        Method method = methodArray[n];
                        Object[] objectArray = new Object[]{stringArray};
                        try {
                            this.logStatus("about to launch application");
                            method.invoke(null, objectArray);
                            this.logStatus("application launched");
                            ((Component)this).setVisible(false);
                            return;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            this.logMessage("Exception in main class \"" + this.getMainClassName() + "\"");
                            this.log.write(invocationTargetException.getTargetException());
                            this.logMessage(invocationTargetException.getMessage());
                            this.ok = false;
                            return;
                        }
                    }
                    this.logStatus("methods [" + String.valueOf(++n) + "]: " + methodArray[n].getName());
                }
            }
            catch (Exception exception) {
                this.logMessage("Could not get methods for main class \"" + this.getMainClassName() + "\"");
                this.log.write(exception);
                this.logMessage(exception.getMessage());
                this.ok = false;
                return;
            }
        }
        catch (Exception exception) {
            this.logMessage("Could not load main class \"" + this.getMainClassName() + "\"");
            this.log.write(exception);
            this.logMessage(exception.getMessage());
            this.ok = false;
        }
    }

    String getMainClassName() {
        String string = "com.denova.JExpress.Installer.JExpressInstaller.class";
        if (string.endsWith(".class")) {
            int n = string.lastIndexOf(46);
            string = string.substring(0, n);
        }
        return string;
    }

    String getMainJarFilename() {
        return "JExpressInstaller" + ".jar";
    }

    void firewallExit(String string) {
        this.logMessage("Unknown host :" + string);
        this.errorExit("Detected proxy or firewall. Use Firewall installer version.");
    }

    void setStatus(String string) {
        if (this.status != null) {
            UiUtilities.update((Component)this.status, (Object)string);
            UiUtilities.update((Component)this.fileStatus, (Object)"");
        }
        JExpressLoader.debugLog(string);
        this.logMessage(string);
    }

    void logStatus(String string) {
        JExpressLoader.debugLog(string);
        this.logMessage(string);
        load.statusLog("JExpressLoader: " + string);
    }

    void logMessage(String string) {
        this.log.write(string);
        JExpressLoader.debugLog(string);
    }

    void errorExit(String string) {
        this.logMessage(string);
        load.errorExit(string);
    }

    public static void main(String[] stringArray) {
        Object object;
        load.statusLog("JExpressLoader: main started");
        Object object2 = "QzControlUrl                                                                               .";
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).startsWith("-")) {
                String string3 = ((String)object).substring(1);
                if (string3.equals("a")) {
                    bl = true;
                } else if (string3.equals("q")) {
                    if (++n < stringArray.length) {
                        while (n < stringArray.length && !stringArray[n].equalsIgnoreCase("-" + "p") && !stringArray[n].equalsIgnoreCase("-" + "a")) {
                            bl2 = true;
                            string = string + stringArray[n];
                            string = string + " ";
                            ++n;
                        }
                        string = string.trim();
                    } else {
                        UiUtilities.note("Expected directory after -" + "q");
                        System.exit(1);
                    }
                } else if (string3.equals("p") && ++n < stringArray.length) {
                    while (n < stringArray.length && !stringArray[n].equalsIgnoreCase("-" + "q") && !stringArray[n].equalsIgnoreCase("-" + "a")) {
                        string2 = string2 + stringArray[n];
                        string2 = string2 + " ";
                        ++n;
                    }
                    string2 = string2.trim();
                }
            } else {
                object2 = object;
            }
            ++n;
        }
        object = new JExpressLoader((String)object2, bl, bl2, string, string2);
        ((JExpressLoader)object).launch();
    }

    public static void debugLog(String string) {
    }

    public JExpressLoader(String string, boolean bl, boolean bl2, String string2, String string3) {
        String string4 = JRE.getJavaHome() + "bin" + File.separator + "install";
        this.dir = new File(string4);
        if (bl) {
            this.dir.mkdirs();
            TempFiles.setDefaultDirectory(string4);
            Log.setAlwaysFlush(false);
            Log.setUseTempDirectory(true);
        }
        this.log = new Log("loader");
        JExpressLoader.debugLog("started JExpressLoader");
        this.controlUrl = string.trim();
        this.appletInstall = bl;
        this.silentInstall = bl2;
        this.installDirectory = string2.trim();
        this.extraParameters = string3.trim();
        this.logStatus("instantiated");
        this.logMessage("Control url is " + this.controlUrl);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createMainPanel(), "Center");
        this.setTitle("JExpress Installer");
        JExpressLoader jExpressLoader = this;
        if (jExpressLoader == null) {
            throw null;
        }
        JExpressLoaderWindow jExpressLoaderWindow = jExpressLoader.new JExpressLoaderWindow();
        this.addWindowListener(jExpressLoaderWindow);
        this.pack();
        UiUtilities.centerOnScreen(this);
    }

    class JExpressLoaderWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == JExpressLoader.this) {
                JExpressLoader.this.JExpressLoader_WindowClosing(windowEvent);
            }
        }

        JExpressLoaderWindow() {
        }
    }
}

