/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.l;
import com.sun.crypto.provider.m;
import com.sun.crypto.provider.r;
import com.sun.crypto.provider.s;
import com.sun.crypto.provider.t;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 7647557958927458271L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new s(2, this.y.toByteArray()).o();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            s s2 = new s(byteArrayInputStream);
            if (s2.e != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            s s3 = s2.g.d();
            if (s3.e != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            m m2 = s3.p();
            t t2 = m2.h();
            if (m2.a() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            s s4 = m2.d();
            if (s4.e == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (s4.e != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            s4.g.k();
            this.p = s4.g.e().a();
            this.g = s4.g.e().a();
            if (s4.g.a() != 0) {
                this.l = s4.g.e().c();
            }
            if (s4.g.a() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = s2.g.b();
            this.parseKeyBits();
            if (s2.g.a() != 0) {
                throw new InvalidKeyException("Excess key data");
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public String getAlgorithm() {
        return "DH";
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                l l2 = new l();
                l2.a(new t(this.DH_data));
                l l3 = new l();
                l3.a(new r(this.p));
                l3.a(new r(this.g));
                if (this.l != 0) {
                    l3.a(new r(this.l));
                }
                s s2 = new s(48, l3.toByteArray());
                l2.a(s2);
                l l4 = new l();
                l4.a((byte)48, l2);
                l4.a(this.key);
                l l5 = new l();
                l5.a((byte)48, l4);
                this.encodedKey = l5.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String getFormat() {
        return "X.509";
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public BigInteger getY() {
        return this.y;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        int n3 = 1;
        while (n3 < byArray.length) {
            n2 += byArray[n3] * n3;
            ++n3;
        }
        return n2;
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            m m2 = new m(this.key);
            this.y = m2.e().a();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Public Key:\ny:\n" + new r(this.y).toString() + "\n" + "p:\n" + new r(this.p).toString() + "\n" + "g:\n" + new r(this.g).toString());
        if (this.l != 0) {
            stringBuffer.append("\nl:\n    " + this.l);
        }
        return stringBuffer.toString();
    }
}

