   10REM ***************************************
   20REM * Xfer/BBC                            *
   30REM * BBC <-> PC Serial Transfer program  *
   40REM * BBC End (Slave)                     *
   50REM * (c) Mark de Weger, 1996             *
   60REM ***************************************
   70:
   80:
   90REM *****************
  100REM Main program
  110REM *****************
  120:
  130REM Initialisation
  140PROCreset
  150REM Clear serial port buffers
  160*FX 21,1
  170*FX 21,2
  180MODE 7
  190ON ERROR PROCfatal_error
  200PROCsetvars
  210PROCassemble
  220PROCinitconnection
  230PROCmain
  240END
  250:
  260REM Main procedure
  270DEF PROCmain
  280REM Switch RS423 Escape off
  290*FX 181,1
  300REM Switch RS423 Printer selection off
  310*FX 5,0
  320REM Switch RS423 Output off
  330*FX 3,0
  340REM Switch output to printer off
  350VDU 3
  360PROCsetvars
  370REPEAT
  380REM Switch RS423 Output off
  390*FX 3,0
  400PROCstatus("waiting for command","",0)
  410g$=GET$
  420IF (g$="*") OR (g$="S") OR (g$="R") THEN name$=FNread_string
  430IF g$="*" THEN PROCoscli(name$)
  440IF g$="S" THEN PROCsendfile(name$)
  450IF g$="R" THEN PROCreceivefile(name$)
  460IF g$="T" THEN PROCtermemu
  470REM C: command to send current directory name (before transfer of file)
  480IF g$="C" THEN PROCsenddir
  490UNTIL g$="Q" OR g$="E"
  500:
  510REM Quit
  520PROCreset
  530REM Clear RS423 input buffer
  540*FX 21,1
  550IF g$="Q" THEN PROCstatus("quitting XFER","",0) ELSE PROCstatus("error at PC; quitting XFER","",0)
  560END
  570:
  580:
  590REM ******************
  600REM Oscli command
  610REM ******************
  620:
  630REM Carry out * command
  640DEF PROCoscli(oscli$)
  650REM Switch output to printer on (*FX 3,3 doesn't work for *-commands)
  660VDU 2
  670REM Select RS423 for printer output
  680*FX 5,2
  690ON ERROR PROCallowed_error
  700OSCLI(oscli$)
  710ON ERROR PROCfatal_error
  720PRINT sync_text$
  730REM Switch output to printer off
  740VDU 3
  750REM Deselect RS423 for printer output
  760*FX 5,0
  770ENDPROC
  780:
  790:
  800REM ******************
  810REM Send files to PC
  820REM ******************
  830:
  840REM Send file
  850DEF PROCsendfile(f$)
  860ON ERROR PROCallowed_error:ENDPROC
  870fh%=OPENIN(f$)
  880ON ERROR PROCfatal_error
  890REM Print string to show OPENIN went well
  900*FX 3,3
  910PRINT sync_text$
  920*FX 3,0
  930IF fh%=0 THEN fs%=0 ELSE fs%=EXT#fh%
  940REM If file does not exist: send 0 to pc
  950IF fh%=0 THEN OSCLI("FX3,3"):PROCwrite_integer(fh%):OSCLI("FX3,0"):ENDPROC
  960PROCstatus("sending file",f$,fs%)
  970REM Select serial port for output
  980*FX 3,3
  990REM Send confirmation that file exists (by non-0 number)
 1000PROCwrite_integer(fh%)
 1010REM Send file size
 1020PROCwrite_integer(fs%)
 1030REM Send file contents
 1040crc2%=FNsfc(fh%,fs%)
 1050CLOSE#fh%
 1060REM Send CRC
 1070PROCwrite_integer(crc2%)
 1080REM Send .inf file
 1090PROCsendinf(f$,fs%)
 1100REM Select VDU for output
 1110*FX 3,0
 1120ENDPROC
 1130:
 1140REM Send file contents
 1150DEF FNsfc(fh%,fs%)
 1160REM Initialise
 1170!crc%=0
 1180?bufstart%=buffer% MOD 256
 1190bufstart%?1=buffer% DIV 256
 1200?pblockstart%=pblock% MOD 256
 1210pblockstart%?1=pblock% DIV 256
 1220?pblock%=fh%
 1230?blocks_tbt%=(fs% DIV bufsize%)+1
 1240IF fs%=0 THEN ?blocks_tbt%=0
 1250rest_bytes%=fs% MOD bufsize%
 1260IF rest_bytes%=0 THEN rest_bytes%=bufsize%
 1270?end_lb%=(buffer%+rest_bytes%) MOD 256
 1280end_lb%?1=(buffer%+rest_bytes%) DIV 256
 1290?bufend%=(buffer%+bufsize%) MOD 256
 1300bufend%?1=(buffer%+bufsize%) DIV 256
 1310REM Do it
 1320CALL sendfile
 1330=!crc%
 1340:
 1350REM Send .inf file
 1360DEF PROCsendinf(f$,length%)
 1370REM Osfile 5: reads file's catalog info
 1380$nblock%=f$
 1390?pblock%=nblock% MOD 256
 1400pblock%?1=nblock% DIV 256
 1410X%=pblock% MOD 256
 1420Y%=pblock% DIV 256
 1430A%=5
 1440CALL osfile%
 1450start%=pblock%!2 AND &00FFFFFF
 1460exec%=pblock%!6 AND &00FFFFFF
 1470load%=pblock%!&0A AND &00FFFFFF
 1480IF pblock%!&0E <> 0 THEN locked$="Locked" ELSE locked$=""
 1490IF MID$(f$,2,1)="." THEN dir$="" ELSE dir$=FNgetcurrentdir+"."
 1500PRINT dir$;f$;"  ";~start%;"  ";~exec%;"  ";~length%;"  ";locked$
 1510ENDPROC
 1520:
 1530:
 1540REM **********************
 1550REM Receive files from PC
 1560REM **********************
 1570:
 1580REM Receive file
 1590DEF PROCreceivefile(f$)
 1600REM Receive file attributes+length
 1610start%=FNread_integer
 1620exec%=FNread_integer
 1630length%=FNread_integer
 1640locked$=FNread_string
 1650PROCstatus("receiving file",f$,length%)
 1660ON ERROR PROCallowed_error:ENDPROC
 1670fh%=OPENOUT(f$)
 1680ON ERROR PROCfatal_error
 1690REM Print string to show OPENOUT went well
 1700*FX 3,3
 1710PRINT sync_text$
 1720*FX 3,0
 1730REM Receive file contents
 1740crc2%=FNgetfilecontents(fh%,length%)
 1750CLOSE#fh%
 1760IF crc2%=-1 THEN ENDPROC
 1770crcrec%=FNread_integer
 1780REM Tell pc if crc error
 1790*FX 3,3
 1800IF crcrec%<>crc2% THEN PRINT err_txt2$:ENDPROC ELSE PRINT sync_text$
 1810*FX 3,0
 1820REM Osfile 1: set file attributes
 1830$nblock%=f$
 1840?pblock%=nblock% MOD 256
 1850pblock%?1=nblock% DIV 256
 1860pblock%!2=start%
 1870pblock%!6=exec%
 1880pblock%!&0A=length%
 1890pblock%!&0E=0
 1900X%=pblock% MOD 256
 1910Y%=pblock% DIV 256
 1920A%=1
 1930CALL osfile%
 1940IF MID$(locked$,1,1)="L" THEN OSCLI("ACCESS "+f$+" L")
 1950ENDPROC
 1960:
 1970REM Receive file contents
 1980DEF FNgetfilecontents(fh%,fs%)
 1990REM Initialise
 2000!bytes_transferred%=0
 2010!crc%=0
 2020!filelength%=fs%
 2030?max_bib_min1%=(bufsize%-1) MOD 256
 2040max_bib_min1%?1=(bufsize%-1) DIV 256
 2050?bufstart%=buffer% MOD 256
 2060bufstart%?1=buffer% DIV 256
 2070?pblockstart%=pblock% MOD 256
 2080pblockstart%?1=pblock% DIV 256
 2090?pblock%=fh%
 2100REM Do it
 2110ON ERROR PROCallowed_error:ENDPROC
 2120CALL receivefile
 2130ON ERROR PROCfatal_error
 2140=!crc%
 2150:
 2160:
 2170REM ****************************
 2180REM Terminal emulation
 2190REM ****************************
 2200:
 2210REM Start terminal emulation
 2220DEF PROCtermemu
 2230PROCstatus("terminal emulation","",0)
 2240REM Select RS423 as printer (*FX 3,3 doesn't work for *-commands)
 2250*FX 5,2
 2260REM Switch output to printer on
 2270VDU 2
 2280REM Enable RS423 Escape
 2290*FX 181,0
 2300END
 2310ENDPROC
 2320:
 2330:
 2340REM ****************************
 2350REM Send current directory name
 2360REM ****************************
 2370:
 2380DEF PROCsenddir
 2390dir$=FNgetcurrentdir
 2400REM Switch RS423 output on
 2410*FX3,3
 2420PRINT dir$
 2430REM Switch RS423 output off
 2440*FX3,0
 2450ENDPROC
 2460:
 2470:
 2480REM ****************************
 2490REM Initialisation/error/status
 2500REM ****************************
 2510:
 2520REM Initialise and check connection
 2530DEF PROCinitconnection
 2540PROCstatus("Waiting for connection","",0)
 2550REM 1200 Baud RS423 Receiving
 2560*FX 7,4
 2570REM Receive from RS423
 2580*FX 2,1
 2590REM Test connection
 2600text$=FNread_string
 2610IF text$<>sync_text$ THEN PROCreset:PRINT "Invalid data received. Please try again.":END
 2620REM Get baud rate and set it
 2630x%=FNread_integer
 2640PRINT
 2650PRINT "Initializing at ";STR$(x%);" baud."
 2660PRINT
 2670REM Osbyte 7: set RS423 receiving speed
 2680IF x%=1200 THEN X%=4
 2690IF x%=2400 THEN X%=5
 2700IF x%=4800 THEN X%=6
 2710IF x%=9600 THEN X%=7
 2720IF x%=19200 THEN X%=8
 2730A%=7
 2740CALL osbyte%
 2750REM Osbyte 8: set RS423 sending speed
 2760A%=8
 2770CALL osbyte%
 2780ENDPROC
 2790:
 2800REM Initialise variables
 2810DEF PROCsetvars
 2820DIM pblock% &11
 2830DIM nblock% &F
 2840osbyte%=&FFF4
 2850oscli%=&FFF7
 2860osfile%=&FFDD
 2870osgbpb%=&FFD1
 2880oswrch%=&FFEE
 2890sync_text$="-----BBC-----PC-----"
 2900err_txt$="-----BBCerror-----PC-----"
 2910err_txt2$="-----BBCerror-----PC-----2"
 2920@%=&90A
 2930REM Variables for mc
 2940bufsize%=4000
 2950bytes_in_buffer%=&70
 2960max_bib_min1%=&72
 2970crc%=&74
 2980filelength%=&78
 2990bytes_transferred%=&7C
 3000bufptr%=&80
 3010bufstart%=&82
 3020pblockstart%=&84
 3030end_lb%=&86
 3040bufend%=&88
 3050blocks_tbt%=&8A
 3060receivefile=M%
 3070sendfile=N%
 3080ENDPROC
 3090:
 3100REM Print status of connection
 3110DEF PROCstatus(status$,file$,length%)
 3120CLS
 3130PRINT CHR$141;"XFER/BBC"
 3140PRINT CHR$141;"XFER/BBC"
 3150PRINT
 3160PRINT "(c) 1996 Mark de Weger"
 3170PRINT
 3180PRINT
 3190PRINT ""
 3200PRINT "Status: ";status$
 3210IF file$<>"" THEN PRINT "  File name: ";file$
 3220IF length%<>0 THEN PRINT "  File length: ";STR$(length%)
 3230PRINT ""
 3240ENDPROC
 3250:
 3260REM Reset RS423
 3270DEF PROCreset
 3280ON ERROR OFF
 3290REM Close serial port and reselect keyboard input
 3300*FX 2,0
 3310REM Flush serial port input buffer
 3320*FX 21,1
 3330REM Reselect VDU output
 3340*FX 3,0
 3350REM Deselect RS423 as printer destination
 3360*FX 5,0
 3370REM Switch printer output off
 3380VDU 3
 3390REM Close remaining open files
 3400CLOSE#0
 3410PRINT ""
 3420ENDPROC
 3430:
 3440REM Fatal error
 3450DEF PROCfatal_error
 3460PROCreset
 3470REPORT
 3480PRINT " at line ";ERL
 3490END
 3500ENDPROC
 3510:
 3520:
 3530REM ********************
 3540REM RS423 Utilities
 3550REM ********************
 3560:
 3570REM Read string
 3580DEF FNread_string
 3590LOCAL string$,g$
 3600string$=""
 3610REPEAT
 3620g$=GET$
 3630IF g$<>CHR$(13) THEN string$=string$+g$
 3640UNTIL g$=CHR$(13)
 3650=string$
 3660:
 3670REM Read integer
 3680DEF FNread_integer
 3690LOCAL s$
 3700s$=FNread_string
 3710=VAL(s$)
 3720:
 3730REM Write integer
 3740DEF PROCwrite_integer(i%)
 3750LOCAL s$,loop%
 3760s$=STR$(i%)
 3770PRINT s$
 3780ENDPROC
 3790:
 3800:
 3810REM ********************
 3820REM Other utilities
 3830REM ********************
 3840:
 3850REM Get current directory name
 3860DEF FNgetcurrentdir
 3870REM Osgbpb 6: read directory (and device)
 3880$nblock%="xxxx"
 3890pblock%?1=nblock% MOD 256
 3900pblock%?2=nblock% DIV 256
 3910pblock%?3=0
 3920pblock%?4=0
 3930X%=pblock% MOD 256
 3940Y%=pblock% DIV 256
 3950A%=6
 3960CALL osgbpb%
 3970=CHR$(nblock%?3)
 3980:
 3990REM Error to be trapped
 4000DEF PROCallowed_error
 4010ON ERROR PROCfatal_error
 4020REM Close open files
 4030CLOSE#0
 4040REM Switch off RS423 output
 4050*FX 3,0
 4060REM De-select RS423 printer
 4070*FX 5,0
 4080REM Switch output to printer off
 4090VDU 3
 4100REM Switch RS423 Escape off
 4110*FX 181,1
 4120PROCstatus("error, waiting for PC to respond","",0)
 4130REM Switch on RS423 output
 4140*FX 3,3
 4150REM Print string to tell PC of error
 4160PRINT err_txt$
 4170REM Wait for pc to respond acknowledgement of error
 4180pc$=""
 4190REPEAT
 4200g$=GET$
 4210IF g$<>"" THEN pc$=pc$+g$ ELSE pc$=""
 4220IF LEN(pc$)>LEN(err_txt$) THEN pc$=RIGHT$(pc$,LEN(pc$)-1)
 4230UNTIL pc$=err_txt$
 4240REM Send error to PC
 4250REPORT
 4260PRINT
 4270REM Switch off RS423 output
 4280*FX 3,0
 4290PROCmain
 4300:
 4310:
 4320REM ***********************
 4330REM Machine code generation
 4340REM ***********************
 4350:
 4360DEF PROCassemble
 4370DIM mc% 400
 4380DIM buffer% bufsize%
 4390FOR opt%=0 TO 3 STEP 3
 4400P%=mc%
 4410[
 4420OPT opt%
 4430\
 4440\ Receive file
 4450.receivefile
 4460.M%
 4470\ *bytes_in_buffer%=0
 4480LDA #0
 4490STA bytes_in_buffer%
 4500STA bytes_in_buffer%+1
 4510.fillrbloop
 4520\ if !bytes_transferred%=!filelength% then goto recexit
 4530LDA bytes_transferred%
 4540CMP filelength%
 4550BNE elsec
 4560LDA bytes_transferred%+1
 4570CMP filelength%+1
 4580BNE elsec
 4590LDA bytes_transferred%+2
 4600CMP filelength%+2
 4610BNE elsec
 4620LDA bytes_transferred%+3
 4630CMP filelength%+3
 4640BNE elsec
 4650JMP recexit
 4660.elsec
 4670\ if *bytes_in_buffer%=*max_bib_min1% then goto saveexit
 4680LDA bytes_in_buffer%
 4690CMP max_bib_min1%
 4700BNE getbyte
 4710LDA bytes_in_buffer%+1
 4720CMP max_bib_min1%+1
 4730BNE getbyte
 4740JMP saveexit
 4750.getbyte
 4760\ Y%=get from RS423 input buffer
 4770LDA #145
 4780LDX #1
 4790JSR osbyte%
 4800\ if not gotten then goto getbyte
 4810BCS getbyte
 4820\ *bufptr%=buffer%+*bytes_in_buffer%
 4830CLC
 4840LDA bufstart%
 4850ADC bytes_in_buffer%
 4860STA bufptr%
 4870LDA bufstart%+1
 4880ADC bytes_in_buffer%+1
 4890STA bufptr%+1
 4900\ ?(bufptr)=Y%
 4910TYA
 4920LDX #0
 4930STA (bufptr%,X)
 4940\ !crc%=!crc%+(bufptr%)
 4950CLC
 4960ADC crc%
 4970STA crc%
 4980BCC elsee
 4990LDA #0
 5000ADC crc%+1
 5010STA crc%+1
 5020BCC elsee
 5030LDA #0
 5040ADC crc%+2
 5050STA crc%+2
 5060BCC elsee
 5070LDA #0
 5080ADC crc%+3
 5090STA crc%+3
 5100.elsee
 5110\ !bytes_transferred%=!bytes_transferred%+1
 5120CLC
 5130LDA #1
 5140ADC bytes_transferred%
 5150STA bytes_transferred%
 5160BCC elsed
 5170LDA #0
 5180ADC bytes_transferred%+1
 5190STA bytes_transferred%+1
 5200BCC elsed
 5210LDA #0
 5220ADC bytes_transferred%+2
 5230STA bytes_transferred%+2
 5240BCC elsed
 5250LDA #0
 5260ADC bytes_transferred%+3
 5270STA bytes_transferred%+3
 5280.elsed
 5290\ *bytes_in_buffer%=*bytes_in_buffer%+1
 5300CLC
 5310LDA #1
 5320ADC bytes_in_buffer%
 5330STA bytes_in_buffer%
 5340LDA #0
 5350ADC bytes_in_buffer%+1
 5360STA bytes_in_buffer%+1
 5370\ goto fillrbloop
 5380JMP fillrbloop
 5390.saveexit
 5400JSR buffertofile
 5410JMP receivefile
 5420.recexit
 5430JSR buffertofile
 5440.rrecexit
 5450RTS
 5460\
 5470\ Save contents of buffer to file
 5480.buffertofile
 5490\ pblock%!1=*bufstart%
 5500LDY #1
 5510LDA bufstart%
 5520STA (pblockstart%),Y
 5530INY
 5540LDA bufstart%+1
 5550STA (pblockstart%),Y
 5560INY
 5570LDA #0
 5580STA (pblockstart%),Y
 5590INY
 5600STA (pblockstart%),Y
 5610\ pblock%!5=*bytes_in_buffer%
 5620INY
 5630LDA bytes_in_buffer%
 5640STA (pblockstart%),Y
 5650INY
 5660LDA bytes_in_buffer%+1
 5670STA (pblockstart%),Y
 5680INY
 5690LDA #0
 5700STA (pblockstart%),Y
 5710INY
 5720STA (pblockstart%),Y
 5730\ osgbpb 2 (Save block of data)
 5740LDA #2
 5750LDX pblockstart%
 5760LDY pblockstart%+1
 5770JSR osgbpb%
 5780RTS
 5790\
 5800\ Send file
 5810.sendfile
 5820.N%
 5830\ IF ?blocks_tbt%=0 THEN GOTO .sendexit
 5840LDA blocks_tbt%
 5850CMP #0
 5860BEQ sendexit
 5870\ load block of data
 5880\ pblock%!1=*bufstart%
 5890LDY #1
 5900LDA bufstart%
 5910STA (pblockstart%),Y
 5920INY
 5930LDA bufstart%+1
 5940STA (pblockstart%),Y
 5950INY
 5960LDA #0
 5970STA (pblockstart%),Y
 5980INY
 5990STA (pblockstart%),Y
 6000\ pblock%!5=bufsize%
 6010INY
 6020LDA #bufsize% MOD 256
 6030STA (pblockstart%),Y
 6040INY
 6050LDA #bufsize% DIV 256
 6060STA (pblockstart%),Y
 6070INY
 6080LDA #0
 6090STA (pblockstart%),Y
 6100INY
 6110STA (pblockstart%),Y
 6120\ load block
 6130LDA #4
 6140LDX pblockstart%
 6150LDY pblockstart%+1
 6160JSR osgbpb%
 6170\ ?blocks_tbt%=?blocks_tbt%-1
 6180DEC blocks_tbt%
 6190\ send block to pc and start new block
 6200JSR sendblock
 6210JMP sendfile
 6220.sendexit
 6230RTS
 6240\
 6250\ send block to pc and calculate crc
 6260.sendblock
 6270\ *bufptr%=*bufstart%
 6280LDA bufstart%
 6290STA bufptr%
 6300LDA bufstart%+1
 6310STA bufptr%+1
 6320.sbloop
 6330\ VDU ?(bufptr%)
 6340LDY #0
 6350LDA (bufptr%),Y
 6360JSR oswrch%
 6370\ !crc%=!crc%+?tempadr%
 6380CLC
 6390ADC crc%
 6400STA crc%
 6410BCC elses
 6420LDA #0
 6430ADC crc%+1
 6440STA crc%+1
 6450BCC elses
 6460LDA #0
 6470ADC crc%+2
 6480STA crc%+2
 6490BCC elses
 6500LDA #0
 6510ADC crc%+3
 6520STA crc%+3
 6530.elses
 6540\ *bufptr%=*bufptr%+1
 6550CLC
 6560LDA #1
 6570ADC bufptr%
 6580STA bufptr%
 6590LDA #0
 6600ADC bufptr%+1
 6610STA bufptr%+1
 6620\ IF ?blocks_tbt%<>0 THEN GOTO .testall
 6630LDA blocks_tbt%
 6640CMP #0
 6650BNE testall
 6660\ IF *bufptr%=*end_lb% THEN RETURN ELSE GOTO sbloop
 6670LDA bufptr%
 6680CMP end_lb%
 6690BNE elses1
 6700LDA bufptr%+1
 6710CMP end_lb%+1
 6720BNE elses1
 6730RTS
 6740.elses1
 6750JMP sbloop
 6760.testall
 6770\ IF *bufptr%=*bufend% THEN RETURN ELSE GOTO sbloop
 6780LDA bufptr%
 6790CMP bufend%
 6800BNE elses2
 6810LDA bufptr%+1
 6820CMP bufend%+1
 6830BNE elses2
 6840RTS
 6850.elses2
 6860JMP sbloop
 6870]
 6880NEXT
 6890ENDPROC