/* utils.c (bbcim; bbc diskbeeld manipulatie): hulp functies.
 *
 * Copyright (c) W.H. Scholten 1996, 1997
 */


/*__________________PROGRAMMA___________________*/
#if 0
/* NB invoer en bbcnaam mogen niet zelfde string zijn */
void invoer_naar_bbcnaam(char *invoer, char *bbcnaam) {
    if (invoer[1]=='.')
	strncpy(bbcnaam, invoer,9);
    else {
	bbcnaam[0]='$'; bbcnaam[1]='.'; strncpy(bbcnaam+2, invoer, 7);
    }
    bbcnaam[9]=0;
}
#endif


/* number of char's to be checked for replacement */
#define  filenamechar_no  sizeof(filenamechar_bad)

void replace_bad_chars(char *unix_bbcfile_naam) {
    /* Name check: replace certain characters in filenames (most filesystems can't
       handle all characters from bbc filenames) */
    int i,j;

    for (i=0; i<filenamechar_no; i++) {
	for (j=0; j<strlen(unix_bbcfile_naam); j++) {
	    if (unix_bbcfile_naam[j]<32)
		unix_bbcfile_naam[j]='_';
	    if (unix_bbcfile_naam[j]==filenamechar_bad[i])
		unix_bbcfile_naam[j]=filenamechar_replace[i];
	}
    }
}



void reduceer_unix_naam(char *unixnaam, char *bbcnaam) {
    if (bbcnaam[0]=='$')
	strcpy(unixnaam,bbcnaam+2);
    else {
	unixnaam[0]=bbcnaam[0];
	strcpy(unixnaam+1,bbcnaam+2);
    }
}



/* Reading numbers from a buffer */
long read4lsb(byte *data) {
    return (long) data[0] | ( ((long) data[1]) <<8) | ( ((long) data[2]) <<16) | ( ((long) data[3]) <<24);
}


long read3lsb(byte *data) {
    return (long) data[0] | ( ((long) data[1]) <<8) | ( ((long) data[2]) <<16);
}

long read2lsb(byte *data) {
    return (long) data[0] | ( ((long) data[1]) <<8);
}



int  file_sanitycheck(char *filename, int verbose) {
    FILE *fp;

    bbcim_errno=0;

    fp=fopen(filename, "rb");
    if (fp==NULL) {
	bbcim_error=
#ifdef NL
	"Kan bestand niet openen";
#else
	"Cannot open file";
#endif
	if (verbose) printf("%s: %s\n", filename, bbcim_error);
	bbcim_errno=BBC_OPEN_FAILED;
	return bbcim_errno;
    }
    fclose(fp);
    return 0;
}


int  diskimage_sanitycheck(struct diskimage* image, int verbose) {
    FILE *fpdisk;
    unsigned char files=0;
    char *diskname=image->filename;


    bbcim_errno=0;

    fpdisk=fopen(diskname, "rb");
    if (fpdisk==NULL) {
	bbcim_error=
#ifdef NL
	"Kan diskbeeld niet openen\n\n";
#else
	"Cannot open diskimage\n\n";
#endif
	if (verbose) printf(bbcim_error);
	bbcim_errno=BBC_OPEN_FAILED;
	return bbcim_errno;
    }

    switch(image->type) {
    case DFS_DISK:
/* for (side=0; side<image.sides; side++) { */
	/* Doe alleen iets als het diskbeeld meer dan 2 sectoren bevat. */
	fseek(fpdisk,0L, SEEK_END);
	if (ftell(fpdisk)<512) {
	    /* Should be a non-fatal error */
	    bbcim_error=
#ifdef NL
	    "niets op het diskbeeld\n\n";
#else
	    "nothing on the diskimage\n\n";
#endif
	    bbcim_errno=BBC_NO_ROOT_DIR;
	    break;
	}

	fseek(fpdisk,256+5L,SEEK_SET);
	fread(&files,1,1,fpdisk);
	if (files % 8) {
	    bbcim_error=
#ifdef NL
	    "corrupt diskbeeld (bestand-aantal byte)\n";
#else
	    "bad diskimage (fileno byte)\n";
#endif
	    bbcim_errno=BBC_BAD_DISK;
	    break;
	}
	/* SANITY CHECK startsec>1 ? */
	break;
    case ADFS_DISK:
	break;
    default:
	bbcim_error="bad disktype\n";
	bbcim_errno=BAD_DISK_TYPE_ARGUMENT;
	break;
    }

    fclose(fpdisk);
    if (verbose && bbcim_errno) printf(bbcim_error);
    return bbcim_errno;
}



int get_diskattributes(struct diskimage *image, int verbose) {
    FILE *fpdsk;
    char disk_dsk[100];
    char type[100];
    char sides[100];
    char *disk;

    bbcim_errno=0;

    disk=image->filename;

    strcpy(disk_dsk, disk);
    strcat(disk_dsk, ".dsk");

    if (file_sanitycheck(disk_dsk, verbose)) return bbcim_errno;

    fpdsk=fopen(disk_dsk, "r");
    /* -- read disk attributes */
    if (fscanf(fpdsk, "%99s %99s %dT %dS %dB", type, sides, &image->tracks, &image->sectors_per_track, &image->bytes_per_sector)!=5) {
	bbcim_error="Bad dsk format\n";
	bbcim_errno=BBC_BAD_DSK_FORMAT;
    };

    if (diskinfo_from_string(type, image) || diskinfo_from_string(sides, image)) {
 	bbcim_error="Bad dsk format\n";
	bbcim_errno=BBC_BAD_DSK_FORMAT;
    }

    fclose(fpdsk);
    if (verbose && bbcim_errno) printf(bbcim_error);
    return bbcim_errno;
}


int  diskinfo_from_string(char *string, struct diskimage *image) {
    if (!strncmp(string, "DFS", 10)) image->type = DFS_DISK;
    else if (!strncmp(string, "W62", 10)) image->type = W62_DISK;
    else if (!strncmp(string, "DDOS", 10)) image->type = DDOS_DISK;
    else if (!strncmp(string, "ADFS", 10)) image->type = ADFS_DISK;
    else if (!strncmp(string, "HDFS", 10)) image->type = HDFS_DISK;
    else if (!strncmp(string, "DS", 10)) image->sides = 2;
    else if (!strncmp(string, "SS", 10)) image->sides = 1;
    else return -1;
    return 0;
}


/* Get bbc file attributes from info file */
int get_fileattributes_info(char *filename, struct bbcfile *file, int verbose) {
    FILE *fpinfo;
    char file_info[100];
/*     char type[100]; */
    char read_line[100];
/*     char *disk; */
    int  error=0;
    int  len_s, i;
    int  locked=0;

    bbcim_errno=0;

    strcpy(file_info, filename);
    strcat(file_info, ".inf");

    if (file_sanitycheck(file_info, verbose)) return bbcim_errno;

    fpinfo=fopen(filename, "r");
    fseek(fpinfo, 0L, SEEK_END);
    file->length=ftell(fpinfo);
    fclose(fpinfo);

    fpinfo=fopen(file_info, "r");

    fscanf(fpinfo,"%12s", file->naam);
    if (file->naam[1]!='.') {
	bbcim_error="Bad info format\n";
	bbcim_errno=BBC_BAD_INF_FORMAT;
	error++;
    }

    if (!error)
	if (fscanf(fpinfo,"%lx %lx", &file->loadaddr, &file->execaddr)!=2) {
	    bbcim_error="Bad info format\n";
	    bbcim_errno=BBC_BAD_INF_FORMAT;
	    error++;
	}

    if (!error) {
	fgets(read_line, 99, fpinfo); len_s=strlen(read_line);
	for (i=0; i<len_s; i++)
	    if (read_line[i]=='L') {
		locked=ATTR_LOCKED;
		break;
	    }
	file->attributes=locked;
    }

    fclose(fpinfo);
    if (verbose && bbcim_errno) printf(bbcim_error);
    return bbcim_errno;
}
