/* (bbcim) cat-extract.c: toon catalogus van bestanden etc in diskbeeld (DFS/ADFS).
 * Copyright (C) W.H.Scholten 1996,1997
 *
 */

/* Show catalogue & extract files & calc CRC's (Acorn DFS)*/
/* int  disk_cat_extract_crc(char *disk, int args, char *arglist[], struct diskimage *image, int flags) { */
int  disk_cat_extract_crc(struct diskimage *image, int args, char *arglist[], struct bbcfile *beeb_file, int flags) {
    FILE *fpdisk, *fpcat, *fpextract, *fpinfo;
    char catalogus[50], extract[50], info_naam[50], basisnaam[50];
    char bbcdisk_naam[15], bbcfile_naam[15];
    char unix_bbcfile_naam[15];
    char testnaam[15];
    char *disk;

    unsigned char filebyte,H;

    long filesizesum=0;
    int  extr_list=0; /* list of files given ? */

    int i, rfiles, bootoption, antwoord, k;
    unsigned char files=0;
    unsigned int sectorsondisk;
    long file;
    int  locked;
    unsigned char eellddss; 

    long startsector;
    unsigned long loadaddress, execaddress, length;

    unsigned int crc;


/* FOR ADFS */
    char string[100];
#define NUM_FREESPACE_ENTRIES 82
#define ADFS_BOOTOPTION (256+253)
#define DIRECTORY_SIZE 1280
    byte dir_entry[DIRECTORY_SIZE];
    byte buf[512];

    long freespace_entries;
    char fullpath[100];
    char *path;
    int  path_index;
    char dirname[100];

    long dir_sector;
    int  status;
    int  extr_list_no;
    byte accessR, accessW, accessL, accessDIR, attributeE;

/* Internal use only (ADFS): */
#define FIND_DIR  1
#define NEXT_DIR  2
#define DIR_FOUND 3


#ifdef UNIX_MKDIR
    mode_t dir_mode;
#endif

#if defined(MAC_MKDIR) || defined(SYSTEM_MKDIR)
    char actie[60];
#endif

    static long find_file_infoaddr; /* for GET_ATTRIBUTES */







    if (flags & NEW_DISK) {
	find_file_infoaddr=-1;
	return 0;
    }

    bbcim_errno=0;

    disk = image->filename;

    if (flags & EXTRACT_FILES) flags |=SHOW_FILES;

    if (image->type==DFS_DISK) {
    /* -- DFS diskbeelden -- */

/* disk d.f ->
 * -ed         disk/d.f
 * -ed#        disk/df
 * -e#         disk.df
 * -e          disk.d.f
 * -es         d.f
 * -es#        df
 */


    if (diskimage_sanitycheck(image, flags & VERBOSE)) return bbcim_errno;

    strcpy(basisnaam, disk);
    basisnaam[strcspn(disk,".")]=0;
    strcpy(catalogus, basisnaam);
    strcat(catalogus,".cat");

    fpdisk=fopen(disk,"rb");


    if (flags & EXTRACT_DIR) {
	rename_sequential(basisnaam); /* in case a file (dir too?)  already exists named basis_naam */
#ifdef MAC_MKDIR
	strcpy(actie, ":"); /*MIGHT NEED TO BE "volume:" where volume is ? */
	strcat(actie, basisnaam);
	mkdir(actie,0);
#endif
#ifdef UNIX_MKDIR
	dir_mode=0777; /* CHANGE */
	mkdir(basisnaam, dir_mode);
#endif
#ifdef SYSTEM_MKDIR
	sprintf(actie, "mkdir %s", basisnaam);
	system(actie);
#endif
    }


    /* DISKNAAM BEPALEN (voor cat, crc, extract) */
    fseek(fpdisk,0L,SEEK_SET);
    for (i=0; i<8; i++) {
	fread (&filebyte,1,1,fpdisk);
	bbcdisk_naam[i]=filebyte;
	if (filebyte==0) break;
    }
    fseek(fpdisk,256L,SEEK_SET);
    for (i=0; i<4; i++) {
	fread (&filebyte,1,1,fpdisk);
	bbcdisk_naam[i+8]=filebyte;
	if (filebyte==0) break;
    }



    fseek(fpdisk,256+5L,SEEK_SET);
    fread(&files,1,1,fpdisk);
    rfiles=files/8;
    extr_list=((flags & EXTRACT_FILES) && (args>0));


    fread(&filebyte,1,1,fpdisk);
    bootoption=filebyte >> 4;
    H=filebyte & 3;
    fread(&filebyte,1,1,fpdisk);
    sectorsondisk=filebyte+H*256L;


    if ((flags & EXTRACT_FILES) && !extr_list) fpcat=fopen(catalogus,"w"); else fpcat=stdout;


/*    if (flags & SHOW_FILES) goto skip_diskinfo;*/

   #ifdef NL
    fprintf(fpcat,"\nDiskette :%s",bbcdisk_naam);
    if (strlen(bbcdisk_naam)==0) fprintf(fpcat, "(geen naam)");
    fprintf(fpcat,"\n%d sectoren op de diskette\n",sectorsondisk);
   #else
    fprintf(fpcat,"\nDisk :%s",bbcdisk_naam);
    if (strlen(bbcdisk_naam)==0) fprintf(fpcat, "(no name)");
    fprintf(fpcat,"\n%d sectors on disk\n",sectorsondisk);
   #endif

   #ifdef NL
    fprintf(fpcat, "bootoptie: ");
   #else
    fprintf(fpcat, "bootoption: ");
   #endif

    switch(bootoption) {
    case 0 :
       #ifdef NL
	fprintf(fpcat, "geen");
       #else
	fprintf(fpcat, "none");
       #endif
	break;
    case 1 : fprintf(fpcat, "*LOAD !BOOT");break;
    case 2 : fprintf(fpcat, "*RUN !BOOT");break;
    case 3 : fprintf(fpcat, "*EXEC !BOOT");
    }
    fprintf(fpcat,"\n");

   #ifdef NL
    fprintf(fpcat, "Bestand    Laad  Start  Lengte Toegang startsector\n");
   #else
    fprintf(fpcat, "File       Load   Exec  Length Access  startsector\n");
   #endif


skip_diskinfo:

    /*Hoofdlus: alle bestanden opzoeken*/
    if (files>0) {

	extr_list_no=0;

	for(file=0;file<files; file +=8) {
	    strcpy(extract, basisnaam);
	    if (flags & EXTRACT_DIR) strcat(extract,"/"); else strcat(extract,".");
	    if (flags & SHORT_NAME) extract[0]=0;

	    fseek(fpdisk,file+15L,SEEK_SET);
	    fread(&filebyte,1,1,fpdisk);
	    locked=filebyte >>7;
	    bbcfile_naam[0]=(filebyte & 0x7F);
	    bbcfile_naam[1]='.';
    

	    fseek(fpdisk,file+8L,SEEK_SET);
	    fread(bbcfile_naam+2,1,7,fpdisk);
	    bbcfile_naam[9]=0;


	    /* spaties aan het einde van bbc naam weghalen: geeft anders bestands namen
	       met spaties (in linux). */
	    for (i=8;i>0 && (bbcfile_naam[i]==' '); i--);
	    bbcfile_naam[i+1]=0;


	    /* IF FILE LIST GIVEN, SEE IF NAME IS IN DISKIMAGE */
	    if (extr_list) {
		int found=0;
		for (i=0; i<args;i++) {
		    if (arglist[i][1]=='.')
			strncpy(testnaam, arglist[i],9);
		    else {
			testnaam[0]='$'; testnaam[1]='.';
			strncpy(testnaam+2, arglist[i],7);
		    }
		    testnaam[9]=0;
		    if (!strcmp(bbcfile_naam, testnaam)) found=1;
		}
		if (!found) continue;
		extr_list_no++;
	    }


	    /* load/exec  adressen + lengte bepalen */
	    fseek(fpdisk,256+file+14,SEEK_SET);

	    fread(&eellddss,1,1,fpdisk);

	    /* STARTSECTOR */
	    fread(&filebyte,1,1,fpdisk);
	    startsector=filebyte+(eellddss & 3)*256L;


	    /* LOADADDRESS */
	    fseek(fpdisk,file+256L+8L,0);
	    fread(&filebyte,1,1,fpdisk);
	    fread(&H,1,1,fpdisk);
	    loadaddress=H*256L+filebyte+(eellddss & 0x0C)*16384L;
	    if (loadaddress & 0x30000) loadaddress |=0xFF0000;

	    /* EXECADDRESS */
	    fread(&filebyte,1,1,fpdisk);
	    fread(&H,1,1,fpdisk);
	    execaddress=H*256L+filebyte+(eellddss & 0xC0)*4L*256L;
	    if (execaddress & 0x30000) execaddress |=0xFF0000;

	    /* FILELENGTE */
	    fread(&filebyte,1,1,fpdisk);
	    fread(&H,1,1,fpdisk);
	    length=H*256L+filebyte+(eellddss & 0x30)*16L*256L;

	    filesizesum +=length;

	    if (flags & GET_ATTRIBUTES) {
		if (file>find_file_infoaddr) {
		    /* new file found */
		    strcpy(beeb_file->naam, bbcfile_naam);
		    beeb_file->loadaddr=loadaddress;
		    beeb_file->execaddr=execaddress;
		    beeb_file->length=length;
		    beeb_file->attributes=locked;
		    return 0;
		}
	    }
	    if (flags & LOAD_FILE) {
		fseek(fpdisk, startsector*256, SEEK_SET);
		fread(beeb_file->data, length, 1, fpdisk);
		return 0;
	    }

	    /* UITVOER VAN DEZE GEGEVENS NAAR CATALOGUS */
	    if (flags & SHOW_FILES) {
		fprintf(fpcat,"%-9s %6lX %6lX %6lX", bbcfile_naam, loadaddress, execaddress, length);
		if (locked) fprintf(fpcat," Locked");
		else        fprintf(fpcat,"       "); /*VOOR CRC UITLIJNEN*/
	    }

	    strcpy(unix_bbcfile_naam, bbcfile_naam);
	    replace_bad_chars(unix_bbcfile_naam);
	    if (!(flags & BBC_DIR)) {
		reduceer_unix_naam(extract+strlen(extract), unix_bbcfile_naam);
	    }
	    else strcat(extract, unix_bbcfile_naam);


	    if (flags & EXTRACT_FILES) {
		/* NAME CHECK: does it already exist? */
		char nieuwe_naam[55];

		strcpy(nieuwe_naam, extract);
		if ((fpextract=fopen(extract, "rb"))!=NULL) {
		    fclose(fpextract);
		    antwoord=overschrijf_vraag(extract, nieuwe_naam);

		    switch(antwoord) {
		    case OVERSCHRIJVEN:
			break;
		    case HERNOEM_NIEUW:
			strcpy(extract, nieuwe_naam); break;
		    case HERNOEM_BESTAAND:
			rename(extract, nieuwe_naam);
			/* altijd ook info bestand hernoemen: */
			strcpy(info_naam, extract); strcat(info_naam, ".inf");
			strcat(nieuwe_naam, ".inf"); rename(info_naam, nieuwe_naam);
			break;
		    case SLA_OVER:
			continue; /*to for*/
		    } /*switch */
		}
		/* END NAME CHECK */


		fpextract=fopen(extract, "wb");

		fseek(fpdisk,startsector*256, SEEK_SET);
		for (i=0; i<length; i++) {
		    fread(&filebyte,1,1,fpdisk);
		    if (feof(fpdisk)) {
                       #ifdef NL
			printf("onverwacht einde van het diskbeeld" \
			       " bij bestand %s\n\n", bbcfile_naam);
                       #else
			printf("unexpected end of the diskimage" \
			       " at file %s\n\n", bbcfile_naam);
                       #endif
			exit(1);
		    }
		    fwrite(&filebyte,1,1,fpextract);
		}
		fclose(fpextract);
	    }


	    if (flags & DISK_INFO) { /* should be INFO_FILE */ 
		strcpy(info_naam, extract);
		strcat(info_naam, ".inf");
		fpinfo=fopen(info_naam, "w");
		fprintf(fpinfo, "%-9s", bbcfile_naam);
		/* I no longer include the (superfluous) file length in the INFO file. */
		fprintf(fpinfo," %6lX %6lX", loadaddress, execaddress);
		if (locked) fprintf(fpinfo," Locked");
	    } /*N.B. info bestand wordt in crc deel gesloten*/


	    crc=0;
	    if (flags & (CALC_CRC | DISK_INFO)) {
		fseek(fpdisk,startsector*256, SEEK_SET);
		for (i=0; i<length; i++) {
		    fread(&filebyte,1,1,fpdisk);
		    if (feof(fpdisk)) {
                       #ifdef NL
			printf("onverwacht einde van het diskbeeld" \
			       " bij bestand %s\n\n", bbcfile_naam);
                       #else
			printf("unexpected end of the diskimage" \
			       " at file %s\n\n", bbcfile_naam);
                       #endif
			return BBC_DISK_TRUNCATED;
		    }

		    crc ^=(filebyte << 8);
		    for(k=0;k<8;k++) {
			if (crc & 32768)
			    crc =(((crc ^ 0x0810) & 32767) << 1)+1;
			else
			    crc =crc <<1;
		    }
		}

		if (flags & DISK_INFO) {
		    fprintf(fpinfo, " CRC=%04X", crc); fclose(fpinfo);
		}
	    }

	    if (extr_list)
		printf(" %s\n",extract);
	    else
		fprintf(fpcat,"   %4d", (int) startsector);

	    if (flags & CALC_CRC)
		fprintf(fpcat, "       CRC= %04X\n", crc);
	    else
		fprintf(fpcat, "\n");
	}

	/* SHOW NO OF (EXTRACTED) FILES */
	if (extr_list){
	    rfiles=extr_list_no;
           #ifdef NL
	    printf("aantal bestanden: %d\n",rfiles);
	}
	fprintf(fpcat,"\n%d bestand%s\n", rfiles, (rfiles !=1) ? "en" : "");
           #else
	    printf("number of files: %d\n",rfiles);
        }
        fprintf(fpcat,"\n%d file%s\n", rfiles, (rfiles !=1) ? "s" : "");
           #endif


	fclose(fpdisk);
	if ((flags & REMOVE_DISK) && !extr_list) remove(disk);
    }
   #ifdef NL
    fprintf(fpcat,"Totaal %ld bytes\n", filesizesum);
   #else
    fprintf(fpcat,"Total %ld bytes\n",  filesizesum);
   #endif

    if (flags & LOAD_FILE) return BBC_FILE_NOT_FOUND; /* Not found */

    if (fpcat !=stdout) fclose(fpcat);
    return 0;
} /* ^  DFS beeld functies */






else {

/* int  disk_adfscat_extract_crc(char *disk, int args, char *arglist[], struct diskimage *image, int flags) { */
#if 0
    FILE *fpdisk, *fpcat, *fpextract, *fpinfo;
    byte filebyte;
    char string[100], bbcfile_naam[100], testnaam[100], unix_bbcfile_naam[100];
    char catalogus[100], info_naam[100];
    byte dir_entry[DIRECTORY_SIZE];
    byte buf[512];
    char extract[200], basisnaam[200];
    int  i,k;
    long sector, sectorsondisk, freespace;
    long freespace_entries;
    char path[100];
    int  path_index;
    char dirname[100];

    long dir_sector;
    int  status;

    unsigned long loadaddress, execaddress, length, startsector;
    byte accessR, accessW, accessL, accessDIR, attributeE;
    int  extr_list=0;
    int  extr_list_no, antwoord;

    long filesizesum=0;
    unsigned int  crc;

    int file;
int bootoption;

#ifdef UNIX_MKDIR
    mode_t dir_mode;
#endif

#if defined(MAC_MKDIR) || defined(SYSTEM_MKDIR)
    char actie[60];
#endif

#endif /* only in case it's a separate function */








/************************ ADFS *****************************/

/* disk a/b/f ->
 * -ed         disk/a/b/f
 * -ed#        disk/f
 * -e#         disk.f
 * -e          disk.a.b.f
 * -es         a.b.f
 * -es#        f
 */

#define NUM_FREESPACE_ENTRIES 82
#define ADFS_BOOTOPTION (256+253)
#define DIRECTORY_SIZE 1280

/* Internal use only: */
#define FIND_DIR  1
#define NEXT_DIR  2
#define DIR_FOUND 3

    int recursive_extract=1; /* yes please */



    if (diskimage_sanitycheck(image, 1)) return bbcim_errno;

    extr_list=((flags & EXTRACT_FILES) && (args>1));

/*     if ((flags & EXTRACT_FILES) && !extr_list) fpcat=fopen(catalogus,"w"); else fpcat=stdout; */ /* wordt in extr lus gedaan */

    if (args<1)
	fullpath[0]=0;
    else
    { strcpy(fullpath, arglist[0]); }

    /*------------- FREE SPACE ------------------*/
    fpdisk=fopen(disk,"rb");
    fseek(fpdisk,0L,SEEK_SET);
    if (fread(buf, 512,1, fpdisk)<1) {
       #ifdef NL
	printf("ADFS sector 0&1 lezen mislukt\n");
       #else
	printf("Failed to read ADFS sector 0\n");
       #endif
	return BBC_DISK_TRUNCATED;
    }

#if 0
/* -- ADFS Freespace not used in cat,extr,crc -- */
    freespace_entries=buf[256+254]/3;
    printf("freespace entries %d\n", (int) freespace_entries);
    for (i=0; i<freespace_entries/*NUM_FREESPACE_ENTRIES*/; i++) {
	sector=read3lsb(buf+3*i);
	printf("free %d at %ld\n", i, sector);
    }
#endif

    sectorsondisk=read3lsb(buf+252);
    printf("sectorsondisk %ld\n", sectorsondisk);

    fseek(fpdisk,256L,SEEK_SET);
    fread(buf, 256,1, fpdisk);
    bootoption=buf[253];
#if 0
/* -- ADFS Freespace not used in cat,extr,crc -- */
    for (i=0; i<freespace_entries/*NUM_FREESPACE_ENTRIES*/; i++) {
	freespace=read3lsb(buf+3*i);
	printf("free %d size %ld\n", i, freespace);
    }
#endif


    /*------------- ZOEK DIR EN LIST/EXTRACT FILES ------------------*/
    dir_sector=2; /* the sector of the current dir, start with root dir */
    path_index=0;
    status=FIND_DIR;
    if (fullpath[0]=='/') /*path_index++;*/ path=fullpath+1; else path=fullpath;
    if (path[strlen(path)-1]=='/') path[strlen(path)-1]=0;
    for (;;) {
/* printf("pathindex=%d\n", path_index); */
/* printf("path+pathindex[]=%s\n", path+path_index); */
	for (i=path_index; i<strlen(path); i++) {
	    if ( path[i]=='/' ) { strncpy(dirname, path+path_index, i-path_index); dirname[i-path_index]=0; path_index=i+1; break; }
	}
	if (i>=strlen(path)) { strcpy(dirname,path+path_index); path_index=strlen(path); }

 	if (strlen(dirname)==0) {
 	    status=DIR_FOUND;
 	}

/* printf("dirname=%s\n", dirname); */
	/* ROOT DIR =sec 2-6 track 0 */
	fseek(fpdisk,256L*dir_sector,SEEK_SET);
	if (fread(dir_entry, 1280,1, fpdisk)<1) {
           #ifdef NL
	    printf("ADFS dir lezen mislukt\n");
           #else
	    printf("Failed to read ADFS dir\n");
           #endif
	    exit(0);
	}

	memcpy(string, dir_entry+1, 4); string[4]=0;
	printf("fixed root string = %s\n", string); /* =Hugo*/


	if (status == DIR_FOUND) {
	    strcpy(basisnaam, disk);
	    basisnaam[strcspn(disk,".")]=0;

/* disk a/b/f ->
 * -ed         disk/a/b/f       disk/a/b.cat
 * -ed#        disk/f           disk.cat
 * -e#         disk.f           disk.cat
 * -e          disk.a.b.f       disk.a.b.cat
 * -es         a.b.f            a.b.cat
 * -es#        f                cat
 */
	    if (flags & SHORT_NAME)
	        basisnaam[0]=0;

	    if (flags & BBC_DIR) {
		if (!(flags & SHORT_NAME))
		    strcat(basisnaam, "/");
		strcat(basisnaam, path);
	    }


	    if (flags & EXTRACT_DIR) {
/*		rename_sequential(basisnaam);*/ /* in case a file (dir too?)  already exists named basis_naam */
		for (i=0; i<=strlen(basisnaam); i++) {printf("i=%d\n",i);
		    if (basisnaam[i]=='/' || i==strlen(basisnaam)) {
			char temp[256];
			strcpy(temp, basisnaam); temp[i]=0;
#ifdef MAC_MKDIR
		strcpy(actie, ":"); /*MIGHT NEED TO BE "volume:" where volume is ? */
		strcat(actie, /*basisnaam*/temp);
		mkdir(actie,0);
#endif
#ifdef UNIX_MKDIR
		dir_mode=0777; /* CHANGE */
		mkdir(/*basisnaam*/temp, dir_mode);
#endif
#ifdef SYSTEM_MKDIR
		sprintf(actie, "mkdir %s", /*basisnaam*/temp);
		system(actie);
#endif
		    }
		}
	    }
	    else {
		for (i=0; i<strlen(basisnaam); i++)
		    if (basisnaam[i]=='/') basisnaam[i]='.';
	    }

	    strcpy(catalogus, basisnaam);
	    strcpy(catalogus+strlen(basisnaam),".cat");

	    if ((flags & EXTRACT_FILES) && !extr_list) fpcat=fopen(catalogus,"w"); else fpcat=stdout;
#           ifdef NL
	    fprintf(fpcat,"       Bestand      Laad     Exec      Lengte  R W L D E  sector\n");
#           else
	    fprintf(fpcat,"       File         Load     Exec      Length  R W L D E  sector\n");
#           endif

	}

	extr_list_no=0;

	for (file=0; file<47; file++ ) {
	    int j;
	    strcpy(extract, basisnaam);
	    if (basisnaam[0])
	    if (flags & EXTRACT_DIR) strcat(extract,"/"); else strcat(extract,".");
/* 	    if (flags & SHORT_NAME) extract[0]=0; */

	    strncpy(string, dir_entry+5+file*26, 10); string[10]=0;
	    if (strlen(string)==0) break; /* last entry */

	    for (j=0; j<strlen(string); j++) {
		string[j] &=127;
		if (string[j]==13) { string[j]=0; break; }
		if (string[j]<32) string[j]='_';
	    }
	    string[10]=0;

	    strcpy(bbcfile_naam, string); /* not necessary */
	    if (status==DIR_FOUND) {
		/* IF FILE LIST GIVEN, SEE IF NAME IS IN DISKIMAGE */
		if (extr_list) {
		    int found=0;
		    for (i=1; i<args;i++) { /* ADFS */
			strncpy(testnaam, arglist[i],11);
			testnaam[11]=0;
			if (!strcmp(bbcfile_naam, testnaam)) found=1;
		    }
		    if (!found) continue; /* volgende ADFS bestand */
		    extr_list_no++;
		}
	    } /* DIR_FOUND */
	    accessR=dir_entry[5+file*26]>>7;
	    accessW=dir_entry[6+file*26]>>7;
	    accessL=dir_entry[7+file*26]>>7;
	    accessDIR=dir_entry[8+file*26]>>7;
	    attributeE=dir_entry[9+file*26]>>7;

	    loadaddress=read4lsb(dir_entry+15+file*26);
	    execaddress=read4lsb(dir_entry+19+file*26);
	    length=read4lsb(dir_entry+23+file*26);

	    startsector=read3lsb(dir_entry+27+file*26);

	    if (status == DIR_FOUND) {
		/* UITVOER VAN DE GEGEVENS NAAR CATALOGUS */
		if (flags & SHOW_FILES) {
#if 0
		    /* DFS: */
		    fprintf(fpcat,"%-9s %6lX %6lX %6lX", bbcfile_naam, loadaddress, execaddress, length);
		    if (locked) fprintf(fpcat," Locked");
		    else        fprintf(fpcat,"       "); /*VOOR UITLIJNEN*/
#else
		    fprintf(fpcat, " %s %-12s %8lX %8lX %6lX", accessDIR ? "DIR: " : "     ", string, loadaddress, execaddress, length);
		    fprintf(fpcat, "   %s %s %s %s %s", accessR ? "R" : "-",   accessW ? "W" : "-",  accessL ? "L" : "-",  accessDIR ? "D" : "-",  attributeE ? "E" : "-");
#endif
		}

		strcpy(unix_bbcfile_naam, bbcfile_naam);
		replace_bad_chars(unix_bbcfile_naam);
/*	    if (!(flags & BBC_DIR)) {
	    reduceer_unix_naam(extract+strlen(extract), unix_bbcfile_naam);
	    }
	    else*/ strcat(extract, unix_bbcfile_naam);

	    filesizesum +=length;


	    if ((flags & EXTRACT_FILES) && !accessDIR) { /* extract files */
		/* NAME CHECK: does it already exist? */
		char nieuwe_naam[55];
		FILE *fpextract;

		strcpy(nieuwe_naam, extract);
		if ((fpextract=fopen(extract, "rb"))!=NULL) {
		    fclose(fpextract);
		    antwoord=overschrijf_vraag(extract, nieuwe_naam);

		    switch(antwoord) {
		    case OVERSCHRIJVEN:
			break;
		    case HERNOEM_NIEUW:
			strcpy(extract, nieuwe_naam); break;
		    case HERNOEM_BESTAAND:
			rename(extract, nieuwe_naam);
			/* altijd ook info bestand hernoemen: */
			strcpy(info_naam, extract); strcat(info_naam, ".inf");
			strcat(nieuwe_naam, ".inf"); rename(info_naam, nieuwe_naam);
			break;
		    case SLA_OVER:
			continue; /*to for*/
		    } /*switch */
		}
		/* END NAME CHECK */


		fpextract=fopen(extract, "wb");

		fseek(fpdisk,startsector*256, SEEK_SET);
		for (i=0; i<length; i++) {
		    fread(&filebyte,1,1,fpdisk);
		    if (feof(fpdisk)) {
                       #ifdef NL
			printf("onverwacht einde van het diskbeeld" \
			       " bij bestand %s\n\n", bbcfile_naam);
                       #else
			printf("unexpected end of the diskimage" \
			       " at file %s\n\n", bbcfile_naam);
                       #endif
			exit(1);
		    }
		    fwrite(&filebyte,1,1,fpextract);
		}
		fclose(fpextract);
	    }

	    if ((flags & DISK_INFO) && !accessDIR) { /* should be INFO_FILE */ 
		strcpy(info_naam, extract);
		strcat(info_naam, ".inf");
		fpinfo=fopen(info_naam, "w");
		fprintf(fpinfo, "%-12s", bbcfile_naam);
		/* I no longer include the (superfluous) file length in the INFO file. */
		fprintf(fpinfo," %6lX %6lX", loadaddress, execaddress);
		fprintf(fpinfo, "   %s %s %s %s %s", accessR ? "R" : "-",   accessW ? "W" : "-",  accessL ? "L" : "-",  accessDIR ? "D" : "-",  attributeE ? "E" : "-");
	    } /*N.B. info bestand wordt in crc deel gesloten*/


	    if (flags & (CALC_CRC | DISK_INFO)) {
		fseek(fpdisk,startsector*256, SEEK_SET);
		for (i=0; i<length; i++) {
		    fread(&filebyte,1,1,fpdisk);
		    if (feof(fpdisk)) {
#ifdef NL
			printf("onverwacht einde van het diskbeeld" \
			       " bij bestand %s\n\n", bbcfile_naam);
#else
			printf("unexpected end of the diskimage" \
			       " at file %s\n\n", bbcfile_naam);
#endif
			exit(1);
		    }

		    crc ^=(filebyte << 8);
		    for(k=0;k<8;k++) {
			if (crc & 32768)
			    crc =(((crc ^ 0x0810) & 32767) << 1)+1;
			else
			    crc =crc <<1;
		    }
		}

		if ((flags & DISK_INFO ) && !accessDIR) {
		    fprintf(fpinfo, " CRC=%04X", crc); fclose(fpinfo);
		}
	    }

	    if (extr_list)
		printf(" %s\n",extract);
	    else
		fprintf(fpcat,"   %4ld", startsector);

	    if (flags & CALC_CRC)
		fprintf(fpcat, "       CRC= %04X\n", crc);
	    else
		fprintf(fpcat, "\n");

	    }
	    else {
		if (accessDIR==1 && !strcmp(string, dirname)) { status=NEXT_DIR; dir_sector=startsector; break; }
	    }
	}
	if (status==DIR_FOUND) { printf("done\n"); return 0; }
	if (status==NEXT_DIR) { status=FIND_DIR; continue; }
	if (status==FIND_DIR) { printf("dir %s not found!\n", dirname); return BBC_DIR_NOT_FOUND; }
    }
    fclose(fpdisk);

    if (fpcat!=stdout) fclose(fpcat);
    return 0;
} /* ^  ADFS diskbeelden */

}

/* ^  disk_cat_extract_crc.c */
