/* bbc_crc.c: controleer/maak 16 bit crc van bestanden (zie BBC user guide p.399)
 * Copyright (C) W.H.Scholten 1996
 *
 * (bbcim)
 */

long fcrc(char *bestand, int verbose) {
    unsigned long length=0;
    unsigned char filebyte;
    FILE *fp;
    unsigned int crc=0;
    int k;


    length=0; crc=0;

    if (file_sanitycheck(bestand, verbose)) return bbcim_errno;

    fp=fopen(bestand,"rb");
    while (1) {
	if (!fread(&filebyte,1,1,fp)) break;
	/* if (feof(fp)) break; */
	length++;
	crc ^=(filebyte << 8);
	for(k=0; k<8; k++) {
	    if (crc & 32768) crc=(((crc ^ 0x0810) & 32767) << 1)+1;
	    else crc <<= 1;
	}
    }
    fclose(fp);

    return crc;
}







/* CRC controle voor archief formaat */
/* return 0=ok, -n = n bad crc's found */
int  archive_crc_check(int args, char *arglist[], int flags) {
    FILE *fparchive, *fpinfo;
    char infofile[100];
    int  archivefile,l, found, len_s, i;
    char bbc_naam[12];

    char read_line[100];
    unsigned int crc;
    int  bad_crc_s;

    for(archivefile=0; archivefile<args; archivefile++) {

	/* .inf bestanden overslaan: */
	l=strlen(arglist[archivefile]);
	if (l>4)
	    if (!strncmp(arglist[archivefile]+l-4,".inf",4)) continue;

	strcpy(infofile,arglist[archivefile]);
	strcat(infofile,".inf");



	/* BESTAAT HET INFO BESTAND? */
	fpinfo=fopen(infofile, "r");
	if (fpinfo==NULL) {
          #ifdef NL
	    printf("Info bestand %s kan niet geopend worden, sla over\n", infofile);
          #else
	    printf("Info file %s cannot be opened, skipping file\n", infofile);
          #endif
	    continue;
	}


	/* BESTAAT HET ARCHIEF BESTAND? */
	fparchive=fopen(arglist[archivefile], "rb");
	if (fparchive==NULL) {
          #ifdef NL
	    printf("Archief bestand %s kan niet geopend worden\n", arglist[archivefile]);
          #else
	    printf("Archive file %s cannot be opened\n", arglist[archivefile]);
          #endif
	    continue;
	}
	fclose(fparchive);


	/* UIT HET inf BESTAND DE BESTANDSNAAM HALEN. */
	fscanf(fpinfo,"%12s", bbc_naam);
	if (bbc_naam[1]!='.') strncpy(bbc_naam, arglist[archivefile],12);
	bbc_naam[9]=0;

	/* CRC zoeken */
	fseek(fpinfo,0L,0);
	fgets(read_line, 99, fpinfo);

	found=0;
	len_s=strlen(read_line);
	printf("bestand %-9s (%-9s) CRC ", arglist[archivefile],bbc_naam);
	for (i=0; i<len_s-4; i++) {
	    if (!strncmp(read_line+i,"CRC=",4)) {
		found=1;
		fseek(fpinfo, i+4L,0); fscanf(fpinfo, "%x", &crc);
		if (crc!=fcrc(arglist[archivefile],1)) {
		    bad_crc_s++;
#ifdef NL
		    printf("fout, gevonden: %4X", crc);
#else
		    printf("wrong, found: %4X", crc);
#endif
		    crc=fcrc(arglist[archivefile],0);

#ifdef NL
		    printf(", berekend: %4X\n", crc);
#else
		    printf(", calculated: %4X\n", crc);
#endif
		}
#ifdef NL
		else printf("in orde\n");
#else
		else printf("OK\n");
#endif
		break;
	    }
	}
#ifdef NL
	if (!found) printf("ontbreekt\n");
#else
	if (!found) printf("missing\n");
#endif
	fclose(fpinfo);
    } /*FOR */
    return -bad_crc_s; /* = -number of bad crc's */
}






/* Controleer CRC's in __CATALOG__ ($.ELITE 00E00 FF8023 ... CRC=xxxx) */
/* return: 0=ok, -n = n bad crc's */
int  xbeeb_crc_check(char *dir, int flags) {
    FILE *fpcat;
    unsigned int crc;
    int found, len_s, i;
    int bad_crc_s;

    char bbc_file[15], read_line[100];
    char *catalogue="__CATALOG__";

    fpcat=fopen(catalogue, "r");
    if (fpcat==NULL) {
	bbcim_error=
#ifdef NL
	"__CATALOG__ kon niet geopend worden\n";
#else
	"__CATALOG__ couldn't be opened\n";
#endif
	fprintf(stderr, bbcim_error);
	bbcim_errno=BBC_OPEN_CATALOG_FAILED;
	return bbcim_errno;
    }

    while (1) {
	if (fgets(read_line, 99, fpcat)==NULL) break;
	if (read_line[1]=='.') {
	    strncpy(bbc_file, read_line, 9); bbc_file[9]=0;
	    /* SPATIES AAN EINDE WEGHALEN */
	    for (i=8;i>0;i--) {
		if (bbc_file[i]!=' ') break;
		bbc_file[i]=0;
	    }

	    found=0;
	    len_s=strlen(read_line);
#ifdef NL
	    printf("bestand %-9s CRC ", bbc_file);
	    for (i=0; i<len_s-4; i++) {
		if (!strncmp(read_line+i,"CRC=",4)) {
		    found=1;
		    sscanf(read_line+i+4L, "%x", &crc);
		    if (crc!=fcrc(bbc_file,1)) {
			bad_crc_s++;
			printf("fout, gevonden: %4X", crc);
			crc=fcrc(bbc_file,0);
			printf(", berekend: %4X\n", crc);
		    }
		    else printf("in orde\n");
		    break;
		}
	    } if (!found) printf("ontbreekt\n");
#else
	    printf("file %-9s CRC ", bbc_file);
	    for (i=0; i<len_s-4; i++) {
		if (!strncmp(read_line+i,"CRC=",4)) {
		    found=1;
		    sscanf(read_line+i+4L, "%x", &crc);
		    if (crc!=fcrc(bbc_file,1)) {
			bad_crc_s++;
			printf("wrong, found: %4X", crc);
			crc=fcrc(bbc_file,0);
			printf(", calculated: %4X\n", crc);
		    }
		    else printf("all right\n");
		    break;
		}
	    } if (!found) printf("missing\n");
#endif
	}
    } /*while*/
    return -bad_crc_s; /* = -number of bad crc's */
}



