//bbc_crc.cc: controleer/maak 16 bit crc van bestanden
//Copyright (C) W.H.Scholten 1996
//Deel van bbcim.


//Bereken de CRC van een bestand (zie BBC user guide p.399)

unsigned int fcrc(char *bestand)
{
 unsigned long length=0;
 unsigned char byte;
 FILE *fp;

 unsigned int crc=0;

  fp=fopen(bestand,"rb");

  if (fp==NULL)
   {
#ifdef NL
    printf("Bestand %s kan niet geopend worden\n\n", bestand);
#else
    printf("File %s couldn't be opened\n", bestand);
#endif

    return crc;
    }

   while (1)
    {
     fread(&byte,1,1,fp);
     if (feof(fp)) break;
     length +=1;
     crc ^=(byte << 8);
     for(int k=0;k<8;k++)
       {
        if (crc & 32768) crc=(((crc ^ 0x0810) & 32767) << 1)+1;
        else crc =crc << 1;
        }
    }
fclose(fp);

return crc;
}







//CRC controle voor archief formaat

void icrc(int argc, char *argv[], int options)
 {FILE *fpadd, *fpinfo, *fpcat;
  unsigned char byte,H;
  char addfile[100], infofile[100], catfile[100];


//   if ((argc-options)<3)
//    {
//     #ifdef NL
//     printf("Naam van het toe te voegen archief bestand?");
//     #else
//     printf("Name of the archive file to be added?");
//     #endif
//     scanf("%50s", addfile);
//     } else strcpy(addfile, argv[2+options]);

  if ((argc-options)<2)
    {
     #ifdef NL
     printf("Geen lijst van archief bestanden meegegeven\n");
     #else
     printf("No archive file list given\n");
     #endif
     exit(1);
     }



  for(int addfiles=2; addfiles<argc; addfiles++)
    {


//.inf bestanden overslaan:
      int l=strlen(argv[addfiles]);
      if (l>4)
        {if (!strncmp(argv[addfiles]+l-4,".inf",4))
          continue;
         }

      strcpy(infofile,argv[addfiles]);
      strcat(infofile,".inf");



//BESTAAT HET INFO BESTAND?
      fpinfo=fopen(infofile, "r");
      if (fpinfo==NULL)
         {
          #ifdef NL
           printf("Info bestand %s kan niet geopend worden, sla over\n", infofile);
          #else
           printf("Info file %s cannot be opened, skipping file\n", infofile);
          #endif
          continue;
          }


//BESTAAT HET ARCHIEF BESTAND?
     fpadd=fopen(argv[addfiles], "rb");
      if (fpadd==NULL)
         {
          #ifdef NL
           printf("Archief bestand %s kan niet geopend worden\n", argv[addfiles]);
          #else
           printf("Archive file %s cannot be opened\n", argv[addfiles]);
          #endif
          continue;
          }

//UIT HET inf BESTAND DE BESTANDSNAAM HALEN.
 
      char bbc_naam[12], bbc2[12];

      fscanf(fpinfo,"%s", bbc_naam);
      bbc_naam[9]=0;
// printf("bbc_naam %s\n", bbc_naam);

      if (bbc_naam[1]!='.') strcpy(bbc_naam, argv[addfiles]);
           else {bbc2[0]=bbc_naam[0];
                 strcpy(bbc2+1,bbc_naam+2);}



      unsigned long loadaddress, execaddress;

      char read_line[100];
      unsigned int crc;

//      fscanf(fpinfo," %s", read_line);
//CRC zoeken
     fseek(fpinfo,0L,0);
     fgets(read_line, 99, fpinfo);

     int found=0;
     int len_s=strlen(read_line);
     printf("bestand %-9s (%-9s) CRC ", argv[addfiles],bbc_naam);
     for (int i=0; i<len_s-4; i++)
       {if (!strncmp(read_line+i,"CRC=",4))
            {found=1;
             fseek(fpinfo, i+4L,0); fscanf(fpinfo, "%x", &crc);
             if (crc!=fcrc(argv[addfiles]))
               {
#ifdef NL
                printf("fout, gevonden: %4X", crc);
#else
                printf("wrong, found: %4X", crc);
#endif

                crc=fcrc(argv[addfiles]);

#ifdef NL
                printf(", berekend: %4X\n", crc);
#else
                printf(", calculated: %4X\n", crc);
#endif
                }
             else printf("in orde\n");
             break;
             }
        } if (!found) printf("ontbreekt\n");





    fclose(fpinfo);


  } //FOR


}






//Controleer CRC's in __CATALOG__ ($.ELITE 00E00 FF8023 ... CRC=xxxx)

void xcrc(int argc, char *argv[], int options)
 {FILE *fp_bbc, *fpinfo, *fpcat;
  unsigned char byte,H;
  unsigned int crc;

  char bbc_file[15], read_line[100];

  fpcat=fopen("__CATALOG__", "r");
  if (fpcat==NULL)
    {
#ifdef NL
     printf("__CATALOG__ kon niet geopend worden\n");
#else
     printf("__CATALOG__ couldn't be opened\n");
#endif
   exit (1);
     }

  while (1)
   {if (fgets(read_line, 99, fpcat)==NULL) break;
    if (read_line[1]=='.')
      {strncpy(bbc_file, read_line, 9); bbc_file[9]=0;
       int found=0;
       int len_s=strlen(read_line);
       printf("bestand %-9s CRC ", bbc_file);
       for (int i=0; i<len_s-4; i++)
         {if (!strncmp(read_line+i,"CRC=",4))
             {found=1;
              sscanf(read_line+i+4L, "%x", &crc);
              if (crc!=fcrc(bbc_file))
                 {printf("fout, gevonden: %4X", crc);
                 crc=fcrc(bbc_file);
                 printf(", berekend: %4X\n", crc);
                  }
              else printf("in orde\n");
              break;
              }
          } if (!found) printf("ontbreekt\n");
       }
    } //while   



}











