dnl----- Common files distribution --------------------------- *@--NOTICE--@*
dnl
dnl $Id: aclocal.glob,v 1.1 1997/08/12 21:22:58 mdw Exp $

dnl --- *@-mdw_CHECK_MANYLIBS-@* ---
dnl
dnl Author:	Mark Wooding
dnl
dnl Synopsis:	mdw_CHECK_MANYLIBS(FUNC, LIBS, [IF-FOUND], [IF-NOT-FOUND])
dnl
dnl Arguments:	FUNC = a function to try to find
dnl		LIBS = a whitespace-separated list of libraries to search
dnl		IF-FOUND = what to do when the function is found
dnl		IF-NOT-FOUND = what to do when the function isn't found
dnl
dnl Use:	Searches for a library which defines FUNC.  It first tries
dnl		without any libraries; then it tries each library specified
dnl		in LIBS in turn.  If it finds a match, it adds the
dnl		appropriate library to `LIBS'.
dnl
dnl		This is particularly handy under DIREIX: if you link with
dnl		`-lnsl' then you get non-NIS-aware versions of getpwnam and
dnl		so on, which is clearly a Bad Thing.

AC_DEFUN(mdw_CHECK_MANYLIBS,
[AC_CACHE_CHECK([for library containing $1], [mdw_cv_lib_$1],
[mdw_save_LIBS="$LIBS"
mdw_cv_lib_$1="no"
AC_TRY_LINK(,[$1()], [mdw_cv_lib_$1="none required"])
test "$mdw_cv_lib_$1" = "no" && for i in $2; do
LIBS="-l$i $mdw_save_LIBS"
AC_TRY_LINK(,[$1()],
[mdw_cv_lib_$1="-l$i"
break])
done
LIBS="$mdw_save_LIBS"])
if test "$mdw_cv_lib_$1" != "no"; then
  test "$mdw_cv_lib_$1" = "none required" || LIBS="$mdw_cv_lib_$1 $LIBS"
  $3
else :
  $4
fi])

dnl --- *@-mdw_GCC_FLAGS-@* ---
dnl
dnl Author:	Mark Wooding
dnl
dnl Synopsis:	mdw_GCC_FLAGS([FLAGS])
dnl
dnl Arguments:	FLAGS = GCC compiler flags to add (default is 
dnl			`-pedantic -Wall')
dnl
dnl Use:	If the C compiler is GCC, add the compiler flags.

AC_DEFUN(mdw_GCC_FLAGS,
[if test "$GCC" = "yes"; then
  CFLAGS="$CFLAGS ifelse([$1], [], [-pedantic -Wall], [$1])"
fi])

dnl --- *@-mdw_OPT_NDEBUG-@* ---
dnl
dnl Author:	Mark Wooding
dnl
dnl Synopsis:	mdw_OPT_NDEBUG
dnl
dnl Arguments:	---
dnl
dnl Use:	Turns off the `NDEBUG' flag if the user wants to do
dnl		debugging.

AC_DEFUN(mdw_OPT_NDEBUG,
[AC_ARG_ENABLE(debugging,
[  --enable-debugging      spews vast swathes of useless information],
[if test "$enableval" = "no"; then
  AC_DEFINE(NDEBUG, 1)
fi],
[AC_DEFINE(NDEBUG, 1)])])

