/*
 * malloc.c - the malloc routine
 *
 * malloc allocates blocks of memory. It checks to
 * see if it has a free block big enough, but if not
 * gets more memory from the system using sbrk. It
 * will split a large free block into two smaller ones.
 * -Pete French. 17/7/1990
 */

extern char* sbrk();

struct mlist {			/* malloc list structure */
              unsigned int len;
              char free;
              struct mlist *next;
             };

#define	FREE	'f'
#define	USED	'u'
#define MINBRK	64	/* minimum allocatable block */

struct mlist m_base={0,USED,(struct mlist*)0};	/* base structure */

char *malloc(s)
unsigned int s;
{
char *new;
struct mlist *ptr;
if(s<MINBRK)
 s=MINBRK;		/* if below minimum break then increase */
s=(s+1) & ~1;		/* make s an even number */
ptr=&m_base;
while(ptr->next != (struct mlist*)0)	/* scan the list for a block */
 {
  ptr=ptr->next;
  if((ptr->free==FREE) && (ptr->len >= s)) /* large enough free block ? */
   {
    if(ptr->len >= (s+MINBRK+sizeof(struct mlist))) /* split block ? */
     {
      register struct mlist *split;	/* split point */
      split=(struct mlist*)((long)ptr+s+sizeof(struct mlist));
      split->next=ptr->next;		/* split the list... */
      ptr->next=split;			/* ...into two */
      split->free=FREE;			/* mark 2nd half as free */
      split->len=ptr->len-s-sizeof(struct mlist);	/* size of 2nd half */
      ptr->len=s;			/* new size of 1st half */
     }
    ptr->free=USED;		/* mark as in use */
    return((char*)ptr+sizeof(struct mlist));
   }
 }
new=sbrk(s+(unsigned int)sizeof(struct mlist));	/* we need more memory */
if(new==(char*)-1)
 return((char*)0);			/* return 0 for error */
else
 {
  register struct mlist *newstr=(struct mlist*)new;
  new+=sizeof(struct mlist);
  ptr->next=newstr;			/* add new block to list */
  newstr->len=s;			/* store length of new block */
  newstr->free=USED;			/* mark as used */
  newstr->next=(struct mlist*)0;	/* mark as end of list */
  return(new);
 }
}
